'
'
'
'
'
'
'                                                                   R E G K E Y
'
'------------------------------------------------------------------------------
'
'
'                                                                  Version 3.00
'
'
'                                   The Registration Key System For Programmers
'
'
'                                            Visual Basic for Windows Interface
'
'
'
'
'         (C) Copyright Brian Pirie, 1993 - 1994. All Rights Reserved.
'
'



' FUNCTION RETURN VALUES
' ----------------------

Const RKFailure = 0
Const RKSuccess = 1



' REGISTRATION KEY VALIDATION RESULTS
' -----------------------------------

Const RKUnregistered = 0
Const RKRegistered = 1



' DLL FUNCTION DECLARATIONS
' -------------------------

Declare Function rkncs Lib "RK30VB.DLL" (ByVal sGenerationCode$, ByVal sValidationCode$) As Integer
Declare Function rkg Lib "RK30VB.DLL" (ByVal sRegString$, ByVal sGenerationCode$, ByVal sRandomSeed$, ByVal sRegKey$) As Integer
Declare Function rkv Lib "RK30VB.DLL" (ByVal sRegString$, ByVal sRegKey$, ByVal sValidationCode$, ByVal sYourName$, ByVal nYourKey As Long, peRegistered As Integer) As Integer
Declare Function rkfg Lib "RK30VB.DLL" (ByVal sRegString$, ByVal sGenerationCode$, ByVal sRandomSeed$, ByVal sFileName$) As Integer
Declare Function rkfv Lib "RK30VB.DLL" (ByVal sFileName$, ByVal sValidationCode$, ByVal sYourName$, ByVal nYourKey As Long, ByVal sRegString$, ByVal cbMaxStringSize As Integer, peRegistered As Integer) As Integer

Function RegKeyFileGenerate% (sRegString$, sGenerationCode$, sRandomSeed$, sFileName$)
' Generates a file-based registration key for a particular user, using the
' secret generation code corresponding to a particular application (as
' passeed to RegKeyNewCodeSet()). The registration string is usually the
' name of the registered user, but may also contain other information, such
' as the version registered or date of expiry. A registration key file is
' generated, using the specified filename, containing the registration string
' and the resulting registration key. If a file with the specified name
' already exists, it is overwritten. sRandomSeed should contain 10 random
' numbers and upper-case letters, which are required during the registration
' key generation process.
'
' This function is called by KeyGen or your own registration key generation
' utility, each time a registration key is generated for a new user. This
' function is used for file-based registration keys; compare with
' RegKeyGenerate().
'
' sRegString         INPUT: Registration string
' sGenerationCode    INPUT: App's generation code
' sRandomSeed        INPUT: Random number seed
' sFileName          INPUT: Registration key file name

    RegKeyFileGenerate% = rkfg(sRegString$, sGenerationCode$, sRandomSeed$, sFileName$)

End Function

Function RegKeyFileValidate% (sFileName$, sValidationCode$, sYourName$, nYourKey As Long, sRegString$, cbMaxStringSize As Integer, peRegistered As Integer)
' Checks whether the specified registration key file is valid for a
' particular application, using the application-specified validation code
' that was generated by RegKeyNewCodeSet(). The RKVALID pointed to by
' peRegistered is set to either RK_REGISTERED or RK_UNREGISTERED,
' indicating whether or not the registration key and registration string
' stored in the registration key file are valid. The sFileName parameter
' may include wildcards. If you have registered RegKey, your own name and
' RegKey registration key should be passed to this function to diable the
' RegKey "unregistered" message.
'
' This function is called from within your application each time it
' executes, in order to determine whether it should operate in registered
' or unregistered mode. This function is used with file-based registration
' keys; compare with RegKeyValidate().
'
' sFileName           INPUT: Registration key file name
' sValidationCode     INPUT: App's validation code
' sYourName           INPUT: Your name (if registered)
' nYourKey            INPUT: Your key (if registered)
' sRegString          OUTPUT: Registration string
' cbMaxStringSize     INPUT: Characters in reg. string
' peRegistered        OUTPUT: Is key valid

   sTemp$ = String$(cbMaxStringSize, 0)
   RegKeyFileValidate% = rkfv(sFileName$, sValidationCode$, sYourName$, nYourKey, sTemp$, cbMaxStringSize + 1, peRegistered)
   sRegString$ = sTemp$

End Function

Function RegKeyGenerate% (sRegString$, sGenerationCode$, sRandomSeed$, sRegKey$)
' Generates a registration key for a particular user, using the secret
' generation code corresponding to a particular application (as passed to
' RegKeyNewCodeSet()). The registration string is usually the name of the
' registered user, but may also contain other information, such as the
' version registered or date of expiry. The registration key is returned as a
' string of letters and upper-case numbers. sRegKey must be large enough to
' hold 20 digits. sRandomSeed should contain 10 random numbers and upper-case
' letters, which are required during the registration key generation process.
'
' This function is called by KeyGen or your own registration key generation
' utility, each time a registration key is generated for a new user. This
' function is used for user-entered registration keys; compare with
' RegKeyFileGenerate().
'
' sRegString          INPUT: Registration string
' sGenerationCode     INPUT: App's generation code
' sRandomSeed         INPUT: Random number seed
' sRegKey             OUTPUT: 20-digit registration key

   sTemp$ = String$(20, 0)
   RegKeyGenerate% = rkg(sRegString$, sGenerationCode$, sRandomSeed$, sTemp$)
   sRegKey$ = sTemp$

End Function

Function RegKeyNewCodeSet% (sGenerationCode$, sValidationCode$)
' Generates a registration key validation code corresponding to a
' generation code. This set of generation and validation codes is unique
' for each application using RegKey, and determines the unique registration
' key that corresponds to a particular user's name. The secret generation
' code is used at registration key generation time, and the corresponding
' validation code is used within your application when validating a
' registration key. The validation and generation codes are each
' represented as a ten-digit strings of numbers and upper-case letters.
'
' This function is called by KeyGen or your own utility, and is only used
' once for each application using RegKey.
'
' sGenerationCode     INPUT: Ten digit generation code
' sValidateCode       OUTPUT: Ten digit validation code

   sTemp$ = String$(10, 0)
   RegKeyNewCodeSet% = rkncs(sGenerationCode$, sTemp$)
   sValidationCode$ = sTemp$


End Function

Function RegKeyValidate% (sRegString$, sRegKey$, sValidationCode$, sYourName$, nYourKey As Long, peRegistered As Integer)
' Checks whether a given registration string and registration key
' combination is valid for a particular application, using the application-
' specific validation code that was generated by RegKeyNewCodeSet(). The
' RKVALID pointed to by peRegistered is set to either RK_REGISTERED or
' RK_UNREGISTERED, indicating whether or not the registration key and
' registration string are valid. If you have registered RegKey, your own
' name and RegKey registration key should be passed to this function to
' disable the RegKey "unregistered" message.
'
' This function is called from within your application each time it
' executes, in order to determine whether it should operate in registered
' or unregistered mode. This function is used with user-entered
' registration keys; compare with RegKeyFileValidate().
'
' sRegString          INPUT: Registration string
' sRegKey             INPUT: 20-digit registration key
' sValidationCode     INPUT: App's validation code
' sYourName           INPUT: Your name (if registered)
' nYourKey            INPUT: Your key (if registered)
' peRegistered        OUTPUT: Is key valid

   RegKeyValidate% = rkv(sRegString$, sRegKey$, sValidationCode$, sYourName$, nYourKey, peRegistered)

End Function

