/*
*
* MODULE: DSIINIT.C
*
*/

#include "dsimport.h"

HWND hwndImportWnd;

/*
*
* FUNCTION: InitializeApplication(HANDLE)
*
*/
BOOL FAR PASCAL InitializeApplication(hInst)
HANDLE hInst;
{
      WNDCLASS wc;

      wc.style = NULL;
      wc.lpfnWndProc = ImportWndProc;
      wc.cbClsExtra = NULL;
      wc.cbWndExtra = NULL;
      wc.hInstance = hInst;
      wc.hIcon = LoadIcon(hInst, DSIMPORT);
      wc.hCursor = LoadCursor(NULL, IDC_ARROW);
      wc.hbrBackground = GetStockObject(LTGRAY_BRUSH);
      wc.lpszMenuName = DSIMENU;
      wc.lpszClassName = "DSIWnd";
      
      return(RegisterClass(&wc));
}
/*
*
* FUNCTION: InitializeInstance(LPSTR, int)
*
*/
BOOL FAR PASCAL InitializeInstance(lpCmdLine, nCmdShow)
LPSTR lpCmdLine;
int nCmdShow;
{
      char sz[80];
      
      LoadString(hInst, IDS_APPNAME, sz, sizeof(sz));

      hwndImportWnd = CreateWindow("DSIWnd",
                                     sz,
                                     WS_OVERLAPPEDWINDOW | WS_CLIPCHILDREN,
                                     CW_USEDEFAULT,
                                     CW_USEDEFAULT,
                                     CW_USEDEFAULT,
                                     CW_USEDEFAULT,
                                     NULL,
                                     NULL,
                                     hInst,
                                     NULL);

      
      if (!hwndImportWnd)
               return(FALSE);

      ShowWindow(hwndImportWnd, SW_SHOWMAXIMIZED);

      return(TRUE);
}

