EXTPROC CEnvi2
// ****************************************
// *** NoTitleB.cmd - Remove elements   ***
// *** ver.1          of the title bar. ***
// ****************************************

#include <WinTools.lib>
#include <WinMsg.lib>

main(argc,argv)
{
   if ( argc < 3 )
      Instructions();
   else {
      WindowTitle = argv[1];
      WindowHandle = GetWindowHandle(WindowTitle);

      AlterTitleBar(WindowHandle,argc-2,argv+2);
   }
}

Instructions()
{
   puts(``)
   puts(`NoTitleB - Remove elements of a title bar`)
   puts(``)
   puts(`SYNTAX: NoTitleB <WindowTitle> <Element> [<Element>...]`)
   puts(``)
   puts(`Where: WindowTitle : Current title of window`)
   puts(`       Element : Specific element of window to remove, may be:`)
   puts(`                  TITLE, SYSMENU, MENU, MINMAX`)
   puts(``)
   puts(`Examples: To remove all titlebar elements, do the following:`)
   puts(`            NoTitleB Clock TITLE SYSMENU MENU MINMAX`)
   puts(``)
}


   #define FCF_TITLEBAR          0x00000001
   #define FCF_SYSMENU           0x00000002
   #define FCF_MENU              0x00000004
   #define FCF_SIZEBORDER        0x00000008
   #define FCF_MINBUTTON         0x00000010
   #define FCF_MAXBUTTON         0x00000020
   #define FCF_MINMAX            0x00000030
   #define FCF_VERTSCROLL        0x00000040
   #define FCF_HORZSCROLL        0x00000080
   #define FCF_DLGBORDER         0x00000100
   #define FCF_BORDER            0x00000200
   #define FCF_SHELLPOSITION     0x00000400
   #define FCF_TASKLIST          0x00000800
   #define FCF_NOBYTEALIGN       0x00001000
   #define FCF_NOMOVEWITHOWNER   0x00002000
   #define FCF_ICON              0x00004000
   #define FCF_ACCELTABLE        0x00008000
   #define FCF_SYSMODAL          0x00010000
   #define FCF_SCREENALIGN       0x00020000
   #define FCF_MOUSEALIGN        0x00040000
   #define FCF_HIDEBUTTON        0x01000000
   #define FCF_HIDEMAX           0x01000020

   #define FID_SYSMENU     0x8002
   #define FID_TITLEBAR    0x8003
   #define FID_MINMAX      0x8004
   #define FID_MENU        0x8005
   #define FID_VERTSCROLL  0x8006
   #define FID_HORZSCROLL  0x8007
   #define FID_CLIENT      0x8008


AlterTitleBar(pHwnd,pCount,pArgs)
{
   AlteredFlag = 0;
   for ( ; pCount; pCount--, pArgs++ ) {
      Setting = pArgs[0];
 
      if ( !stricmp(Setting,"TITLE") ) {
         id = FID_TITLEBAR; cf = FCF_TITLEBAR;
      } else if ( !stricmp(Setting,"SYSMENU") ) {
         id = FID_SYSMENU; cf = FCF_SYSMENU;
      } else if ( !stricmp(Setting,"MENU") ) {
         id = FID_MENU; cf = FCF_MENU;
      } else if ( !stricmp(Setting,"MINMAX") ) {
         id = FID_MINMAX; cf = FCF_MINMAX;
      } else {
         printf("Unrecognized frame element \"%s\"!\a\n",Setting);
         exit(EXIT_FAILURE);
      }

      if ( SubHwnd = WinWindowFromID(pHwnd,id) ) {
         // remove this element
         AlteredFlag |= cf;
         // set parent to object (undisplayed)
         #define HWND_OBJECT 2
         WinSetParent(SubHwnd,HWND_OBJECT,False);
      }
   }

   if ( AlteredFlag ) {
      // send message that frame has been updated
      #define WM_UPDATEFRAME  0x0042
      WinPostMsg(pHwnd,WM_UPDATEFRAME,AlteredFlag,NULL);
   }
}

WinWindowFromID(pParentHwnd,pChildID)
{
   #define ORD_WIN32WINDOWFROMID 899
   return PMDynamicLink("PMWIN",ORD_WIN32WINDOWFROMID,BIT32,CDECL,
                        pParentHwnd,pChildID);
}

WinSetParent(pHwnd,pNewParentHwnd,pRedraw)
{
   #define ORD_WIN32SETPARENT 865
   return PMDynamicLink("PMWIN",ORD_WIN32SETPARENT,BIT32,CDECL,
                         pHwnd,pNewParentHwnd,pRedraw);
}

