EXTPROC CEnvi2
/*******************************************************************
 *** Sound - Sound a specified frequency for specified number of ***
 *** ver.1   milliseconds (approximate).                         ***
 *******************************************************************/

main(argc,argv)
{
   if ( argc != 3 || 0 == (frequency=atol(argv[1])) || 0 == (duration=atol(argv[2])) )
      Instructions();
   else
      DosBeep(frequency,duration)
}

DosBeep(Frequency,Duration)   // play specified Frequency, in Hz, for specified
{                             // duration, in milliseconds
   #define ORD_DOS32BEEP   286
   return DynamicLink("doscalls",ORD_DOS32BEEP,BIT32,CDECL,Frequency,Duration)
}

//DosBeepGate(Frequency,Duration)
//{
//   #define DOS16BEEP_GATE 0x1692
//   rc = DynamicLink(DOS16BEEP_GATE,BIT16,PASCAL,
//                    Frequency,Duration);
//   printf("rc = %08X\n",rc);
//}

Instructions()
{
   printf("\a\n")
   printf("Sound - Sound a specified tone on the internal speaker for specified time\n")
   printf("\n")
   printf("SYNTAX:  SOUND Freqency Duration\n")
   printf("\n")
   printf("Where:  Frequency     Tone in hertz\n")
   printf("        Duration      In milliseconds\n")
   printf("\n")
   printf("The following example would play middle A for 2 seconds:\n");
   printf("    SOUND 440 2000\n")
   printf("\n")
}

