EXTPROC CEnvi2
//***************************************************************
//*** SysInfo() - Display lots of system information from the ***
//*** ver.1       DosQuerySysInfo() call.                     ***
//***************************************************************

#define QSV_MAX_PATH_LENGTH   1
#define QSV_MAX_TEXT_SESSIONS 2
#define QSV_MAX_PM_SESSIONS   3
#define QSV_MAX_VDM_SESSIONS  4
#define QSV_BOOT_DRIVE        5  // 1=A, 2=B, etc.
#define QSV_DYN_PRI_VARIATION 6  // 0=Absolute, 1=Dynamic
#define QSV_MAX_WAIT          7  // seconds
#define QSV_MIN_SLICE         8  // milli seconds
#define QSV_MAX_SLICE         9  // milli seconds
#define QSV_PAGE_SIZE         10
#define QSV_VERSION_MAJOR     11
#define QSV_VERSION_MINOR     12
#define QSV_VERSION_REVISION  13 // Revision letter
#define QSV_MS_COUNT          14 // Free running millisecond counter
#define QSV_TIME_LOW          15 // Low dword of time in seconds
#define QSV_TIME_HIGH         16 // High dword of time in seconds
#define QSV_TOTPHYSMEM        17 // Physical memory on system
#define QSV_TOTRESMEM         18 // Resident memory on system
#define QSV_TOTAVAILMEM       19 // Available memory for all processes
#define QSV_MAXPRMEM          20 // Avail private mem for calling proc
#define QSV_MAXSHMEM          21 // Avail shared mem for calling proc
#define QSV_TIMER_INTERVAL    22 // Timer interval in tenths of ms
#define QSV_MAX_COMP_LENGTH   23 // max len of one component in a name
#define QSV_FOREGROUND_FS_SESSION 24
#define QSV_FOREGROUND_PROCESS 25

printf("System parameters:\n");
printf("Maximum length, in bytes, of a path name: %d\n",QuerySysInfo(QSV_MAX_PATH_LENGTH));
printf("Maximum number of text sessions: %d\n",QuerySysInfo(QSV_MAX_TEXT_SESSIONS));
printf("Maximum number of PM sessions: %d\n",QuerySysInfo(QSV_MAX_PM_SESSIONS));
printf("Maximum number of DOS sessions: %d\n",QuerySysInfo(QSV_MAX_VDM_SESSIONS));
printf("Boot drive: %c\n",'A' - 1 + QuerySysInfo(QSV_BOOT_DRIVE));
printf("Priority method: %s\n",QuerySysInfo(QSV_DYN_PRI_VARIATION) ? "Dynamic" : "Absolute" );
printf("Maximum wait in seconds: %d\n",QuerySysInfo(QSV_MAX_WAIT));
printf("Minimum time slice in milliseconds: %d\n",QuerySysInfo(QSV_MIN_SLICE));
printf("Maximum time slice in milliseconds: %d\n",QuerySysInfo(QSV_MAX_SLICE));
printf("Memory page size in bytes: %d\n",QuerySysInfo(QSV_PAGE_SIZE));
printf("Major version number: %d\n",QuerySysInfo(QSV_VERSION_MAJOR));
printf("Minor version number: %d\n",QuerySysInfo(QSV_VERSION_MINOR));
printf("Revision letter (value): %d\n",QuerySysInfo(QSV_VERSION_REVISION));
printf("32-bit, free-running millisecond counter: %u\n",QuerySysInfo(QSV_MS_COUNT));
printf("Time (seconds) since January 1, 1970 at 0:00:00 (low): %u\n",QuerySysInfo(QSV_TIME_LOW));
printf("Time (seconds) since January 1, 1970 at 0:00:00 (high): %u\n",QuerySysInfo(QSV_TIME_HIGH));
printf("Total physical memory (bytes / Mb): %u / %f\n",
       QuerySysInfo(QSV_TOTPHYSMEM),QuerySysInfo(QSV_TOTPHYSMEM)/float(0x100000));
printf("Total resident memory (bytes / Mb): %u / %f\n",
       QuerySysInfo(QSV_TOTRESMEM),QuerySysInfo(QSV_TOTRESMEM)/float(0x100000));
printf("Total available memory (bytes / Mb): %u / %f\n",
       QuerySysInfo(QSV_TOTAVAILMEM),QuerySysInfo(QSV_TOTAVAILMEM)/float(0x100000));
printf("Available private memory for this process (bytes / Mb): %u / %f\n",
       QuerySysInfo(QSV_MAXPRMEM),QuerySysInfo(QSV_MAXPRMEM)/float(0x100000));
printf("Available shared memory for this process (bytes / Mb): %u / %f\n",
       QuerySysInfo(QSV_MAXSHMEM),QuerySysInfo(QSV_MAXSHMEM)/float(0x100000));
printf("Timer interval in tenths of a millisecond: %u\n",QuerySysInfo(QSV_TIMER_INTERVAL));
printf("Maximum length of one component in a name: %u\n",QuerySysInfo(QSV_MAX_COMP_LENGTH));
printf("Session ID of current full-screen session: %d\n",QuerySysInfo(QSV_FOREGROUND_FS_SESSION));
printf("Process ID of current foreground process: %d\n",QuerySysInfo(QSV_FOREGROUND_PROCESS));


QuerySysInfo(pIndex) // return double-word value for this
{                    // index.  Exit failure if error.
   #define ORD_DOS32QUERYSYSINFO 348
   lRC = DynamicLink("doscalls",ORD_DOS32QUERYSYSINFO,BIT32,CDECL,
                     pIndex,pIndex,lData,4);
   if ( lRC ) {
      printf("DosQuerySysInfo() returned error %d for index %d\n\a",lRC,pIndex);
      exit(EXIT_FAILURE);
   }
   return lData;
}

