EXTPROC CEnvi2
//********************************************************************
//*** Which.bat - Show when command would be executed by searching ***
//*** ver.1       for command along path.                          ***
//********************************************************************

ExecuteOrder = { ".COM", ".EXE", ".CMD", ".BAT" };

Instructions()
{
   printf("\a\n")
   puts(`Which - Determine which command in PATH will execute, and what order`)
   puts(``)
   puts(`SYNTAX: Which <CommandSpec>`)
   puts(``)
   puts(`WHERE: CommandSpec is any file spec.  If CommandSpec has no extension then`)
   printf(`       will search executables in this order:`)
   for ( i = 0; i <= GetArraySpan(ExecuteOrder); i++ )
      printf(" %s",ExecuteOrder[i])
   puts(``)
   puts(`EXAMPLES: Which EDIT`)
   puts(`          Which SESSION.C*`)
   exit(EXIT_FAILURE);
}

main(argc,argv)
{
   if ( argc != 2 )   Instructions();

   NameParts = SplitFileName(argv[1]);
   if ( NameParts.dir[0] ) {
      printf("\aWHICH whill not work with directory specifications.\n");
      exit(EXIT_FAILURE);
   }

   // if extension then use it, else use our extension list
   if ( NameParts.ext[0] ) {
      Extensions[0] = NameParts.ext;
      ExtensionCount = 1;
   } else {
      Extensions = ExecuteOrder;
      ExtensionCount = 1 + GetArraySpan(ExecuteOrder);
   }

   // get prioritized list of all directories
   PathCount = BuildPathList(PathList);

   // for each directory, find all of the matching files
   FindCount = 0;
   for ( PathIdx = 0; PathIdx < PathCount; PathIdx++ ) {
      for ( ExtensionIdx = 0; ExtensionIdx < ExtensionCount; ExtensionIdx++ ) {
         FindCount += FindFileInDirectory(PathList[PathIdx],NameParts.name,Extensions[ExtensionIdx]);
      }
   }

   if ( !FindCount ) {
      printf("\aNo commands found for %s\n",argv[1]);
      exit(EXIT_FAILURE);
   }

}


BuildPathList(List)
{
   Count = 0;
   // First path will always be the current one
   List[Count++] = FullPath(".");

   // get full path of each directory from the PATH variable
   if ( Path = getenv("PATH") ) {
      for ( Dir = strtok(Path,";"); Dir; Dir = strtok(NULL,";") ) {
         if ( Dir[0] )
            List[Count++] = FullPath(Dir);
      }
   }

   // make sure each element in path list ends in '\'
   for ( i = 0; i < Count; i++ ) {
      if ( strcmp(":\\",List[i]+1) )
         strcat(List[i],"\\");
   }
   return Count;
}

FindFileInDirectory(DirSpec,NameSpec,ExtSpec)
{
   sprintf(FindSpec,"%s%s%s",DirSpec,NameSpec,ExtSpec);
   if ( !(FindList = Directory(FindSpec,False,FATTR_RDONLY|FATTR_ARCHIVE)) )
      return 0;

   Count = 1 + GetArraySpan(FindList);
   for ( i = 0; i < Count; i++ )
      printf("  %s\n",FindList[i].name);
   return Count;
}

