EXTPROC CEnvi2.exe
//***********************************************************
//*** WinQList.cmd - Show a list of all PM queues, their  ***
//*** ver.1          sizes, and how many windows use them ***
//***********************************************************

#define HWND_DESKTOP 1
#define HWND_OBJECT  2

printf("\nBuild Queue List from Window handles...");

QueueCount = BuildQueueList(QueueList);

printf("\rProcess      ID      Queue    Size   Desktop Windows  Object Windows");
printf("\n---------- ------    -----   ------  ---------------  --------------\n\n");

for ( q = 0; q < QueueCount; q++ ) {
   hmq = QueueList[q].Queue;
   if ( GetQueueData(hmq,ProcessList(),ProcessName,ProcessID,QueueSize) )
      printf("%-10.10s   %-5d %04X    %-6d       %-6d        %-6d\n",
             ProcessName,ProcessID,hmq,QueueSize,
             QueueList[q].DesktopCount,QueueList[q].ObjectCount);
}

/////////////////////////////////////////////////////////////////////////

BuildQueueList(QList)
{
   AddQueueForWindowAndChildren(QList,HWND_DESKTOP,True);
   AddQueueForWindowAndChildren(QList,HWND_OBJECT,False);
   return 1 + GetArraySpan(QList);
}

AddQueueForWindowAndChildren(QList,ParentHandle,IsDesktopWindow)
{
   // Get the queue for this parent handle
   Queue = GetWindowQueue(ParentHandle);

   // If this queue is not already in the queue list, then add it
   if ( !defined(QList) ) {
      QList[0].Queue = Queue;
      QList[0].DesktopCount = IsDesktopWindow ? 1 : 0;
      QList[0].ObjectCount = IsDesktopWindow ? 0 : 1;
   } else {
      // only show this queue if it hasn't already been shown
      for ( i = GetArraySpan(QList); 0 <= i; i-- ) {
         if ( Queue == QList[i].Queue ) {
            if ( IsDesktopWindow )
               QList[i].DesktopCount++;
            else
               QList[i].ObjectCount++;
            break;
         }
      }
      if ( i < 0 ) {
         NewEntry.Queue = Queue;
         NewEntry.DesktopCount = IsDesktopWindow ? 1 : 0;
         NewEntry.ObjectCount = IsDesktopWindow ? 0 : 1;
         QList[1+GetArraySpan(QList)] = NewEntry;
      }
   }

   // recursively call this routine for all its children
   EnumHandle = WinBeginEnumWindows(ParentHandle);
   while ( NULL != (WinHandle = WinGetNextWindow(EnumHandle)) ) {
      AddQueueForWindowAndChildren(QList,WinHandle,IsDesktopWindow);
   }
   WinEndEnumWindows(EnumHandle);
}

WinBeginEnumWindows(pHwndParent)
{
   #define ORD_WIN32BEGINENUMWINDOWS   702
   return DynamicLink("PMWIN",ORD_WIN32BEGINENUMWINDOWS,BIT32,CDECL,pHwndParent)
}

WinGetNextWindow(pHEnum)
{
   #define ORD_WIN32GETNEXTWINDOW      756
   return DynamicLink("PMWIN",ORD_WIN32GETNEXTWINDOW,BIT32,CDECL,pHEnum)
}

WinEndEnumWindows(pHEnum)
{
   #define ORD_WIN32ENDENUMWINDOWS     737
   return DynamicLink("PMWIN",ORD_WIN32ENDENUMWINDOWS,BIT32,CDECL,pHEnum)
}

GetWindowQueue(hwnd)
{
   #define ORD_WIN32QUERYWINDOWULONG   843
   #define QWL_HMQ   (-4)
   return DynamicLink("PMWIN",ORD_WIN32QUERYWINDOWULONG,BIT32,CDECL,
                      hwnd,QWL_HMQ)
}

GetQueueInfo(hmq,count,pid)
{
   #define ORD_WIN32QUERYQUEUEINFO  824
   BLOBSize(qinfo,4 * 5);
   success = DynamicLink("PMWIN",ORD_WIN32QUERYQUEUEINFO,BIT32,CDECL,
                         hmq,qinfo,BLObSize(qinfo));
   if ( success ) {
      pid = BLObGet(qinfo,4 * 1,UWORD32);
      count = BLObGet(qinfo,4 * 3,UWORD32);
   }
   return(success);
}

GetQueueData(hmq,PList,ProcessName,ProcessID,QueueSize)
   // return data about this queue and who owns it; False if cannot
{
   if ( !GetQueueInfo(hmq,QueueSize,ProcessID) )
      return(False);

   // to find process name, match processID to id in PList
   for ( p = GetArraySpan(PList); 0 <= p; p-- ) {
      if ( ProcessID == PList[p].id ) {
         ProcessName = SplitFileName(PList[p].name).name;
         return(True);
      }
   }
   // if got here, then all OK except for process name
   ProcessName = "?????";
   return(True);
}

