(********************************)
(* global declaration for setup *)
(********************************)
unit Decla;

interface

const Max_Group = 05;
      Max_Files = 150;
      Max_Icons = 100;
      Max_Run   = 05;
      Max_Path  = 51;
      Max_IniF  = 100;
      Max_Maxi  = 120;
      Max_Pack  = 5;
      One_Meg   = 1048576;
      Fch_UnIns = 'UNSETUP.';
      Fch_Ins   = 'SETUP.';
      Prg_Title = 'Create';
      Prg_Versi = '5.00b';
      Prg_Year  = '1996';
      Prg_Autho = 'J. BERTRAND';

      (* vecteur des groupes *)
Type TVect_Group = record
                    GroupName : string [30];    (* Nom du groupe      *)
                    GroupFile : string [79];    (* Fichier de groupe  *)
                   end;
     (* vecteur des icones a creer *)
     TVect_Icons = record
                    DiskNumb : byte;            (* numero de disquette*)
                    OrigPath : string [03];     (* original path      *)
                    OrigName : string [12];     (* original name      *)
                    FileDriv : string [2];      (* drive of icon      *)
                    FileName : string [12];     (* nom du fichier     *)
                    FilePath : string [03];     (* access au fichier  *)
                    IconName : string [30];     (* nom de l'icone     *)
                    Compress : byte;            (* Compress Yes / No  *)
                    SizeNorm : longint;         (* file size          *)
                    SizeComp : longint;         (* size after expand  *)
                    GroupNum : byte;            (* number of group    *)
                    PackFile : byte;            (* packet file        *)
                   end;
     (* vecteur des fichier a copier *)
     TVect_Files = record
                    DiskNumb : byte;            (* numero de disquette*)
                    OrigPath : string [03];     (* original path      *)
                    OrigName : string [12];     (* original name      *)
                    FileDriv : string [2];      (* drive of file      *)
                    FileName : string [12];     (* nom du fichier     *)
                    FilePath : string [03];     (* chemin destination *)
                    Compress : byte;            (* Compress Yes / No  *)
                    CopyFile : byte;            (* Copy Yes / No      *)
                    SizeNorm : longint;         (* file size          *)
                    SizeComp : longint;         (* size after expand  *)
                    PackFile : byte;            (* packet file        *)
                   end;
     (* vecteurs des fichier a lancer *)
     TVect_Run =   record
                    FileName : string [12];     (* fichier a lancer   *)
                    FilePath : string [03];     (* chemin d'access    *)
                    DocsDriv : string [2];      (* drive of file      *)
                    DocsName : string [12];     (* document associe   *)
                    DocsPath : string [03];     (* chemin document    *)
                    PackFile : byte;            (* packet file        *)
                   end;
     (* vecteur des disques *)
     TVect_Path =  record
                    LettDriv : string [2];      (* la lettre lecteur  *)
                    PathDriv : string [79];     (* chemin lecteur     *)
                   end;
     (* vecteur des files INI *)
     TVect_IniFi = record
                    FileName : string [12];     (* name of ini file   *)
                    FilePath : string [03];     (* path to access     *)
                    INISecti : string [30];     (* name of section    *)
                    INIField : string [30];     (* name of filed      *)
                    INIValue : string [30];     (* name of value(s)   *)
                   end;
     (* For transfert between dialogs *)
     TTran_Infor = record
                    Title  : string;
                    Number : integer;
                    Positi : integer;
                   end;
     (* for deletion *)
     TVect_Libel = record
                    Libelle : string [12];
                    Exists  : boolean;
                   end;
     (* info about file *)
     TFichierInf = record
                    Name : string [12];
                    Size : longint;
                   end;
     (* all file onfo *)
     TFile_Info  = record
                    Driv : char;
                    path : string [79];
                    onam : string [12];
                    Fich : TFichierInf;
                    Comp : TFichierInf;
                    FlgC : byte;
                   end;

     (* description of pack file *)
     TPack_File = record
                   libelle : string [30];
                  end;

var VGroup : array [1 .. max_group] of TVect_Group;   (* les groupes    *)
    VIcons : array [1 .. max_icons] of TVect_Icons;   (* les icones     *)
    VFiles : array [1 .. max_files] of TVect_Files;   (* les fichiers   *)
    VRun   : array [1 .. max_run]   of TVect_Run;     (* les lancements *)
    VPath  : array [1 .. max_path]  of TVect_Path;    (* origine/desti. *)
    VIniF  : array [1 .. max_inif]  of TVect_IniFi;   (* ini files      *)
    VLibel : array [1 .. max_maxi] of TVect_Libel;    (* for list dialg *)
    VPack  : array [1 .. max_pack] of TPack_File;     (* pack files desc*)
    VTrans : TTran_Infor;                             (* for dialogs    *)
    VFileI : TFile_Info;                              (* info of file   *)
    MultiF : TVect_Files;                             (* multiple files *)
    MultiI : TVect_Icons;                             (* multiple icons *)
    MultiD : TVect_Run;                               (* multiple docs  *)
    Title,SubTitle,Version,Author,Copyright : string; (* informations   *)
    Disk_Number  : integer;                           (* nbr de dsk < 2 *)
    Disk_Current : longint;                           (* space on flop  *)
    Disk_Space   : longint;                           (* space needed   *)
    Number_Direc : integer;                           (* nbr of target  *)
    Number_Group : integer;                           (* nbr de groupes *)
    Number_Icons : integer;                           (* nbr d'icones   *)
    Number_Files : integer;                           (* nbr de fichiers*)
    Number_Run   : integer;                           (* nbr de lance.  *)
    Number_Ini   : integer;                           (* Nbr of ini line*)
    Number_Pack  : byte;                              (* Nbr of pack fil*)
    Modification : boolean;                           (*True=modificatio*)
    ProjectName  : string [79];

implementation

end.

