(*********************************)
(*                               *)
(* Functions to install programs *)
(* (c)1996 by J. BERTRAND        *)
(*                               *)
(* ----------------------------- *)
(*                               *)
(* windows function (directory)  *)
(* directory functions           *)
(* file functions                *)
(* group & icons functions       *)
(*                               *)
(*********************************)
unit Disque;

interface

Const DiskName = 'DISK.';

(*******************)
(* extra functions *)
(*******************)
function WinDir : string;
                  {Windows directory without '\' at the end
                   none if can't find it}
function SysDir : string;
                  {Windows system directory without '\' at the end
                   none if can't find it}
function StartApp (AppName,AppParams,AppDir : string) : integer;
                  {0..32 : Error look to ShellExecute for explanations of error
                   other values > 32 : Ok application lauched Return = Handle of App}
function CheckDsk (Path : string;Number : integer) : integer;
                  {0 : OK it is the right disk in
                   1 : It isn't the right disk}
function SetPath (sPath : string) : integer;
                 {Return pointer in path array}

(***********************)
(* directory functions *)
(***********************)

function CreateDirectory (DirectoryName : string) : integer;
                  {0 : OK   directory created
                   1 : Unable to create}
function DestroyDirectory (DirectoryName : string) : integer;
                  {0 : OK directory deleted
                   1 : Unable to destroy}

(******************)
(* file functions *)
(******************)

function FileInfo (Name : string) : integer;
                  {0 : No problem
                   1 : Unabled to access file}
function DiskIDCorrect (Floppy : char;PathAccess : string;ID : integer) : integer;
                  { 0 : Yes this good floppy
                    1 : Wrong floppy and ok button
                    2 : Wrong floppy but cancel button}
function SizeFile (Fichier : string) : longint;
                  {-2 : Unable to set size
                   -1 : File doesn't exist
                   >0 : Size of the file}
function SizeLZFile (Fichier : string) : longint;
                  {-2 : Unable to set size
                   -1 : File doesn't exist
                   >0 : Size of the file}
function DeleteFile (Fichier : string) : integer;
                  {0 : OK file deleted
                   1 : File doesn't exist
                   2 : Unable to delete}
function ExistFile (Fichier : string) : integer;
                  {0 : File doesn't exist
                   1 : File exist}
function RenameFile (OldName,NewName : string) : integer;
                  {0 : OK file renammed
                   1 : OldName does't exist
                   2 : NewNameAlReadyExist
                   3 : Unable to rename}
function EnougthSpace (DriveUnit: char;Fichier : string) : integer;
                  {0 : OK enougth space
                   1 : File Doesn't exist
                   2 : Not enougth space
                   3 : Wrong letter Drive}
function CopyFile (FromFile,ToFile : string;Switch : byte) : integer;
		  {Switch         000 = Do nothing
			  bit 0 : 001 = Overwrite if ToFile exits
			      1 : 002 =
			      2 : 004 =
			      3 : 008 =
			      4 : 016 =
 			      5 : 032 =
                              6 : 064 =
                              7 : 128 =}
                  {0 : OK file copied
                   1 : File already exist and Switch = 0
                   2 : Unable to open Source File
                   3 : Unable to open destination file
                   4 : Unable to read from Source File
                   5 : Unable to write to destination file}

function HardCopyFile (const FromFile,ToFile : string;Switch : byte) : integer;
		  {Switch         000 = Do nothing
			  bit 0 : 001 = Overwrite if ToFile exits
			      1 : 002 =
			      2 : 004 =
			      3 : 008 =
			      4 : 016 =
 			      5 : 032 =
                              6 : 064 =
                              7 : 128 =}
                  {0 : OK file copied
                   1 : File already exist and Switch = 0
                   2 : Unable to open Source File
                   3 : Unable to open destination file
                   4 : Unable to read from Source File
                   5 : Unable to write to destination file}

(**********************)
(* Ini file functions *)
(**********************)

{
 0 : All thing are Ok
 1 : problem
}
function CreateIniFile    (FileName : string) : integer;
function DeleteIniFile    (FileName : string) : integer;
function CreateIniSection (FileName,Section : string) : integer;
function DeleteIniSection (FileName,Section : string) : integer;
function CreateIniField   (FileName,Section,Field : string) : integer;
function DeleteIniField   (FileName,Section,Field : string) : integer;
function ModifyIniValue   (FileName,Section,Field,Value : string) : integer;

implementation

uses SysUtils,WinProcs,WinTypes,DdeMan,ShellAPI,FileCtrl,Dialogs,LZExpand,
     IniFiles,Decla;

(*********************)
(*                   *)
(* FONCTIONS EN PLUS *)
(*                   *)
(*********************)

(*************************)
(* repertoire de windows *)
(*************************)
function WinDir : string;
var Tmp : string;
    Pas : array [0 .. 254] of char;
    Siz : integer;
begin
 Tmp := '';
 if GetWindowsDirectory(Pas,Sizeof (Pas)) <> 0 then
  Tmp := StrPas (Pas);
 WinDir := Tmp;
end;

(*********************)
(* repertoire system *)
(*********************)
function SysDir : string;
var Tmp : string;
    Pas : array [0 .. 254] of char;
    Siz : integer;
begin
 Tmp := '';
 if GetSystemDirectory (Pas,Sizeof (Pas)) <> 0 then
  Tmp := StrPas (Pas);
 SysDir := Tmp;
end;

(*******************************)
(* lancement d'une application *)
(*******************************)
function StartApp (AppName,AppParams,AppDir : string) : integer;
var Tmp : Integer;
    zFileName : array [0 .. 79] of char;
    zParams   : array [0 .. 79] of char;
    zDir      : array [0 .. 79] of Char;
begin
 Tmp := 0;
 StrPCopy (zFileName,AppName);
 StrPCopy (zParams,AppParams);
 StrPCopy (zDir,AppDir);
 Tmp := ShellExecute (0,Nil,zFileName,zParams,zDir,1);
 StartApp := Tmp;
end;

(********************************)
(* verification d'une disquette *)
(********************************)
function CheckDsk (Path : string;Number : integer) : integer;
var Tmp : integer;
    Nbr : string [3];
    Nam : string [12];
begin
 Tmp := 0;
 str (Number:3,Nbr);
 while pos (' ',Nbr) <> 0 do Nbr [pos (' ',Nbr)] := '0';
 while length (Nbr) < 3 do Nbr := '0' + Nbr;
 Nam := DiskName + Nbr;
 if ExistFile (Path + Nam) = 0 then
  Tmp := 1;
 CheckDsk := Tmp;
end;

(**********************************************)
(* set a new path in array and return position*)
(**********************************************)
function SetPath (sPath : string) : integer;
var iReturn  : integer;
    iCtr     : integer;
begin
 iReturn := 0;
 for iCtr := 1 to (Max_Path - 1) do
 begin
  if VPath [iCtr].PathDriv = UpperCase (Copy (sPath,3,length (sPath))) then
  begin
   iReturn := iCtr;
   break;
  end
  else
  begin
   if vPath [iCtr].PathDriv = '' then
   begin
    iReturn := iCtr;
    VPath [iCtr].LettDriv := UpperCase (Copy (sPath,1,2));
    VPath [iCtr].PathDriv  := UpperCase (Copy (sPath,3,length (sPath)));
    Number_Direc := iCtr;
    break;
   end;
  end;
 end;
 SetPath := iReturn;
end;

(*********************************)
(*                               *)
(* FONCTIONS SUR LES REPERTOIRES *)
(*                               *)
(*********************************)

(****************************)
(* creation d'un repertoire *)
(****************************)
function CreateDirectory (DirectoryName : string) : integer;
var Tmp : integer;
begin
 Tmp := 0;
 {$I-}; ForceDirectories (DirectoryName) {$I+};
 if DirectoryExists (DirectoryName) = false then Tmp := 1;
 CreateDirectory := tmp;
end;

(**************************)
(* destruction repertoire *)
(**************************)
function DestroyDirectory (DirectoryName : string) : integer;
var Tmp : integer;
begin
 Tmp := 0;
 {$I-}; RmDir (DirectoryName); {$I+};
 if ioresult <> 0 then Tmp := 1;
 DestroyDirectory := Tmp;
end;

(******************************)
(*                            *)
(* FONCTIONS SUR LES FICHIERS *)
(*                            *)
(******************************)


(******************)
(* info of a file *)
(******************)
function FileInfo (Name : string) : integer;
var Tmp : integer;
    Tm1 : string;
    Tm2 : string;
    Tm3 : string;
    FrF : Array [0..255] of char;
    ToF : Array [0..255] of char;
begin
 Tmp := 0;
 if FileExists (Name) = true then
 begin
  Tm1 := Name;
  Tm2 := Name;
  with VFileI do
  begin
   Driv := 'A';
   Path := '';
   ONam := '';
   Fich.Name := '';
   Fich.Size := 0;
   Comp.Name := '';
   Comp.Size := 0;
   FlgC := 0;
  end;
  (* drive *)
  if pos (':',Name) <> 0 then
  begin
   VFileI.Driv := Name [1];
   System.Delete (Tm1,1,pos (':',Tm1));
   System.Delete (Tm2,1,pos (':',Tm2));
  end;
  (* path *)
  While pos ('\',Tm1) <> 0 do
  begin
   VFileI.Path := VFileI.Path + copy (Tm1,1,pos ('\',Tm1));
   System.Delete (Tm1,1,Pos ('\',Tm1));
  end;
  VFileI.Path := copy (VFileI.Path,1,length (VFileI.Path) - 1);
  if VFileI.Path = '' then VFileI.Path := '\';
  (* name *)
  VFileI.Fich.Name := copy (Tm2,length (Tm2) - 11,13);
  while pos ('\',VFileI.Fich.Name) <> 0 do
   System.Delete (VFileI.Fich.Name,1,pos ('\',VFileI.Fich.Name));
  (* size *)
  VFileI.Fich.Size := SizeFile (Name);
  (* compressed *)
  StrPCopy (FrF,Name);
  GetExpandedName (FrF,ToF);
  if StrComp (FrF,ToF) <> 0 then
  begin
   Tm3 := StrPas (ToF);
   while pos ('\',Tm3) <> 0 do System.Delete (Tm3,1,pos ('\',Tm3));
   VFileI.ONam := Tm3;
   VFileI.FlgC := 1;
   VFileI.Comp.Name := strPas (ToF);
   VFileI.Comp.Size := SizeLZFile (Name);
  end;
 end
 else
  Tmp := 1;
 FileInfo := Tmp;
end;

(************************************)
(* check if floppy containt DISK.ID *)
(************************************)
function DiskIDCorrect (Floppy : char;PathAccess : string;ID : integer) : integer;
var Tmp : integer;
    Suf : string [3];
    Dsk : string;
begin
 Tmp := 0;
 Str (ID:3,Suf);
 If pathAccess [length (PathAccess)] = '\' then
 begin
  if length (PathAccess) > 1 then
  begin
   repeat
    PathAccess := copy (PathAccess,1,length (PathAccess) - 1)
   until PathAccess [length (PathAccess)] <> '\';
  end
  else
   PathAccess := '';
 end;
 While pos (' ',Suf) <> 0 do Suf [Pos (' ',Suf)] := '0';
 Dsk := Floppy + ':' + PathAccess + '\DISK.' + Suf;
 if ExistFile (Dsk) = 1 then
  Tmp := 0
 else
 begin
  Tmp := MessageDlg ('Please insert disk #' + Suf +
                     ' into drive ' + upcase (Floppy) + ':' + PathAccess,
                     mtConfirmation,[mbOk,mbCancel],0);
 end;
 DiskIDCorrect := tmp;
end;

(***********************)
(* taille d'un fichier *)
(***********************)
function SizeFile (Fichier : string) : longint;
var Tmp : longint;
    Siz : longint;
    Fch : file of byte;
begin
 if FileExists (Fichier) = false then
  Tmp := -1
 else
 begin
  System.assign (Fch,Fichier);
  {$I-}; System.Reset (Fch); {$I+};
  if ioresult <> 0 then
   Tmp := -2
  else
  begin
   Tmp := FileSize (Fch);
   System.Close (Fch);
  end;
 end;
 SizeFile := Tmp;
end;

(*****************************)
(* size of a compressed file *)
(*****************************)
function SizeLZFile (Fichier : string) : longint;
var pFrom     : array [0..255] of char;
    iHandle   : integer;
    ReOpenBuf : TOFStruct;
    iReturn   : longint;
begin
 iReturn := 0;
 strPCopy (pFrom,Fichier);
 LZStart;
 iHandle := LZOpenFile (pFrom, ReOpenBuf,of_Read or of_share_deny_write);
 if iHandle < 1 then
  iReturn := -1
 else
 begin
  iReturn := LZSeek (iHandle,0,2);
  LZClose (iHandle);
 end;
 LZDone;
 SizeLZFile := iReturn;
end;

(*********************)
(* efface un fichier *)
(*********************)
function DeleteFile (Fichier : string) : integer;
var Tmp : integer;
    Fch : file;
begin
 Tmp := 0;
 if ExistFile (Fichier) = 0 then
  Tmp := 1
 else
 begin
  Assign (Fch,Fichier);
  {$I-}; Erase (Fch); {$I+};
  if ioresult <> 0 then Tmp := 2;
 end;
 DeleteFile := Tmp;
end;

(******************************)
(* teste si un fichier existe *)
(******************************)
function ExistFile (Fichier : string) : integer;
var Fch : file;
    Tmp : integer;
begin
 Tmp := 1;
 assign (Fch,Fichier);
 {$I-}; reset (Fch); {$I+};
 if ioresult = 0 then Close (Fch)
                 else Tmp := 0;
 ExistFile := Tmp;
end;

(**********************)
(* renomme un fichier *)
(**********************)
function RenameFile (OldName,NewName : string) : integer;
var Tmp : integer;
    Fch : file;
begin
 Tmp := 0;
 if ExistFile (OldName) = 1 then
  Tmp := 1
 else
  if ExistFile (NewName) = 1 then
   Tmp := 2
  else
  begin
   assign (Fch,OldName);
   {$I-}; rename (Fch,NewName) {$I+};
   if ioresult <> 0 then Tmp := 3;
  end;
 RenameFile := Tmp;
end;

(***************************)
(* y a t il assez de place *)
(***************************)
function EnougthSpace (DriveUnit : char;Fichier : string) : integer;
var Tmp : integer;
    Siz : longint;
    Dsk : integer;
    DFr : longint;
begin
 Tmp := 0;
 Dsk := ord (upcase (DriveUnit)) - 64;
 if Dsk < 1 then
  Tmp := 3
 else
 begin
  if ExistFile (Fichier) = 0 then
   Tmp := 1
  else
  begin
   Siz := SizeFile (Fichier);
   if Siz > -1 then
   begin
    DFr := DiskFree (Dsk);
    if Dfr < 0 then
     tmp := 3
    else
     if Siz > DiskFree (Dsk) then Tmp := 2;
   end;
  end;
 end;
 EnougthSpace := Tmp;
end;

(**********************)
(* copie d'un fichier *)
(**********************)
function CopyFile (FromFile,ToFile : string ; Switch : byte) : integer;
var Tmp : integer;
    FromF, ToF: file;
    NumRead, NumWritten: Word;
    iHandle : Integer;
    iNewHandle : Integer;
    iReturn : Integer;
    iLongReturn : LongInt;
    pFrom : Array[0..256] of Char;
    pTo : Array[0..256] of Char;
begin
 Tmp := 0;
 If (ExistFile (ToFile) = 1) and (Switch = 0) then
  Tmp := 1
 else
 begin
  StrPCopy( pFrom, FromFile );
  iReturn := GetExpandedName( pFrom, pTo );
  if iReturn = -1 then
   Tmp := 2
  else
  begin
   if iReturn = -2 then
    Tmp := 3
   else
   begin
    if ( StrEnd( pTo ) - pTo ) > 0 then
    begin
     ToFile := ExtractFilePath( ToFile ) +
               ExtractFileName( strPas( pTo ) );
     LZStart;
     iHandle := FileOpen( FromFile, fmShareDenyWrite );
     if iHandle < 1 then
      Tmp := 2
     else
     begin
      iNewHandle := FileCreate( ToFile );
      if iNewHandle < 1 then
       Tmp := 3
      else
      begin
       iLongReturn := CopyLZFile( iHandle , iNewHandle );
       if iLongReturn = LZERROR_UNKNOWNALG then
        Tmp := 5
       else
       begin
        FileClose( iHandle );
        FileClose( iNewHandle );
        LZDone;
       end;
      end;
     end;
    end
    else
     Tmp := 3;
   end
  end;
 end;
 CopyFile := Tmp;
end;

(****************************)
(* copy a file just copy it *)
(****************************)
function HardCopyFile (const FromFile,ToFile : string ; Switch : byte) : integer;
var FromF, ToF: file;
    NumRead, NumWritten: Word;
    Buf    : array [1 .. 4096] of Char;
    Tmp : integer;
    Age : longint;
    Hdl : integer;
begin
 Tmp := 0;
 If (ExistFile (ToFile) = 1) and (Switch = 0) then
  Tmp := 1
 else
 begin
  AssignFile(FromF, FromFile);
  {$I-}; Reset(FromF, 1); {$I+};
  if ioresult = 0 then
  begin
   AssignFile(ToF, ToFile);
   {$I-};Rewrite(ToF, 1); {$I+};
   if ioresult = 0 then
   begin
    repeat
     {$I-}; BlockRead(FromF, Buf, SizeOf(Buf), NumRead); {$I+};
     if ioresult = 0 then
     begin
      {$I-}; BlockWrite(ToF, Buf, NumRead, NumWritten); {$I+};
      if ioresult <> 0 then
       Tmp := 5;
     end
     else
      Tmp := 4;
    until (NumRead = 0) or (NumWritten <> NumRead);
    System.CloseFile(FromF);
   end
   else
    Tmp := 3;
   System.CloseFile(ToF);
  end
  else
   Tmp := 2;
 end;
 (* set date *)
 {$I-}; Age := FileAge (FromFile); {$I+};
 if ioresult = 0 then
 begin
  {$I-}; Hdl := FileOpen (ToFile,fmShareDenyWrite); {$I+};
  if ioresult =0 then
  begin
   {$I-}; FileSetDate (Hdl,Age); {$I+};
   {$I-}; FileClose (Hdl); {$I+};
  end;
 end;
 HardCopyFile := Tmp;
end;


(**********************)
(* Ini file functions *)
(**********************)

{
 0 : All thing are Ok
 1 : problem
}
(* create an Ini file : it is a text file in fact *)
function CreateIniFile    (FileName : string) : integer;
var Tmp : integer;
    Fch : System.Text;
begin
 Tmp := 0;
 System.Assign (Fch,FileName);
 {$I-}; System.rewrite (Fch); {$I+};
 if ioresult = 0 then
  System.Close (Fch)
 else
  Tmp := 1;
 CreateIniFile := Tmp;
end;

(* delete an Ini file *)
function DeleteIniFile    (FileName : string) : integer;
var Tmp : integer;
    Fch : System.Text;
begin
 Tmp := 0;
 System.Assign (Fch,FileName);
 {$I-}; System.Erase (Fch); {$I+};
 if ioresult <> 0 then
  Tmp := 1;
 DeleteIniFile := Tmp;
end;

(* create a new section at the end of Ini file *)
function CreateIniSection (FileName,Section : string) : integer;
var Tmp : integer;
    Fch : System.Text;
begin
 Tmp := 0;
 System.Assign (Fch,FileName);
 {$I-}; System.Append (Fch); {$I+};
 if ioresult <> 0 then
  Tmp := 1
 else
 begin
  System.Writeln (Fch);
  System.Writeln (Fch,'[' + Section + ']');
  Close (Fch);
 end;
 CreateIniSection := Tmp;
end;

(* delete entire section *)
function DeleteIniSection (FileName,Section : string) : integer;
var Tmp : integer;
    Fch : TIniFile;
begin
 Tmp := 0;
 Fch := TIniFile.Create (FileName);
 Fch.EraseSection (Section);
 Fch.Free;
 DeleteIniSection := Tmp;
end;

(* Create a Ini Field *)
function CreateIniField   (FileName,Section,Field : string) : integer;
var Tmp : integer;
    Fch : TIniFile;
begin
 Tmp := 0;
 Fch := TIniFile.Create (FileName);
 Fch.WriteString (Section,Field,'');
 Fch.Free;
 CreateIniField := Tmp;
end;

(* Delete an Ini Field *)
function DeleteIniField   (FileName,Section,Field : string) : integer;
var Tmp : integer;
    Fch : TIniFile;
begin
 Tmp := 0;
 Fch := TIniFile.Create (FileName);
 Fch.WriteString (Section,Field,'');
 Fch.Free;
 DeleteIniField := Tmp;
end;

(* modify, add a new value *)
function ModifyIniValue   (FileName,Section,Field,Value : string) : integer;
var Tmp : integer;
    Fch : TIniFile;
begin
 Tmp := 0;
 Fch := TIniFile.Create (FileName);
 Fch.WriteString (Section,Field,Value);
 Fch.Free;
 ModifyIniValue := Tmp;
end;

end.

