unit Appadd;

interface

uses WinTypes, WinProcs, Classes, Graphics, Forms, Controls, Buttons,
  StdCtrls, ExtCtrls;

type
  TAddAppDialog = class(TForm)
    OKBtn: TBitBtn;
    CancelBtn: TBitBtn;
    Bevel1: TBevel;
    Label1: TLabel;
    Label2: TLabel;
    FileList: TListBox;
    IconList: TListBox;
    SelectDocs: TEdit;
    procedure SetNewFile(Sender: TObject);
    procedure ValNewFile(Sender: TObject);
    procedure SetNewIcon(Sender: TObject);
    procedure ValNewIcon(Sender: TObject);
    procedure Initialise(Sender: TObject);
    procedure CancelBtnClick(Sender: TObject);
    procedure OKBtnClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var AddAppDialog: TAddAppDialog;

implementation

uses Decla;

{$R *.DFM}

(* set a new file *)
procedure TAddAppDialog.SetNewFile(Sender: TObject);
begin
 IconList.ItemIndex := -1;
 if FileList.ItemIndex <> -1 then
 begin
  With VFiles [FileList.ItemIndex + 1] do
   SelectDocs.Text := FilePath + '\' + FileName;
 end;
end;

(* set and validate a new file *)
procedure TAddAppDialog.ValNewFile(Sender: TObject);
begin
 IconList.ItemIndex := -1;
 if FileList.ItemIndex <> -1 then
 begin
  With VFiles [FileList.ItemIndex + 1] do
   SelectDocs.Text := FilePath + '\' + FileName;
 end;
 OkBtnClick (Sender);
end;

(* set a new icon *)
procedure TAddAppDialog.SetNewIcon(Sender: TObject);
begin
 FileList.ItemIndex := -1;
 if IconList.ItemIndex <> -1 then
 begin
  with VIcons [IConList.ItemIndex + 1] do
   SelectDocs.Text := FilePath + '\' + FileName;
 end;
end;

(* set and validate a new icon *)
procedure TAddAppDialog.ValNewIcon(Sender: TObject);
begin
 FileList.ItemIndex := -1;
 if IconList.ItemIndex <> -1 then
 begin
  with VIcons [IConList.ItemIndex + 1] do
   SelectDocs.Text := FilePath + '\' + FileName;
 end;
 OkBtnClick (Sender);
end;

(* init dialog *)
procedure TAddAppDialog.Initialise(Sender: TObject);
var Bcl : integer;
begin
 SelectDocs.Text := '';
 FileList.Clear;
 if Number_Files > 0 then
 begin
  for Bcl := 1 to Number_Files do
   FileList.Items.Add (VFiles [Bcl].FileName);
 end;
 IconList.Clear;
 if Number_Icons > 0 then
 begin
  for Bcl := 1 to Number_Icons do
   IconList.Items.Add (VIcons [Bcl].FileName);
 end;
end;

(* cancel button *)
procedure TAddAppDialog.CancelBtnClick(Sender: TObject);
begin
 VTrans.Number := 0;
 ModalResult := mrCancel;
end;

(* ok button *)
procedure TAddAppDialog.OKBtnClick(Sender: TObject);
begin
 if FileList.ItemIndex <> -1 then
 begin
  With VFiles [FileList.ItemIndex + 1] do
  begin
   VTrans.Title := FileName;
   VTrans.Positi := FileList.ItemIndex + 1;
   VTrans.Number := 1;
  end;
 end;
 if IconList.ItemIndex <> -1 then
 begin
  With VIcons [IconList.ItemIndex + 1] do
  begin
   VTrans.Title := FileName;
   VTrans.Positi := IconList.ItemIndex + 1;
   VTrans.Number := 2;
  end;
 end;
 if (FileList.ItemIndex = -1) and
    (IconList.ItemIndex = -1) then
  ModalResult := mrCancel
 else
  ModalResult := mrOk;
end;

end.
