unit Delete;

interface

uses WinTypes, WinProcs, Classes, Graphics, Forms, Controls, Buttons,
  StdCtrls, ExtCtrls;

type
  TDeleteDialog = class(TForm)
    CancelBtn: TBitBtn;
    Bevel1: TBevel;
    Label1: TLabel;
    Liste: TListBox;
    DelBtn: TBitBtn;
    Label2: TLabel;
    procedure CancelBtnClick(Sender: TObject);
    procedure Init(Sender: TObject);
    procedure DelBtnClick(Sender: TObject);
    procedure ListeClick(Sender: TObject);
    procedure DblClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  DeleteDialog: TDeleteDialog;

implementation

uses Decla;

{$R *.DFM}

(* delete button *)
procedure TDeleteDialog.DelBtnClick(Sender: TObject);
var Tmp : integer;
begin
 if Liste.ItemIndex = -1 then
  Exit;
 VLibel [Liste.ItemIndex + 1].Exists := False;
 ModalResult := mrOk;
end;

(* cancel button *)
procedure TDeleteDialog.CancelBtnClick(Sender: TObject);
begin
 Close;
end;

(* init dialog *)
procedure TDeleteDialog.Init(Sender: TObject);
var Bcl : integer;
begin
 Caption := VTrans.Title;
 Liste.Clear;
 if VTrans.Number > 0 then
 begin
  for Bcl := 1 to VTrans.Number do
   Liste.Items.Add (VLibel [Bcl].libelle);
 end;
 if VTrans.Positi <> -1 then
  Liste.ItemIndex := VTrans.Positi - 1
 else
  Liste.ItemIndex := -1;
 DelBtn.Enabled := Liste.ItemIndex <> -1;
end;

(* click on list box : select *)
procedure TDeleteDialog.ListeClick(Sender: TObject);
begin
 DelBtn.Enabled := true;
end;

(* dbl click : select and delete *)
procedure TDeleteDialog.DblClick(Sender: TObject);
begin
 DelBtn.Enabled := true;
 DelBtnClick (Sender);
end;

end.
