unit Group;

interface

uses WinTypes, WinProcs, Classes, Graphics, Forms, Controls, Buttons,
     StdCtrls, ExtCtrls,Dialogs;

type
  TGroupDialog = class(TForm)
    OKBtn: TBitBtn;
    Bevel1: TBevel;
    Label1: TLabel;
    PGrpName: TEdit;
    Label2: TLabel;
    PGrpFile: TEdit;
    Label3: TLabel;
    Label4: TLabel;
    PListGroup: TListBox;
    AddBtn: TBitBtn;
    DelBtn: TBitBtn;
    procedure OKBtnClick(Sender: TObject);
    procedure Initialise(Sender: TObject);
    procedure AddBtnClick(Sender: TObject);
    procedure DelBtnClick(Sender: TObject);
    procedure Modification(Sender: TObject);
  private
    { Private declarations }
    Modif : boolean;
  public
    { Public declarations }
  end;

var
  GroupDialog: TGroupDialog;

implementation

uses Decla;

{$R *.DFM}

(* Ok button *)
procedure TGroupDialog.OKBtnClick(Sender: TObject);
begin
 ModalResult := mrOk;
 Close;
end;

(* Init dialog *)
procedure TGroupDialog.Initialise(Sender: TObject);
var Bcl : integer;
begin
 PListGroup.Clear;
 if Number_Group > 0 then
 begin
  for Bcl := 1 to Number_Group do
   PListGroup.Items.Add (VGroup [Bcl].GroupName);
 end;
 PListGroup.ItemIndex := -1;
 PGrpName.Text := '';
 PGrpFile.Text := '';
 Modif := false;
 ActiveControl := PListGroup;
end;

(* Add button *)
procedure TGroupDialog.AddBtnClick(Sender: TObject);
var Bcl : integer;
    Flg : boolean;
    Tm1 : string;
    Tm2 : string;
begin
 if PGrpName.text = '' then
 begin
  MessageDlg ('You must specify a group name',mtInformation,[mbok],0);
  exit;
 end;
 if Modif = true then
 (* modification *)
 begin
  with VGroup [PListGroup.ItemIndex + 1] do
  begin
   Tm1 := PGrpName.Text;
   Tm2 := PGrpFile.Text;
   Flg := True;
   for Bcl := 1 to length (Tm2) do
    if not (Tm2 [Bcl] in ['A' .. 'Z','0' .. '9']) then Flg := False;
   if Flg = true then
   begin
    GroupName := Tm1;
    GroupFile := Tm2;
    PListGroup.Items [PListGroup.ItemIndex] := GroupName;
   end
   else
    MessageDlg ('Wrong group file name',mtInformation,[mbok],0);
  end;
  PGrpName.Text := '';
  PGrpFile.Text := '';
  AddBtn.Caption := '&Add';
  PListGroup.ItemIndex := -1;
  PListGroup.Enabled := true;
  OkBtn.Enabled := true;
  Modif := false;
 end
 else
 (* creation *)
 begin
  if Number_Group + 1 <= Max_Group then
  begin
   inc (Number_Group);
   with VGroup [Number_Group] do
   begin
    GroupName := PGrpName.Text;
    GroupFile := PGrpFile.Text;
    Flg := True;
    for Bcl := 1 to length (GroupFile) do
     if not (GroupFile [Bcl] in ['A' .. 'Z','0' .. '9']) then Flg := False;
   end;
   if Flg = False then
   begin
    Dec (Number_Group);
    MessageDlg ('Wrong group file name',mtInformation,[mbok],0);
   end
   else
    PListGroup.Items.Add (VGroup [Number_Group].GroupName);
   PGrpFile.Text := '';
   PGrpName.Text := '';
   ActiveControl := PListGroup;
  end
  else
  begin
   MessageDlg ('Maximum of group reached',mtInformation,[mbok],0);
   PGrpName.Text := '';
   PGrpFile.Text := '';
  end;
 end;
end;

(* Del button *)
procedure TGroupDialog.DelBtnClick(Sender: TObject);
var Tmp : integer;
    Bcl : integer;
begin
 if PListGroup.ItemIndex <> -1 then
 begin
  Tmp := PListGroup.ItemIndex + 1;
  for Bcl := Tmp to (Max_Group - 1) do
   VGroup [Bcl] := VGroup [Bcl + 1];
  Dec (Number_Group);
  PListGroup.Items.Delete (PListGroup.ItemIndex);
 end;
end;

(* modification of a group *)
procedure TGroupDialog.Modification(Sender: TObject);
begin
 Modif := true;
 PGrpName.Text := VGroup [PListGroup.ItemIndex + 1].GroupName;
 PGrpFile.Text := VGroup [PListGroup.ItemIndex + 1].GroupFile;
 AddBtn.Caption := '&Mod';
 PListGroup.Enabled := false;
 OkBtn.Enabled := false;
end;

end.
