/*
    csetup.c

    Setup Program Written in the Mans language

    Another fine Herman Rodent production

*/

// COPYRIGHT:
//
//   (C) Copyright Microsoft Corp. 1993.  All rights reserved.
//
//   You have a royalty-free right to use, modify, reproduce and
//   distribute the Sample Files (and/or any modified version) in
//   any way you find useful, provided that you agree that
//   Microsoft has no warranty obligations or liability for any
//   Sample Application Files which are modified.
//

#include "csetup.h"
#include "setupapi.h"
#include <stdlib.h>


//
// global data specific to the app you are installing
//

char *szAppName         = "CSetup";         // App name
char *szCaption         = "'C' Setup";      // Caption
char szDest[_MAX_PATH]  = "C:\\BOGUS";      // Destination path
char *szProgmanGroup    = "C Setup";        // Progman group caption

//
// general stuff
//

HWND hwndFrame;                     // handle to setup frame window (hSetup)
CATCHBUF CatchBuf;
int Err;

//
// local functions
//

void Install(void);

//
// Entry point
//

int PASCAL WinMain(HINSTANCE hInstance,
                   HINSTANCE hPrevInstance,
                   LPSTR lpszCmdLine,
                   int cmdShow)
{
    UINT ui;
    char szInf[_MAX_PATH];
 
    //
    // We don't allow multiple instances
    //

    if (hPrevInstance) {
        return 1;
    }

    //
    // Do any initial stuff
    //

    dprintf("Initializing");
    if (!InitSetup(lpszCmdLine)) {
        Error("No main window");
        return 1;
    }

    hwndFrame = HwndFrame();

    //
    // Setup a catch buffer so we can do something like
    // ON ERROR GOTO
    //

    if ((Err = Catch((int FAR *) CatchBuf)) != 0) {
        goto Quit;
    }

    //
    // Set the background image and caption
    //

    SetBitmap(szCUIDLL, LOGO);
    SetWindowText(hwndFrame, szCaption);

    GetSymbolValue("STF_SRCINFPATH", szInf, sizeof(szInf));
    if (!lstrlen(szInf)) {
        GetSymbolValue("STF_CWDDIR", szInf, sizeof(szInf));
        lstrcat(szInf, "CSETUP.INF");
    }
    dprintf("Reading ini file: %s", (LPSTR)szInf);
    ReadInfFile(szInf);

Welcome:

    switch(UIStartDlg(szCUIDLL, WELCOME, "FInfoDlgProc", 
        APPHELP, "FHelpDlgProc")) {
    case CONTINUE:
        UIPop(1);
        break;

    default:
        AskQuit();
        goto Welcome;
    }


GetPath:
    SetSymbolValue("EditTextIn", szDest);
    SetSymbolValue("EditFocus", "END");
GetPathL1:
    ui = UIStartDlg(szCUIDLL, DESTPATH, 
            "FEditDlgProc", APPHELP, "FHelpDlgProc");
    GetSymbolValue("EditTextOut", szDest, sizeof(szDest));

    if (ui == CONTINUE) {
        if (IsDirWritable(szDest) == 0) {
            BadPath();
            goto GetPathL1;
        }
        UIPop(1);
    } else if (ui == REACTIVATE) {
        goto GetPathL1;
    } else if ( ui == BACK) {
        UIPop(1);
        goto Welcome;
    } else {
        AskQuit();
        goto GetPath;
    }


    Install();


    //
    // Get here either by normal exit or from a Throw caused
    // by some error handler
    //

Quit:

    if (Err == 0) {
        ui = EXITSUCCESS;
     } else if (Err == STFQUIT) {
        ui = EXITQUIT;
    } else {
        ui = EXITFAILURE;
    }

QuitL1:
    ui = UIStartDlg(szCUIDLL, ui, "FInfo0DlgProc", 0, "");
    if (ui == REACTIVATE) {
        goto QuitL1;
    }
    UIPop(1);
    TerminateFrame();
    return 0;
}
    
// **********************************************
// YOU CODE GOES HERE
// **********************************************

void Install()
{
    char szSrcDir[_MAX_PATH];
    char szTemp[_MAX_PATH];
    char szIni[_MAX_PATH];
    char buf[_MAX_PATH+256];

    GetSymbolValue("STF_SRCDIR", szSrcDir, sizeof(szSrcDir));

    //
    // Create the destination directory
    //

    CreateDir(szDest, cmoNone);

    //
    // Open a log file and write some info to it
    //

    MakePath(szDest, "LOGFILE.OUT", szTemp);
    OpenLogFile(szTemp, 0);
    WriteToLogFile("");
    WriteToLogFile("  User chose as destination directory: %s", (LPSTR)szDest);
    WriteToLogFile("");

    //
    // Copy all the files 
    //

    AddSectionFilesToCopyList("Files", szSrcDir, szDest);
    CopyFilesInCopyList();

    //
    // Modify INI files
    //

    MakePath(szDest, "DEMO.INI", szIni);
    CreateIniKeyValue(szIni, "Section 1", "Key 1", "Value 1" , cmoNone);
    CreateIniKeyValue(szIni, "Section 2", "Key 2", "Value 2" , cmoNone);
    CreateIniKeyValue(szIni, "Section 3", "Key 3", "Value 3" , cmoNone);
  
    //
    // Create Progman groups and add items
    //

    CreateProgmanGroup(szProgmanGroup, "", cmoNone);
    ShowProgmanGroup(szProgmanGroup, 1, cmoNone);

    MakePath(szDest, "file1.txt", szTemp);
    wsprintf(buf, "notepad.exe %s", (LPSTR)szTemp);
    CreateProgmanItem(szProgmanGroup, "File 1", buf, "", cmoOverwrite);

    MakePath(szDest, "file2.txt", szTemp);
    wsprintf(buf, "notepad.exe %s", (LPSTR)szTemp);
    CreateProgmanItem(szProgmanGroup, "File 2", buf, "", cmoOverwrite);

    //
    // close the log file
    //

    CloseLogFile();
}
