/*
    setupapi.c

    Functions which do stuff like the BASIC Setup functions
*/

// COPYRIGHT:
//
//   (C) Copyright Microsoft Corp. 1993.  All rights reserved.
//
//   You have a royalty-free right to use, modify, reproduce and
//   distribute the Sample Files (and/or any modified version) in
//   any way you find useful, provided that you agree that
//   Microsoft has no warranty obligations or liability for any
//   Sample Application Files which are modified.
//

#include <windows.h>
#include "setupapi.h"
#include "csetup.h"
#include <string.h>

//
// Extern 
//

extern CATCHBUF CatchBuf;

//
// Global data 
//

HANDLE hSetup;
BOOL fFrameInit;
BOOL fInstallInit;

//
// macros
//

#undef ERROR
#define ERROR(e)  Throw((int FAR *)CatchBuf, (e))


//
// local functions
//

static void End(void);
static void StfApiErr(UINT uiMsg, LPSTR szApi, LPSTR szArgs);
static HWND InitFrame(LPSTR szCmdLine);
static void InitInstall(void);
static void BadArgErr(UINT uiArg, LPSTR szApi, LPSTR szArgs);
static BOOL FValidInfSect(LPSTR szSect);
static BOOL FValidIniFile(LPSTR szFile);


//
// Global functions
//


BOOL CreateProgManItem(LPSTR szGroup, LPSTR szItem, LPSTR szCmd, LPSTR szOther, UINT cmo)
{
    char szItemNew[256];
    char buf[256];

    if (!szOther || !lstrlen(szOther)) {
        lstrcpy(szItemNew, szItem);
    } else {
        wsprintf(szItemNew, "%s,%s", szItem, szOther);
    }
    if (!szGroup
    || !lstrlen(szGroup)
    || (lstrlen(szGroup) > 24)) {
        wsprintf(buf, "%s, %s, %s, %s, %u", szGroup, szItem, szCmd, szOther, cmo);
        BadArgErr(1, "CreateProgmanItem", buf);
    }

    if (FCreateProgManItem(szGroup, szItemNew, szCmd, cmo) == 0) {
        wsprintf(buf, "%s, %s, %s, %s, %u", szGroup, szItem, szCmd, szOther, cmo);
        StfApiErr(saeFail, "CreateProgmanItem", buf);
        ERROR(STFERR);
    }
    return TRUE;
}

BOOL ShowProgmanGroup(LPSTR szGroup, UINT uiCmd, UINT cmo)
{
    char buf[256];

    if (!lstrlen(szGroup)
    || lstrlen(szGroup) > 24) {
        BadArgErr(1, "ShowProgmanGroup", szGroup);
    }
    wsprintf(buf, "%u%", uiCmd);
    if (FShowProgManGroup(szGroup, buf, cmo) == 0) {
        wsprintf(buf, "%s, %u, %u", szGroup, uiCmd, cmo);
        StfApiErr(saeFail, "ShowProgmanGroup", buf);
        ERROR(STFERR);
    }
    return TRUE;
}


void CreateIniKeyValue(LPSTR szFile, LPSTR szSect, LPSTR szKey, 
                       LPSTR szValue, UINT cmo)
{
    UINT n;
    char buf[256];

    if (FValidIniFile(szFile) == 0) {
        n = 1;
    } else if (FValidInfSect(szSect) == 0) {
        n = 2;
    } else {
        n = 0;
    }
    if (n > 0) {
        wsprintf(buf, "%s, %s, %s, %s, %y", szFile, szSect, szKey, szValue, cmo);
        BadArgErr(n, "CreateIniKeyValue", buf);
    }

    if (FCreateIniKeyValue(szFile, szSect, szKey, szValue, cmo) == 0) {
        wsprintf(buf, "%s, %s, %s, %s, %y", szFile, szSect, szKey, szValue, cmo);
        StfApiErr(saeFail, "CreateIniKeyValue", buf);
        ERROR(STFERR);
    }
}


HANDLE InitSetup(LPSTR szCmdLine)
{
    HANDLE h;

    fFrameInit = FALSE;
    fInstallInit = FALSE;

    if (hSetup) {
        StfApiErr(saeInit, "InitSetup", szCmdLine);
    }
 
    h = InitFrame(szCmdLine);
    fFrameInit = TRUE;

    InitInstall();
    fInstallInit = TRUE;

    return h;
}

void ReadInfFile(LPSTR lpszInfFile)
{
    if (FOpenInf(lpszInfFile, 1, 0) == 0) {
        Error("Failed to read %s", lpszInfFile);
    }
}

UINT UIStartDlg(LPSTR szDll,
                UINT uiDlg, 
                LPSTR szDlgProc,
                UINT uiHelpDlg, 
                LPSTR szHelpProc)
{
    char sz[MAXSTRINGLENGTH];

    FDoDialog(HwndFrame(), szDll, uiDlg, szDlgProc, uiHelpDlg, szHelpProc);
    GetSymbolValue("DLGEVENT", sz, sizeof(sz));
    if (lstrcmp(sz, "EXIT") == 0) {
        return EXIT;
    } else if (lstrcmp(sz, "REACTIVATE") == 0) {
        return REACTIVATE;
    } else if (lstrcmp(sz, "CONTINUE") == 0) {
        return CONTINUE;
    } else if (lstrcmp(sz, "BACK") == 0) {
        return BACK;
    } else {
        return CONTINUE;
    }
}


UINT AskQuit()
{
    do {

        switch (UIStartDlg(szCUIDLL, ASKQUIT, "FQuitDlgProc", APPHELP, "FHelpDlgProc")) {
        case EXIT:
            UIPopAll;
//          return EXIT;
            Throw((int FAR *)CatchBuf, STFQUIT);

        case CONTINUE:
            UIPop(1);
            return CONTINUE;

        case REACTIVATE:
        default:
            break;
        }
    } while(1);
}

void BadPath()
{
    do {

        if (UIStartDlg(szCUIDLL, BADPATH, "FInfo0DlgProc", 0, "") != REACTIVATE) {
            UIPop(1);
            return;
        }
    } while(1);
}

void UIPop(UINT uiCount)
{
    FKillNDialogs(uiCount);
}


void UIPopAll()
{
    UIPop((UINT)65535);
}

//
// Show an error message box
//

void cdecl Error(LPSTR lpFormat, ...) 
{
    char buf[256];

    wvsprintf(buf, lpFormat, (LPSTR)(&lpFormat+1));
    MessageBeep(MB_ICONEXCLAMATION);
    MessageBox(HwndFrame(), buf, szAppName, MB_OK|MB_ICONEXCLAMATION);
}

void MakePath(LPSTR szDir, LPSTR szFile, LPSTR szPath)
{
    if (!szDir || !lstrlen(szDir)) {
        lstrcpy(szPath, szFile);
    } else if (!szFile || !lstrlen(szFile)) {
        lstrcpy(szPath, szDir);
    } else if (szDir[lstrlen(szDir)-1] == '\\') {
        lstrcpy(szPath, szDir);
        lstrcat(szPath, szFile);
    } else {
        lstrcpy(szPath, szDir);
        lstrcat(szPath, "\\");
        lstrcat(szPath, szFile);
    }
}

void cdecl WriteToLogFile(LPSTR lpFormat, ...) 
{
    char buf[256];

    wvsprintf(buf, lpFormat, (LPSTR)(&lpFormat+1));
    FWriteToLogFile(buf, 1);
}

BOOL AddSectionFilesToCopyList(LPSTR szSect, LPSTR szSrc, LPSTR szDest)
{
    int n;
    char buf[256];

    if (FValidInfSect(szSect) == 0) {
        n = 1;
    } else if (FValidFATDir(szSrc) == 0) {
        n = 2;
    } else if (FValidFATDir(szDest) == 0) {
        n = 3;
    } else {
        n = 0;
    }
    if (n > 0) {
        wsprintf(buf, "%s, %s, %s", szSect, szSrc, szDest);
        BadArgErr(n, "AddSectionFilesToCopyList", buf);
    }
    if (FAddSectionFilesToCopyList(szSect, szSrc, szDest) == 0) {
        wsprintf(buf, "%s, %s, %s", szSect, szSrc, szDest);
        StfApiErr(saeFail, "AddSectionFilesToCopyList", buf);
        ERROR(STFERR);
    }
    return TRUE;
}

UINT CopyFilesInCopyList(void)
{
    return GrcCopyFilesInCopyList(HinstFrame());
}

void FAR cdecl DbgOut(LPSTR lpFormat, ...) 
{
    char buf[256];

    if (!GetSystemMetrics(SM_DEBUG)) return;

    wsprintf(buf, "%s: ", (LPSTR)szAppName);
    OutputDebugString(buf);
    wvsprintf(buf, lpFormat, (LPSTR)(&lpFormat+1));
    OutputDebugString(buf);
    OutputDebugString("\r\n");
}

void CreateDir(LPSTR szDir, UINT uiCmd)
{
    char buf[256];

    if (FValidFATDir(szDir) == 0) {
        wsprintf(buf, "%s, %u", szDir, uiCmd);
        BadArgErr(1, "CreateDir", buf);
    }
    if (FCreateDir(szDir, uiCmd) == 0) {
        wsprintf(buf, "%s, %u", szDir, uiCmd);
        StfApiErr(saeFail, "CreateDir", buf);
        ERROR(STFERR);
    }
}

//
// Local functions
//

static void End(void)
{
    ERROR(STFQUIT);
}

static void StfApiErr(UINT uiMsg, LPSTR szApi, LPSTR szArgs)
{
    LPSTR lpText;
    char msg[32];
    char buf[256];

    switch (uiMsg) {
    case saeFail:
        lpText = "Failed";
        break;

    case saeInit:
        lpText = "Already Initialized";
        break;

    case saeNYI:
        lpText = "NYI"; // not yet initialized?
        break;

    default:
        wsprintf(msg, "Bad Arg %u", uiMsg - saeArg);
        lpText = msg;
        break;
    }

    if (szArgs && lstrlen(szArgs)) {
        wsprintf(buf, "%s: %s (%s)", lpText, szApi, szArgs);
    } else {
        wsprintf(buf, "%s: %s", lpText, szApi);
    }
    MessageBox(HwndFrame(), buf, "C-Setup API Error", MB_TASKMODAL | MB_ICONHAND | MB_OK);
    End();
}

static void BadArgErr(UINT uiArg, LPSTR szApi, LPSTR szArgs)
{
    StfApiErr(uiArg+saeArg, szApi, szArgs);
    ERROR(STFERR);
}

static HWND InitFrame(LPSTR szCmdLine)
{
    HWND hWnd;

    if (hSetup) {
        StfApiErr(saeInit, "InitFrame", szCmdLine);
    } else {
        hWnd = InitializeFrame(szCmdLine);
        if ((int)hWnd == -1) {
            End(); // not an error
        } else if (hWnd == NULL) {
            StfApiErr(saeFail, "InitFrame", szCmdLine);
            End();
        } else {
            return hWnd;
        }
    }
}

static void InitInstall(void)
{
    if (hSetup) {
        StfApiErr(saeInit, "InitInstall", "");
    } else if (FInitializeInstall(HinstFrame(), HwndFrame()) == 0) {
        StfApiErr(saeFail, "InitInstall", "");
    }
}

static BOOL FValidInfSect(LPSTR szSect)
{
    if (!szSect 
    || !lstrlen(szSect)
    || (_fstrchr(szSect,']') != NULL)) {
        return FALSE;
    }
    return TRUE;
}

static BOOL FValidIniFile(LPSTR szFile)
{
    if ((FValidFATPath(szFile) == 0)
    && (_fstricmp(szFile, "WIN.INI") != 0)) {
        return FALSE;
    }
    return TRUE;
}
