/*
    setupapi.h
*/

// string constants

#define szCUIDLL "mscuistf.dll"


// Command Option Flags

#define cmoVital       1
#define cmoCopy        2
#define cmoUndo        4
#define cmoRoot        8
#define cmoDecompress  16
#define cmoTimeStamp   32
#define cmoReadOnly    64
#define cmoBackup      128
#define cmoForce       256
#define cmoRemove      512
#define cmoOverwrite   1024
#define cmoAppend      2048
#define cmoPrepend     4096
#define cmoNone        0
#define cmoAll         ((UINT)65535)

// Setup API Errors
#define saeFail    0
#define saeInit    1
#define saeNYI     3
#define saeArg     4    // must be max sae value

//General Return Codes

#define grcOkay         0
#define grcNotOkay      1
#define grcUserQuit     48

// ON ERROR Error Codes
#define STFERR       1024   //setup system error
#define STFQUIT      1025   //user quit

#define MAXSTRINGLENGTH 64

//
// debug macros
//

#ifdef DEBUG

    extern void FAR cdecl DbgOut(LPSTR lpFormat, ...);

    #define dprintf                         DbgOut

#else // not DEBUG

    #define dprintf  if (0) ((int (*)(char *, ...)) 0)

#endif // DEBUG

//
// Macros for external functions which we are simply doing
// a name mapping for
//

#define SetBitmap(a,b) FSetBitmap((a),(b))
#define GetSymbolValue(sym, val, i) CbGetSymbolValue((sym),(val),(i))
#define SetSymbolValue(sym,val) FSetSymbolValue((sym),(val))
#define OpenLogFile(f,a) FOpenLogFile((f),(a))
#define CloseLogFile FCloseLogFile
#define CreateProgmanGroup(g,p,c) FCreateProgmanGroup((g),(p),(c))
#define IsDirWritable(p) FIsDirWritable(p)

//
// in setupapi.c
//


extern BOOL CreateProgmanItem(LPSTR szGroup, LPSTR szItem, LPSTR szCmd, LPSTR szOther, UINT cmo);
extern void CreateDir(LPSTR szDir, UINT uiCmd);
extern HANDLE InitSetup(LPSTR szCmdLine);
extern BOOL AddSectionFilesToCopyList(LPSTR szSect,
                                      LPSTR szSrc,
                                      LPSTR szDest);
extern void CreateIniKeyValue(LPSTR szFile, LPSTR szSect, LPSTR szKey, 
                       LPSTR szValue, UINT cmo);
extern BOOL ShowProgmanGroup(LPSTR szGroup, UINT uiCmd, UINT cmo);
extern void ReadInfFile(LPSTR lpszInfFile);
extern void cdecl Error(LPSTR lpFormat, ...) ;
extern void UIPopAll(void);
extern void UIPop(UINT uiCount);
extern UINT AskQuit(void);
extern UINT UIStartDlg(LPSTR szDll,
                UINT uiDlg, 
                LPSTR szDlgProc,
                UINT uiHelpDlg, 
                LPSTR szHelpProc);
extern void BadPath(void);
extern void MakePath(LPSTR szDir, LPSTR szFile, LPSTR szPath);
extern void cdecl WriteToLogFile(LPSTR lpFormat, ...) ;
extern UINT CopyFilesInCopyList(void);

//
// external functions
//

extern BOOL FAR PASCAL FCreateProgManItem(LPSTR szGroup, LPSTR szItem, LPSTR szCmd, UINT cmo);
extern BOOL FAR PASCAL FShowProgManGroup(LPSTR szGroup, LPSTR szCmd, UINT cmo);
extern BOOL FAR PASCAL FCreateProgmanGroup(LPSTR szGroup, LPSTR szPath, UINT cmo);
extern BOOL FAR PASCAL FValidFATPath(LPSTR szPath);
extern BOOL FAR PASCAL FCreateIniKeyValue(LPSTR szFile, LPSTR szSect, LPSTR szKey, 
                       LPSTR szValue, UINT cmo);
extern HWND FAR PASCAL HwndFrame(void);
extern HINSTANCE FAR PASCAL HinstFrame(void);
extern int FAR PASCAL FSetBitmap(LPSTR lpszDll, UINT uiBitmap);
extern BOOL FAR PASCAL FCreateDir(LPSTR szDir, UINT uiCmd);
extern BOOL FAR PASCAL FValidFATDir(LPSTR szDir);
extern BOOL FAR PASCAL FSetSymbolValue(LPSTR lpszSymbol,
                                      LPSTR lpszValue);
extern BOOL FAR PASCAL FOpenLogFile(LPSTR szFile, BOOL bAppend);
extern void FAR PASCAL FCloseLogFile(void);
extern BOOL FAR PASCAL FAddSectionFilesToCopyList(LPSTR szSect,
                                                 LPSTR szSrc,
                                                 LPSTR szDest);



extern HANDLE FAR PASCAL InitializeFrame(LPSTR lpszCmdLine);
extern int FAR PASCAL FInitializeInstall(HINSTANCE hInstance, HWND hwndFrame);
extern int FAR PASCAL CbGetSymbolValue(LPSTR lpszSym, LPSTR lpszValue, int iMax);
extern int FAR PASCAL FOpenInf(LPSTR szFile, BOOL fCheck, BOOL fCheckSyms);
extern BOOL FAR PASCAL FDoDialog(HWND hWnd,
                                 LPSTR szDll,
                                 UINT uiDlg, 
                                 LPSTR szDlgProc,
                                 UINT uiHelpDlg, 
                                 LPSTR szHelpProc);
extern void FAR PASCAL TerminateFrame(void);
extern void FAR PASCAL FKillNDialogs(UINT uiCount);
extern BOOL FAR PASCAL FIsDirWritable(LPSTR lpszPath);
extern BOOL FAR PASCAL FOpenLogFile(LPSTR szFile, BOOL bAppend);
extern BOOL FAR PASCAL FWriteToLogFile(LPSTR szString, BOOL bRequire);
extern UINT FAR PASCAL GrcCopyFilesInCopyList(HINSTANCE hInstance);
extern HINSTANCE FAR PASCAL HinstFrame(void);
