(* VersionInfo component for Delphi.  Copyright c W. Murto September 1995. *)
  (* Free to use as you see fit, just don't sell it or say you wrote it.*)

unit Verinfo;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Controls, Forms, Ver;

type
  TVerNum = array[0..3] of integer;
  TVos = (Windows16, Windows32);
  TVft = (App, Dll);
  TVersionInfo = class(TComponent)
  private
    { Private declarations }
    fActive : boolean;
    fResFilename : string;
    fFileVerNum,
    fProdVerNum : string;
    fFVerNum,
    fPVerNum : TVerNum;
    fVFileOS : TVos;
    fVFileType : TVft;
    fComments,
    fCompanyName,
    fFileDescription,
    fFileVersion,
    fInternalName,
    fLegalCopyright,
    fOriginalFilename,
    fProductName,
    fProductVersion : string;
    procedure StrToVerNum(const Source: string; var Dest: TVerNum);
    procedure SetActive(Value: boolean);
    procedure SetResFilename(const Value: string);
    procedure SetFileVerNum(const Value: string);
    procedure SetProdVerNum(const Value: string);
    procedure SetVFileOS(Value: TVos);
    procedure SetVFileType(Value: TVft);
    procedure SetComments(const Value: string);
    procedure SetCompanyName(const Value: string);
    procedure SetFileDescription(const Value: string);
    procedure SetFileVersion(const Value: string);
    procedure SetInternalName(const Value: string);
    procedure SetLegalCopyright(const Value: string);
    procedure SetOriginalFilename(const Value: string);
    procedure SetProductName(const Value: string);
    procedure SetProductVersion(const Value: string);
    function WriteResFile: boolean;
  protected
    { Protected declarations }
  public
    { Public declarations }
    constructor Create(AOwner: TComponent); override;
  published
    { Published declarations }
    property Active: boolean read fActive write SetActive stored false;
    property ResFilename: string read fResFilename write SetResFilename;
    property FileVerNum: string read fFileVerNum write SetFileVerNum;
    property ProdVerNum: string read fProdVerNum write SetProdVerNum;
    property VFileOS: TVos read fVFileOS write SetVFileOS;
    property VFileType: TVft read fVFileType write SetVFileType;
    property Comments: string read fComments write SetComments;
    property CompanyName: string read fCompanyName write SetCompanyName;
    property FileDescription: string read fFileDescription write SetFileDescription;
    property FileVersion: string read fFileVersion write SetFileVersion;
    property InternalName: string read fInternalName write SetInternalName;
    property LegalCopyright: string read fLegalCopyright write SetLegalCopyright;
    property OriginalFilename: string read fOriginalFilename write SetOriginalFilename;
    property ProductName: string read fProductName write SetProductName;
    property ProductVersion: string read fProductVersion write SetProductVersion;
  end;

procedure Register;

implementation

constructor TVersionInfo.Create(AOwner: TComponent);
begin
  inherited Create(AOwner);
  if csDesigning in ComponentState then
     fActive := false else fActive := true;
  fFileVerNum := '0.0.0.0'; FillChar(fFVerNum, SizeOf(fFVerNum), 0);
  fProdVerNum := '0.0.0.0'; FillChar(fPVerNum, SizeOf(fPVerNum), 0);
end;

procedure TVersionInfo.StrToVerNum(const Source: string; var Dest: TVerNum);
var I, L : integer;
    Buf : string;
begin
  Buf := ''; I := 0; FillChar(Dest, SizeOf(Dest), 0);
  for L := 1 to Length(Source) do
    case Source[L] of
      '0'..'9': Buf := Buf + Source[L];
      '.': begin
             Dest[I] := StrToIntDef(Buf, 0); Buf := '';
             if I < 3 then inc(I);
           end;
    end; {case}
  if Length(Buf) > 0 then Dest[I] := StrToIntDef(Buf, 0);
end;

procedure TVersionInfo.SetActive(Value: boolean);
begin
  if not (csDesigning in ComponentState) then exit;   {**********************}
  if Value <> fActive then fActive := Value else exit;
  if fActive and (Length(fResFilename) > 4) then WriteResFile;
end;

procedure TVersionInfo.SetResFilename(const Value: string);
begin
  if (not fActive) and (Value <> fResFilename) then fResFilename := Value;
end;

procedure TVersionInfo.SetFileVerNum(const Value: string);
begin
  if (not fActive) and (Value <> fFileVerNum) then
  begin
    fFileVerNum := Value;
    StrToVerNum(fFileVerNum, fFVerNum);
  end;
end;

procedure TVersionInfo.SetProdVerNum(const Value: string);
begin
  if (not fActive) and (Value <> fProdVerNum) then
  begin
    fProdVerNum := Value;
    StrToVerNum(fProdVerNum, fPVerNum);
  end;
end;

procedure TVersionInfo.SetVFileOS(Value: TVos);
begin
  if (not fActive) and (Value <> fVFileOS) then fVFileOS := Value;
end;

procedure TVersionInfo.SetVFileType(Value: TVft);
begin
  if (not fActive) and (Value <> fVFileType) then fVFileType := Value;
end;

procedure TVersionInfo.SetComments(const Value: string);
begin
  if (not fActive) and (Value <> fComments) then fComments := Value;
end;

procedure TVersionInfo.SetCompanyName(const Value: string);
begin
  if (not fActive) and (Value <> fCompanyName) then fCompanyName := Value;
end;

procedure TVersionInfo.SetFileDescription(const Value: string);
begin
  if (not fActive) and (Value <> fFileDescription) then fFileDescription := Value;
end;

procedure TVersionInfo.SetFileVersion(const Value: string);
begin
  if (not fActive) and (Value <> fFileVersion) then fFileVersion := Value;
end;

procedure TVersionInfo.SetInternalName(const Value: string);
begin
  if (not fActive) and (Value <> fInternalName) then fInternalName := Value;
end;

procedure TVersionInfo.SetLegalCopyright(const Value: string);
begin
  if (not fActive) and (Value <> fLegalCopyright) then fLegalCopyright := Value;
end;

procedure TVersionInfo.SetOriginalFilename(const Value: string);
begin
  if (not fActive) and (Value <> fOriginalFilename) then fOriginalFilename := Value;
end;

procedure TVersionInfo.SetProductName(const Value: string);
begin
  if (not fActive) and (Value <> fProductName) then fProductName := Value;
end;

procedure TVersionInfo.SetProductVersion(const Value: string);
begin
  if (not fActive) and (Value <> fProductVersion) then fProductVersion := Value;
end;

function TVersionInfo.WriteResFile: boolean;
const
  SFInfo : array[0..8] of string[20] = ('Comments', 'CompanyName', 'FileDescription',
    'FileVersion', 'InternalName', 'LegalCopyright', 'OriginalFilename',
    'ProductName', 'ProductVersion');
  Block0 : array[$00..$77] of byte = (
  $FF, $10, $00, $FF, $01, $00, $30, $00, $00, $00, $00, $00, $00, $00, $34, $00,
  $56, $53, $5F, $56, $45, $52, $53, $49, $4F, $4E, $5F, $49, $4E, $46, $4F, $00,
  $BD, $04, $EF, $FE, $00, $00, $01, $00, $00, $00, $00, $00, $00, $00, $00, $00,
  $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00,
  $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00,
  $00, $00, $00, $00, $00, $00, $00, $00, $53, $74, $72, $69, $6E, $67, $46, $69,
  $6C, $65, $49, $6E, $66, $6F, $00, $00, $00, $00, $00, $00, $30, $34, $30, $39,
  $30, $34, $45, $34, $00, $00, $00, $00);
  Block1 : array[$00..$23] of byte = (
  $24, $00, $00, $00, $56, $61, $72, $46, $69, $6C, $65, $49, $6E, $66, $6F, $00,
  $14, $00, $04, $00, $54, $72, $61, $6E, $73, $6C, $61, $74, $69, $6F, $6E, $00,
  $09, $04, $E4, $04);
  StartSFI = $0078;
var
  Buffer : PChar;
  ResFile : File;
  SizeOfBuffer, NumWritten, AWord, Pos, Mark, I : Word;
  SFData : TStrings;
begin
  Result := false;
  GetMem(Buffer, 2048);
  SFData := TStringList.Create;
  try
    FillChar(Buffer^, 2048, 0);
    SFData.Add(fComments); SFData.Add(fCompanyName); SFData.Add(fFileDescription);
    SFData.Add(fFileVersion); SFData.Add(fInternalName); SFData.Add(fLegalCopyright);
    SFData.Add(fOriginalFilename); SFData.Add(fProductName); SFData.Add(fProductVersion);
    Move(Block0, Buffer[$0], SizeOf(Block0));
    Move(fFVerNum[0], Buffer[$2A], 2); Move(fFVerNum[1], Buffer[$28], 2);
    Move(fFVerNum[2], Buffer[$2E], 2); Move(fFVerNum[3], Buffer[$2C], 2);
    Move(fPVerNum[0], Buffer[$32], 2); Move(fPVerNum[1], Buffer[$30], 2);
    Move(fPVerNum[2], Buffer[$36], 2); Move(fPVerNum[3], Buffer[$34], 2);
    case fVFileOS of Windows16: AWord := $0001; Windows32: AWord := $0004; end;
    Move(AWord, Buffer[$40], 2);
    case fVFileType of App: AWord := $0001; Dll: AWord := $0002; end;
    Move(AWord, Buffer[$44], 2);
    Pos := StartSFI;
    for I := 0 to 8 do
    begin
      Mark := Pos; inc(Pos, 4);
      StrPCopy(@Buffer[Pos],SFInfo[I]);
      Pos := Pos + Length(SFInfo[I]);
      Pos := Pos + 4 - (Pos mod 4);
      StrPCopy(@Buffer[Pos],SFData[I]);
      Pos := Pos + Length(SFData[I]);
      AWord := Pos + 1 - Mark; Move(AWord, Buffer[Mark], 2);
      AWord := Length(SFData[I]) + 1; Move(AWord, Buffer[Mark + 2], 2);
      Pos := Pos + 4 - (Pos mod 4);
    end;
    AWord := Pos - 3 - $68;
    Move(AWord, Buffer[$68], 2);
    AWord := Pos - 3 - $54;
    Move(AWord, Buffer[$54], 2);
    Move(Block1, Buffer[Pos], SizeOf(Block1));
    inc(Pos, SizeOf(Block1));
    AWord := Pos - $0C;
    Move(AWord, Buffer[$08], 2); Move(AWord, Buffer[$0C], 2);
    SizeOfBuffer := Pos;
    AssignFile(ResFile, fResFilename);
    Rewrite(ResFile, 1);
    BlockWrite(ResFile, Buffer^, SizeOfBuffer, NumWritten);
    CloseFile(ResFile);
    Result := true;
  finally
    SFData.Free;
    FreeMem(Buffer, 2048);
  end;
end;


procedure Register;
begin
  RegisterComponents('Samples', [TVersionInfo]);
end;

end.
