unit Target;

interface

uses WinTypes, WinProcs, Classes, Graphics, Forms, Controls, Buttons,
     StdCtrls, FileCtrl, ExtCtrls,SysUtils,Dialogs;

type
  TTargetDialog = class(TForm)
    Bevel1: TBevel;
    TargetDirectoryDrv: TDriveComboBox;
    TargetDirectoryLst: TDirectoryListBox;
    Label1: TLabel;
    Label2: TLabel;
    btNext: TButton;
    btBefore: TButton;
    btCancel: TButton;
    Label3: TLabel;
    Label4: TLabel;
    Label5: TLabel;
    Label6: TLabel;
    TargetDirectoryEdi: TEdit;
    SpaceHard: TLabel;
    SpaceNeed: TLabel;
    procedure btCancelClick(Sender: TObject);
    procedure btBeforeClick(Sender: TObject);
    procedure btNextClick(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure Initialisation(Sender: TObject);
    procedure ChangingDirectory(Sender: TObject);
  private
    { Private declarations }
    procedure GetInformation;
  public
    { Public declarations }
  end;

var TargetDialog: TTargetDialog;

implementation

uses Decla,Generale;

{$R *.DFM}

(* Cancel button *)
procedure TTargetDialog.btCancelClick(Sender: TObject);
begin
 MainBack.Close;
end;

(* before button *)
procedure TTargetDialog.btBeforeClick(Sender: TObject);
begin
 GetInformation;
 CurrentWin := 8;
 Direction := 1;
 Close;
end;

(* Next button *)
procedure TTargetDialog.btNextClick(Sender: TObject);
begin
 GetInformation;
 CurrentWin := 9;
 Direction := 0;
 Close;
end;

(* closing dialog *)
procedure TTargetDialog.FormClose(Sender: TObject;
  var Action: TCloseAction);
begin
 MainBack.Initialisation (Sender);
end;

(* init dialog *)
procedure TTargetDialog.Initialisation(Sender: TObject);
var Tmp : longint;
begin
 TargetDirectoryDrv.Drive := VPath [2].LettDriv [1];
 if DirectoryExists (VPath [2].LettDriv + VPath [2].PathDriv) = true then
  TargetDirectoryLst.Directory := VPath [2].LettDriv + VPath [2].PathDriv
 else
  TargetDirectoryLst.Directory := VPath [2].LettDriv + '\';
 TargetDirectoryEdi.Text := VPath [2].PathDriv;
 Tmp := DiskSize (Ord (upcase(VPath [2].LettDriv [1])) - 64);
 SpaceHard.Caption := IntToStr (Tmp);
 SpaceNeed.Caption := IntToStr (Disk_Space);
 if Disk_Space > Tmp then
  MessageDlg ('You need more space on this hard drive, choose another drive',
              mtInformation,[mbOk],0)
end;

(* changing target directory *)
procedure TTargetDialog.ChangingDirectory(Sender: TObject);
var Tmp : string;
begin
 Tmp := TargetDirectoryLst.Directory;
 Delete(Tmp,1,2);
 if Length( Tmp ) = 1 then
   TargetDirectoryEdi.Text := VPath [2].PathDriv
 else
   TargetDirectoryEdi.Text := Tmp + VPath [2].PathDriv;
end;

(* get all dialog information *)
procedure TTargetDialog.GetInformation;
var Bcl : integer;
    Old : string;
begin
 (* get main directory information *)
 Old := VPath [2].PathDriv;
 VPath [2].LettDriv := upcase (TargetDirectoryDrv.Drive) + ':';;
 VPath [2].PathDriv := TargetDirectoryEdi.Text;
 if Old <> VPath [2].PathDriv then
 begin
  (* check if other directories are under main *)
  for Bcl := 3 to (max_path - 1) do
  begin
   if copy (VPath [Bcl].PathDriv,1,length (Old)) = Old then
   (* change for new main root *)
   begin
    VPath [Bcl].LettDriv := VPath [2].LettDriv;
    System.Delete (VPath [Bcl].PathDriv,1,length (Old));
    System.Insert (VPath [2].PathDriv,VPath [Bcl].PathDriv,1);
   end;
  end;
 end;
end;

end.
