/**************************************************************************** */
/* Samp_Act.c */
/* Sample Window Class used to illustrate Window Acts*/
/* Search for WINDACTS to see the changes made*/
/*****************************************************************************/

#include <windows.h>		    /* required for all Windows applications */
#include <string.h>
#include <stdio.h>
#include "resource.h"

#include "windacts.h"		// WINDACTS

// variables used by the program
char	sValue[256];	// the string displayed in the window
long	lValue;			// the long value in the window
HINSTANCE	hInst;		// handle of this instance

UINT	uActListMsg;	// WINDACTS - holds the id of message "ActList"

// Function prototypes
long FAR PASCAL SampActWindProc(HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam);



/**************************************************************************/
int PASCAL WinMain(hInstance, hPrevInstance, lpCmdLine, nCmdShow)
HANDLE hInstance;			     /* current instance	     */
HANDLE hPrevInstance;			     /* previous instance	     */
LPSTR lpCmdLine;			     /* command line		     */
int nCmdShow;				     /* show-window type (open/icon) */
{
    MSG msg;				     /* message			     */
    WNDCLASS      wc;
    HWND	hWnd;

	hInst = hInstance;

	// register the WindActs message used by all our window classes.
	uActListMsg = RegisterWindowMessage("ActList");	// WINDACTS

	if (!hPrevInstance) {
		/* text editor window */
		wc.hCursor = LoadCursor(NULL, IDC_ARROW);
		wc.style = 0;	  /* Class style(s).			*/
		wc.lpfnWndProc = SampActWindProc;	 /* Function to retrieve messages for       */
		wc.hIcon = LoadIcon(NULL,(LPCSTR)IDI_APPLICATION);
		wc.cbClsExtra = 0;		    /* No per-class extra data.		  */
		wc.cbWndExtra = 0;		    /* No per-window extra data.	  */
		wc.hInstance = hInstance;	    /* Application that owns the class.	  */
		wc.hbrBackground = (HBRUSH)(COLOR_WINDOW+1); 
		wc.lpszMenuName =   NULL;
		wc.lpszClassName = "SampleWindClass"; /* Name used in call to CreateWindow. */
		if (!RegisterClass(&wc)) return FALSE;

	};

	hWnd =CreateWindow("SampleWindClass","Sample"
		,WS_CLIPCHILDREN|WS_OVERLAPPEDWINDOW|WS_VISIBLE,
		10,10,300,200,HWND_DESKTOP,0,hInstance,0);


    while (hWnd && GetMessage(&msg,	   /* message structure			     */
	    NULL,		   /* handle of window receiving the message */
	    NULL,		   /* lowest message to examine		     */
	    NULL))		   /* highest message to examine	     */
	{
			TranslateMessage(&msg);	   /* Translates virtual key codes	     */
			DispatchMessage(&msg);	   /* Dispatches message to window	     */
    }
    return (msg.wParam);	   /* Returns the value from PostQuitMessage */
}


///////////////////////////////////////////////////////////////////////////////////
// Window handling code


// set the values given a Flute array in dhand
// hWnd - is the handle of the window
HGLOBAL SetValues(HGLOBAL dhand, HWND hWnd )
{
	DataObj	*pob;
	BOOL	b1,b2;

	if (!dhand) return 0;		// there is a problem (low mem?)
	
	pob = DataGlobalLock(dhand);
	if (pob->tint.vtype!=ARRAYTYPE || pob->tarray.elements!=2) {
		// we haven't been given the correct parameters - report an error
		GlobalUnlock((HGLOBAL)dhand);
		return (LRESULT) 
			GeneralError(hInst,IDS_PARAMETERERROR);
	};
	
	pob = PtrContent(pob);
	lValue = GetALong(pob,&b1);
	pob = NextDataObj(pob);
	GetAString(pob, &b2, sValue,sizeof(sValue));
	GlobalUnlock((HGLOBAL)dhand);
	
	// if the extraction of data failed, then report an error
	if (!b1 || !b2)
		return (LRESULT)
			GeneralError(hInst,IDS_PARAMETERERROR);
	
	InvalidateRect(hWnd, NULL,FALSE);
	return NULL;
}

LRESULT GetValues()
{
	return (LRESULT)MakeArray2(MakeInt(lValue), MakeString(sValue) );
}



/* text edit window handler procedure, used to edit text for program objects */
long FAR PASCAL __export SampActWindProc(HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam)
{
	static	UINT	Acts[2];

    switch (message) {
		case WM_CREATE:
			strcpy(sValue,"Sample Text");
			lValue =1000;
			RegisterActList(hInst, IDS_ACTSTRING1,Acts);		// WINDACTS
			SetWindowFluteName(hWnd, "My_Sample_Window");		// WINDACTS - name our window
			break;
		case WM_CLOSE:
			PostQuitMessage(0);
			break;
		case WM_PAINT:
			{
				// paint the window
				HDC	devcon;
				PAINTSTRUCT	ps;
				char	cbuffer[280];
				RECT	cr;

				devcon=BeginPaint(hWnd,&ps);
				if (!devcon) break;
				sprintf(cbuffer,"%ld\r\n%s",lValue,sValue);
				GetClientRect(hWnd,&cr);
				DrawText(devcon,cbuffer,-1,&cr,DT_LEFT|DT_NOPREFIX|DT_EXPANDTABS);
				EndPaint(hWnd,&ps);

			};
			break;
		default:
			// WINDACTS - code to process window acts
			if (message == uActListMsg) {
				// a browser message has been received
				if (wParam) {
					// help on a function
					char	actname[128];
					FindActName(hInst, (UINT)wParam, IDS_ACTSTRING1, actname, sizeof(actname));
					WinHelp(hWnd,"SampAct.hlp",HELP_PARTIALKEY, (DWORD)actname);
					return NULL;
				} else {
					// return a list of functions
					return (LRESULT)ProduceActList(hInst, IDS_ACTSTRING1);
				};
				
			} else if (message == Acts[0]) {
				// Set the values 
				return SetValues( (HGLOBAL) wParam, hWnd);
			} else if (message == Acts[1]) {
				// Get the values
				return GetValues();
			} else return DefWindowProc(hWnd,message,wParam,lParam);
    };
    return (NULL);
}


