#ifndef INC_LISTENEL_HPP
#define INC_LISTENEL_HPP

#include "listtype.hpp"



class LISTENELEMENT  {


// erzeugt von US (Innovative Software) am 14.08.1991, 13:32
// letzte nderung von US am 22.09.1991, 11:42

    public:
/*
Referenz auf das vorhergehende Listenelement
*/
        LISTENELEMENT* Vorgaenger;
/*
Referenz auf das nachfolgende Listenelement
*/
        LISTENELEMENT* Nachfolger;
/*
Zeiger auf die Daten, die zu diesem Element gehren
*/
        VOIDPTR Daten;
/*
Zeiger auf eine Funktion, die unmittelbar vor dem Lschen dieses Elementes aufgerufen wird. Damit kann zum Beispiel indirekt der Destruktor eines Objektes aufgerufen werden.
Die DeleteProc erhlt als Parameter den Zeiger auf die mit diesem Element assoziierten Daten.
Wenn die DeleteProc einen Wert ungleich 0 zurckgibt, wird der Speicher, auf den Daten zeigt, nicht gelscht. Andernfalls wird der Speicher mit delete gelscht.
*/
        DELETEPROC DeleteProc;
/*
Konstruktor. Der Konstruktor erhlt als Parameter einen Zeiger auf die Daten, die zu diesem Element gehren, sowie jeweils einen Zeiger auf das vorhergehende und das nachfolgende Element.
*/
        LISTENELEMENT(VOIDPTR Daten, LISTENELEMENT* Vorgaenger, LISTENELEMENT* Nachfolger);
/*
Konstruktor. Der Konstruktor erhlt als Parameter einen Zeiger auf die Daten, die zu diesem Element gehren, sowie jeweils einen Zeiger auf das vorhergehende und das nachfolgende Element. Der vierte Parameter zeigt auf die DeleteProc.
*/
        LISTENELEMENT(VOIDPTR Daten, LISTENELEMENT* Vorgaenger, LISTENELEMENT* Nachfolger, DELETEPROC DeleteProc);
/*
Destruktor
*/
        ~LISTENELEMENT();
};

#endif
