VERSION 2.00
Begin Form MainFrm 
   BorderStyle     =   3  'Fixed Double
   Caption         =   "AA-Sort DLL Demo"
   ClientHeight    =   6735
   ClientLeft      =   1260
   ClientTop       =   1485
   ClientWidth     =   7275
   Height          =   7140
   KeyPreview      =   -1  'True
   Left            =   1200
   LinkTopic       =   "Form1"
   MaxButton       =   0   'False
   ScaleHeight     =   6735
   ScaleWidth      =   7275
   Top             =   1140
   Width           =   7395
   Begin CommandButton cmdVersion 
      Caption         =   "&Version"
      Height          =   375
      Left            =   1080
      TabIndex        =   24
      Top             =   2400
      Width           =   855
   End
   Begin TextBox txtBounds 
      Alignment       =   1  'Right Justify
      Height          =   375
      Index           =   3
      Left            =   5520
      MaxLength       =   16
      MultiLine       =   -1  'True
      TabIndex        =   14
      Text            =   "32767"
      Top             =   1680
      Width           =   1215
   End
   Begin TextBox txtBounds 
      Alignment       =   1  'Right Justify
      Height          =   375
      Index           =   2
      Left            =   5520
      MaxLength       =   16
      MultiLine       =   -1  'True
      TabIndex        =   12
      Text            =   "-32768"
      Top             =   1200
      Width           =   1215
   End
   Begin ComboBox cmboSortType 
      Height          =   300
      Left            =   1560
      Style           =   2  'Dropdown List
      TabIndex        =   6
      Top             =   960
      Width           =   1935
   End
   Begin ListBox lstAAsorted 
      Height          =   2565
      Left            =   4080
      TabIndex        =   18
      Top             =   3120
      Width           =   2655
   End
   Begin CommandButton cmdCheck 
      Caption         =   "&Check"
      Height          =   375
      Left            =   3720
      TabIndex        =   21
      Top             =   2400
      Width           =   855
   End
   Begin TextBox txtBounds 
      Alignment       =   1  'Right Justify
      Height          =   375
      Index           =   1
      Left            =   5520
      MaxLength       =   16
      MultiLine       =   -1  'True
      TabIndex        =   10
      Text            =   "100"
      Top             =   720
      Width           =   1215
   End
   Begin TextBox txtBounds 
      Alignment       =   1  'Right Justify
      Height          =   375
      Index           =   0
      Left            =   5520
      MaxLength       =   16
      MultiLine       =   -1  'True
      TabIndex        =   8
      Text            =   "0"
      Top             =   240
      Width           =   1215
   End
   Begin ComboBox CmboArrayType 
      Height          =   300
      Left            =   1560
      Style           =   2  'Dropdown List
      TabIndex        =   4
      Top             =   600
      Width           =   1935
   End
   Begin CommandButton cmdExit 
      Caption         =   "E&xit"
      Height          =   375
      Left            =   5040
      TabIndex        =   22
      Top             =   2400
      Width           =   855
   End
   Begin CommandButton cmdSort 
      Caption         =   "&Sort"
      Default         =   -1  'True
      Height          =   375
      Left            =   2400
      TabIndex        =   20
      Top             =   2400
      Width           =   855
   End
   Begin VScrollBar vscListBoxes 
      Height          =   2655
      Left            =   3360
      TabIndex        =   19
      Top             =   3120
      Width           =   255
   End
   Begin ListBox lstSorted 
      Height          =   2565
      Left            =   360
      Sorted          =   -1  'True
      TabIndex        =   16
      Top             =   3120
      Width           =   2655
   End
   Begin ComboBox cmboElementType 
      Height          =   300
      Left            =   1560
      Style           =   2  'Dropdown List
      TabIndex        =   2
      Top             =   240
      Width           =   1935
   End
   Begin ListBox lstUnsorted 
      Height          =   2565
      Left            =   360
      TabIndex        =   0
      Top             =   3120
      Width           =   2535
   End
   Begin Label lblMaximumValue 
      Alignment       =   1  'Right Justify
      AutoSize        =   -1  'True
      Caption         =   "Ma&ximum Value"
      Height          =   195
      Left            =   3870
      TabIndex        =   13
      Top             =   1680
      Width           =   1320
   End
   Begin Label lblMinimumValue 
      Alignment       =   1  'Right Justify
      AutoSize        =   -1  'True
      Caption         =   "M&inimum Value"
      Height          =   195
      Left            =   3915
      TabIndex        =   11
      Top             =   1200
      Width           =   1275
   End
   Begin Label lblStatusBox 
      BackColor       =   &H00C0C0C0&
      BorderStyle     =   1  'Fixed Single
      Caption         =   "StatusBox"
      Height          =   375
      Left            =   0
      TabIndex        =   23
      Top             =   6360
      Width           =   7335
   End
   Begin Label lblSortType 
      Alignment       =   1  'Right Justify
      AutoSize        =   -1  'True
      Caption         =   "S&ort Type"
      Height          =   195
      Left            =   570
      TabIndex        =   5
      Top             =   960
      Width           =   840
   End
   Begin Label lblLowerBound 
      Alignment       =   1  'Right Justify
      AutoSize        =   -1  'True
      Caption         =   "&Lower Bound"
      Height          =   195
      Left            =   4125
      TabIndex        =   7
      Top             =   240
      Width           =   1125
   End
   Begin Label lblArraySize 
      Alignment       =   1  'Right Justify
      AutoSize        =   -1  'True
      Caption         =   "Array Si&ze"
      Height          =   195
      Left            =   4380
      TabIndex        =   9
      Top             =   720
      Width           =   870
   End
   Begin Label lblArrayType 
      Alignment       =   1  'Right Justify
      AutoSize        =   -1  'True
      Caption         =   "&Array Type"
      Height          =   195
      Left            =   480
      TabIndex        =   3
      Top             =   600
      Width           =   930
   End
   Begin Label lblElementType 
      Alignment       =   1  'Right Justify
      AutoSize        =   -1  'True
      Caption         =   "&Element Type"
      Height          =   195
      Left            =   240
      TabIndex        =   1
      Top             =   240
      Width           =   1170
   End
   Begin Label lblSorted 
      Alignment       =   2  'Center
      Caption         =   "Sorted by AA-Sort DLL"
      Height          =   195
      Left            =   3840
      TabIndex        =   17
      Top             =   6000
      Width           =   3015
   End
   Begin Label lblUnsorted 
      Alignment       =   2  'Center
      AutoSize        =   -1  'True
      Caption         =   "Unsorted"
      Height          =   195
      Left            =   360
      TabIndex        =   15
      Top             =   6000
      Width           =   2535
   End
End
Option Explicit

'
' Definitions for aavbsort.dll routines.
'

' Returns various information about the version of the dll
Declare Function Version Lib "aavbsort.dll" (ByVal whichInfo As Integer) As String

' SortAry routines, sorts the array in place
Declare Sub SortAryCurrency Lib "aavbsort.dll" (array() As Currency)
Declare Sub SortAryDouble Lib "aavbsort.dll" (array() As Double)
Declare Sub SortAryInteger Lib "aavbsort.dll" (array() As Integer)
Declare Sub SortAryLong Lib "aavbsort.dll" (array() As Long)
Declare Sub SortArySingle Lib "aavbsort.dll" (array() As Single)
Declare Sub SortAryString Lib "aavbsort.dll" (s() As String)
Declare Sub SortAryUserType Lib "aavbsort.dll" (array() As test, ByVal typeDeclaration As String, ByVal elementIndexToSortOn As Integer)


' SortIdx routines, sorts a index
Declare Sub SortIdxCurrency Lib "aavbsort.dll" (array() As Currency, indexArray() As Integer)
Declare Sub SortIdxDouble Lib "aavbsort.dll" (array() As Double, indexArray() As Integer)
Declare Sub SortIdxInteger Lib "aavbsort.dll" (array() As Integer, indexArray() As Integer)
Declare Sub SortIdxLong Lib "aavbsort.dll" (array() As Long, indexArray() As Integer)
Declare Sub SortIdxSingle Lib "aavbsort.dll" (array() As Single, indexArray() As Integer)
Declare Sub SortIdxString Lib "aavbsort.dll" (s() As String, intArray() As Integer)

' Fixed string SortAry and SortIdx routines.
'     You need to declare one of these for the specific size of fix string array
'     you are using.
Declare Sub SortAryFixed15String Lib "aavbsort.dll" Alias "SortAryFixedString" (s() As String * 15)
Declare Sub SortAryFixed40String Lib "aavbsort.dll" Alias "SortAryFixedString" (s() As String * 40)
Declare Sub SortAryFixed80String Lib "aavbsort.dll" Alias "SortAryFixedString" (s() As String * 80)
Declare Sub SortAryFixed255String Lib "aavbsort.dll" Alias "SortAryFixedString" (s() As String * 255)

Declare Sub SortIdxFixed15String Lib "aavbsort.dll" Alias "SortIdxFixedString" (s() As String * 15, intArray() As Integer)
Declare Sub SortIdxFixed40String Lib "aavbsort.dll" Alias "SortIdxFixedString" (s() As String * 40, intArray() As Integer)
Declare Sub SortIdxFixed80String Lib "aavbsort.dll" Alias "SortIdxFixedString" (s() As String * 80, intArray() As Integer)
Declare Sub SortIdxFixed255String Lib "aavbsort.dll" Alias "SortIdxFixedString" (s() As String * 255, intArray() As Integer)

'
' Constant for managing list boxes
'
Const listBoxRows = 12

Sub CmboArrayType_Click ()
   pClearResults
End Sub

Sub cmboElementType_Click ()
   pClearResults
End Sub

Sub cmboSortType_Click ()
   pClearResults
End Sub

Sub cmdCheck_Click ()

   txtBounds(2) = Format$(minInt)
   txtBounds(2).SetFocus : DoEvents
   txtBounds(3) = "9999"
   txtBounds(3).SetFocus : DoEvents
   txtBounds(2) = "1000"
   txtBounds(2).SetFocus : DoEvents
   cmdCheck.SetFocus : DoEvents

   cmdSort_Click

   lstSorted.Visible = True
   lstUnsorted.Visible = False
   vscListBoxes.Value = vscListBoxes.Max
   vscListBoxes.Value = vscListBoxes.Min

   pStatusMsg "Check Sort"
End Sub

Sub cmdExit_Click ()

   End

End Sub

Sub cmdSort_Click ()

   'Get the current values from form
   arrayBase = Val(txtBounds(0))
   arraySize = Val(txtBounds(1))
   arrayType = cmboArrayType.ListIndex + 1

   'Erase the previous sort's results
   pClearResults
   
   'Setup the vertical scrolling
   vscListBoxes.Min = arrayBase
   vscListBoxes.Max = arrayBase + arraySize - 1
   vscListBoxes.LargeChange = listBoxRows
   vscListBoxes.Enabled = True

   'Create the test arrays
   pStatusMsg "Creating test array..."
   arrayUpdateArrays Me
   'Clear off trash written by updateArrays
   Me.Cls

   'Display the unsorted results
   lstUnsorted.Visible = True
   pDisplayArray lstUnsorted, Int(arrayBase), Int(arrayBase) + listBoxRows, cmboElementType.ListIndex + 1, cmboSortType.ListIndex + 1
   lstSorted.Visible = False
   pDisplayArray lstSorted, Int(arrayBase), Int(arrayBase) + listBoxRows, cmboElementType.ListIndex + 1, cmboSortType.ListIndex + 1
   
   'Sort
   pStatusMsg "Sorting..."
   DoEvents
   Dim sortElaspedTime
   sortElaspedTime = pSortAry(cmboElementType.ListIndex + 1, cmboSortType.ListIndex + 1)
   
   'Display the sorted results
   pStatusMsg "Done. Elasped time: " & Format$(sortElaspedTime, "0.00")
   pDisplayArray lstAAsorted, Int(arrayBase), Int(arrayBase) + listBoxRows, cmboElementType.ListIndex + 1, cmboSortType.ListIndex + 1

End Sub

Sub cmdVersion_Click ()

   MsgBox Version(0), 64, "AAVBSORT.DLL - Version"

End Sub

Sub Form_KeyDown (keycode As Integer, shift As Integer)


   Exit Sub
   'Shift key must be alt
   If shift <> 4 Then Exit Sub

   Select Case keycode
   Case Asc("A"), Asc("a")
         cmboArrayType.SetFocus
   Case Asc("L")
   End Select

   keycode = 0
   shift = 0
   
End Sub

Sub Form_Load ()

   pClearResults

   pLoadElementTypes

   pLoadArrayTypes
   'Default array type to random (the -1 is because lists start counting from zero)
   cmboArrayType.ListIndex = RandomSorted_ArrayType - 1

   'To start with, the user has not set min or max elements
   userSetMinMaxElement = Not_userSetMinMaxElement
   minElement = minInt
   maxElement = maxInt

   pLoadSortTypes
   
   'Center form just to the top left of the screen
   Me.Left = (screen.Width - Me.Width) / 3
   Me.Top = (screen.Height - Me.Height) / 3

End Sub

Sub lblArraySize_Click ()
   txtBounds(1).SetFocus
End Sub

Sub lblArrayType_Click ()
   cmboArrayType.SetFocus
End Sub

Sub lblElementType_Click ()
   cmboElementType.SetFocus
End Sub

Sub lblLowerBound_Click ()
   txtBounds(0).SetFocus
End Sub

Sub lblMaximumValue_Click ()
   txtBounds(3).SetFocus
End Sub

Sub lblMinimumValue_Click ()
   txtBounds(2).SetFocus
End Sub

Sub lblSortType_Click ()
   cmboSortType.SetFocus
End Sub

Sub pClearResults ()

'Erases the results of a sort from the form

   pStatusMsg ""

   vscListBoxes.Enabled = False
   vscListBoxes.Value = vscListBoxes.Min
   
   lstUnsorted.Clear
   lstSorted.Clear
   lstAAsorted.Clear

   
End Sub

Sub pDisplayArray (lst As Control, lower As Integer, upper As Integer, ByVal elementType As Integer, ByVal sortType As Integer)
   
   Select Case sortType
   Case 1
      'Inplace array sort
      Select Case elementType
      Case IntegerElements
         pDisplayIntegerArray lst, lower, upper, i()
      Case LongElements
         pDisplayLongArray lst, lower, upper, l()
      Case SingleElements
         pDisplaySingleArray lst, lower, upper, s()
      Case DoubleElements
         pDisplayDoubleArray lst, lower, upper, d()
      Case StringElements
         pDisplayStringArray lst, lower, upper, st()
      Case FixedString15Elements
         pDisplayString15Array lst, lower, upper, fx15()
      Case CurrencyElements
         pDisplayCurrencyArray lst, lower, upper, c()
      End Select
   Case 2
      'Index Array Sort
      Select Case elementType
      Case IntegerElements
         pDisplayIntegerIndex lst, lower, upper, index(), i()
      Case LongElements
         pDisplayLongIndex lst, lower, upper, index(), l()
      Case SingleElements
         pDisplaySingleIndex lst, lower, upper, index(), s()
      Case DoubleElements
         pDisplayDoubleIndex lst, lower, upper, index(), d()
      Case StringElements
         pDisplayStringIndex lst, lower, upper, index(), st()
      Case FixedString15Elements
         pDisplayString15Index lst, lower, upper, index(), fx15()
      Case CurrencyElements
         pDisplayCurrencyIndex lst, lower, upper, index(), c()
      End Select
   Case 10
      'Display orginal unsorted arrays
      Select Case elementType
      Case IntegerElements
         pDisplayIntegerArray lst, lower, upper, ip()
      Case LongElements
         pDisplayLongArray lst, lower, upper, lp()
      Case SingleElements
         pDisplaySingleArray lst, lower, upper, sp()
      Case DoubleElements
         pDisplayDoubleArray lst, lower, upper, dp()
      Case StringElements
         pDisplayStringArray lst, lower, upper, stp()
      Case FixedString15Elements
         pDisplayString15Array lst, lower, upper, fx15p()
      Case CurrencyElements
         pDisplayCurrencyArray lst, lower, upper, cp()
      End Select
   End Select

End Sub

Sub pDisplayCurrencyArray (lst As Control, lower As Integer, upper As Integer, a() As Currency)

   lst.Clear
   Dim ii As Integer

   For ii = lower To upper
      lst.AddItem Format$(a(ii))
   Next ii

End Sub

Sub pDisplayCurrencyIndex (lst As Control, lower As Integer, upper As Integer, index() As Integer, a() As Currency)

   lst.Clear
   Dim ii As Integer

   For ii = lower To upper
      lst.AddItem Format$(a(index(ii)))
   Next ii

End Sub

Sub pDisplayDoubleArray (lst As Control, lower As Integer, upper As Integer, a() As Double)

   lst.Clear
   Dim ii As Integer

   For ii = lower To upper
      lst.AddItem Format$(a(ii))
   Next ii

End Sub

Sub pDisplayDoubleIndex (lst As Control, lower As Integer, upper As Integer, index() As Integer, a() As Double)

   lst.Clear
   Dim ii As Integer

   For ii = lower To upper
      lst.AddItem Format$(a(index(ii)))
   Next ii

End Sub

Sub pDisplayIntegerArray (lst As Control, lower As Integer, upper As Integer, a() As Integer)

   lst.Clear
   Dim ii As Integer

   For ii = lower To upper
      lst.AddItem Format$(a(ii))
   Next ii

End Sub

Sub pDisplayIntegerIndex (lst As Control, lower As Integer, upper As Integer, index() As Integer, a() As Integer)

   lst.Clear
   Dim ii As Integer

   For ii = lower To upper
      lst.AddItem Format$(a(index(ii)))
   Next ii

End Sub

Sub pDisplayLongArray (lst As Control, lower As Integer, upper As Integer, a() As Long)

   lst.Clear
   Dim ii As Integer

   For ii = lower To upper
      lst.AddItem Format$(a(ii))
   Next ii

End Sub

Sub pDisplayLongIndex (lst As Control, lower As Integer, upper As Integer, index() As Integer, a() As Long)

   lst.Clear
   Dim ii As Integer

   For ii = lower To upper
      lst.AddItem Format$(a(index(ii)))
   Next ii

End Sub

Sub pDisplaySingleArray (lst As Control, lower As Integer, upper As Integer, a() As Single)

   lst.Clear
   Dim ii As Integer

   For ii = lower To upper
      lst.AddItem Format$(a(ii))
   Next ii

End Sub

Sub pDisplaySingleIndex (lst As Control, lower As Integer, upper As Integer, index() As Integer, a() As Single)

   lst.Clear
   Dim ii As Integer

   For ii = lower To upper
      lst.AddItem Format$(a(index(ii)))
   Next ii

End Sub

Sub pDisplayString15Array (lst As Control, lower As Integer, upper As Integer, a() As String * 15)

   lst.Clear
   Dim ii As Integer

   For ii = lower To upper
      lst.AddItem Format$(a(ii))
   Next ii

End Sub

Sub pDisplayString15Index (lst As Control, lower As Integer, upper As Integer, index() As Integer, a() As String * 15)

   lst.Clear
   Dim ii As Integer

   For ii = lower To upper
      lst.AddItem Format$(a(index(ii)))
   Next ii

End Sub

Sub pDisplayStringArray (lst As Control, lower As Integer, upper As Integer, a() As String)

   lst.Clear
   Dim ii As Integer

   For ii = lower To upper
      lst.AddItem Format$(a(ii))
   Next ii

End Sub

Sub pDisplayStringIndex (lst As Control, lower As Integer, upper As Integer, index() As Integer, a() As String)

   lst.Clear
   Dim ii As Integer

   For ii = lower To upper
      lst.AddItem Format$(a(index(ii)))
   Next ii

End Sub

Sub pLoadArrayTypes ()

   cmboArrayType.AddItem "Sorted"            'Sorted_ArrayType = 1
   cmboArrayType.AddItem "Reverse Sorted"    'ReverseSorted_ArrayType = 2
   cmboArrayType.AddItem "Random Sorted"     'RandomSorted_ArrayType = 3
   cmboArrayType.AddItem "All Constants"     'AllConst_ArrayType = 4

   cmboArrayType.ListIndex = 0
End Sub

Sub pLoadElementTypes ()

   cmboElementType.AddItem "Integer"         'IntegerElements = 1
   cmboElementType.AddItem "Long"            'LongElements = 2
   cmboElementType.AddItem "Single"          'SingleElements = 3
   cmboElementType.AddItem "Double"          'DoubleElements = 4
   cmboElementType.AddItem "String"          'StringElements = 5
   cmboElementType.AddItem "FixedString*15"  'FixedString15Elements = 6
   cmboElementType.AddItem "Currency"        'CurrencyElements = 7

   cmboElementType.ListIndex = 0


End Sub

Sub pLoadSortTypes ()
   
   cmboSortType.AddItem "Inplace (SortAry)"
   cmboSortType.AddItem "Indexed (SortIdx)"
   
   cmboSortType.ListIndex = 0


End Sub

Function pMinVal (ByVal a As Integer, ByVal b As Integer) As Integer

   If a <= b Then
      pMinVal = a
   Else
      pMinVal = b
   End If
End Function

Function pSortAry (ByVal elementType As Integer, ByVal sortType As Integer)

'Returns the elapse time for the sort

   Dim t1, t2

   If sortType = 1 Then
      'Inplace array sort
      Select Case elementType
      Case IntegerElements
         t1 = Timer
         SortAryInteger i()
      Case LongElements
         t1 = Timer
         SortAryLong l()
      Case SingleElements
         t1 = Timer
         SortArySingle s()
      Case DoubleElements
         t1 = Timer
         SortAryDouble d()
      Case StringElements
         t1 = Timer
         SortAryString st()
      Case FixedString15Elements
         t1 = Timer
         SortAryFixed15String fx15()
      Case CurrencyElements
         t1 = Timer
         SortAryCurrency c()
      End Select
   Else
      'Index Array Sort
      Select Case elementType
      Case IntegerElements
         t1 = Timer
         SortIdxInteger i(), index()
      Case LongElements
         t1 = Timer
         SortIdxLong l(), index()
      Case SingleElements
         t1 = Timer
         SortIdxSingle s(), index()
      Case DoubleElements
         t1 = Timer
         SortIdxDouble d(), index()
      Case StringElements
         t1 = Timer
         SortIdxString st(), index()
      Case FixedString15Elements
         t1 = Timer
         SortIdxFixed15String fx15(), index()
      Case CurrencyElements
         t1 = Timer
         SortIdxCurrency c(), index()
      End Select
   End If

   t2 = Timer

   pSortAry = t2 - t1

End Function

Sub pStatusMsg (ByVal msg As String)

'Dispalys a message in the status box

   lblStatusBox.Caption = msg
   lblStatusBox.Refresh
End Sub

Sub txtBounds_GotFocus (index As Integer)

   'Select all the text
   If Len(txtBounds(index).Text) <> 0 Then
      txtBounds(index).SelStart = 0
      txtBounds(index).SelLength = Len(txtBounds(index).Text)
   End If

End Sub

Sub txtBounds_KeyPress (index As Integer, keyAscii As Integer)

   '
   ' Filter non-numeric chars
   '
   'Backspaces are OK
   If keyAscii = 8 Then Exit Sub

   ' Minus sign OK if first char and lbounds text box
   If keyAscii = Asc("-") And Len(txtBounds(index).Text) = 0 And index = 0 Then Exit Sub

   'Otherwise the char must be a digit
   If keyAscii >= Asc("0") And keyAscii <= Asc("9") Then Exit Sub

   ' Complain and filter char
   Beep
   keyAscii = 0
End Sub

Sub txtBounds_LostFocus (index As Integer)

   Select Case index
   Case 0
      'Lower Bounds
      If Val(txtBounds(index)) < minInt Or Val(txtBounds(index)) > maxInt Then
         pStatusMsg "Lower bounds must be between" & Str$(minInt) & " and" & Str$(maxInt)
         Beep
         txtBounds(index).SetFocus
         Exit Sub
      End If
      arrayBase = Val(txtBounds(index))
   Case 1
      'Array Size
      If Val(txtBounds(index)) <= 0 Or Val(txtBounds(index)) > maxInt Then
         pStatusMsg "Array size must be between 0 and" & Str$(maxInt)
         Beep
         txtBounds(index).SetFocus
         Exit Sub
      End If
      arraySize = Val(txtBounds(index))
   Case 2
      'min Element
      If Trim$(txtBounds(index)) = "" Then
         userSetMinMaxElement = Not_userSetMinMaxElement
         minElement = minInt
      End If
         
      If Val(txtBounds(index)) < minInt Or Val(txtBounds(index)) > maxInt Or Val(txtBounds(index)) >= maxElement Then
         pStatusMsg "Minimum element value must be between" & Str$(maxInt) & " &" & Str$(maxInt) & " and less than the maximum element value"
         Beep
         txtBounds(index).SetFocus
         Exit Sub
      End If
      userSetMinMaxElement = HasSet_userSetMinMaxElement
      minElement = Val(txtBounds(index))
   Case 3
      'max Element
      If Trim$(txtBounds(index)) = "" Then
         userSetMinMaxElement = Not_userSetMinMaxElement
         maxElement = maxInt
      End If
         
      If Val(txtBounds(index)) < minInt Or Val(txtBounds(index)) > maxInt Or Val(txtBounds(index)) <= minElement Then
         pStatusMsg "Maximum element value must be between" & Str$(maxInt) & " &" & Str$(maxInt) & " and greater than the minimum element value"
         Beep
         txtBounds(index).SetFocus
         Exit Sub
      End If
      userSetMinMaxElement = HasSet_userSetMinMaxElement
      maxElement = Val(txtBounds(index))
   End Select

   pClearResults
End Sub

Sub txtStatusBox_GotFocus ()

End Sub

Sub vscListBoxes_Change ()

'Scrolls through the list boxes in a sync'ed fashion

   ' Quick exit if scroll bar has been turned off
   If Not vscListBoxes.Enabled Then Exit Sub

   ' Dispaly the orignal unsorted array (flag is by passing 10 as the sortType)
   pDisplayArray lstUnsorted, Int(vscListBoxes.Value), pMinVal(vscListBoxes.Max, vscListBoxes.Value + listBoxRows), cmboElementType.ListIndex + 1, 10

   pDisplayArray lstSorted, Int(vscListBoxes.Value), pMinVal(vscListBoxes.Max, vscListBoxes.Value + listBoxRows), cmboElementType.ListIndex + 1, cmboSortType.ListIndex + 1
   pDisplayArray lstAAsorted, Int(vscListBoxes.Value), pMinVal(vscListBoxes.Max, vscListBoxes.Value + listBoxRows), cmboElementType.ListIndex + 1, cmboSortType.ListIndex + 1

End Sub

