#ifndef _CPPSUM_H_
#define _CPPSUM_H_
/***************************************************************************
*
* DLL functions to get summary info from OLE 2.0 document files.
*
*     Copyright  1994 Frank F Ramos, All Rights Reserved
*     Send problem reports and comments to 72202.2574@compuserve.com
*            
* Compile using CPPSUM.H
* Link using CPPSUM.LIB
* CPPSUM.DLL should be placed in \WINDOWS\SYSTEM.
* 
* Example of usage:
*     WORD   wInitStatus;
*     HANDLE hSumInfo;
*     char   szTemp[256];
*     LPSTR  szFilePath;
*     WORD   yr, mon, day, hr, min, sec;
*     if (wInitStatus = SumInfoInit()) {
*        ... loop to process files ...
*           szFilePath = ...
*           if (hSumInfo = SumInfoOpenFile(szFilePath)) {
*              if (SumInfoGetString(hSumInfo, PID_TITLE, szTemp, 256)) {
*                 ... do something with szTemp ...
*              }
*              if (SumInfoGetTime(hSumInfo, PID_LASTSAVED, 
*                                 &yr, &mon, &day, &hr, &min, &sec)) {
*                 ... do something with time ...
*              }
*              ...
*              SumInfoCloseFile(hSumInfo);
*           }
*        }
*        SumInfoUninit(wInitStatus);
*     }
*
* Reasons for failure:
*     SumInfoInit:     out of memory
*     SumInfoOpenFile: out of memory
*                      file not found
*                      file is not an OLE 2.0 structured storage file
*                      file does not contain OLE 2.0 summary info
*                      OLE 2.0 summary info is incorrectly formatted
*     SumInfoGet...  : specified property type is not available
*     
* Change log:
* V1.4 94/06/18 Documentation changes only
* V1.3 94/06/06 Change validity checking, because Excel 5.0 files
*                  are slightly invalid
* V1.2 94/03/01 Change STGM_SHARE_DENY_WRITE to STGM_SHARE_DENY_NONE, so
*                  info can be obtained for files currently open in WinWord.
* V1.1 94/01/22 Add wInitStatus parameter to SumInfoInit and SumInfoUninit,
*                  to account for case where CoInitialize already called for  
*                  application.
*               Ensure SumInfoGetString returns zero terminated string.
*               Fix minor typos in documentation.
* V1.0 94/01/20 Initial version.
**************************************************************************/

   /* String properties */
#define PID_TITLE          0X00000002
#define PID_SUBJECT        0X00000003
#define PID_AUTHOR         0X00000004
#define PID_KEYWORDS       0X00000005
#define PID_COMMENTS       0X00000006
#define PID_TEMPLATE       0X00000007
#define PID_LASTAUTHOR     0X00000008
#define PID_REVNUMBER      0X00000009
#define PID_APPNAME        0X00000012

   /* Time properties */
#define PID_TOTAL_EDITTIME 0X0000000A
#define PID_LASTPRINTED    0X0000000B
#define PID_CREATED        0X0000000C
#define PID_LASTSAVED      0X0000000D

   /* Long properties */
#define PID_PAGECOUNT      0X0000000E
#define PID_WORDCOUNT      0X0000000F
#define PID_CHARCOUNT      0X00000010
#define PID_SECURITY       0X00000013

   /* bit masks for security long */
#define AllSecurityFlagsEqNone         0
#define fSecurityPassworded            1
#define fSecurityRORecommended         2
#define fSecurityRO                    4
#define fSecurityLockedForAnnotations  8

#ifdef __cplusplus
extern "C" {
#endif

WORD FAR PASCAL SumInfoInit(); /* return value of non-zero indicates success 
                                  return value must be passed to SumInfoUninit */

HANDLE FAR PASCAL SumInfoOpenFile(LPSTR      szPath);  /*in : file path  */
                                 
BOOL FAR PASCAL SumInfoGetString(HANDLE      hSumInfo, /*in : handle     */
                                 DWORD       pid,      /*in : property ID*/
                                 LPSTR       lpBuf,    /*out: string val */
                                 int         cbBuf);   /*in : lpStr size */
                                 
BOOL FAR PASCAL SumInfoGetLong  (HANDLE      hSumInfo, /*in : handle     */     
                                 DWORD       pid,      /*in : property ID*/
                                 LPLONG      lpLong);  /*out: long val   */
                                 
BOOL FAR PASCAL SumInfoGetTime  (HANDLE      hSumInfo, /*in : handle     */
                                 DWORD       pid,      /*in : property ID*/
                                 LPWORD      lpYear,   /*out: 1980-9999  */
                                 LPWORD      lpMonth,  /*out: 1-12       */
                                 LPWORD      lpDay,    /*out: 1-31       */
                                 LPWORD      lpHour,   /*out: 0-23       */
                                 LPWORD      lpMin,    /*out: 0-59       */
                                 LPWORD      lpSec);   /*out: 0-59       */
                                 
void FAR PASCAL SumInfoCloseFile(HANDLE     hSumInfo); /*in : handle     */

void FAR PASCAL SumInfoUninit   (WORD     wInitStatus);/*in : status from SumInfoInit*/

#ifdef __cplusplus
}
#endif 

#endif /* _CPPSUM_H_ */

