'
'
'   MAGMAED.BAS
'
'      Declarations and Constants for the Magma Editor VBX
'
'      This was mainly copied from the MAGMAED.H file for the DLL version
'



' Editor styles
Global Const ES_WANTTAB = &H8000
Global Const ES_OWNERDRAW = &H4000
Global Const ES_HASSTRINGS = &H200
Global Const ODT_EDIT = 99

' This is the structure used for searching and replacing
Global Const MAXPATTERNLEN = 128

Type SearchArg
  ' Flags for search & replace operation
  fFlags As Integer
   
  ' This is the search pattern. The array is MAXPATTERNLEN chars long,
  ' unless SEARCH_USE_VARWIDTH_PATTERN is specified. In that case,
  ' the replacement pattern follows the NULL character in the search
  ' pattern.
  szPattern As String

  ' This is the replacement pattern
  szReplacement As String
End Type

' Value of SearchArg.fFlags
Global Const SEARCH_CASE_INSENSITIVE = &H1         ' case insensitive search
Global Const SEARCH_NO_REGEXP = &H2                ' don't treat pattern as regex
Global Const SEARCH_SELECTMATCH = &H4              ' highlight the matched text
Global Const SEARCH_WHOLE_WORD_ONLY = &H8          ' match a whole word only
Global Const SEARCH_PROMPT_ON_REPLACE = &H100      ' prompt before replacing
Global Const SEARCH_REPLACE_ALL = &H200            ' global substitution
Global Const SEARCH_BACKWARD = &H1000              ' search backwards
Global Const SEARCH_USE_VARWIDTH_PATTERN = &H2000



' Editor Messages
Global Const WM_USER = &H400
Global Const WM_BASE = (WM_USER + 1313)

Global Const ME_SELFINSERT = WM_BASE + 0
Global Const ME_FSEARCH = WM_BASE + 1
Global Const ME_BSEARCH = WM_BASE + 2
Global Const ME_FREPLACE = WM_BASE + 3
Global Const ME_BREPLACE = WM_BASE + 4

Global Const ME_DELLINE = WM_BASE + 5
Global Const ME_APPENDLINE = WM_BASE + 6
Global Const ME_INSERTLINE = WM_BASE + 7
Global Const ME_CUT = WM_BASE + 8
Global Const ME_CUTAPPEND = WM_BASE + 9
Global Const ME_RESETMARK = WM_BASE + 10
Global Const ME_COPY = WM_BASE + 11
Global Const ME_DUPLINE = WM_BASE + 12
Global Const ME_PASTE = WM_BASE + 13
Global Const ME_BACKSPACE = WM_BASE + 14
Global Const ME_DELWORD = WM_BASE + 15
Global Const ME_DELCHAR = WM_BASE + 16
Global Const ME_DELEOL = WM_BASE + 17
Global Const ME_TOGGLEINSERT = WM_BASE + 18
  Global Const INSERTMODE_TOGGLE = 0
  Global Const INSERTMODE_ON = 1
  Global Const INSERTMODE_OFF = 2
Global Const ME_TAB = WM_BASE + 19
Global Const ME_BACKTAB = WM_BASE + 20
Global Const ME_UNDO = WM_BASE + 21
Global Const ME_REDO = WM_BASE + 22
Global Const ME_SEARCHAGAIN = WM_BASE + 23
Global Const ME_REPLACEAGAIN = WM_BASE + 24

Global Const ME_MOVEUP = WM_BASE + 30
Global Const ME_MOVEDOWN = WM_BASE + 31
Global Const ME_MOVELEFT = WM_BASE + 32
Global Const ME_MOVERIGHT = WM_BASE + 33
Global Const ME_MOVEBOL = WM_BASE + 34
Global Const ME_MOVEEOL = WM_BASE + 35
Global Const ME_MOVENEXTWORD = WM_BASE + 36
Global Const ME_MOVEPREVWORD = WM_BASE + 37
Global Const ME_MOVENEXTPARA = WM_BASE + 38
Global Const ME_MOVEPREVPARA = WM_BASE + 39
Global Const ME_MOVETOPOFWINDOW = WM_BASE + 40
Global Const ME_MOVEBOTOFWINDOW = WM_BASE + 41
Global Const ME_MOVENEXTPAGE = WM_BASE + 42
Global Const ME_MOVEPREVPAGE = WM_BASE + 43
Global Const ME_MOVETOPOFBUFFER = WM_BASE + 44
Global Const ME_MOVEBOTOFBUFFER = WM_BASE + 45
Global Const ME_MOVETOBOOKMARK = WM_BASE + 46
Global Const ME_SETBOOKMARK = WM_BASE + 47
Global Const ME_GOTOLINE = WM_BASE + 48
  Global Const GOTOLINE_ABS = 1
  Global Const GOTOLINE_LAST = 2
  Global Const GOTOLINE_NEXT = 3
  Global Const GOTOLINE_PREV = 4
Global Const ME_REMOVEBOOKMARK = WM_BASE + 49
  Global Const BOOKMARK_REMOVEALL = -1

Global Const ME_MATCHBRACE = WM_BASE + 50
Global Const ME_MARKLINE = WM_BASE + 51
Global Const ME_MARKLINERANGE = WM_BASE + 52
Global Const ME_INSERTCHAR = WM_BASE + 53
Global Const ME_UNDOLINES = WM_BASE + 54
Global Const ME_STREAMMARK = WM_BASE + 55
Global Const ME_RECTMARK = WM_BASE + 56
Global Const ME_CASELOWER = WM_BASE + 57
Global Const ME_CASEUPPER = WM_BASE + 58

Global Const ME_OPENFILE = WM_BASE + 60
Global Const ME_WRITEFILE = WM_BASE + 61

' Return codes for EM_WRITEFILE
  Global Const EN_ERRCREATING = (-1)
  Global Const EN_ERRWRITING = (-2)

' Options and settings
Global Const ME_SETBKCOLOR = WM_BASE + 70
Global Const ME_SETTEXTCOLOR = WM_BASE + 71
Global Const ME_SETOPTION = WM_BASE + 72
Global Const ME_QUERYOPTION = WM_BASE + 73
Global Const ME_OPTIONDLG = WM_BASE + 74
Global Const ME_SETFONT = WM_BASE + 75
Global Const ME_TOGGLEWORDWRAP = WM_BASE + 76
  Global Const WORDWRAP_OFF = 0
  Global Const WORDWRAP_ON = 1
  Global Const WORDWRAP_TOGGLE = 2
Global Const ME_SETHIGHLIGHTCOLOR = WM_BASE + 77
Global Const ME_SETHIGHLIGHTTEXTCOLOR = WM_BASE + 78

Global Const ME_HELPONWORD = WM_BASE + 80
Global Const ME_GETCURRWORD = WM_BASE + 81

Global Const ME_KEYMACDEFINE = WM_BASE + 90
Global Const ME_KEYMACPLAY = WM_BASE + 91
Global Const ME_KEYMACPAUSE = WM_BASE + 92
Global Const ME_PROGFROMKEYMAC = WM_BASE + 93

' Misc
Global Const ME_QUERYSEARCHSTRING = WM_BASE + 100
Global Const ME_QUERYSTATUS = WM_BASE + 101
Global Const ME_INSERTSTRING = WM_BASE + 102
  Global Const ME_INSERT_MODE = 0
  Global Const ME_OVERSTRIKE_MODE = 1
Global Const ME_GETITEMDATA = WM_BASE + 103
Global Const ME_SETITEMDATA = WM_BASE + 104
Global Const ME_GETITEMHEIGHT = WM_BASE + 105
Global Const ME_SETITEMHEIGHT = WM_BASE + 106
Global Const ME_QUERYNUMWORDS = WM_BASE + 107
Global Const ME_TRIMTEXT = WM_BASE + 108
 Global Const TRIM_LEADING_BLANKS = &H1
 Global Const TRIM_TRAILING_BLANKS = &H2
 Global Const TRIM_COMPRESS_BLANKS = &H4
Global Const ME_CENTER = WM_BASE + 109
Global Const ME_REFORMAT = WM_BASE + 110
Global Const ME_REFORMATALL = WM_BASE + 111
Global Const ME_QUERYBOOKMARK = WM_BASE + 112
Global Const ME_INSERTPICTURE = WM_BASE + 113
Global Const ME_DUMPUNDOINFO = WM_BASE + 114

' Owner-drawn messages sent by the editor control
Global Const ME_DRAWITEM = WM_BASE + 115
Global Const ME_DELETEITEM = WM_BASE + 116
Global Const ME_MEASUREITEM = WM_BASE + 117

Global Const ME_SETREADNOTIFICATION = WM_BASE + 118
Global Const ME_READNOTIFY = WM_BASE + 119
  Global Const READNOTIFY_START = 0
  Global Const READNOTIFY_READING = 1
  Global Const READNOTIFY_END = 2

Global Const ME_SETCOLUMN = WM_BASE + 120

Global Const WM_BASE_LAST_MSG = WM_BASE + 200


' Notification messages
Global Const MEN_UPDATE = WM_BASE + 200

' Test bed for messages
Global Const WM_MSGTESTBASE = WM_BASE + 900

' Standard Windows messages
Global Const WM_SETTEXT = 12
Global Const WM_GETTEXT = 13
Global Const WM_GETTEXTLENGTH = 14

' Standard Windows edit control messages
Global Const EM_GETSEL = (WM_USER + 0)
Global Const EM_SETSEL = (WM_USER + 1)
Global Const EM_LINESCROLL = (WM_USER + 6)
Global Const EM_GETMODIFY = (WM_USER + 8)
Global Const EM_SETMODIFY = (WM_USER + 9)
Global Const EM_GETLINECOUNT = (WM_USER + 10)
Global Const EM_LINEINDEX = (WM_USER + 11)
Global Const EM_LINELENGTH = (WM_USER + 17)
Global Const EM_REPLACESEL = (WM_USER + 18)
Global Const EM_GETLINE = (WM_USER + 20)
Global Const EM_LIMITTEXT = (WM_USER + 21)
Global Const EM_CANUNDO = (WM_USER + 22)
Global Const EM_UNDO = (WM_USER + 23)
Global Const EM_LINEFROMCHAR = (WM_USER + 25)
Global Const EM_SETTABSTOPS = (WM_USER + 27)
Global Const EM_EMPTYUNDOBUFFER = (WM_USER + 29)
Global Const EM_GETFIRSTVISIBLELINE = (WM_USER + 30)
Global Const EM_SETREADONLY = (WM_USER + 31)


' The following messages are compatible with the Chicago RTF edit control
Global Const EM_CHARFROMPOS = (WM_USER + 1213)
Global Const EM_EXGETSEL = (WM_USER + 1214)
Global Const EM_EXLINEFROMCHAR = (WM_USER + 1215)
Global Const EM_EXSETSEL = (WM_USER + 1216)
Global Const EM_GETSELTEXT = (WM_USER + 1217)
Global Const EM_GETTEXTRANGE = (WM_USER + 1218)
Global Const EM_POSFROMCHAR = (WM_USER + 1219)
Global Const EM_SELECTIONTYPE = (WM_USER + 1220)
Global Const EM_SETBKGNDCOLOR = (WM_USER + 1221)
Global Const EM_GETCHARFORMAT = (WM_USER + 1222)
Global Const EM_SETCHARFORMAT = (WM_USER + 1223)
  Global Const SCF_SELECTION = &H1
  Global Const SCF_WORD = &H2


Type CharRange
  cpMin As Long
  cpMax As Long
End Type


Type MeStatus
  bInsert As Integer
  column As Integer
  row As Long
  currLineNum As Long
  nTotalLines As Long
End Type

Type Rect
  left As Integer
  top As Integer
  right As Integer
  bottom As Integer
End Type


Type MEDRAWITEMSTRUCT
  CtlType As Integer
  CtlID As Integer
  itemID As Integer
  itemAction As Integer
  itemState As Integer
  hwndItem As Integer
  hDC As Integer
  rcItem As Rect
  itemData As Long
  lpText As String
  lineNumber As Long
  colLeft As Integer
  idxLeft As Integer
  pixLeft As Integer
End Type

Function MECanUndo (pEditCtl As Control) As Integer
  MECanUndo = SendMessage(pEditCtl.hWnd, EM_CANUNDO, 0, 0)
End Function

Function MEGetColumn (pEditCtl As Control) As Long
  Dim qs As MeStatus
  rc = SendMessage(pEditCtl.hWnd, ME_QUERYSTATUS, 0, qs)
  MEGetColumn = qs.column
End Function

Function MEGetCurrLinenum (pEditCtl As Control) As Long
  Dim qs As MeStatus
  rc = SendMessage(pEditCtl.hWnd, ME_QUERYSTATUS, 0, qs)
  MEGetCurrLinenum = qs.currLineNum
End Function

Function MEGetCurrRow (pEditCtl As Control) As Integer
  Dim qs As MeStatus
  rc = SendMessage(pEditCtl.hWnd, ME_QUERYSTATUS, 0, qs)
  MEGetCurrRow = qs.row
End Function

Function MEGetFirstVisibleLine (pEditCtl As Control) As Long
  MEGetFirstVisibleLine = SendMessage(pEditCtl.hWnd, EM_GETFIRSTVISIBLELINE, 0, 0)
End Function

Function MEGetLine (pEditCtl As Control, ByVal lineNum As Long) As String
  Dim szBuf As String
  Dim rc    As Long

  szBuf = String(1024, Chr(0))
  rc = SendMessage(pEditCtl.hWnd, EM_GETLINE, lineNum, szBuf)
  MEGetLine = szBuf

End Function

Function MEGetNumLines (pEditCtl As Control) As Long
  MEGetNumLines = SendMessage(pEditCtl.hWnd, EM_GETLINECOUNT, 0, 0)
End Function

Function MEGetTextLength (pEditCtl As Control) As Long
  MEGetTextLength = SendMessage(pEditCtl.hWnd, WM_GETTEXTLENGTH, 0, 0)
End Function

Function MELineFromChar (pEditCtl As Control, ByVal idx As Long) As Long
  MELineFromChar = SendMessage(pEditCtl.hWnd, EM_LINEFROMCHAR, 0, idx)
End Function

Function MELineIndex (pEditCtl As Control, ByVal lineNum As Long) As Long
  MELineIndex = SendMessage(pEditCtl.hWnd, EM_LINEINDEX, 0, lineNum)
End Function

Function MELineLength (pEditCtl As Control, ByVal idx As Long) As Long
  MELineLength = SendMessage(pEditCtl.hWnd, EM_LINELENGTH, 0, idx)
End Function

