Option Explicit

Const ATTR_DIRECTORY = 16

Function FindFile$ (srcPath$, Filename$)

' Description
'     Finds a file in the subdirs under srcPath
'
' Parameters
'     Name                 Type     Value
'     ------------------------------------------------------------
'     srcPath              String   The path so start searching in
'     Filename             String   The file to look for
'
' Returns
'     The first occurence of Filename$
'
' Last modified by Jens Balchen 10.03.1996

Dim DirReturn As String, i As Integer
Dim subdirs$
Dim filefound$
Dim path$

   ' If Path lacks a "\", add one to the end
   If Right$(srcPath, 1) <> "\" Then srcPath = srcPath & "\"
   srcPath = UCase$(srcPath)
   Filename$ = UCase$(Filename$)
   
   ' Now find if the file is here
   DirReturn = Dir(srcPath & Filename, 0)

   ' If it is, return the filename and dir
   If DirReturn$ <> "" Then
      FindFile$ = srcPath$ & Filename$
      Exit Function
   End If

   ' No, it wasn't here. Do all the subdirs
   ' Initialize var to hold filenames
   DirReturn = Dir(srcPath & "*.*", ATTR_DIRECTORY)
   
   ' Find all subdirs
   Do While DirReturn <> ""
      ' Make sure we don't do anything with "." and "..", they aren't real files
      If DirReturn <> "." And DirReturn <> ".." Then
         DoEvents
         If GetAttr(srcPath & DirReturn) = ATTR_DIRECTORY Then
            ' It's a dir. Add it to dirlist
            subdirs$ = subdirs$ & srcPath & DirReturn & ";"
         End If
      End If
      DirReturn = Dir
   Loop

   ' Do all subs
   Do
      
      i% = i% + 1
      If Mid$(subdirs$, i%, 1) = ";" Then
         path$ = Left$(subdirs$, i% - 1)
         If path$ <> "" Then
            filefound$ = FindFile$(path$, Filename$)
            If filefound$ <> "" Then
               FindFile$ = filefound$
               Exit Function
            End If
            subdirs$ = Right$(subdirs$, Len(subdirs$) - i%)
            i% = 0
         End If
      End If

      DoEvents

      If subdirs$ = "" Then Exit Do

   Loop

ExitFunc:

   Exit Function

End Function

