VERSION 2.00
Begin Form frmMain 
   BackColor       =   &H00C0C0C0&
   BorderStyle     =   3  'Fixed Double
   Caption         =   "Chat Sample Application"
   ClientHeight    =   7545
   ClientLeft      =   2115
   ClientTop       =   585
   ClientWidth     =   8115
   FontBold        =   -1  'True
   FontItalic      =   0   'False
   FontName        =   "Arial"
   FontSize        =   8.25
   FontStrikethru  =   0   'False
   FontUnderline   =   0   'False
   Height          =   7950
   Icon            =   DSCHAT.FRX:0000
   Left            =   2055
   LinkTopic       =   "Form1"
   MaxButton       =   0   'False
   ScaleHeight     =   7545
   ScaleWidth      =   8115
   Top             =   240
   Width           =   8235
   Begin dsSocket dsSocket2 
      DataSize        =   2048
      Left            =   5160
      Linger          =   -1  'True
      LocalPort       =   0
      RemoteDotAddr   =   ""
      RemoteHost      =   ""
      RemotePort      =   0
      ServiceName     =   ""
      Timeout         =   10
      Top             =   0
   End
   Begin dsSocket dsSocket1 
      DataSize        =   2048
      Left            =   4560
      Linger          =   -1  'True
      LocalPort       =   0
      RemoteDotAddr   =   ""
      RemoteHost      =   ""
      RemotePort      =   0
      ServiceName     =   ""
      Timeout         =   10
      Top             =   0
   End
   Begin CommandButton btnStopChat 
      Caption         =   "Stop Chat"
      Enabled         =   0   'False
      Height          =   330
      Left            =   6405
      TabIndex        =   17
      Top             =   1575
      Width           =   1590
   End
   Begin CommandButton btnStopWaiting 
      Caption         =   "Stop Waiting"
      Enabled         =   0   'False
      Height          =   330
      Left            =   4830
      TabIndex        =   16
      Top             =   1575
      Width           =   1590
   End
   Begin CommandButton btnChatSomeone 
      Caption         =   "Chat Someone"
      Height          =   330
      Left            =   6405
      TabIndex        =   15
      Top             =   1260
      Width           =   1590
   End
   Begin CommandButton btnWaitForChat 
      Caption         =   "Wait for chat"
      Height          =   330
      Left            =   4830
      TabIndex        =   14
      Top             =   1260
      Width           =   1590
   End
   Begin TextBox txReply 
      BackColor       =   &H00FFFFFF&
      Enabled         =   0   'False
      Height          =   3060
      Left            =   105
      MultiLine       =   -1  'True
      TabIndex        =   13
      Top             =   3990
      Width           =   7890
   End
   Begin TextBox txPortNumber 
      BackColor       =   &H00FFFFFF&
      Height          =   285
      Left            =   6090
      TabIndex        =   12
      Top             =   630
      Width           =   855
   End
   Begin TextBox txStatus 
      BackColor       =   &H00C0C0C0&
      Height          =   330
      Left            =   105
      TabIndex        =   10
      Top             =   7140
      Width           =   7890
   End
   Begin TextBox txMessage 
      BackColor       =   &H00FFFFFF&
      Enabled         =   0   'False
      Height          =   1695
      Left            =   105
      MultiLine       =   -1  'True
      TabIndex        =   9
      Top             =   1995
      Width           =   7890
   End
   Begin PictureBox Picture1 
      BackColor       =   &H00C0C0C0&
      BorderStyle     =   0  'None
      Height          =   1065
      Left            =   105
      ScaleHeight     =   1065
      ScaleWidth      =   4425
      TabIndex        =   1
      Top             =   630
      Width           =   4425
      Begin OptionButton opServerAddress 
         BackColor       =   &H00C0C0C0&
         Caption         =   "Use Server Address"
         Height          =   225
         Left            =   2310
         TabIndex        =   7
         Top             =   735
         Width           =   2115
      End
      Begin OptionButton opServerName 
         BackColor       =   &H00C0C0C0&
         Caption         =   "Use Server Name"
         Height          =   225
         Left            =   210
         TabIndex        =   6
         Top             =   735
         Value           =   -1  'True
         Width           =   1905
      End
      Begin TextBox txServerAddress 
         BackColor       =   &H00FFFFFF&
         Height          =   285
         Left            =   1575
         TabIndex        =   5
         Top             =   315
         Width           =   2745
      End
      Begin TextBox txServerName 
         BackColor       =   &H00FFFFFF&
         Height          =   285
         Left            =   1575
         TabIndex        =   4
         Top             =   0
         Width           =   2745
      End
      Begin Label Label2 
         BackColor       =   &H00C0C0C0&
         Caption         =   "Server Address :"
         Height          =   225
         Left            =   0
         TabIndex        =   3
         Top             =   315
         Width           =   1485
      End
      Begin Label Label1 
         BackColor       =   &H00C0C0C0&
         Caption         =   "Server Name :"
         Height          =   225
         Left            =   0
         TabIndex        =   2
         Top             =   0
         Width           =   1485
      End
   End
   Begin Label Label5 
      BackColor       =   &H00C0C0C0&
      Caption         =   "Port to Use :"
      Height          =   225
      Left            =   4935
      TabIndex        =   11
      Top             =   630
      Width           =   1170
   End
   Begin Label laReply 
      BackColor       =   &H00C0C0C0&
      Caption         =   "Reply :"
      Enabled         =   0   'False
      Height          =   225
      Left            =   105
      TabIndex        =   0
      Top             =   3780
      Width           =   645
   End
   Begin Label laMessage 
      BackColor       =   &H00C0C0C0&
      Caption         =   "Message :"
      Enabled         =   0   'False
      Height          =   225
      Left            =   105
      TabIndex        =   8
      Top             =   1785
      Width           =   960
   End
End

Option Explicit

'   Declare the constants used to set the Action property
'   and check the State of the socket

Const SOCK_ACTION_CLOSE = 1
Const SOCK_ACTION_CONNECT = 2
Const SOCK_ACTION_LISTEN = 3
Const SOCK_STATE_CONNECTED = 2
Const SOCK_ERR_CLOSED = 20000

Dim nTextPos     As Integer

Sub btnChatSomeone_Click ()

    '   Setup to handle errors as they occur
    On Error Resume Next

    '   If the user selected to use the ServerName, then
    '   set the properties accordingly.  If RemoteDotAddr is
    '   blank, then the control will use the RemoteHost information
    '   to resolve an address.
    If (opServerName) Then
        dsSocket2.RemoteHost = txServerName.Text
        dsSocket2.RemoteDotAddr = ""
    Else
        dsSocket2.RemoteHost = ""
        dsSocket2.RemoteDotAddr = txServerAddress.Text
    End If

    '   Setup the port for connecting to on the remote system
    dsSocket2.RemotePort = Val(txPortNumber.Text)

    '   If the socket is already connected, then this is an error
    If (dsSocket2.State = SOCK_STATE_CONNECTED) Then
        MsgBox "The socket is already connected to someone."

    Else
        '   show the status information
        txStatus.Text = "Connecting to server..."
        
        '   issue the connect command
        dsSocket2.Action = SOCK_ACTION_CONNECT
        
        '   if there were any errors establishing the connection
        '   then report them
        If (Err > 0) Then
            MsgBox "Error connecting to server." & Chr(13) & Format(Err) & " : " & Error
            txStatus.Text = Error & "..."
            btnChatSomeone.Enabled = True
            btnWaitForChat.Enabled = True
            laMessage.Enabled = False
            txMessage.Enabled = False
            laReply.Enabled = False
            txReply.Enabled = False
            Exit Sub
        
        '   else show the status
        Else
            txStatus.Text = "Connected to server " + txServerName.Text + "..."
            btnChatSomeone.Enabled = False
            btnWaitForChat.Enabled = False
            btnStopChat.Enabled = True
            laMessage.Enabled = True
            txMessage.Enabled = True
            laReply.Enabled = True
            txReply.Enabled = True

        End If

    End If

End Sub

Sub btnStopChat_Click ()

    On Error Resume Next

    '   close the connection to the remote
    dsSocket2.Action = SOCK_ACTION_CLOSE
    
    '   If there were any errors then report them.  The Action property
    '   will return errors in the standard VB error variables
    If (Err > 0) Then
        MsgBox "Error disconnecting." & Chr(13) & Format(Err) & " : " & Error
        txStatus.Text = Error & "..."
        Exit Sub
    
    '   If no errors, just report the status
    Else
        txStatus.Text = "Disconnected from " + txServerName.Text + "..."
        btnWaitForChat.Enabled = True
        btnChatSomeone.Enabled = True
        btnStopWaiting.Enabled = False
        btnStopChat.Enabled = False
    End If

End Sub

Sub btnStopWaiting_Click ()

    On Error Resume Next

    '   close the connection to the remote
    dsSocket1.Action = SOCK_ACTION_CLOSE
    
    '   If there were any errors then report them.  The Action property
    '   will return errors in the standard VB error variables
    If (Err > 0) Then
        MsgBox "Error cancelling Listen." & Chr(13) & Format(Err) & " : " & Error
        txStatus.Text = Error & "..."
        Exit Sub
    
    '   If no errors, just report the status
    Else
        txStatus.Text = "Listen cancelled..."
        btnWaitForChat.Enabled = True
        btnChatSomeone.Enabled = True
        btnStopWaiting.Enabled = False
        btnStopChat.Enabled = False
    End If

End Sub

Sub btnWaitForChat_Click ()

    On Error Resume Next

    dsSocket1.LocalPort = Val(txPortNumber.Text)

    dsSocket1.Action = SOCK_ACTION_LISTEN

    '   If there were any errors then report them.  The Action property
    '   will return errors in the standard VB error variables
    If (Err > 0) Then
        MsgBox "Error listening for connection." & Chr(13) & Format(Err) & " : " & Error
        txStatus.Text = Error & "..."
        Exit Sub
    
    '   If no errors, just report the status
    Else
        txStatus.Text = "Listening for connection " + txServerName.Text + "..."
        btnWaitForChat.Enabled = False
        btnChatSomeone.Enabled = False
        btnStopWaiting.Enabled = True
    End If

End Sub

Sub dsSocket1_Accept (CommID As Integer)

    On Error Resume Next

    '   setup dsSocket2 as the communication control
    dsSocket2.Socket = CommID

    '   close the listen so no ther connections arrive
    dsSocket1.Action = SOCK_ACTION_CLOSE

    If (frmMain.WindowState = 1) Then frmMain.WindowState = 0

    '   if there were any errors sending the message
    '   then report them
    If (Err > 0) Then
        MsgBox "Error sending message to server." & Chr(13) & Format(Err) & " : " & Error
        txStatus.Text = Error & "..."
        btnChatSomeone.Enabled = True
        btnWaitForChat.Enabled = True
    
    '   else show the status
    Else
        txStatus.Text = "Connected to remote chat at " & dsSocket1.RemoteDotAddr
        txMessage.Text = ""
        btnChatSomeone.Enabled = False
        btnWaitForChat.Enabled = False
        btnStopWaiting.Enabled = False
        btnStopChat.Enabled = True
        txMessage.Enabled = True
        txReply.Enabled = True
        laMessage.Enabled = True
        laReply.Enabled = True
    End If


End Sub

Sub dsSocket1_Exception (ErrorCode As Integer, ErrorDesc As String)

    txStatus.Text = ErrorDesc

    laMessage.Enabled = False
    txMessage.Enabled = False

    laReply.Enabled = False
    txReply.Enabled = False

End Sub

Sub dsSocket2_Close (ErrorCode As Integer, ErrorDesc As String)
    
    btnStopWaiting.Enabled = False
    btnWaitForChat.Enabled = True
    btnChatSomeone.Enabled = True
    btnStopChat.Enabled = False

    txStatus.Text = ErrorDesc

    laMessage.Enabled = False
    txMessage.Enabled = False

    laReply.Enabled = False
    txReply.Enabled = False

End Sub

Sub dsSocket2_Connect ()

    txMessage.Text = ""

End Sub

Sub dsSocket2_Exception (ErrorCode As Integer, ErrorDesc As String)

    If (ErrorCode = 21054 Or ErrorCode = SOCK_ERR_CLOSED) Then
        btnStopWaiting.Enabled = False
        btnWaitForChat.Enabled = True
        btnChatSomeone.Enabled = True
        btnStopChat.Enabled = False
        End If

    txStatus.Text = ErrorDesc

    laMessage.Enabled = False
    txMessage.Enabled = False

    laReply.Enabled = False
    txReply.Enabled = False

End Sub

Sub dsSocket2_Receive (ReceiveData As String)

    '
    '   Process data echoed back from server
    '
    
    On Error Resume Next

    '   Display the data in the textbox
    txReply.Text = txReply.Text & ReceiveData

End Sub

Sub Form_Paint ()

    '
    '   This is simply some pretty header code
    '

    '   Setup to do a shadowed text title and copyright notice.
    FontSize = 30
    FontItalic = True
    Forecolor = &H808080
    CurrentX = 140
    CurrentY = -50
    Print "Chat"

    Forecolor = &HFF0000
    CurrentX = 170
    CurrentY = -20
    Print "Chat"

    FontSize = 12
    CurrentX = 1800
    CurrentY = 300
    Print Chr(169) & "Dolphin Systems Inc."

End Sub

Sub Form_Unload (Cancel As Integer)

    '   ensure that the sockets are closed, ignore any errors
    On Error Resume Next
    dsSocket1.Action = SOCK_ACTION_CLOSE
    dsSocket2.Action = SOCK_ACTION_CLOSE

End Sub

Sub SendMessage (szMsg As String)
    
    On Error Resume Next

    '   send the message string to the remote system
    dsSocket2.Send = szMsg
    
    '   if there were any errors sending the message
    '   then report them
    If (Err > 0) Then
        MsgBox "Error sending data to server." & Chr(13) & Format(Err) & " : " & Error
        txStatus.Text = Error & "..."
    
    '   else show the status
    Else
        txStatus.Text = Format(Len(szMsg)) + " bytes sent to server..."
    
    End If

End Sub

Sub txMessage_KeyDown (KeyCode As Integer, Shift As Integer)

    If (KeyCode = 13) Then
        SendMessage (txMessage.Text) + Chr(13) + Chr(10)
        txMessage.Text = ""
        KeyCode = 0
        End If

End Sub

