'Declarations
Option Explicit

Global TwipsPerPixel As Single

Global picCount%
Global FirstTime%

Global Const SWP_NOSIZE = 1
Global Const SWP_NOMOVE = 2
Global Const SPI_SETSCREENSAVEACTIVE = 17

Global Const SRCCOPY = &HCC0020
Global Const SRCERASE = &H440328
Global Const SRCINVERT = &H660046
Global Const SRCAND = &H8800C6
Global Const SRCPAINT = &HEE0086
Global Const NOTSRCCOPY = &H330008
Global Const NOTSRCERASE = &H1100A6
Global Const MERGECOPY = &HC000CA
Global Const MERGEPAINT = &HBB0226
Global Const PATCOPY = &HF00021
Global Const PATPAINT = &HFB0A09
Global Const PATINVERT = &H5A0049
Global Const DSTINVERT = &H550009
Global Const BLACKNESS = &H42&
Global Const WHITENESS = &HFF0062

Type lrect
    Left As Integer
    Top As Integer
    right As Integer
    bottom As Integer
End Type

Declare Sub SetWindowPos Lib "User" (ByVal hWnd As Integer, ByVal hWndInsertAfter As Integer, ByVal x As Integer, ByVal y As Integer, ByVal cx As Integer, ByVal cy As Integer, ByVal wFlags As Integer)
Declare Function SystemParametersInfo Lib "User" (ByVal uAction As Integer, ByVal uparam As Integer, lpvParam As Any, ByVal fuWinIni As Integer) As Integer
Declare Function GetDesktopWindow Lib "user" () As Integer
Declare Function GetDC Lib "user" (ByVal hWnd%) As Integer
Declare Function BitBlt Lib "GDI" (ByVal hDestDC%, ByVal x%, ByVal y%, ByVal nWidth%, ByVal nHeight%, ByVal hSrcDC%, ByVal xSrc%, ByVal ySrc%, ByVal dwRop&) As Integer
Declare Function ReleaseDC Lib "User" (ByVal hWnd As Integer, ByVal hDC As Integer) As Integer
Declare Sub GetWindowRect Lib "User" (ByVal hWnd%, lpRect As lrect)
Declare Function ShowCursor Lib "User" (ByVal bShow As Integer) As Integer

Sub CaptureDesktop ()
    
    Dim winSize As lrect
    Dim hSourceDC%, hSourceWnd%, hDestDC%, dwRop&
    Dim nWidth%, nHeight%, dummy%
    
    'Get a handle to the Desktop's DC (device context)
    hSourceWnd% = GetDesktopWindow()
    hSourceDC% = GetDC(hSourceWnd%)
    
    'Get the size in pixels of the actual screen
    Call GetWindowRect(hSourceWnd%, winSize)
    nWidth% = winSize.right             ' Units in pixels.
    nHeight% = winSize.bottom           ' Units in pixels.
    
    'Get handle to the destination picture box
    hDestDC% = frmMain.picSaver.hDC
    
    'Make sure picture box is the same size as the desktop (screen)
    frmMain.picSaver.Top = 0
    frmMain.picSaver.Left = 0
    frmMain.picSaver.Width = (nWidth% + 1) * Screen.TwipsPerPixelX
    frmMain.picSaver.Height = (nHeight% + 1) * Screen.TwipsPerPixelY
    
    'Copy (capture) entire desktop to the picture box
    dwRop& = SRCCOPY
    dummy% = BitBlt(hDestDC%, 0, 0, nWidth%, nHeight%, ByVal hSourceDC%, 0, 0, dwRop&)
    
    'Make sure we release the desktop's DC to windows
    dummy% = ReleaseDC(hSourceWnd%, hSourceDC%)

    'Make sure we can draw onto the picture box
    frmMain.picSaver.AutoRedraw = False
    
End Sub

Sub ExitNice ()
    
    'Make sure we restore things back to the
    'way they were before we started

    Dim dummy%

    'Restore the cursor
    dummy% = ShowCursor(True)
    
    'Tell windows our screensaver is ending
    dummy% = SystemParametersInfo(SPI_SETSCREENSAVEACTIVE, 1, ByVal 0&, 0)
    End

End Sub

Sub Main ()

    Dim dummy%
    Dim msg$
    
    'Windows passes a command line argument to know
    'we should show the configuration form for our
    'screensaver
    
    'You may force it by using Project options in VB

    Select Case Command$
        Case "/c", "/C"
            'Configuration form would be loaded here
            msg$ = "SPINNING TOP SCREEN SAVER"
            msg$ = msg$ + Chr$(10) + Chr$(10)
            msg$ = msg$ + "Software design by FXLP" + Chr$(10) + Chr$(10)
            msg$ = msg$ + "Source code available upon request." + Chr$(10) + Chr$(10)
            msg$ = msg$ + "Inquiries for custom software:" + Chr$(10) + "74052.2417@COMPUSERVE.COM"
            msg$ = msg$ + Chr$(10) + Chr$(10)
            msg$ = msg$ + "No warranties of any kind provided with this demo."
            MsgBox msg$, 64, "Spinning Top"
        Case Else
            'Tell windows our screen saver is starting
            dummy% = SystemParametersInfo(SPI_SETSCREENSAVEACTIVE, 0, ByVal 0&, 0)
            Load frmMain
            'Capture the screen so we may draw onto a copy of the desktop
            'and not the desktop itself
            CaptureDesktop
            'Show main screen
            frmMain.Show
            'Avoid main form from being moved or resized
            SetWindowPos frmMain.hWnd, -1, 0, 0, 0, 0, SWP_NOMOVE Or SWP_NOSIZE
            'Make sure everything's in place, so we let windows refresh
            dummy% = DoEvents()
    End Select

End Sub

