Option Explicit

Global Const aD$ = "Copyright 1995 anno Domini, inc."

'DDD Professional ToolKit is Copyright 1995 by anno Domini, inc.
'You may use this software source code in your applications
'providing you have purchased/registered this software and that
'you do not distribute the any part of the source code in uncompiled
'form.  Violation of this copyright is a Federal Offense and will
'be prosecuted to the fullest.

Sub BtnGotFocus (C As Control)  'C=Control
    'Draws a dark gray line around the control as if the control has focus
    Dim SM As Integer
    Dim f As Form
    Set f = C.Parent
    SM = f.ScaleMode
    f.ScaleMode = 3
    f.Line (C.Left - 2, C.Top - 2)-(C.Left + C.Width + 2, C.Top + C.Height + 2), Charcoal, B
    f.ScaleMode = SM
End Sub

Sub BtnLostFocus (C As Control) 'C=Control
    'Removes the dark gray line around the control that the BtnGotFocus routine created
    Dim SM As Integer
    Dim f As Form
    Set f = C.Parent
    SM = f.ScaleMode
    f.ScaleMode = 3
    f.Line (C.Left - 2, C.Top - 2)-(C.Left + C.Width + 2, C.Top + C.Height + 2), Gray, B
    f.ScaleMode = SM
End Sub

Sub Centerform (f As Form)  'F=Form
    'Simply centers a form on the screen
    f.Left = (Screen.Width - f.Width) / 2
    f.Top = (Screen.Height - f.Height) / 2
End Sub

Sub Frame (f As Form, t As String, fc As Single, fx As Integer, tx As Single, ty As Single, bx As Single, by As Single)
    'f=form, t=text, fc=forecolor, fx=3D effect, tx=left x-coor., ty=top y-coor., bx=right x-coor., by=bottom y-coor.
    'Draws a 3D frame
    Dim a As Integer
    Dim th, tw
    Dim OldFC As Single
    Dim SM As Integer
    SM = f.ScaleMode
    f.ScaleMode = 3
    OldFC = f.ForeColor
    f.Line (tx, ty)-(bx, by), Charcoal, B
    f.Line (tx + 1, ty + 1)-(bx + 1, by + 1), White, B
    th = f.TextHeight(t$)
    tw = f.TextWidth(t$)
    f.Line (tx + 7, ty - 4)-((tx + 7) + tw + 2, (ty - 4) + th - 3), Gray, BF
    f.ForeColor = fc
    f.FontSize = 8.25: f.FontBold = True: f.FontItalic = False
    Select Case fx
    Case 0  'Flat Text
        f.CurrentX = tx + 8: f.CurrentY = ty - 5
        f.Print t$
    Case 1  'Indented Text
        Call IndentFont(f, t$, fc, tx + 8, ty - 5)
    Case 2
        Call RaiseFont(f, t$, fc, tx + 8, ty - 5)
    End Select
    f.ScaleMode = SM
End Sub

Sub Indent (C As Control)   'C=Control
    'Indents a control
    Dim SM As Integer
    Dim f As Form
    Set f = C.Parent
    SM = f.ScaleMode
    f.ScaleMode = 3
    f.Line (C.Left - 1, C.Top - 1)-(C.Left - 1, C.Top + C.Height + 1), Charcoal
    f.Line (C.Left + C.Width + 1, C.Top - 1)-(C.Left - 1, C.Top - 1), Charcoal
    f.Line (C.Left + C.Width + 1, C.Top - 1)-(C.Left + C.Width + 1, C.Top + C.Height + 1), White
    f.Line (C.Left - 1, C.Top + C.Height + 1)-(C.Left + C.Width + 1, C.Top + C.Height + 1), White
    f.ScaleMode = SM
End Sub

Sub IndentControl (C As Control, P As Control)  'C=Control, P=Parent
    'Indents a control that is within a P or parent control
    P.Line (C.Left - 1, C.Top - 1)-(C.Left - 1, C.Top + C.Height + 1), Charcoal
    P.Line (C.Left + C.Width + 1, C.Top - 1)-(C.Left - 1, C.Top - 1), Charcoal
    P.Line (C.Left + C.Width + 1, C.Top - 1)-(C.Left + C.Width + 1, C.Top + C.Height + 1), White
    P.Line (C.Left - 1, C.Top + C.Height + 1)-(C.Left + C.Width + 1, C.Top + C.Height + 1), White
End Sub

Sub IndentFont (f As Form, t As String, fc As Single, X As Integer, Y As Integer)
    'F=Form, T=Text, fc=Forecolor, X=CurrentX, Y=CurrentY
    'Draw the offset White text first
    f.ForeColor = White
    f.CurrentX = X + 1
    f.CurrentY = Y + 1
    f.Print t
    'Draw the text offset over top of the white text
    f.ForeColor = fc
    f.CurrentX = X
    f.CurrentY = Y
    f.Print t
End Sub

Sub Indentform (f As Form)  'F=Form
    'Draw a frame around the form to give it an indented look
    Dim SM As Integer   'Scale Mode
    Dim SH As Single    'Scale Height
    Dim SW As Single    'Scale Width
    Dim X As Integer    'X Coordinates
    Dim Y As Integer    'Y Coordinates
    SM = f.ScaleMode
    f.ScaleMode = 3
    SW = f.ScaleWidth
    SH = f.ScaleHeight
    If f.BorderStyle Then
       f.Line (X, Y)-(SW - 1, SH - 1), White, B
    Else
       f.Line (0, 0)-(SW - 1, SH - 1), 0&, B
       X = 1: Y = 1
       f.Line (X, Y)-(SW - 2, SH - 2), White, B
    End If
    f.Line (X, Y)-(SW - 1, Y), Charcoal
    f.Line (X, Y)-(X, SH - 1), Charcoal
    f.ScaleMode = SM

End Sub

Sub IndentLabel (C As Control, Parent As Integer)    'C=Control, Parent=Parent
    'Indents a label control
    Dim X As Integer
    Dim f As Form
    Dim PB As Control
    Dim Is_A_Form As Integer
    If C.Parent.hWnd = Parent Then Is_A_Form = True
    C.BorderStyle = 0
    Set f = C.Parent
    If Is_A_Form Then
       f.Line (C.Left - 1, C.Top - 1)-(C.Left - 1, C.Top - 1 + C.Height), Charcoal
       f.Line (C.Left + C.Width + 1, C.Top - 1)-(C.Left - 1, C.Top - 1), Charcoal
       f.Line (C.Left + C.Width + 1, C.Top - 1)-(C.Left + C.Width + 1, C.Top - 1 + C.Height), White
       f.Line (C.Left - 1, C.Top - 1 + C.Height)-(C.Left + C.Width + 1, C.Top - 1 + C.Height), White
    Else
       On Local Error Resume Next
       For X = 0 To f.Controls.Count - 1
         If f.Controls(X).hWnd = Parent Then
           Set PB = f.Controls(X)
           Exit For
         End If
       Next
       PB.Line (C.Left - 1, C.Top)-(C.Left - 1, C.Top + C.Height + 1), Charcoal
       PB.Line (C.Left + C.Width + 1, C.Top)-(C.Left - 1, C.Top), Charcoal
       PB.Line (C.Left + C.Width + 1, C.Top)-(C.Left + C.Width + 1, C.Top + C.Height + 1), White
       PB.Line (C.Left - 1, C.Top + C.Height + 1)-(C.Left + C.Width + 1, C.Top + C.Height + 1), White
    End If
End Sub

Sub Raise (C As Control)    'C=Control
    Dim SM As Integer   'Scale Mode
    Dim f As Form       'F=Form
    Set f = C.Parent    'Establish Control's Parent
    SM = f.ScaleMode
    f.ScaleMode = 3
    f.Line (C.Left - 1, C.Top - 1)-(C.Left - 1, C.Top + C.Height + 1), White
    f.Line (C.Left + C.Width + 1, C.Top - 1)-(C.Left - 1, C.Top - 1), White
    f.Line (C.Left + C.Width + 1, C.Top - 1)-(C.Left + C.Width + 1, C.Top + C.Height + 1), 0 'Charcoal
    f.Line (C.Left - 1, C.Top + C.Height + 1)-(C.Left + C.Width + 1, C.Top + C.Height + 1), 0 'Charcoal
    f.ScaleMode = SM
End Sub

Sub RaiseBar (P As PictureBox)  'P=PictureBox
    'Creates a Raised look for Toolbars & Statusbars
    If P.Align = 1 Then P.Line (0, 0)-(P.ScaleWidth - 1, P.ScaleHeight - 1), 0&, B
    P.Line (1, P.ScaleHeight - 2)-(P.ScaleWidth - 1, P.ScaleHeight - 2), Charcoal, B
    P.Line (1, 0)-(P.ScaleWidth - 1, 0), White
    P.Line (1, 1)-(1, P.ScaleHeight - 1), White
End Sub

Sub RaiseFont (f As Form, t As String, fc As Single, X As Integer, Y As Integer)
    'F=Form, T=Text, fc=Forecolor, X=CurrentX, Y=CurrentY
    'Draw the offset White text first
    f.ForeColor = White
    f.CurrentX = X - 1
    f.CurrentY = Y - 1
    f.Print t
    'Draw the text offset over top of the white text
    f.ForeColor = fc
    f.CurrentX = X
    f.CurrentY = Y
    f.Print t
End Sub

Sub Raiseform (f As Form)   'F=Form
    'Draw a frame around the form to give it an raised look
    Dim SM As Integer   'Scale Mode
    Dim SH As Single    'Scale Height
    Dim SW As Single    'Scale Width
    Dim X As Integer    'X Coordinates
    Dim Y As Integer    'Y Coordinates
    SM = f.ScaleMode
    f.ScaleMode = 3
    SW = f.ScaleWidth
    SH = f.ScaleHeight
    If f.BorderStyle Then
       f.Line (X, Y)-(SW - 1, SH - 1), Charcoal, B
    Else
       f.Line (0, 0)-(SW - 1, SH - 1), 0&, B
       X = 1: Y = 1
       f.Line (X, Y)-(SW - 2, SH - 2), Charcoal, B
    End If
    f.Line (X, Y)-(SW - 1, Y), White
    f.Line (X, Y)-(X, SH - 1), White
    f.ScaleMode = SM
End Sub

