Option Explicit

' globals for vb4-3 converter

Global iDoWhat%, Aborted%
Global sFileIn$, sFileOut$
Global sPathIn$

Global ssFind$(), ssReplace$(), ssKillLine$(), ssKill$()

Global ssProperty$

Dim sFiles$(), sFileOnly$()
Dim sProject$
Dim sProjectPath$, sTranslatePath$
Dim iForm%

Sub ConvertProject (f As Form)   ' processes project-files
    On Error Resume Next
    
    On Error Resume Next
    Dim s$, sWhat$, sRest$, sDrv$, sPath$, sFile$
    Dim iMax%, i%, j%, k%, sOutProj$
    
    sProject = sFileIn
    Aborted = False
    
    Call MakeFilePath(sFileIn, sDrv, sPath, sFile)
    ReDim sFiles(0), sFileOnly(0)
    
    sProjectPath = sDrv & sPath
    
    sTranslatePath = sProjectPath & "VB3" & "\"      ' new project path
    MkDir Left(sTranslatePath, Len(sTranslatePath) - 1) ' MKDir
    Err = 0
    
    Close #2 ' just in case it was open ... else error, but who cares
    Err = 0

    sOutProj = sTranslatePath & sFile
    sOutProj = Left(sOutProj, Len(sOutProj) - 3) & "MAK"
    Open sOutProj For Output As #2
    
    Open sProject For Input As #1
    Do While Not EOF(1)
        Line Input #1, s
        i = InStr(s, "=")
        If i <> 0 Then
            sWhat = Left(s, i - 1)
            sRest = Mid(s, i + 1)
            Select Case sWhat
                Case "Form"
                    iMax = UBound(sFiles)
                    ReDim Preserve sFiles(iMax + 1)
                    ReDim Preserve sFileOnly(iMax + 1)
                    sFiles(iMax + 1) = MakePath(sRest, sProjectPath)
                    sFileOnly(iMax + 1) = GetFilename(sRest)
                    Print #2, sFileOnly(iMax + 1)
                    
                Case "Module"
                    i = InStr(sRest, ";")
                    
                    sFile = Mid(sRest, i + 1)
                    
                    iMax = UBound(sFiles)
                    ReDim Preserve sFiles(iMax + 1)
                    ReDim Preserve sFileOnly(iMax + 1)
                    
                    sFiles(iMax + 1) = MakePath(sFile, sProjectPath)
                    sFileOnly(iMax + 1) = GetFilename(sFile)
                    
                    Print #2, Trim(GetFilename(sFile))
                    
                Case "VBX"
                    i = InStr(sRest, ";")
                    sFile = Mid(sRest, i + 1)
                    Print #2, Trim(GetFilename(sFile))
                    
                Case "Reference"
                Case "VersionCompatible"
                Case "MajorVer"
                Case "MinorVer"
                Case "RevisionVer"
                Case "AutoIncrementVer"
                Case "ServerSupportFiles"
                Case "VersionCompanyName"
                Case "VersionFileDescription"
                Case "VersionLegalCopyright"
                Case "VersionProductName"
                Case "ExeName"
                Case "StartMode"
                Case "ProductName"
                Case "Name"
                Case "HelpFile"
                Case "HelpContextID"
                Case "Description"
                    ' don't copy these
                
                Case "Object" ' convert OCXes
                    i = InStr(sRest, ";")
                    sFile = Trim(GetFilename(Mid(sRest, i + 1)))
                    Select Case sFile
                        Case "COMDLG16.OCX": sFile = "CMDIALOG.VBX"
                        Case "MSMASK16.OCX": sFile = "MSMASKED.VBX"
                        Case "MSCOMM16.OCX": sFile = "MSCOMM.VBX"
                        Case "THREED16.OCX": sFile = "THREED.VBX"
                        Case "TABCTL16.OCX": sFile = "" ' TAB's must be redone
                        Case "GAUGE16.OCX": sFile = "GAUGE.VBX"
                        Case "KEYSTA16.OCX": sFile = "KEYSTAT.VBX"
                        Case "PICCLP16.OCX": sFile = "PICCLIP.VBX"
                        Case "SPIN16.OCX": sFile = "SPIN.VBX"
                        Case "MCI16.OCX": sFile = "MCI.VBX"
                        Case "GRAPH16.OCX": sFile = "GRAPH.VBX"
                        Case Else: sFile = ""
                    End Select
                    
                    If sFile <> "" Then Print #2, "C:\WINDOWS\SYSTEM\" & sFile
                    
                Case Else
                    Print #2, s
            End Select
        Else
            Print #2, s
        End If
    Loop
    Close #1
    Close #2
    
    For i = 1 To UBound(sFiles)
        f!lblProz = Str(Fix((i / UBound(sFiles)) * 100)) & " %"
        f!lblAnz = Str(i) & " / " & UBound(sFiles)
        Call Research(sFiles(i), f)
        DoEvents
        If Aborted Then Exit For
    Next i

    DoEvents
    
    Unload f
End Sub

Function ProcessLine$ (s$)
    On Error Resume Next
    Dim s1$, s2$
    Dim i%
    
    s1 = s
    s2 = ssCheckProperty(s1)
    s1 = s2
    s2 = ssCheckReplace(s1)
    s1 = s2
    s2 = ssCheckKillLine(s1)
    s1 = s2
    s2 = ssCheckRest(s1)
    s1 = s2
    
    If iForm = 1 Then
        i = InStr(s1, "VB.")
        If i > 0 Then
            s2 = Left(s1, i - 1) & Mid(s1, i + 3)
            s1 = s2
        End If

        i = InStr(s1, "VBX.")
        If i > 0 Then
            s2 = Left(s1, i - 1) & Mid(s1, i + 4)
            s1 = s2
        End If
    End If

    ProcessLine = s1
End Function

Sub Research (sFile$, f As Form)
    On Error Resume Next
    Dim s$, strIn$, strOut$, sD$, sp$, sF$, iCnt&
    
    Call ssEinrichten
    
    f!lblDatei = sFile
    f!lblLine = ""
    
    Call MakeFilePath(sFile, sD, sp, sF)
    
    sPathIn = sD & sp
    sFileOut = sTranslatePath & sF
    
    Open sFile For Input As #1
    Open sFileOut For Output As #2
    
    iCnt = 0
    If UCase(Right(sF, 3)) = "FRM" Then iForm = 1

    Do While (Not EOF(1)) And (Not Aborted)
        Line Input #1, strIn

        If strIn = "End" Then iForm = 0 ' end of Form-Structure

        Do While Right(Trim(strIn), 1) = "_"
            Line Input #1, s
            strIn = Left(RTrim(strIn), Len(RTrim(strIn)) - 1) & " " & LTrim(s)
        Loop
        strOut = ProcessLine(strIn)
        Print #2, strOut
        
        iCnt = iCnt + 1
        If Rnd > .9 Then f!lblLine = iCnt: DoEvents
    Loop
    
    Close #1
    Close #2
    
    ' copy FRX-File
    
    s = Left(sFile, Len(sFile) - 1) & "x"
    FileCopy s, Left(sFileOut, Len(sFileOut) - 1) & "x"
    Err = 0
    
End Sub

Sub ssAddKillLine (s1$)
    On Error Resume Next
    Dim i%
    i = UBound(ssKillLine) + 1
    ReDim Preserve ssKillLine(i)
    
    ssKillLine(i) = s1
End Sub

Sub ssAddReplace (s1$, s2$)
    On Error Resume Next
    Dim i%
    i = UBound(ssFind) + 1
    ReDim Preserve ssFind(i), ssReplace(i)
    
    ssFind(i) = s1: ssReplace(i) = s2
End Sub

Function ssCheckKillLine$ (s$)
    On Error Resume Next
    Dim s1$, i%
    
    s1 = s$
    For i = 1 To UBound(ssKillLine)
        If Left(Trim(s), Len(ssKillLine(i))) = ssKillLine(i) Then s1 = "": Exit For
    Next i
    ssCheckKillLine = s1
End Function

Function ssCheckProperty$ (strIn$)
    On Error Resume Next
    Dim i%, strOut$, ss$
    
    strOut = strIn
    If ssProperty = "" Then ' Property-Structures changed
        ss = "BeginProperty"
        If Left(Trim(strIn), Len(ss)) = ss Then
            i = InStr(strIn, ss)
            ssProperty = Trim(Mid(strIn, i + Len(ss)))
            i = InStr(ssProperty, "{")
            If i > 0 Then
                ssProperty = Trim(Left(ssProperty, i - 1))
            End If
            strOut = ""
        End If
    Else
        If Trim(strIn) = "EndProperty" Then
            ssProperty = ""
            strOut = ""
        Else
            i = InStr(strOut, "}")
            If i > 0 Then
                strOut = Mid(strOut, i + 1)
            End If
            strOut = Space(Len(strOut) - Len(Trim(strOut))) & ssProperty & Trim(strOut)
        End If
    End If
    ssCheckProperty = strOut
End Function

Function ssCheckReplace$ (strIn$)
    On Error Resume Next
    Dim s1$, s2$, i%, i1%, i2%
    
    s1 = strIn
   
    For i = 1 To UBound(ssFind)
        i1 = InStr(s1, ssFind(i))
        If i1 > 0 Then
            s2 = Left(s1, i1 - 1) & ssReplace(i) & Mid(s1, i1 + Len(ssFind(i)))
            s1 = s2
        End If
    Next i
    ssCheckReplace = s1
End Function

Function ssCheckRest$ (strIn$)
    On Error Resume Next
    Dim i%, i1%, ss$, strOut$
    Dim sFile$, iPos&, iLen%, s1$, s2$
    
    strOut = strIn
    
    ' Fontweight changed into Fontbold

    If UCase(Left(Trim(strIn), 10)) = UCase("Fontweight") Then
        i = Val(Mid(strIn, InStr(strIn, "=") + 1))
        If i > 400 Then
            strOut = Space(Len(strIn) - Len(Trim(strIn))) & "Fontbold = -1 ' True"
        Else
            strOut = Space(Len(strIn) - Len(Trim(strIn))) & "Fontbold = 0 ' False"
        End If
    End If
    
    ss = ".FRX"":"
    i = InStr(UCase(strOut), ss)
    If i > 0 Then
        i = InStr(strOut, "$""")
        If i > 0 Then   ' convert FRX-Entry to String
            i1 = InStr(i + 2, strOut, """")
            sFile = Mid(strOut, i + 2, (i1 - i) - 2)
            iPos = CLng("&H" & Trim(Mid(strOut, InStr(strOut, ":") + 1))) + 1
            
            Open sPathIn & sFile For Binary Access Read As #4
            s1 = Space(1): s2 = Space(1)
            Get #4, iPos, s1
            Get #4, iPos + 1, s2
            iLen = Asc(s2) * 256 + Asc(s1)
            ss = Space(iLen)
            Get #4, iPos + 4, ss
            Close #4
            ss = ssCleanString(ss)
            strOut = Left(strOut, i - 1) & """" & ss & """"
            
        Else
            i = InStr(strOut, """")
            If i > 0 Then strOut = Left(strOut, i - 1) & Mid(strOut, i + 1)
            i = InStr(strOut, """")
            If i > 0 Then strOut = Left(strOut, i - 1) & Mid(strOut, i + 1)
        End If
    End If
    
    ssCheckRest = strOut
End Function

Function ssCleanString$ (s$)
    On Error Resume Next
    Dim i%, ss$, s1$
    ss = ""
    For i = 1 To Len(s)
        s1 = Mid(s, i, 1)
        If Asc(s1) >= 32 Then ss = ss & s1
    Next i
    ssCleanString = ss
End Function

Sub ssEinrichten ()
    On Error Resume Next
    
    ReDim ssFind(0), ssReplace(0), ssKillLine(0), ssKill(0)
    
    Call ssAddReplace("MSMask.MaskEdBox", "MaskEdBox")
    
    Call ssAddReplace("VB.CheckBox", "SSCheck") ' VB4-Controls in 3D
    Call ssAddReplace("VB.CommandButton", "CommandButton")
    Call ssAddReplace("VB.CommonDialog", "CommonDialog")
    Call ssAddReplace("VB.Data", "Data")
    Call ssAddReplace("VB.Form", "Form")
    Call ssAddReplace("VB.Frame", "SSFrame")
    Call ssAddReplace("VB.Image", "Image")
    Call ssAddReplace("VB.Label", "Label")
    Call ssAddReplace("VB.Line", "Line")
    Call ssAddReplace("VB.ListBox", "ListBox")
    Call ssAddReplace("VB.MDIForm", "MDIForm")
    Call ssAddReplace("VB.Menu", "Menu")
    Call ssAddReplace("VB.OptionButton", "SSOption")
    Call ssAddReplace("VB.PictureBox", "PictureBox")
    Call ssAddReplace("VB.TextBox", "TextBox")
    Call ssAddReplace("VB.Timer", "Timer")
    Call ssAddReplace("MSCommLib.MSComm", "MSComm")
    
    Call ssAddReplace("VBX.CSCLOCK", "CSCLOCK") ' add all used VBX's here
    Call ssAddReplace("VBX.CSCalendar", "CSCalendar")
    Call ssAddReplace("VBX.CSComboBox", "CSComboBox")
    Call ssAddReplace("VBX.CSMeter", "CSMeter")
    Call ssAddReplace("VBX.CSOptList", "CSOptList")
    Call ssAddReplace("VBX.sivbLB", "sivbLB")
    Call ssAddReplace("VBX.sicrEdit", "sicrEdit")
    Call ssAddReplace("VBX.sidtEdit", "sidtEdit")
    Call ssAddReplace("VBX.silgEdit", "silgEdit")
    Call ssAddReplace("VBX.sidbEdit", "sidbEdit")
    Call ssAddReplace("VBX.sitxEdit", "sitxEdit")
    Call ssAddReplace("VBX.TrueGrid", "TrueGrid")
    Call ssAddReplace("VBX.HEVBLayer", "HEVBLayer")
    Call ssAddReplace("VBX.Mh3dGauge", "Mh3dGauge")
    
    Call ssAddReplace("Threed.SSCheck", "SSCheck")
    Call ssAddReplace("Threed.SSCommand", "SSCommand")
    Call ssAddReplace("Threed.SSFrame", "SSFrame")
    Call ssAddReplace("Threed.SSOption", "SSOption")
    Call ssAddReplace("Threed.SSPanel", "SSPanel")
    
    Call ssAddReplace("VERSION 4.00", "VERSION 2.00")
    
    Call ssAddReplace("DBEngine.Idle dbFreeLocks", "FreeLocks") ' VB4 Code
    Call ssAddReplace(" As Boolean", " As Integer")          ' Data types
    Call ssAddReplace(" As Date", " As Long")
    Call ssAddReplace("App.Path()", "App.Path")

    Call ssAddReplace("vbKeyEscape", "KEY_ESCAPE") ' VB4 Constants
    Call ssAddReplace("vbKeyTab", "KEY_TAB")
    Call ssAddReplace("vbKeyShift", "KEY_SHIFT")
    Call ssAddReplace("vbKeyControl", "KEY_CONTROL")
    Call ssAddReplace("vbKeyReturn", "KEY_RETURN")
    Call ssAddReplace("vbKeyHome", "KEY_HOME")
    Call ssAddReplace("vbKeyEnd", "KEY_END")
    Call ssAddReplace("vbKeyDown", "KEY_DOWN")
    Call ssAddReplace("vbKeyUp", "KEY_UP")
    Call ssAddReplace("vbKeySpace", "KEY_SPACE")
    Call ssAddReplace("vbKeyInsert", "KEY_INSERT")
    Call ssAddReplace("vbKeyDelete", "KEY_DELETE")

    Call ssAddReplace("vbHourglass", "HOURGLASS")
    Call ssAddReplace("vbDefault", "DEFAULT")
    Call ssAddReplace("vbYesNo", "MB_YESNO")
    Call ssAddReplace("vbYesNoCancel", "MB_YESNOCANCEL")
    Call ssAddReplace("vbOKOnly", "MB_OK")
    Call ssAddReplace("vbOKCancel", "MB_OKCANCEL")
    Call ssAddReplace("vbRetryCancel", "MB_RETRYCANCEL")
    Call ssAddReplace("vbAbortRetryIgnore", "MB_ABORTRETRYIGNORE")
    Call ssAddReplace("vbCritical", "MB_ICONSTOP")
    Call ssAddReplace("vbQuestion", "MB_ICONQUESTION")
    Call ssAddReplace("vbExclamation", "MB_ICONEXCLAMATION")
    Call ssAddReplace("vbInformation", "MB_ICONINFORMATION")
    Call ssAddReplace("vbCritical", "MB_ICONSTOP")
    Call ssAddReplace("vbDefaultButton1", "MB_DEFBUTTON1")
    Call ssAddReplace("vbDefaultButton2", "MB_DEFBUTTON2")
    Call ssAddReplace("vbDefaultButton3", "MB_DEFBUTTON3")
    Call ssAddReplace("vbApplicationModal", "MB_APPLMODAL")
    Call ssAddReplace("vbSystemModal", "MB_SYSTEMMODAL")
    Call ssAddReplace("vbOK", "IDOK")
    Call ssAddReplace("vbYes", "IDYES")
    Call ssAddReplace("vbNo", "IDNO")
    Call ssAddReplace("vbCancel", "IDCANCEL")
    Call ssAddReplace("vbRetry", "IDRETRY")
    Call ssAddReplace("vbIgnore", "IDIGNORE")
    Call ssAddReplace("vbBlack", "BLACK")
    Call ssAddReplace("vbRed", "RED")
    Call ssAddReplace("vbGreen", "GREEN")
    Call ssAddReplace("vbYellow", "YELLOW")
    Call ssAddReplace("vbBlue", "BLUE")
    Call ssAddReplace("vbMagenta", "MAGENTA")
    Call ssAddReplace("vbCyan", "CYAN")
    Call ssAddReplace("vbWhite", "WHITE")
    Call ssAddReplace("dbLong", "DB_LONG")
    Call ssAddReplace("dbText", "DB_TEXT")
    Call ssAddReplace("dbDouble", "DB_DOUBLE")
    Call ssAddReplace("dbInteger", "DB_INTEGER")
    Call ssAddReplace("dbSingle", "DB_SINGLE")
    Call ssAddReplace("dbDate", "DB_DATE")
    Call ssAddReplace("dbMemo", "DB_MEMO")
    Call ssAddReplace("dbLangGeneral", "DB_LANG_GENERAL")
    Call ssAddReplace("dbLangSpanish", "DB_LANG_SPANISH")
    Call ssAddReplace("dbLangDutch", "DB_LANG_DUTCH")
    Call ssAddReplace("dbEncrypt", "DB_ENCRYPT")
    Call ssAddReplace("dbVersion10", "DB_VERSION10")
    Call ssAddReplace("dbVersion11", "DB_VERSION10")
    Call ssAddReplace("dbVersion20", "DB_VERSION10")
    Call ssAddReplace("dbVersion25", "DB_VERSION10")

    Call ssAddKillLine("Attribute VB_")
    Call ssAddKillLine("Appearance")
    Call ssAddKillLine("Fontcharset")
    Call ssAddKillLine("fontcharset")
    Call ssAddKillLine("Fontstrikethrough")
    Call ssAddKillLine("fontstrikethrough")
    Call ssAddKillLine("Icon")
    Call ssAddKillLine("ShowInTaskbar")
    Call ssAddKillLine("_stockprops")
    Call ssAddKillLine("_version")
    Call ssAddKillLine("_extentx")
    Call ssAddKillLine("_extenty")
    Call ssAddKillLine("RecordsetType")
    
    Call ssAddReplace("Private ", "") ' just remove text and leave rest
    Call ssAddReplace("Public ", "Dim ")
    
    ssProperty = ""
    
End Sub

