Option Explicit

' utils

Sub CenterForm (f As Form)
    f.Top = (Screen.Height - f.Height) / 2
    f.Left = (Screen.Width - f.Width) / 2
End Sub

Function GetFilename$ (sPath$)
    On Error Resume Next
    Dim ss$, i%, sF$
    i = InStr(sPath, "\")
    If i = 0 Then
        sF = sPath
    Else
        ss = strReverse(sPath)
        i = InStr(ss, "\")
        sF = Mid(sPath, 2 + Len(sPath) - i)
    End If
    GetFilename = sF
End Function

Sub MakeFilePath (s$, sDrive$, sPath$, sFile$)
    On Error Resume Next
    Dim i%, j%, s1$

    sDrive$ = "": sPath$ = "": sFile$ = ""
    s1 = s

    If Mid(s1, 2, 1) = ":" Then ' Drive
        sDrive$ = Mid(s1, 1, 2)
        s1 = Mid(s1, 3)
    End If

    i = 0: j = 1
    Do While j > 0
        j = InStr(i, s1, "\")
        If j > 0 Then i = j + 1
    Loop

    sPath$ = Mid(s1, 1, i - 1)
    If sPath$ = "\" Then sPath$ = ""

    sFile$ = Trim(Mid(s1, i))

    Err = 0
End Sub

Function MakePath$ (sPath$, sCurPath$)
    On Error Resume Next
    Dim s$, sp$, ss$, i%, iMore%
    s = Trim(sCurPath)
    If Mid(s, Len(s), 1) = "\" Then s = Left(s, Len(s) - 1)
    sp = Trim(sPath)
    If Mid(sp, 2, 1) = ":" Then
        MakePath = sp
    Else
        Do While Left(sp, 2) = ".."
            sp = Mid(sp, 4)
            ss = strReverse(s)
            i = InStr(ss, "\")
            s = Left(s, Len(s) - i)
        Loop
        MakePath = s & "\" & sp
    End If
End Function

Function strReverse (s$)   ' LISP
    On Error Resume Next
    Dim sTmp$, i%
    sTmp = ""
    For i = Len(s) To 1 Step -1
        sTmp = sTmp & Mid(s, i, 1)
    Next i
    strReverse = sTmp
End Function

