   Option Explicit
   DefInt A-Z
               
'--FUNCTION TO SEE IF VBTRACE IS RUNNING
   Declare Function CMS_FindWindow Lib "User" Alias "FindWindow" (ByVal ThunderForm As Any, ByVal lpCaption As Any)

'--INI FILES
   Declare Function CMS_GetPrivateProfileString Lib "Kernel" Alias "GetPrivateProfileString" (ByVal Appname As String, ByVal KeyName As String, ByVal DEFAULT As String, ByVal ReturnedString As String, ByVal MaxSize, ByVal Filename As String)

'--GET FREE GDI AND USR MEMORY
   Declare Function CMS_GetFreeSystemResources Lib "User" Alias "GetFreeSystemResources" (ByVal fuSysResource)
   Global Const GDI = 1
   Global Const USR = 2

'--GET SYSTEM MEMORY
   Declare Function CMS_GetFreeSpace Lib "Kernel" Alias "GetFreeSpace" (ByVal wFlags) As Long

'--FREE DISK SPACE
   Declare Function CMS_DiskSpaceFree Lib "SetupKit.DLL" Alias "DiskSpaceFree" () As Long
   

Sub VBTrace (OpCode, ProcedureName As String)

'--DECLARE VARIABLES
   Dim I, J
   Dim Result
   Dim ThisTime As Double
   Dim OutRecord As String
   Dim TraceGridVariable As String
   Dim ElapsedTime As String
   Dim CumlativeTime As String
   Dim TotalTime As String
   Dim Percent As String
   Dim Msg As String
   Dim SyncCode As String
   Dim ppFileName As String
   Dim ppValue As String

'--DECLARE CONSTANTS
   Const IconStop = 16
   Const ThisProgramsSyncCode = ""
   Const TraceFileRecordLength = 600
   Const ppTitle = "VBTrace Grid Column Configuration"
   Const ppItem = "SyncCode"
   Const ppDefault = ""
   Const Padder = "."

'--DECLARE STATIC VARIABLES
   Static TraceOperationOffSwitch
   Static PreviousLine()
   Static PreviousTime() As Double
   Static CumTime() As Double
   Static PercentTime()
   Static TotalRunTime As Double
   Static EntryCount()
   Static ExitCount()
   Static LineNumber
   Static ProcedureNames() As String
   Static PreviousProcedure As String
   Static PreviousOpCode
   Static MarginWidth
   Static VBTraceFileNo
   
'--IF TRACE HAS BEEN TURNED OFF THEN EXIT
   If TraceOperationOffSwitch Then
      Exit Sub
   ElseIf CMS_FindWindow(0&, "VBTrace 2.0  -  Visual Basic Debug Utility") Then
   ElseIf CMS_FindWindow(0&, "VBTrace") Then
   Else
      Exit Sub
   End If

'--GET ARBAY SIZE AND BUMP IF NECESSARY
   ReDim EntryExit(1) As String
   EntryExit(0) = "(Entry)"
   EntryExit(1) = "(Exit)"
   On Error Resume Next
   For I = 0 To UBound(ProcedureNames)
      If ProcedureName = ProcedureNames(I) Then
         Exit For
      End If
   Next I
   If I > UBound(ProcedureNames) Then
      ReDim Preserve ProcedureNames(I + 100)
      ReDim Preserve CumTime(I + 100)
      ReDim Preserve PercentTime(I + 100)
      ReDim Preserve EntryCount(I + 100)
      ReDim Preserve ExitCount(I + 100)
      ReDim Preserve PreviousLine(-1 To I + 100)
      ReDim Preserve PreviousTime(-1 To I + 100)
      ProcedureNames(I) = ProcedureName
   End If
   
'--SET INDENT
   Select Case OpCode
      Case 1         'ENTERED PROCEDURE
         EntryCount(I) = EntryCount(I) + 1
         If PreviousOpCode = 1 Then
            MarginWidth = MarginWidth + 2
         End If
      Case 2         'EXITED PROCEDURE
         ExitCount(I) = ExitCount(I) + 1
         If ProcedureName <> PreviousProcedure Then
            MarginWidth = MarginWidth - 2
         End If
   End Select
         
'--GET SYNCCODE IF FIRST LINE
   ppValue = Space$(199)
   Result = CMS_GetPrivateProfileString(ppTitle, ppItem, ppDefault, ppValue, Len(ppValue) + 1, app.Path & "\VBTRACE.INI")
   SyncCode = Trim$(ppValue)
   If SyncCode <> ThisProgramsSyncCode & Chr$(0) Then
      Msg = "The VBTrace Column Configuration Has Changed Since This Program "
      Msg = Msg & "Was Loaded.  You Must Exit And Reload This Program."
      MsgBox Msg, IconStop, "VBTrace Error Message"
      Close
      End
   End If
   If LineNumber = 0 Or Len(Dir$(app.Path & "\VBTRACE.TXT")) = False Then
      If Len(Dir$(app.Path & "\VBTRACE.TXT")) Then
         Kill app.Path & "\VBTRACE.TXT"
      End If
      OutRecord = "/*" & Now & ","
      ReDim ProcedureNames(0)
      I = False
      LineNumber = False
   End If
   LineNumber = LineNumber + 1
   
'--GET ELASPSED TIME
   ThisTime = Timer
   If PreviousTime(I) Then
      If OpCode = 2 Then
         ElapsedTime = Str$(ThisTime - PreviousTime(I))
         CumTime(I) = CumTime(I) + Val(ElapsedTime)
         CumlativeTime = Format$(CumTime(I), "##0.0")
         TotalRunTime = TotalRunTime + Val(ElapsedTime)
         TotalTime = Format$(TotalRunTime, "##0.0")
         PercentTime(I) = CumTime(I) / TotalRunTime * 100
         Percent = Format$(PercentTime(I))
      End If
   End If
   
'--ASSEMBLE COLUMN DATA
   TraceGridVariable = "LineNumber"
   OutRecord = OutRecord & "LineNumber," & LineNumber & ","
   TraceGridVariable = "PreviousLine(I)"
   OutRecord = OutRecord & "PreviousLine(I)," & PreviousLine(I) & ","
   TraceGridVariable = "ElapsedTime"
   OutRecord = OutRecord & "ElapsedTime," & ElapsedTime & ","
   TraceGridVariable = "CumlativeTime"
   OutRecord = OutRecord & "CumlativeTime," & CumlativeTime & ","
   TraceGridVariable = "Percent"
   OutRecord = OutRecord & "Percent," & Percent & ","
   TraceGridVariable = "TotalTime"
   OutRecord = OutRecord & "TotalTime," & TotalTime & ","
   TraceGridVariable = "EntryCount(I)"
   OutRecord = OutRecord & "EntryCount(I)," & EntryCount(I) & ","
   TraceGridVariable = "ExitCount(I)"
   OutRecord = OutRecord & "ExitCount(I)," & ExitCount(I) & ","
   TraceGridVariable = "ProcedureName"
   OutRecord = OutRecord & "ProcedureName," & ProcedureName & ","
   OutRecord = OutRecord & "\,\,"
   
'--APPEND MEMORY VALUES TO RECORD
   TraceGridVariable = "Available GDI Memory"
   OutRecord = OutRecord & Format$(CMS_GetFreeSystemResources(GDI)) & ","
   TraceGridVariable = "Available USER Memory"
   OutRecord = OutRecord & Format$(CMS_GetFreeSystemResources(USR)) & ","
   TraceGridVariable = "Available Global Heap Memory"
   OutRecord = OutRecord & Format$(CMS_GetFreeSpace(0)) & ","
      
'--APPEND DISK SPACE TO RECORD
   TraceGridVariable = "Available Disk Space"
   OutRecord = OutRecord & Left$(app.Path, 1) & Format$(CMS_DiskSpaceFree()) & ","
   
'--APPEND FORMS COUNT TO RECORD
   TraceGridVariable = "Forms Count"
   OutRecord = OutRecord & Forms.Count & ","
   
'--APPEND PROCEDURE NAME TO RECORD
   TraceGridVariable = ProcedureName
   OutRecord = OutRecord & String$(MarginWidth, Padder) & ProcedureName & EntryExit(OpCode - 1)
   TraceGridVariable = ""
   
'--APPEND PASSED VARIABLES TO RECORD

'--OPEN TRACE FILE, WRITE RECORD, AND CLOSE FILE
   VBTraceFileNo = FreeFile
   Open app.Path & "\VBTRACE.TXT" For Random Shared As VBTraceFileNo Len = TraceFileRecordLength
      OutRecord = Left$(OutRecord & Space$(TraceFileRecordLength - 2), TraceFileRecordLength - 2)
      Put #VBTraceFileNo, LineNumber, OutRecord
      PreviousLine(I) = LineNumber
      PreviousTime(I) = ThisTime
      PreviousOpCode = OpCode
      PreviousProcedure = ProcedureName
  Close VBTraceFileNo
Exit Sub
   
VBTraceError:
   If Len(TraceGridVariable) Then
      Msg = Error$ & " Referencing TraceGrid Variable '" & TraceGridVariable & "'.  "
      Msg = Msg & "Disabling VBTrace."
   End If
   If Len(Msg) = 0 Then
      Msg = Error$
   End If
   MsgBox Msg, IconStop, "VBTrace Error Handler"
   Msg = ""
   TraceOperationOffSwitch = True
   Close VBTraceFileNo
   If Len(Dir$(app.Path & "\VBTRACE.TXT")) Then
      Close VBTraceFileNo
      Kill app.Path & "\VBTRACE.TXT"
   End If
End Sub

