Option Explicit

Declare Function cGetWindowsDirectory Lib "vbprftrc.dll" () As String
Declare Function cKillFileAll Lib "vbprftrc.dll" (ByVal lpFilename As String) As Integer
Declare Function cTimerClose Lib "vbprftrc.dll" (ByVal TimerHandle As Integer) As Integer
Declare Function cTimerOpen Lib "vbprftrc.dll" () As Integer
Declare Function cTimerRead Lib "vbprftrc.dll" (ByVal TimerHandle As Integer) As Long
Declare Function cTimerStart Lib "vbprftrc.dll" (ByVal TimerHandle As Integer) As Integer

'Don't change any variables and their value below

Type tagTRACERtype
   StartStop                        As String * 1
   RoutineHandle                    As Integer
End Type

Type tagPROFILERtype
   ModuleName                       As String * 12
   RoutineHandle                    As String * 4
   RoutineName                      As String * 82
   TimeCounter                      As Integer
   TotalCall                        As Long
   TotalTime                        As Long
   MinimumTime                      As Long
   MaximumTime                      As Long
   Dummy                            As String * 10
   CrLf                             As String * 2
End Type

Dim tagTRACER                       As tagTRACERtype
Dim tagPROFILER                     As tagPROFILERtype

Dim TotalRoutines                   As Integer
Dim ActualTrace                     As Long
Dim OldStartRoutine                 As Integer
Dim OldStopRoutine                  As Integer

Dim FileTR                          As String
Dim FilePF                          As String

Dim chanFileTR                      As Integer
Dim chanFilePF                      As Integer

Sub mcStartTracer (RoutineNumber As Integer)

   Dim TimerCounter  As Integer
   Dim Status        As Integer
   
   ' check if the routine number is not outside the limits
   If ((RoutineNumber < 1) Or (RoutineNumber > TotalRoutines)) Then Exit Sub
      
   ' check if this is the same routine
   If (OldStartRoutine <> RoutineNumber) Then
      ' increment the trace number
      ActualTrace = ActualTrace + 1
      ' prepare the trace information
      tagTRACER.StartStop = ">"
      tagTRACER.RoutineHandle = RoutineNumber
      ' save the trace information
      Put #chanFileTR, ActualTrace, tagTRACER
   End If

   ' save the old routine
   OldStartRoutine = RoutineNumber

   ' read the record associated with the routine number
   Get #chanFilePF, RoutineNumber, tagPROFILER

   ' open a timer
   TimerCounter = cTimerOpen()
   ' save the handle of the new timer
   tagPROFILER.TimeCounter = TimerCounter
   ' increment the number of calls
   tagPROFILER.TotalCall = tagPROFILER.TotalCall + 1

   ' save the record associated with the routine number
   Put #chanFilePF, RoutineNumber, tagPROFILER

   ' start the timer
   Status = cTimerStart(TimerCounter)
   
End Sub

Sub mcStopTracer (RoutineNumber As Integer)

   Dim TimerCounter  As Integer
   Dim TimeElapsed   As Long
   Dim Status        As Integer
   
   ' check if the routine number is not outside the limits
   If ((RoutineNumber < 1) Or (RoutineNumber > TotalRoutines)) Then Exit Sub

   ' check if this is the same routine
   If (OldStopRoutine <> RoutineNumber) Then
      ' increment the trace number
      ActualTrace = ActualTrace + 1
      ' prepare the trace information
      tagTRACER.StartStop = "<"
      tagTRACER.RoutineHandle = RoutineNumber
      ' save the trace information
      Put #chanFileTR, ActualTrace, tagTRACER
   End If

   ' save the old routine
   OldStopRoutine = RoutineNumber

   ' read the record associated with the routine number
   Get #chanFilePF, RoutineNumber, tagPROFILER

   ' check if the timer is valid
   If (tagPROFILER.TimeCounter > 0) Then
      ' computes the elapsed time
      TimeElapsed = cTimerRead(tagPROFILER.TimeCounter)
      ' add the elapsed time
      tagPROFILER.TotalTime = tagPROFILER.TotalTime + TimeElapsed
      ' check for the minimum time
      If (TimeElapsed < tagPROFILER.MinimumTime) Then tagPROFILER.MinimumTime = TimeElapsed
      ' check for the minimum time
      If (TimeElapsed > tagPROFILER.MaximumTime) Then tagPROFILER.MaximumTime = TimeElapsed
   End If

   ' save the record associated with the routine number
   Put #chanFilePF, RoutineNumber, tagPROFILER

   ' close the associated timer
   Status = cTimerClose(tagPROFILER.TimeCounter)

End Sub

