VERSION 4.00
Begin VB.Form ASPI 
   Caption         =   "Form1"
   ClientHeight    =   2205
   ClientLeft      =   1545
   ClientTop       =   1740
   ClientWidth     =   6645
   Height          =   2640
   Left            =   1485
   LinkTopic       =   "Form1"
   ScaleHeight     =   2205
   ScaleWidth      =   6645
   Top             =   1365
   Width           =   6765
   Begin VB.CommandButton Command8 
      Caption         =   "HA ID"
      Height          =   375
      Left            =   2820
      TabIndex        =   9
      Top             =   480
      Width           =   1215
   End
   Begin VB.CommandButton Command7 
      Caption         =   "Read CDROM"
      Height          =   375
      Left            =   2820
      TabIndex        =   7
      Top             =   900
      Width           =   1215
   End
   Begin VB.CommandButton Command6 
      Caption         =   "Read until FM"
      Height          =   375
      Left            =   4080
      TabIndex        =   6
      Top             =   900
      Width           =   1215
   End
   Begin VB.CommandButton Command5 
      Caption         =   "Write && FM"
      Height          =   375
      Left            =   4080
      TabIndex        =   4
      Top             =   480
      Width           =   1215
   End
   Begin VB.CommandButton Command4 
      Caption         =   "Rewind"
      Height          =   375
      Left            =   4080
      TabIndex        =   3
      Top             =   60
      Width           =   1215
   End
   Begin VB.CommandButton Command3 
      Caption         =   "Test Unit Rdy"
      Height          =   375
      Left            =   5340
      TabIndex        =   2
      Top             =   900
      Width           =   1215
   End
   Begin VB.CommandButton Command2 
      Caption         =   "ID6 Inquiry"
      Height          =   375
      Left            =   5340
      TabIndex        =   1
      Top             =   480
      Width           =   1215
   End
   Begin VB.CommandButton Command1 
      Caption         =   "Poll Bus"
      Height          =   375
      Left            =   5340
      TabIndex        =   0
      Top             =   60
      Width           =   1215
   End
   Begin ComctlLib.ProgressBar ProgressBar2 
      Height          =   255
      Left            =   1140
      TabIndex        =   8
      Top             =   1620
      Width           =   5175
      _Version        =   65536
      _ExtentX        =   9128
      _ExtentY        =   450
      _StockProps     =   192
      Appearance      =   1
      Max             =   999
   End
   Begin ComctlLib.ProgressBar ProgressBar1 
      Height          =   255
      Left            =   1140
      TabIndex        =   5
      Top             =   1920
      Width           =   5175
      _Version        =   65536
      _ExtentX        =   9128
      _ExtentY        =   450
      _StockProps     =   192
      Appearance      =   1
   End
   Begin ASPILib.ASPI ASPI1 
      Left            =   60
      Top             =   60
      _Version        =   65536
      _ExtentX        =   850
      _ExtentY        =   850
      _StockProps     =   0
   End
End
Attribute VB_Name = "ASPI"
Attribute VB_Creatable = False
Attribute VB_Exposed = False
Option Explicit

Private Sub Command1_Click()

Dim inq As String
Dim i As Integer, x As Integer

    Cls
    ASPI1.HostAdapter = 0
    For i = 0 To 6
        ASPI1.SCSIID = i
        On Error Resume Next
        inq = ASPI1.Inquiry
        If Err = 0 Then
            Print i; Mid$(inq, 9, 32 - 8)
        Else
            Print i; "No device"
        End If
    Next
    
End Sub



Private Sub Command2_Click()

Dim InquiryBuffer As String
Dim SenseBuffer As String

    ASPI1.SCSIID = 6
    ASPI1.HostAdapter = 0
    ASPI1.CDB = Chr$(&H12) & Chr$(0) & Chr$(0) & Chr$(0) & Chr$(32) & Chr$(0)
    ASPI1.CDBSize = 6
    On Error Resume Next
    InquiryBuffer = ASPI1.ExecuteIn(32)
    If Err <> 0 Then
        
        Select Case Err
                
            Case 1001 ' sense error
            SenseBuffer = ASPI1.SenseBuffer
            Dim i As Integer
            For i = 1 To Len(SenseBuffer)
                Debug.Print i; Hex$(Asc(Mid$(SenseBuffer, i, 1)))
            Next
    
            Case Else
                MsgBox Err.Description
                
        End Select
    
    Else
            MsgBox Mid$(InquiryBuffer, 9, 32 - 8), , "Result of inquiry command"
    End If

End Sub


Private Sub Command3_Click()

Dim SenseBuffer As String
Dim SenseKey As Integer

    ASPI1.SCSIID = 6
    ASPI1.HostAdapter = 0
    ASPI1.CDB = Chr$(0) & Chr$(0) & Chr$(0) & Chr$(0) & Chr$(0) & Chr$(0)
    ASPI1.CDBSize = 6
    On Error Resume Next
    ASPI1.Execute
    If Err <> 0 Then
        
        Select Case Err
                
            Case 1001 ' sense error
            SenseBuffer = ASPI1.SenseBuffer
            SenseKey = Asc(Mid$(SenseBuffer, 3, 1)) And &H1F
            If SenseKey = 2 Then
                MsgBox "Drive not ready"
            Else
                MsgBox "Received Sense Key " & Format$(SenseKey)
            End If
    
            Case Else
                MsgBox Err.Description
                
        End Select
    
    Else
        MsgBox "Drive is ready"
    End If

End Sub


Private Sub Command4_Click()

MsgBox "Rewind"

Dim SenseBuffer As String
Dim SenseKey As Integer

    ASPI1.SCSIID = 6
    ASPI1.HostAdapter = 0
    ASPI1.CDB = Chr$(1) & Chr$(0) & Chr$(0) & Chr$(0) & Chr$(0) & Chr$(0)
    ASPI1.CDBSize = 6
    On Error Resume Next
    ASPI1.Execute
    If Err <> 0 Then
        
        Select Case Err
                
            Case 1001 ' sense error
            SenseBuffer = ASPI1.SenseBuffer
            SenseKey = Asc(Mid$(SenseBuffer, 3, 1)) And &H1F
            If SenseKey = 2 Then
                MsgBox "Drive not ready"
            Else
                MsgBox "Received Sense Key " & Format$(SenseKey)
            End If
    
            Case Else
                MsgBox Err.Description
                
        End Select
    
    Else
        MsgBox "Rewind Completed"
    End If

    
End Sub


Private Sub Command5_Click()

Dim BlockCount As Integer
Dim SenseBuffer As String
Dim SenseKey As Integer
Dim BlockBuffer As String * 10240
Dim i As Integer

'Make up a test pattern
    For i = 1 To 10240
        Mid$(BlockBuffer, i, 1) = Chr$(i Mod 255)
    Next
    
'Write 100 blocks of 10000 bytes
    For BlockCount = 1 To 100
    
        ASPI1.SCSIID = 6
        ASPI1.HostAdapter = 0
        ASPI1.CDB = Chr$(&HA) & Chr$(1) & Chr$(0) & Chr$(0) & Chr$(20) & Chr$(0)
        ASPI1.CDBSize = 6
        On Error Resume Next
        ASPI1.ExecuteOut BlockBuffer, 10240
        If Err <> 0 Then
            
            Select Case Err
                    
                Case 1001 ' sense error
                SenseBuffer = ASPI1.SenseBuffer
                SenseKey = Asc(Mid$(SenseBuffer, 3, 1)) And &H1F
                If SenseKey = 2 Then
                    MsgBox "Drive not ready", , "Writing data"
                Else
                    MsgBox "Received Sense Key " & Format$(SenseKey), , "Writing Data"
                End If
        
                Case Else
                    MsgBox Err.Description, , "Writing Data"
                    
            End Select
        
        End If

'Update progress bar
        ProgressBar1.Value = BlockCount
    
    Next
    ProgressBar1.Value = 0
    
'Write a filemark to signal we're done
    ASPI1.SCSIID = 6
    ASPI1.HostAdapter = 0
    ASPI1.CDB = Chr$(&H10) & Chr$(0) & Chr$(0) & Chr$(0) & Chr$(1) & Chr$(0)
    ASPI1.CDBSize = 6
    On Error Resume Next
    ASPI1.Execute
    If Err <> 0 Then
        
        Select Case Err
                
            Case 1001 ' sense error
            SenseBuffer = ASPI1.SenseBuffer
            SenseKey = Asc(Mid$(SenseBuffer, 3, 1)) And &H1F
            If SenseKey = 2 Then
                MsgBox "Drive not ready", , "Writing FM"
            Else
                MsgBox "Received Sense Key " & Format$(SenseKey), , "Writing FM"
            End If
    
            Case Else
                MsgBox Err.Description, , "Writing FM"
                
        End Select
    
    End If

    MsgBox "Write completed"

End Sub



Private Sub Command6_Click()

Dim BlockCount As Integer
Dim SenseBuffer As String
Dim SenseKey As Integer
Dim BlockBuffer As String
Dim i As Integer

'Read until we hit a filemark
    BlockCount = 0
    Do
        ASPI1.SCSIID = 6
        ASPI1.HostAdapter = 0
        ASPI1.CDB = Chr$(&H8) & Chr$(1) & Chr$(0) & Chr$(0) & Chr$(20) & Chr$(0)
        ASPI1.CDBSize = 6
        On Error Resume Next
        BlockBuffer = ASPI1.ExecuteIn(10240)
        If Err <> 0 Then
            
            Select Case Err
                    
                Case 1001 ' sense error
                    SenseBuffer = ASPI1.SenseBuffer
                    SenseKey = Asc(Mid$(SenseBuffer, 3, 1)) And &H1F
                    Select Case SenseKey
                        Case 2
                            MsgBox "Drive not ready", , "Reading Data"
                        Case 0 ' check for filemark
                            i = Asc(Mid$(SenseBuffer, 3, 1)) And &H80
                            If i = &H80 Then
                                Exit Do
                            Else
                                MsgBox "Unknown error condition"
                                Exit Do
                            End If
                        Case Else
                            MsgBox "Received Sense Key " & Format$(SenseKey), , "Reading Data"
                            Exit Do
                    End Select
                
                Case Else
                    MsgBox Err.Description, , "Reading Data"
                    
            End Select
        
        Else
        
'Read the block OK, so verify it
            For i = 1 To 10240 Step 10 ' save a bit of time!
                If Mid$(BlockBuffer, i, 1) <> Chr$(i Mod 255) Then
                    MsgBox "Block " & Format$(BlockCount) & "did not verify"
                End If
            Next
        
        End If
        
'Update progress bar
        BlockCount = BlockCount + 1
        ProgressBar1.Value = BlockCount

    Loop
    
    ProgressBar1.Value = 0
    MsgBox "Read completed"

End Sub


Private Sub Command7_Click()

Dim BlockCount As Integer
Dim SenseBuffer As String
Dim SenseKey As Integer
Dim BlockBuffer As String
Dim i As Integer

'Read 1000 sectors from the CD-ROM
    For BlockCount = 0 To 999
        ASPI1.SCSIID = 3
        ASPI1.HostAdapter = 0
        ASPI1.CDB = Chr$(&H8) & Chr$(0) & Chr$(0) & Chr$((BlockCount / 256) Mod 256) & Chr$(BlockCount Mod 256) & Chr$(0)
        ASPI1.CDBSize = 6
        On Error Resume Next
        BlockBuffer = ASPI1.ExecuteIn(2048)
        If Err <> 0 Then
            
            Select Case Err
                    
                Case 1001 ' sense error
                    SenseBuffer = ASPI1.SenseBuffer
                    SenseKey = Asc(Mid$(SenseBuffer, 3, 1)) And &H1F
                    Select Case SenseKey
                        Case 2
                            MsgBox "Drive not ready", , "Reading Data"
                        Case Else
                            MsgBox "Received Sense Key " & Format$(SenseKey), , "Reading Data"
                            Exit For
                    End Select
                
                Case Else
                    MsgBox Err.Description, , "Reading Data"
                    
            End Select
        
        End If
        
'Update progress bar
        ProgressBar2.Value = BlockCount

    Next
    
    ProgressBar2.Value = 0

End Sub


Private Sub Command8_Click()

    ASPI1.HostAdapter = 0
    MsgBox Format$(ASPI1.HostAdapterSCSIID), , "SCSI ID"
    MsgBox Format$(ASPI1.HostAdapterMaxSCSIID), , "Max SCSI ID"
    MsgBox ASPI1.HostAdapterName, , "Host adapter name"
    MsgBox ASPI1.ASPIManagerName, , "ASPI Manager"
    MsgBox Hex$(ASPI1.HostAdapterMaxBuffer), , "Max Buffer"
    
End Sub


