VERSION 4.00
Begin VB.Form SCSIEx 
   BorderStyle     =   4  'Fixed ToolWindow
   Caption         =   "SCSI Explorer"
   ClientHeight    =   5460
   ClientLeft      =   1185
   ClientTop       =   1680
   ClientWidth     =   7440
   Height          =   5895
   Icon            =   "SCSIEx.frx":0000
   Left            =   1125
   LinkTopic       =   "Form1"
   MaxButton       =   0   'False
   MinButton       =   0   'False
   ScaleHeight     =   5460
   ScaleWidth      =   7440
   ShowInTaskbar   =   0   'False
   Top             =   1305
   Width           =   7560
   Begin VB.Timer TreeTimer 
      Enabled         =   0   'False
      Left            =   2280
      Top             =   5040
   End
   Begin VB.CommandButton Cancel 
      Cancel          =   -1  'True
      Caption         =   "Cancel"
      Height          =   375
      Left            =   1200
      TabIndex        =   23
      Top             =   5040
      Width           =   1035
   End
   Begin VB.Frame Frame3 
      Caption         =   "Status"
      Height          =   1215
      Left            =   3900
      TabIndex        =   19
      Top             =   4140
      Width           =   3495
      Begin VB.Label Status 
         Alignment       =   2  'Center
         Caption         =   "Device Not Ready"
         Height          =   255
         Index           =   2
         Left            =   480
         TabIndex        =   22
         Top             =   840
         Width           =   2595
      End
      Begin VB.Label Status 
         Alignment       =   2  'Center
         Caption         =   "Device Ready"
         Height          =   255
         Index           =   1
         Left            =   480
         TabIndex        =   21
         Top             =   540
         Width           =   2595
      End
      Begin VB.Label Status 
         Alignment       =   2  'Center
         Caption         =   "Device Not Present"
         Height          =   255
         Index           =   0
         Left            =   480
         TabIndex        =   20
         Top             =   240
         Width           =   2595
      End
   End
   Begin VB.Frame Frame2 
      Caption         =   "Features"
      Height          =   2535
      Left            =   3900
      TabIndex        =   8
      Top             =   1560
      Width           =   3495
      Begin VB.TextBox SCSIVersion 
         Height          =   285
         Left            =   1260
         TabIndex        =   18
         Top             =   2100
         Width           =   1995
      End
      Begin VB.CheckBox Features 
         Caption         =   "Place holder for bit 2"
         Height          =   735
         Index           =   2
         Left            =   2400
         TabIndex        =   16
         Top             =   540
         Visible         =   0   'False
         Width           =   915
      End
      Begin VB.CheckBox Features 
         Caption         =   "Relative Addressing"
         Height          =   195
         Index           =   7
         Left            =   180
         TabIndex        =   15
         Top             =   1740
         Width           =   1815
      End
      Begin VB.CheckBox Features 
         Caption         =   "32-bit Transfers"
         Height          =   195
         Index           =   6
         Left            =   180
         TabIndex        =   14
         Top             =   1500
         Width           =   2175
      End
      Begin VB.CheckBox Features 
         Caption         =   "16-bit Transfers"
         Height          =   195
         Index           =   5
         Left            =   180
         TabIndex        =   13
         Top             =   1260
         Width           =   2235
      End
      Begin VB.CheckBox Features 
         Caption         =   "Synchronous Transfers"
         Height          =   195
         Index           =   4
         Left            =   180
         TabIndex        =   12
         Top             =   1020
         Width           =   2475
      End
      Begin VB.CheckBox Features 
         Caption         =   "Linked Commands"
         Height          =   195
         Index           =   3
         Left            =   180
         TabIndex        =   11
         Top             =   780
         Width           =   2415
      End
      Begin VB.CheckBox Features 
         Caption         =   "Command Queuing"
         Height          =   195
         Index           =   1
         Left            =   180
         TabIndex        =   10
         Top             =   540
         Width           =   2235
      End
      Begin VB.CheckBox Features 
         Caption         =   "Soft Reset"
         Height          =   195
         Index           =   0
         Left            =   180
         TabIndex        =   9
         Top             =   300
         Width           =   3015
      End
      Begin VB.Label Label4 
         AutoSize        =   -1  'True
         Caption         =   "SCSI Version:"
         Height          =   195
         Left            =   180
         TabIndex        =   17
         Top             =   2160
         Width           =   975
      End
   End
   Begin VB.Frame Frame1 
      Caption         =   "Product Information"
      Height          =   1395
      Left            =   3900
      TabIndex        =   1
      Top             =   60
      Width           =   3495
      Begin VB.TextBox Revision 
         Height          =   285
         Left            =   900
         TabIndex        =   6
         Top             =   960
         Width           =   2355
      End
      Begin VB.TextBox Product 
         Height          =   285
         Left            =   900
         TabIndex        =   4
         Top             =   600
         Width           =   2355
      End
      Begin VB.TextBox Vendor 
         Height          =   285
         Left            =   900
         TabIndex        =   3
         Top             =   240
         Width           =   2355
      End
      Begin VB.Label Label3 
         AutoSize        =   -1  'True
         Caption         =   "Revision:"
         Height          =   195
         Left            =   180
         TabIndex        =   7
         Top             =   1020
         Width           =   660
      End
      Begin VB.Label Label2 
         AutoSize        =   -1  'True
         Caption         =   "Product:"
         Height          =   195
         Left            =   180
         TabIndex        =   5
         Top             =   660
         Width           =   600
      End
      Begin VB.Label Label1 
         AutoSize        =   -1  'True
         Caption         =   "Vendor:"
         Height          =   195
         Left            =   180
         TabIndex        =   2
         Top             =   300
         Width           =   555
      End
   End
   Begin ComctlLib.ImageList ImageList 
      Left            =   480
      Top             =   4860
      _Version        =   65536
      _ExtentX        =   1005
      _ExtentY        =   1005
      _StockProps     =   1
      BackColor       =   -2147483643
      ImageWidth      =   18
      ImageHeight     =   18
      NumImages       =   5
      i1              =   "SCSIEx.frx":0442
      i2              =   "SCSIEx.frx":0939
      i3              =   "SCSIEx.frx":0E30
      i4              =   "SCSIEx.frx":1327
      i5              =   "SCSIEx.frx":181E
   End
   Begin ASPILib.ASPI ASPI 
      Left            =   0
      Top             =   4980
      _Version        =   65536
      _ExtentX        =   850
      _ExtentY        =   850
      _StockProps     =   0
   End
   Begin ComctlLib.TreeView TreeView 
      Height          =   5235
      Left            =   60
      TabIndex        =   0
      Top             =   120
      Width           =   3735
      _Version        =   65536
      _ExtentX        =   6588
      _ExtentY        =   9234
      _StockProps     =   196
      Appearance      =   1
      ImageList       =   ""
      LabelEdit       =   1
      PathSeparator   =   "\"
      Style           =   7
   End
End
Attribute VB_Name = "SCSIEx"
Attribute VB_Creatable = False
Attribute VB_Exposed = False
Option Explicit

Dim FirstActivate As Boolean
Dim LastTreeNode As Node

Private Sub Check3_Click()

End Sub


Private Sub Cancel_Click()

    Unload Me
    
End Sub

Private Sub Form_Activate()

Dim HA As Integer
Dim ID As Integer
Dim TreeNode As Node
Dim InquiryBuffer As String
Dim PictureNumber As Integer
Dim TopLevel As Integer
Dim Key As String

'First time we get activated, scan the SCSI bus(es)
'and find all the peripherals connected
    
    If FirstActivate = True Then
        FirstActivate = False
        Screen.MousePointer = vbHourglass
        DoEvents ' allow the screen to paint
        DoEvents
        
        Set TreeView.ImageList = ImageList
        TreeView.Style = tvwTreelinesPlusMinusPictureText ' Style 7
        TreeView.LineStyle = tvwRootLines  ' Linestyle 1
        
        For HA = 0 To ASPI.AdapterCount - 1
            ASPI.HostAdapter = HA
            Key = "X" & Format$(HA, "00") & Format$(ASPI.HostAdapterSCSIID, "00")
            Set TreeNode = TreeView.Nodes.Add(, , Key, _
                Format$(ASPI.HostAdapterSCSIID) & " " & "Host Adapter: " & _
                ASPI.HostAdapterName, 1)
            TopLevel = TreeNode.Index
            For ID = 0 To ASPI.HostAdapterMaxSCSIID - 1
                Key = "X" & Format$(HA, "00") & Format$(ID, "00")
                If ID <> ASPI.HostAdapterSCSIID Then
                    ASPI.SCSIID = ID
                    On Error Resume Next
                    InquiryBuffer = ASPI.Inquiry
                    If Err <> 0 Then
                        Set TreeNode = TreeView.Nodes.Add(TopLevel, tvwChild, Key _
                            , Format$(ID) & " No device")
                    Else
                        Select Case Asc(Left$(InquiryBuffer, 1))
                            Case 0 ' fixed disk
                                PictureNumber = 4
                            Case 1 ' tape
                                PictureNumber = 5
                            Case 5 ' CDROM
                                PictureNumber = 2
                            Case Else
                                PictureNumber = 1
                        End Select
                        Set TreeNode = TreeView.Nodes.Add(TopLevel, tvwChild, Key _
                            , Format$(ID) & " " & Mid$(InquiryBuffer, 9, 33 - 9), PictureNumber)
                    End If
                    On Error GoTo 0
                End If
            Next
        Next
        
        TreeNode.EnsureVisible
        TreeView.Indentation = 100
        For Each TreeNode In TreeView.Nodes
            If TreeNode.Expanded = False Then
                TreeNode.Expanded = True
            End If
        Next
        TreeView.Nodes(1).Selected = True
        TreeView.SetFocus
        Set LastTreeNode = TreeView.Nodes.Item(1)
        Screen.MousePointer = vbDefault
        
    End If
    
End Sub

Private Sub Form_Load()

Dim i As Integer

    FirstActivate = True
    Status(0).Top = Status(1).Top
    Status(2).Top = Status(1).Top
    For i = 0 To 2
        Status(i).Visible = False
    Next
    
    Cancel.Move -2000, -200
    
    Me.Move (Screen.Width / 2) - (Me.Width / 2), (Screen.Height / 2) - (Me.Height / 2)
    
End Sub


Private Sub treetimer_Timer()

'Timed out, so disable us and fire the tree view
'click event
    treetimer.Enabled = False
    Call TreeView_Click

End Sub

Private Sub TreeView_Click()

Dim HA As Integer
Dim ID As Integer
Dim InquiryBuffer As String
Dim i As Integer
Dim FeaturesByte As Integer
Dim Mask As Integer

'Disable the timer incase it's going to fire
    treetimer.Enabled = False

'Pre-clear everything
    For i = 0 To 2
        Status(i).Visible = False
    Next
    Vendor.Text = ""
    Product.Text = ""
    Revision.Text = ""
    For i = 0 To 7
        Features(i).Value = 0
    Next
    SCSIVersion.Text = ""

'Pick up the SCSI id and Host adapter from the
'key
    HA = Val(Mid$(LastTreeNode.Key, 2, 2))
    ID = Val(Right$(LastTreeNode.Key, 2))
    ASPI.HostAdapter = HA
    If HA = ASPI.HostAdapterSCSIID Then
        Exit Sub
    End If
    ASPI.SCSIID = ID
    
'Send an inquiry command
    On Error Resume Next
    InquiryBuffer = ASPI.Inquiry
    If Err <> 0 Then
        Status(0).Visible = True
        Exit Sub
    End If
    
'Update the screen
    SCSIVersion.Text = Asc(Mid$(InquiryBuffer, 3, 1)) And &H7
    Vendor.Text = Mid$(InquiryBuffer, 9, 16 - 8)
    Product.Text = Mid$(InquiryBuffer, 17, 32 - 17)
    Revision.Text = Mid$(InquiryBuffer, 33, 36 - 33)
    
    For i = 0 To 7
        FeaturesByte = Asc(Mid$(InquiryBuffer, 8, 1))
        Mask = 2 ^ i
        If (FeaturesByte And Mask) = Mask Then
            Features(i).Value = 1
        Else
            Features(i).Value = 0
        End If
    Next
    
'Now send a test unit ready to see if the device is ready
    ASPI.CDB = Chr$(0) & Chr$(0) & Chr$(0) _
             & Chr$(0) & Chr$(0) & Chr$(0) 'build test unit ready command
    ASPI.CDBSize = 6
    On Error Resume Next
    ASPI.Execute
    If Err = 0 Then
        Status(1).Visible = True
    Else
        Status(2).Visible = True
    End If
    
End Sub

Private Sub TreeView_NodeClick(ByVal Node As Node)

'It's a really bad idea to do anything that munches
'the message queue inside this event. Therefore
'we save the node here and start up a timer. If
'the timer fires before the click event it was
'a key press, which in turn calls the click
'event

    Set LastTreeNode = Node
    If treetimer.Enabled = True Then
        treetimer.Enabled = False
    End If
    treetimer.Interval = 250 'ms
    treetimer.Enabled = True
    
End Sub


