VERSION 4.00
Begin VB.Form tar 
   Caption         =   "TAR Utility"
   ClientHeight    =   4605
   ClientLeft      =   1950
   ClientTop       =   2130
   ClientWidth     =   6465
   Height          =   5040
   Left            =   1890
   LinkTopic       =   "Form1"
   ScaleHeight     =   4605
   ScaleWidth      =   6465
   Top             =   1755
   Width           =   6585
   Begin TabDlg.SSTab SSTab1 
      Height          =   4095
      Left            =   120
      TabIndex        =   0
      Top             =   60
      Width           =   6195
      _Version        =   65536
      _ExtentX        =   10927
      _ExtentY        =   7223
      _StockProps     =   15
      Caption         =   "&Directory"
      TabsPerRow      =   3
      Tab             =   2
      TabOrientation  =   0
      Tabs            =   3
      Style           =   1
      TabMaxWidth     =   0
      TabHeight       =   529
      TabCaption(0)   =   "&Backup"
      Tab(0).ControlCount=   0
      Tab(0).ControlEnabled=   0   'False
      TabCaption(1)   =   "&Restore"
      Tab(1).ControlCount=   0
      Tab(1).ControlEnabled=   0   'False
      TabCaption(2)   =   "&Directory"
      Tab(2).ControlCount=   3
      Tab(2).ControlEnabled=   -1  'True
      Tab(2).Control(0)=   "StartDir"
      Tab(2).Control(1)=   "List1"
      Tab(2).Control(2)=   "StopDir"
      Begin VB.CommandButton StopDir 
         Cancel          =   -1  'True
         Caption         =   "Sto&p"
         Enabled         =   0   'False
         Height          =   375
         Left            =   5100
         TabIndex        =   4
         Top             =   3540
         Width           =   975
      End
      Begin VB.ListBox List1 
         Height          =   2985
         Left            =   180
         MultiSelect     =   2  'Extended
         TabIndex        =   3
         Top             =   480
         Width           =   5895
      End
      Begin VB.CommandButton StartDir 
         Caption         =   "&Start"
         Height          =   375
         Left            =   4080
         TabIndex        =   1
         Top             =   3540
         Width           =   975
      End
   End
   Begin ComctlLib.StatusBar StatusBar 
      Align           =   2  'Align Bottom
      Height          =   285
      Left            =   0
      TabIndex        =   2
      Top             =   4320
      Width           =   6465
      _Version        =   65536
      _ExtentX        =   11404
      _ExtentY        =   503
      _StockProps     =   68
      AlignSet        =   -1  'True
      Style           =   1
      SimpleText      =   ""
      i1              =   "tar.frx":0000
   End
   Begin ASPILib.ASPI ASPI 
      Left            =   60
      Top             =   4020
      _Version        =   65536
      _ExtentX        =   850
      _ExtentY        =   850
      _StockProps     =   0
   End
End
Attribute VB_Name = "tar"
Attribute VB_Creatable = False
Attribute VB_Exposed = False
Option Explicit

Dim AbortDir As Boolean
Dim TapeBuffer As String

    

Function CheckUnitReady() As Boolean

    StatusBar.SimpleText = "Verifying ready..."
    DoEvents

    ASPI.CDB = Chr$(0) & Chr$(0) & Chr$(0) _
             & Chr$(0) & Chr$(0) & Chr$(0)
    ASPI.CDBSize = 6
    On Error Resume Next
    ASPI.Execute
    If Err <> 0 Then
        
        Select Case Err
                
            Case 1001 ' sense error
                CheckUnitReady = False
                Exit Function
            Case Else
                MsgBox Err.Description
                CheckUnitReady = False
                Exit Function
                
        End Select
    
    End If
    CheckUnitReady = True
    
End Function


Function FindTapeDrive() As Boolean

    StatusBar.SimpleText = "Locating tape drive(s)..."
    DoEvents
    
Dim ID As Integer
Dim HA As Integer
Dim IQB As String

    For HA = 0 To ASPI.AdapterCount - 1
        ASPI.HostAdapter = HA
        For ID = 0 To ASPI.HostAdapterMaxSCSIID - 1
            ASPI.SCSIID = ID
            If ID <> ASPI.HostAdapterSCSIID Then
                On Error Resume Next
                IQB = ASPI.Inquiry
                If Err = 0 Then
                    If Asc(Mid$(IQB, 1, 1)) = 1 Then
                        FindTapeDrive = True
                        Exit Function
                    End If
                End If
            End If
        Next
    Next
    FindTapeDrive = False

End Function


Function ReadTape() As String

'If the TapeBuffer is empty, get some more
    If Len(TapeBuffer) = 0 Then
        ASPI.CDB = Chr$(8) & Chr$(1) & Chr$(0) _
                 & Chr$(0) & Chr$(20) & Chr$(0)
        ASPI.CDBSize = 6
        On Error Resume Next
        TapeBuffer = ASPI.ExecuteIn(10240)
    End If
    
'Return this block and remove from the TapeBuffer
    ReadTape = Left$(TapeBuffer, 512)
    TapeBuffer = Mid$(TapeBuffer, 513, Len(TapeBuffer))

End Function

Sub Rewind()

Dim SenseBuffer As String
Dim SenseKey As Integer

    StatusBar.SimpleText = "Rewinding tape..."
    DoEvents
    TapeBuffer = ""
    
    ASPI.CDB = Chr$(1) & Chr$(0) & Chr$(0) & Chr$(0) & Chr$(0) & Chr$(0)
    ASPI.CDBSize = 6
    On Error Resume Next
    ASPI.Execute
    If Err <> 0 Then
        
        Select Case Err
                
            Case 1001 ' sense error
            SenseBuffer = ASPI.SenseBuffer
            SenseKey = Asc(Mid$(SenseBuffer, 3, 1)) And &H1F
            If SenseKey = 2 Then
                MsgBox "Drive not ready"
            Else
                MsgBox "Received Sense Key " & Format$(SenseKey)
            End If
    
            Case Else
                MsgBox Err.Description
                
        End Select
    
    End If

End Sub

Private Sub StartDir_Click()

Dim Buffer As String
Dim Temp As String
Dim FileName As String
Dim FileSize As Single
Dim NullPos As Integer

'Find the tape drive
    If FindTapeDrive() = False Then
        MsgBox "Unable to locate tape drive on SCSI bus", vbCritical
        Exit Sub
    End If

'Make sure a tape is loaded
    Do
        If CheckUnitReady() = False Then
            If MsgBox("No tape is loaded. Press OK to retry, Cancel to abort", vbExclamation + vbOKCancel) = vbCancel Then
                Exit Sub
            End If
        Else
            Exit Do
        End If
    Loop
            
'Start reading...
    StartDir.Enabled = False
    StopDir.Enabled = True
    AbortDir = False
    List1.Clear
    Rewind
    Do
        StatusBar.SimpleText = "Reading directory entry..."
        DoEvents
        Buffer = ReadTape()
        
'Exit if we get a filemark or unresolvable error
        If Len(Buffer) = 0 Then
            Exit Do
        End If
        FileName = Left$(Buffer, 100)
        
'Exit if we get a null in the filename
        If Left$(FileName, 1) = Chr$(0) Then
            Exit Do
        End If
        NullPos = InStr(FileName, Chr$(0))
        FileName = Left$(FileName, NullPos - 1)
        
        Temp = Mid$(Buffer, 125, 12)
        Do
            If Left$(Temp, 1) <> " " Then
                Exit Do
            End If
            Temp = Right$(Temp, Len(Temp) - 1)
        Loop
        FileSize = CSng("&O" & Temp)
          
        List1.AddItem Trim$(FileName) & " " & Format$(FileSize) _
                      & " bytes"
        List1.ListIndex = List1.ListCount - 1
                  
        Do Until FileSize <= 0
            If AbortDir = True Then
                Exit Do
            End If
            Buffer = ReadTape()
            FileSize = FileSize - 512
        Loop

        If AbortDir = True Then
            Exit Do
        End If
        
    Loop

'Send a final rewind command
    Rewind
    StatusBar.SimpleText = ""

    If AbortDir = False Then
        MsgBox "End of tape reached", vbInformation
    Else
        MsgBox "Tape directory aborted", vbInformation
    End If
    
    StartDir.Enabled = True
    StopDir.Enabled = False
    
    
End Sub


Private Sub StopDir_Click()

    AbortDir = True
    
End Sub


