VERSION 4.00
Begin VB.Form FTPExplorer 
   Caption         =   "Universal Internet Explorer"
   ClientHeight    =   5370
   ClientLeft      =   1350
   ClientTop       =   1845
   ClientWidth     =   9885
   Height          =   6060
   Icon            =   "Explorer.frx":0000
   Left            =   1290
   LinkTopic       =   "Form1"
   LockControls    =   -1  'True
   ScaleHeight     =   5370
   ScaleWidth      =   9885
   Top             =   1215
   Width           =   10005
   Begin VB.CommandButton SizeBar 
      Height          =   4425
      Left            =   4230
      MousePointer    =   9  'Size W E
      TabIndex        =   6
      TabStop         =   0   'False
      Top             =   660
      Width           =   76
   End
   Begin FTPCTLib.FTPCT FTP 
      Index           =   0
      Left            =   10050
      Top             =   450
      _ExtentX        =   847
      _ExtentY        =   847
      RemoteHost      =   "127.0.0.1"
      RemotePort      =   21
      ConnectTimeout  =   0
      RecvTimeout     =   0
      NotificationMode=   0
      UserId          =   ""
      Password        =   ""
      AppendToFile    =   0   'False
      ListItemNotify  =   -1  'True
      RemoteFile      =   ""
   End
   Begin VB.Label lFiles 
      BorderStyle     =   1  'Fixed Single
      Caption         =   "Contents"
      Height          =   255
      Left            =   4290
      TabIndex        =   0
      Top             =   390
      UseMnemonic     =   0   'False
      Width           =   5595
   End
   Begin VB.Label lFolders 
      BorderStyle     =   1  'Fixed Single
      Caption         =   "All Folders"
      Height          =   255
      Left            =   0
      TabIndex        =   5
      Top             =   390
      Width           =   4275
   End
   Begin ComctlLib.ImageList tvImagesLarge 
      Left            =   10680
      Top             =   3900
      _Version        =   65536
      _ExtentX        =   1005
      _ExtentY        =   1005
      _StockProps     =   1
      BackColor       =   -2147483643
      ImageWidth      =   32
      ImageHeight     =   32
      NumImages       =   15
      i1              =   "Explorer.frx":27A2
      i2              =   "Explorer.frx":2B61
      i3              =   "Explorer.frx":2F20
      i4              =   "Explorer.frx":32DF
      i5              =   "Explorer.frx":369E
      i6              =   "Explorer.frx":3A5D
      i7              =   "Explorer.frx":3E1C
      i8              =   "Explorer.frx":41DB
      i9              =   "Explorer.frx":4D4A
      i10             =   "Explorer.frx":75A1
      i11             =   "Explorer.frx":7961
      i12             =   "Explorer.frx":7D21
      i13             =   "Explorer.frx":80E1
      i14             =   "Explorer.frx":84A1
      i15             =   "Explorer.frx":8861
   End
   Begin ComctlLib.ImageList tvImagesSmall 
      Left            =   10680
      Top             =   3180
      _Version        =   65536
      _ExtentX        =   1005
      _ExtentY        =   1005
      _StockProps     =   1
      BackColor       =   -2147483643
      ImageWidth      =   16
      ImageHeight     =   16
      NumImages       =   15
      i1              =   "Explorer.frx":8C21
      i2              =   "Explorer.frx":8FE0
      i3              =   "Explorer.frx":939F
      i4              =   "Explorer.frx":975E
      i5              =   "Explorer.frx":9B1D
      i6              =   "Explorer.frx":9EDC
      i7              =   "Explorer.frx":A29B
      i8              =   "Explorer.frx":A65A
      i9              =   "Explorer.frx":B1C9
      i10             =   "Explorer.frx":DA20
      i11             =   "Explorer.frx":DDE0
      i12             =   "Explorer.frx":E1A0
      i13             =   "Explorer.frx":E560
      i14             =   "Explorer.frx":E920
      i15             =   "Explorer.frx":ECE0
   End
   Begin ComctlLib.ImageList tbButtons 
      Left            =   10650
      Top             =   2340
      _Version        =   65536
      _ExtentX        =   1005
      _ExtentY        =   1005
      _StockProps     =   1
      BackColor       =   -2147483643
      ImageWidth      =   16
      ImageHeight     =   16
      MaskColor       =   12632256
      NumImages       =   14
      i1              =   "Explorer.frx":F0A0
      i2              =   "Explorer.frx":F257
      i3              =   "Explorer.frx":F40E
      i4              =   "Explorer.frx":F5C5
      i5              =   "Explorer.frx":F77C
      i6              =   "Explorer.frx":F933
      i7              =   "Explorer.frx":FAEA
      i8              =   "Explorer.frx":FCA1
      i9              =   "Explorer.frx":FE58
      i10             =   "Explorer.frx":10097
      i11             =   "Explorer.frx":1024F
      i12             =   "Explorer.frx":10407
      i13             =   "Explorer.frx":105BF
      i14             =   "Explorer.frx":10777
   End
   Begin ComctlLib.Toolbar Tools 
      Align           =   1  'Align Top
      Height          =   390
      Left            =   0
      TabIndex        =   4
      Top             =   0
      Width           =   9885
      _Version        =   65536
      _ExtentX        =   17436
      _ExtentY        =   688
      _StockProps     =   96
      ImageList       =   "tbButtons"
      NumButtons      =   20
      i1              =   "Explorer.frx":1092F
      i2              =   "Explorer.frx":10ACE
      i3              =   "Explorer.frx":10C79
      i4              =   "Explorer.frx":10E24
      i5              =   "Explorer.frx":10FC3
      i6              =   "Explorer.frx":1116E
      i7              =   "Explorer.frx":1131D
      i8              =   "Explorer.frx":114BC
      i9              =   "Explorer.frx":1165B
      i10             =   "Explorer.frx":117FE
      i11             =   "Explorer.frx":119A2
      i12             =   "Explorer.frx":11B42
      i13             =   "Explorer.frx":11CEA
      i14             =   "Explorer.frx":11E8A
      i15             =   "Explorer.frx":1202E
      i16             =   "Explorer.frx":121D6
      i17             =   "Explorer.frx":12376
      i18             =   "Explorer.frx":1251E
      i19             =   "Explorer.frx":126C6
      i20             =   "Explorer.frx":1286A
      AlignSet        =   -1  'True
      Wrappable       =   0   'False
   End
   Begin ComctlLib.StatusBar Status 
      Align           =   2  'Align Bottom
      Height          =   300
      Left            =   0
      TabIndex        =   2
      Top             =   5070
      Width           =   9885
      _Version        =   65536
      _ExtentX        =   17436
      _ExtentY        =   529
      _StockProps     =   68
      AlignSet        =   -1  'True
      SimpleText      =   ""
      _timers         =   2
      NumPanels       =   4
      i1              =   "Explorer.frx":12A2C
      i2              =   "Explorer.frx":12B38
      i3              =   "Explorer.frx":12C44
      i4              =   "Explorer.frx":12D94
   End
   Begin ComctlLib.TreeView PathTree 
      DragIcon        =   "Explorer.frx":12EE8
      Height          =   4425
      Left            =   0
      TabIndex        =   1
      Top             =   660
      Width           =   4275
      _Version        =   65536
      _ExtentX        =   7541
      _ExtentY        =   7805
      _StockProps     =   196
      Appearance      =   1
      HideSelection   =   0   'False
      ImageList       =   "tvImagesSmall"
      Indentation     =   176
      LabelEdit       =   1
      PathSeparator   =   "\"
      Sorted          =   -1  'True
      Style           =   7
   End
   Begin ComctlLib.ListView FileList 
      DragIcon        =   "Explorer.frx":1332A
      Height          =   4425
      Left            =   4290
      TabIndex        =   3
      Top             =   660
      Width           =   5595
      _Version        =   65536
      _ExtentX        =   9869
      _ExtentY        =   7805
      _StockProps     =   205
      ForeColor       =   -2147483640
      BackColor       =   -2147483643
      Appearance      =   1
      Arrange         =   2
      Icons           =   "tvImagesLarge"
      MultiSelect     =   -1  'True
      SmallIcons      =   "tvImagesSmall"
      Sorted          =   -1  'True
      SortOrder       =   -1  'True
      SortKey         =   2
      View            =   3
      NumItems        =   5
      i1              =   "Explorer.frx":1376C
      i2              =   "Explorer.frx":13816
      i3              =   "Explorer.frx":138C0
      i4              =   "Explorer.frx":1396A
      i5              =   "Explorer.frx":13A18
   End
   Begin VB.Menu mFile 
      Caption         =   "&File"
      Begin VB.Menu fNew 
         Caption         =   "&New"
         Begin VB.Menu mFolder 
            Caption         =   "&Folder"
         End
      End
      Begin VB.Menu m_1 
         Caption         =   "-"
      End
      Begin VB.Menu mDelete 
         Caption         =   "&Delete"
      End
      Begin VB.Menu mRename 
         Caption         =   "&Rename"
      End
      Begin VB.Menu m_2 
         Caption         =   "-"
      End
      Begin VB.Menu mOpen 
         Caption         =   "&Open"
         Shortcut        =   ^O
      End
      Begin VB.Menu mClose 
         Caption         =   "&Close"
      End
   End
   Begin VB.Menu mEdit 
      Caption         =   "&Edit"
      Begin VB.Menu mCopy 
         Caption         =   "&Copy"
      End
      Begin VB.Menu mPaste 
         Caption         =   "&Paste"
      End
   End
   Begin VB.Menu mView 
      Caption         =   "&View"
      Begin VB.Menu mLargeIcons 
         Caption         =   "Lar&ge Icons"
      End
      Begin VB.Menu mSmallIcons 
         Caption         =   "S&mall Icons"
      End
      Begin VB.Menu mList 
         Caption         =   "&List"
      End
      Begin VB.Menu mDetails 
         Caption         =   "&Details"
      End
      Begin VB.Menu m_3 
         Caption         =   "-"
      End
      Begin VB.Menu mRefresh 
         Caption         =   "&Refresh"
      End
   End
   Begin VB.Menu mTools 
      Caption         =   "&Tools"
      Begin VB.Menu mConnect 
         Caption         =   "&Connect"
         Begin VB.Menu mConNetworkDrive 
            Caption         =   "&Network Drive..."
         End
         Begin VB.Menu mConUNCPath 
            Caption         =   "&UNC Path..."
         End
         Begin VB.Menu mConFTPServer 
            Caption         =   "&FTP Server..."
         End
      End
      Begin VB.Menu mDisconnect 
         Caption         =   "&Disconnect"
         Begin VB.Menu mDisNetworkDrive 
            Caption         =   "&Network Drive..."
         End
         Begin VB.Menu mDisUNCPath 
            Caption         =   "&UNC Path...."
         End
         Begin VB.Menu mDisFTPServer 
            Caption         =   "&FTP Server..."
         End
      End
   End
   Begin VB.Menu mHelp 
      Caption         =   "&Help"
      Begin VB.Menu mHelpAbout 
         Caption         =   "&About..."
      End
   End
End
Attribute VB_Name = "FTPExplorer"
Attribute VB_Creatable = False
Attribute VB_Exposed = False
Option Explicit
Dim FTPCallBack() As Integer                    ' FTP Control CallBack Var
Dim RefreshFlag As Boolean                      ' TreeView Refresh Flag
Dim CurrentNode As Node

'------------------------------------------------------------
Private Sub FileList_AfterLabelEdit(Cancel As Integer, NewString As String)
'------------------------------------------------------------
    Dim OldKey As String                        ' Preserves Selected Key's Name
'------------------------------------------------------------
    OldKey = FileList.SelectedItem.Key          ' Save Key Value
    
    ' Attempt To Rename File...
    If vRenameFile(FileList.SelectedItem, NewString, FTP, FTPCallBack, RefreshFlag) Then
        If RefreshFlag Then                     ' Is Refresh Flag Set...
            ' Force PathTree Refresh...
            Call PathTree_NodeClick(PathTree.Nodes.item(OldKey).Parent)
        End If
    Else
        Cancel = True                           ' Cancel Label Edit
    End If
'------------------------------------------------------------
End Sub
'------------------------------------------------------------

'------------------------------------------------------------
Private Sub FileList_ColumnClick(ByVal ColumnHeader As ColumnHeader)
'------------------------------------------------------------
    If (FileList.SortKey = ColumnHeader.Index - 1) Then
        FileList.Sorted = True
        If (FileList.SortOrder = lvwAscending) Then
            FileList.SortOrder = lvwDescending
        Else
            FileList.SortOrder = lvwAscending
        End If
    Else
        FileList.SortKey = ColumnHeader.Index - 1
    End If
'------------------------------------------------------------
End Sub
'------------------------------------------------------------

Private Sub FileList_DblClick()
    ' Handle Error Incase Clicked Node Is Not A Valid Directory
    On Error Resume Next
    
    ' Get FileList Item And Force Click On It's Twin PathTree Node...
    Call PathTree_NodeClick(PathTree.Nodes.item(FileList.SelectedItem.Key))
End Sub
Private Sub FileList_MouseDown(Button As Integer, Shift As Integer, x As Single, y As Single)
    If (Button = vbLeftButton) Then
        FileList.Tag = "x"
    ElseIf (Button = vbRightButton) Then                        ' Pop Copy/Paste Menu
        If Not FileList.HitTest(1, y) Is Nothing Then
            FileList.SelectedItem = FileList.HitTest(1, y)
        End If
    
        Me.PopupMenu mEdit                                      ' Pop Menu...
    End If
End Sub

'------------------------------------------------------------
Private Sub Form_Load()
'------------------------------------------------------------
    Dim fCaption As String                                  ' Form's Caption
    Dim NodeX As Node                                       ' Tree View Node...
    Dim cNode As Node                                       ' Tree View Node...
'------------------------------------------------------------
    If App.PrevInstance Then
        fCaption = App.title
        Me.Caption = ""
        App.title = ""
        AppActivate fCaption
        SendKeys "^o", True
        End
    Else
        ReDim FTPCallBack(0)                                ' Initialize Array Size...
        ReDim FTPData(0)                                    ' Initialize Array Size...
        ReDim AppCLIPBOARD(0)                               ' Initialize ClipBoard Array
        RefreshFlag = False                                 ' Set Refresh Default
        gUniqueID = gUniqueID + 1                           ' Increment Unique ID Counter
        Me.Tag = Format$(gUniqueID, FMTUID)                 ' Give Form A Unique ID.
        
        ' Create DeskTop Node...
        Set NodeX = PathTree.Nodes.Add(, , Me.Tag & ntDESKTOP & NULLIDX & NTRDESKTOP, NTRDESKTOP, TDESKTOP)
        
        ' Cretae My Computer Node...
        Set cNode = PathTree.Nodes.Add(NodeX, tvwChild, Me.Tag & ntMYCOMPUTER & NULLIDX & NTRMYCOMPUTER, NTRMYCOMPUTER, TMYCOMPUTER)
        Call LoadLocalDrives(PathTree, cNode)               ' Load Root Information...
        
        ' Cretae Network UNC Node...
        Call PathTree.Nodes.Add(NodeX, tvwChild, Me.Tag & ntNETWORK & NULLIDX & NTRNETWORK, NTRNETWORK, TNETDRIVE)
        
        ' Cretae Internet TCP...
        Call PathTree.Nodes.Add(NodeX, tvwChild, Me.Tag & ntINTERNET & NULLIDX & NTRINTERNET, NTRINTERNET, TINTERNET)
        
        PathTree.Nodes(1).Expanded = True                   ' Force TreeView Root To Open...
    End If
'------------------------------------------------------------
End Sub
'------------------------------------------------------------

'------------------------------------------------------------
Private Sub Form_QueryUnload(Cancel As Integer, UnloadMode As Integer)
'------------------------------------------------------------
    Dim fc As FTPCT                     ' FTP Control Instance
'------------------------------------------------------------
    On Error Resume Next                ' Handle Errors
        
    For Each fc In FTP                  ' For Each Open FTP Connection
        If (fc.Index > 0) Then          ' Ignor First Control Instance...
            If (fc.State = prcConnected) Then
                fc.Quit               ' Disconnect Connection
            End If
        End If
    Next                                ' Next Connection
'------------------------------------------------------------
End Sub
'------------------------------------------------------------

'------------------------------------------------------------
Private Sub Form_Resize()
'------------------------------------------------------------
    Dim h As Long, W As Long, Bdr As Long
'------------------------------------------------------------
    Bdr = SizeBar.Width \ 2             ' Boarder Width
    
    h = Me.ScaleHeight - Status.Height - PathTree.Top
    If (h < 2) Then h = 2               ' Handle Form Width Error
    
    W = (ScaleWidth \ 2)                ' Get Form Width
    If (W < 2) Then W = 2               ' Handle Form Width Error
    
    ' Resize TreeView Control
    PathTree.Move PathTree.Left, PathTree.Top, PathTree.Width, h
    
    ' Resize TreeView Lable Width
    lFolders.Move PathTree.Left, lFolders.Top, PathTree.Width
    
    ' Resize Size Bar
    SizeBar.Move Abs(PathTree.Width - Bdr), PathTree.Top, SizeBar.Width, PathTree.Height
    
    ' ReSize ListView Control
    FileList.Move PathTree.Width, FileList.Top, Abs(ScaleWidth - PathTree.Width), PathTree.Height
    
    ' Resize ListView Lable Width
    lFiles.Move FileList.Left, lFiles.Top, FileList.Width
    
'------------------------------------------------------------
End Sub
'------------------------------------------------------------

Private Sub FTP_Authenticate(Index As Integer)
    Status.Panels(2).Text = FTP(Index).ReplyString
End Sub
Private Sub FTP_Connect(Index As Integer)
    Debug.Print "Connect[" & Format(Index, "0") & "]"
End Sub
Private Sub FTP_DelDir(Index As Integer)
    FTPCallBack(Index) = FTPSUCCESS             ' Set CallBack Status
End Sub
Private Sub FTP_DelFile(Index As Integer)
    FTPCallBack(Index) = FTPSUCCESS             ' Set CallBack Status
End Sub
Private Sub FTP_DocInput(Index As Integer, ByVal DocInput As DocInput)
    Select Case DocInput.State
    Case icDocBegin
        Debug.Print "DocIN:Begin"
        FTP(Index).Tag = ""
    Case icDocData
        Debug.Print "DocIN:Data[" & Format(DocInput.BytesTransferred) & "] [" & _
                                    Format(DocInput.BytesTotal) & "]"
'       FTP(Index).Tag = FTP(Index).Tag & Data
    Case icDocEnd
        Debug.Print "DocIN:End"
        FTPCallBack(Index) = FTPSUCCESS             ' Set CallBack Status
    Case icDocError
        Debug.Print "DocIN:Error"
        FTPCallBack(Index) = FTPERROR               ' Set CallBack Status
    Case icDocHeaders
        Debug.Print "DocIN:Headers"
    Case icDocNone
    Case Else
    End Select
End Sub
'------------------------------------------------------------
Private Sub FTP_DocOutput(Index As Integer, ByVal DocOutput As DocOutput)
'------------------------------------------------------------
    Dim Data As String
    Dim length As Long
'------------------------------------------------------------
'   Debug.Print "DocOutput - BytesTransferred", DocOutput.BytesTransferred, DocOutput.BytesTotal
'   Debug.Print "DocOutput - FileName", DocOutput.FILENAME
'   Debug.Print "DocOutput - State", DocOutput.State
'   Debug.Print "DocOutput - Headers.Count", DocOutput.Headers.Count
    
    Select Case DocOutput.State
    Case icDocBegin
        Debug.Print "DocOUT:Begin"
        FTP(Index).Tag = ""
    Case icDocData
        Select Case FTP(Index).Operation
        Case ftpFile
        Case ftpList, ftpNameList
            Call DocOutput.GetData(Data)
            length = Len(Data)
            FTP(Index).Tag = FTP(Index).Tag & Data
        End Select
        
        Debug.Print "DocOUT:Data[" & Format(DocOutput.BytesTransferred) & "] [" & _
                                     Format(DocOutput.BytesTotal) & "]"
    Case icDocEnd
        Debug.Print "DocOUT:End"
        FTPCallBack(Index) = FTPSUCCESS             ' Set CallBack Status
    Case icDocError
        Debug.Print "DocOUT:Error"
        FTPCallBack(Index) = FTPERROR               ' Set CallBack Status
    Case icDocHeaders
        Debug.Print "DocOUT:Headers"
    Case icDocNone
    Case Else
    End Select
'------------------------------------------------------------
End Sub
'------------------------------------------------------------

Private Sub FTP_Error(Index As Integer, Number As Integer, Description As String, Scode As Long, Source As String, HelpFile As String, HelpContext As Long, CancelDisplay As Boolean)
'   Debug.Print "[================================================]"
'   Debug.Print "FTP[" & Format(Index, "0") & "] Error:"
'   Debug.Print "Number:", Number
'   Debug.Print "Description:", Description
'   Debug.Print "Scode: [" & Hex$(Scode) & "]"
'   Debug.Print "Source:", Source
'   Debug.Print "[================================================]"
    
'   Dim er As icError
'   For Each er In FTP(Index).Errors
'       Debug.Print "icError - Code:[", Format(er.Code, "0"), _
                              "Type:[" & er.Type & "] "; _
                              "Description:[" & er.Description & "]"
'   Next
'   FTP(Index).Errors.Clear
'   Debug.Print "[================================================]"
    
    FTPCallBack(Index) = FTPERROR           ' Return FTP CallBack Error...
End Sub

Private Sub FTP_ListItem(Index As Integer, ByVal item As FTPDirItem)
    Debug.Print "FTP:File: " & item.filename & _
                               " [" & CStr(item.Size) & "] " & _
                               " [" & Format$(item.Date, "mm-dd-yy") & "] " & _
                               " [" & item.Attributes & "] " & _
                               " [" & item.Detail & "] "
'   Debug.Print "FTP:FileDetail: " & item.Detail
    
'   FTPCallBack(Index) = FTPSUCCESS             ' Set CallBack Status
End Sub
Private Sub FTP_ProtocolStateChanged(Index As Integer, ByVal ProtocolState As Integer)
    Dim msg As String
    
    Select Case ProtocolState
    Case ftpBase
        msg = "Protocol: Base"
    Case ftpTransaction
        msg = "Protocol: Transaction"
    Case ftpAuthorization
        msg = "Protocol: Authorization"
    Case Else
    End Select
    
    Status.Panels(2).Text = msg
End Sub
Private Sub FTP_Quit(Index As Integer)
    Dim NodeX As Node                           ' Node Variable
    
    ' Copy Node Root...
    Set NodeX = PathTree.Nodes.item(Me.Tag & ntINRCHILD & Format$(Index, FMTINDEX) & FTPROOTDIR)
    
    Call PathTree_NodeClick(NodeX.Parent)       ' Change Focus To Parent Node...
    Call PathTree.Nodes.Remove(NodeX.Key)       ' Remove FTP Node From Tree...
    
    Unload FTP(Index)                           ' Remove Control From Array
End Sub
Private Sub FTP_Reinitialize(Index As Integer)
    FTPCallBack(Index) = FTPSUCCESS             ' Set CallBack Status
    Debug.Print "Reinitialize", FTP(Index).ReplyString
End Sub
Private Sub FTP_StateChanged(Index As Integer, ByVal State As Integer)
    Status.Panels(1).Text = FTP(Index).StateString
End Sub
Private Sub FTP_Status(Index As Integer)
    Status.Panels.item(1).Text = "FTP Status [" & FTP(Index).ReplyString & "]"
    Debug.Print Status.Panels.item(1).Text
End Sub
Private Sub FTP_Timeout(Index As Integer, ByVal event As Integer, Continue As Boolean)
    Dim rc As Long
    rc = MsgBox(FTP(Index).Reply & "Would you like to remain connected?", _
                vbQuestion & vbYesNo, _
                "FTP Session Time Out")             ' Notify User Of Timeout...
    
    FTP(Index).Continue = (rc = vbYes)
    If (rc = vbYes) Then
        FTP(Index).Reinitialize                     ' ReInitialize Connection...
    Else
        Call FTP_Quit(Index)                        ' Clean Up Tree...
    End If
End Sub
Private Sub mClose_Click()
    Unload Me
End Sub
Private Sub mConFTPServer_Click()
    Dim Inst As Long                                        ' Instance Index Variable
    
    Inst = InstanceFTP(FTP, FTPCallBack)                    ' Create New FTP Control Instance
    Call AddFTPConnection(FTP(Inst), PathTree, Me)          ' Show FTP Connect Dialog And Connect
End Sub
Private Sub mConNetworkDrive_Click()
    ' Show Network Connect Common Dialog
    If (ERROR_SUCCESS = WNetConnectionDialog(Me.hwnd, RESOURCETYPE_DISK)) Then
        ' ReLoad LocalDrive Information...
        Call LoadLocalDrives(PathTree, PathTree.Nodes.item(Me.Tag & ntMYCOMPUTER & NULLIDX & NTRMYCOMPUTER))
    End If
End Sub
Private Sub mConUNCPath_Click()
    ' Prompt User To Add UNC Path...
    Call AddUNCPath(PathTree)
End Sub
Private Sub mCopy_Click()
    Dim sItem As ListItem
    Dim i As Long
    
    ' Activated From FileList
    If Me.ActiveControl Is FileList Then                ' Clicked Over FileList
        If Not FileList.SelectedItem Is Nothing Then    ' Is Anything Selected
            Call FillClipBoard(FileList, AppCLIPBOARD)  ' Fill ClipBoard With All Selected Items...
            Exit Sub                                    ' Exit
        End If                                          ' OtherWise Drop Down...
    End If                                              ' Otherwise Drop Down...
    
    ' Activate From PathTree
    If Not PathTree.SelectedItem Is Nothing Then        ' Is PathTree Item Selected...
        ReDim AppCLIPBOARD(0)                           ' Resize ClipBoard Array
        AppCLIPBOARD(0) = PathTree.SelectedItem.Key     ' Copy Selected Object
    End If
End Sub

Private Sub mDisFTPServer_Click()
    ' Disconnect From FTP Servers...
    Call RemoveFTPConnection(PathTree, PathTree.Nodes.item(Me.Tag & ntINTERNET & NULLIDX & NTRINTERNET), FTP)
End Sub
Private Sub mDisNetworkDrive_Click()
    ' Show Network Disconnect Common Dialog
    If (ERROR_SUCCESS = WNetDisconnectDialog(Me.hwnd, RESOURCETYPE_DISK)) Then
        ' ReLoad LocalDrive Information...
        Call LoadLocalDrives(PathTree, PathTree.Nodes.item(Me.Tag & ntMYCOMPUTER & NULLIDX & NTRMYCOMPUTER))
    End If
End Sub
Private Sub mDisUNCPath_Click()
    ' Call Function To Remove UNC Path Conntctions
    Call RemoveUNCPath(PathTree, PathTree.Nodes.item(Me.Tag & ntNETWORK & NULLIDX & NTRNETWORK))
End Sub

Private Sub mEdit_Click()
    Dim sItem As ListItem
    
    If (Me.ActiveControl Is PathTree) Or _
       (Me.ActiveControl Is FileList) Then
        mPaste.Enabled = Not (AppCLIPBOARD(0) = "")
        
        mCopy.Enabled = False
        If Not Me.ActiveControl.SelectedItem Is Nothing Then
            If Me.ActiveControl Is PathTree Then
              mCopy.Enabled = Me.ActiveControl.SelectedItem.Selected
            ElseIf Me.ActiveControl Is FileList Then
                For Each sItem In Me.ActiveControl.ListItems
                    If sItem.Selected Then mCopy.Enabled = True
                Next
            End If
        End If
    End If
End Sub

Private Sub mOpen_Click()
    Dim x As New FTPExplorer                        ' Explorer Form Variable
    x.Show                                          ' Open New Form Instance
End Sub

Private Sub mPaste_Click()
    Dim dKey As String                                  ' Destination Node
    Dim i As Long                                       ' Loop Variable...
    
    ' If Activated From FileList
    If Me.ActiveControl Is FileList Then                ' Clicked Over FileList
        If Not FileList.SelectedItem Is Nothing Then    ' Is Anything Selected
            dKey = FileList.SelectedItem.Key            ' Copy Selected Object
        End If
    End If
    
    ' Activated From PathTree
    If ((Not PathTree.SelectedItem Is Nothing) Or (dKey = "")) Then
        dKey = PathTree.SelectedItem.Key                ' Copy Selected Object
    End If
    
    For i = LBound(AppCLIPBOARD) To UBound(AppCLIPBOARD)        ' For Each File Refer
        Call vCopyFile(AppCLIPBOARD(i), dKey, FTP, FTPCallBack) ' Copy Files
    Next                                                        ' Next File
    
    RefreshFlag = True                                  ' Notify Path Tree To Refresh
'   Call PathTree_NodeClick(PathTree.SelectedItem)      ' Refresh FileList...
    Call PathTree_NodeClick(CurrentNode)                ' Refresh FileList...
End Sub

'------------------------------------------------------------
Private Sub PathTree_AfterLabelEdit(Cancel As Integer, NewString As String)
'------------------------------------------------------------
    ' Attempt To Rename File... Determine Cancel Status...
    Cancel = Not vRenameFile(PathTree.SelectedItem, NewString, FTP, FTPCallBack, RefreshFlag)
'------------------------------------------------------------
End Sub
'------------------------------------------------------------

'------------------------------------------------------------
Private Sub PathTree_BeforeLabelEdit(Cancel As Integer)
'------------------------------------------------------------
    Dim NodeType As String
'------------------------------------------------------------
    NodeType = Mid(PathTree.SelectedItem.Key, (NODEFORMIDLEN + 1), NODEIDLEN) ' Extract Node Type...
    
    Select Case NodeType
    Case ntMCCHILD, ntNWCHILD                       ' My Computer Or UNC Network Child
    Case ntINCHILD                                  ' Internet TCP Child Connection
    Case Else
        Cancel = True                               ' Cancel The Edit...
    End Select
'------------------------------------------------------------
End Sub
'------------------------------------------------------------

Private Sub PathTree_Expand(ByVal Node As Node)
    Call PathTree_NodeClick(Node)                       ' Force File List Repaint...
End Sub

'------------------------------------------------------------
Private Sub PathTree_NodeClick(ByVal Node As Node)
'------------------------------------------------------------
    Dim NodeType As String                          ' Describes Tree View Node Type
    Dim CurPath As String                           ' Node's Current Path
    Dim Idx As Long                                 ' FTP Control Index
    Dim rc As Long                                  ' Function Call Return Code....
    Static LastNode As Node                         ' Remembers Last Node Touched...
'------------------------------------------------------------
    Set CurrentNode = Node
    
    If Not (LastNode Is Nothing) Then               ' Is This First Time?
        If (LastNode.Key = Node.Key) And (Not RefreshFlag) Then ' Is Same Node and Not Refreshing
            Exit Sub                                ' Don't Refresh...
        End If
    End If
    
    Node.Selected = True                            ' ReSelect Node
    NodeType = Mid(Node.Key, (NODEFORMIDLEN + 1), NODEIDLEN) ' Extract Node Type...
    CurPath = Mid(Node.Key, (NODEPREFIXLEN + NODEFTPIDXLEN + 1)) ' Extract Path From Node
    
    Select Case NodeType
    Case ntINCHILD, ntINRCHILD                      ' Internet Root, Child
        CurPath = CurPath & "/"                     ' Append FTP Path Sepparator To Path
    End Select
        
    lFiles.Caption = "Contents of '" & CurPath & "'" ' Update Caption
    Idx = CLng(Mid(Node.Key, (NODEPREFIXLEN + 1), NODEFTPIDXLEN)) ' Extract FTP Control Index ID...
    
    On Error Resume Next                            ' Handle Error If Node Is Deleted
    If Not (LastNode Is Nothing) Then               ' If Not First Node To Touch...
        Select Case LastNode.Image
        Case TFOLDEROPEN                            ' If Folder Is Open...
            LastNode.Image = TFOLDERCLOSED          ' ...Close Folder
        Case TSHORTCUTOPEN                          ' If ShortCut Is Open
            LastNode.Image = TSHORTCUTCLOSED        ' ...Close ShortCut
        End Select
    End If
    
    Set LastNode = Node                             ' Save Current Node As Last Node
    Select Case Node.Image                          ' Determine Image Status
    Case TFOLDERCLOSED                              ' If Folder Is Closed...
        Node.Image = TFOLDEROPEN                    ' ...Open Folder
    Case TSHORTCUTCLOSED                            ' If ShortCut Is Closed...
        Node.Image = TSHORTCUTOPEN                  ' ...Open ShortCut
    End Select
    
    If Not RefreshFlag Then                         ' Clearing May Cause GPF
        FileList.ListItems.Clear                    ' Clear File ListBox...
    End If
    Me.Refresh                                      ' Repaint Window...
    Screen.MousePointer = vbHourglass               ' Set Mouse Pointer HourGlass
        
    Select Case NodeType                            ' Determine Node Type...
    '------------------------------------------------------------
    Case ntMYCOMPUTER                               ' My Computer Node...
    '------------------------------------------------------------
        Call LoadLocalDrives(PathTree, Node)        ' ReLoad Root Information...
        Screen.MousePointer = vbDefault             ' Reset Mouse Pointer
        Exit Sub                                    ' Exit
    '------------------------------------------------------------
    Case ntMCCHILD, ntMCRCHILD, ntNWCHILD, ntNWRCHILD ' My Computer, UNC -  Root, Child
    '------------------------------------------------------------
    Case ntINCHILD, ntINRCHILD                      ' Internet Root - Child
    '------------------------------------------------------------
        FTPCallBack(Idx) = ftpList                  ' Set FTP List Request Status...
        'FTP(Idx).RemoteFile = CurPath
        
        FTP(Idx).List CurPath                       ' Get Directory Listing...
        FTP(Idx).ListItemNotify = False
'       FTP(Idx).ListItemNotify = True
'       Call FTP(Idx).NameList(CurPath)             ' Get Directory Listing...
        
        Do While (FTPCallBack(Idx) = ftpList)       ' Wait For List Response
            DoEvents                                ' Jump Up And Down On The Message Queue
        Loop                                        ' Go Check Status
                
        If (FTPCallBack(Idx) = FTPERROR) Then Exit Sub ' Exit On Error...
    '------------------------------------------------------------
    Case Else
    '------------------------------------------------------------
        Screen.MousePointer = vbDefault             ' Reset Mouse Pointer
        Exit Sub                                    ' Exit Don't Process Any Further
    '------------------------------------------------------------
    End Select
    '------------------------------------------------------------
        
    Call SendMessage(PathTree.hwnd, WM_SETREDRAW, REDRAWOFF, 0) ' Turn PathTree Paint On
    Call GetDirs(PathTree, Node, FTP(Idx), RefreshFlag)         ' Get Directory Lists
    Call SendMessage(PathTree.hwnd, WM_SETREDRAW, REDRAWON, 0)  ' Turn PathTree Paint On
    PathTree.Refresh                                            ' Repaint PathTree
    
    If Not RefreshFlag Then
        Call SendMessage(FileList.hwnd, WM_SETREDRAW, REDRAWOFF, 0) ' Turn FileList Paint Off
        Call GetFiles(FileList, Node, FTP(Idx))                     ' Get Files/Info...
        Call SendMessage(FileList.hwnd, WM_SETREDRAW, REDRAWON, 0)  ' Turn FileList Paint On
    Else
        RefreshFlag = False                         ' Reset RefreshFlag
    End If
    Screen.MousePointer = vbDefault                 ' Reset Mouse Pointer
'------------------------------------------------------------
End Sub
'------------------------------------------------------------

'------------------------------------------------------------
Private Sub SizeBar_MouseMove(Button As Integer, Shift As Integer, x As Single, y As Single)
'------------------------------------------------------------
    If ((Button = vbLeftButton)) Then                   ' If Left Button Down
        SizeBar.Left = SizeBar.Left + x                 ' Move Size Bar
    End If
'------------------------------------------------------------
End Sub
'------------------------------------------------------------

'------------------------------------------------------------
Private Sub SizeBar_MouseUp(Button As Integer, Shift As Integer, x As Single, y As Single)
'------------------------------------------------------------
    Dim Bdr As Long                                     ' Boarder Width...
'------------------------------------------------------------
    Bdr = SizeBar.Width \ 2                             ' Boarder Width 1\2 Of SizeBar Width
    
    ' Check Position Of SizeBar And Fix If OutSide Of Window...
    If (SizeBar.Left < SizeBar.Width) Then              ' Outside Left Of Window
        SizeBar.Left = 1                                ' Fix Position
    ElseIf (SizeBar.Left > Me.ScaleWidth) Then          ' Outside Right Of Window
        SizeBar.Left = Me.ScaleWidth - SizeBar.Width    ' Fix Position
    End If
    
    PathTree.Width = Abs(SizeBar.Left + Bdr)            ' Resize TreeView Width
    lFolders.Width = PathTree.Width                     ' Resize TreeView Lable Width
    
    ' ReSize ListView Control
    FileList.Move PathTree.Width, FileList.Top, Abs(Me.ScaleWidth - PathTree.Width)
    
    ' Resize ListView Lable Width
    lFiles.Move FileList.Left, lFiles.Top, FileList.Width
'------------------------------------------------------------
End Sub
'------------------------------------------------------------

'------------------------------------------------------------
Private Sub Tools_ButtonClick(ByVal Button As Button)
'------------------------------------------------------------
    Dim rc As Long
    Dim PrevNode As Node
'------------------------------------------------------------
    Select Case Button.Image
    Case TBPREVIOUS                             ' Traverse Up The Tree One Notch...
        Set PrevNode = PathTree.SelectedItem.Parent ' Copy Parent Node...
        
        If Not (PrevNode Is Nothing) Then       ' If Not First Node To Touch...
            Call PathTree_NodeClick(PrevNode)   ' Traverse The Node Tree...
            PrevNode.Selected = True            ' Select Node
        End If
        PathTree.SetFocus                       ' Set Focus TreeView Control
    Case TBNEW                                  ' Open A New Window...
        Call mOpen_Click
    Case TBNETCONNECT                           ' Connect To Network Drive
        Me.PopupMenu mConnect, , vbPopupMenuRightButton
    Case TBTBNETDISCONNECT                      ' Disconnect From Network Drive
        Me.PopupMenu mDisconnect, , vbPopupMenuRightButton
    Case TBCUT                                  '
    Case TBCOPY                                 '
    Case TBPASTE                                '
    Case TBUNDODELETE                           '
    Case TBDELETE                               ' Delete Current File Or Directory
'        If (Me.ActiveControl Is PathTree) Or (Me.ActiveControl Is FileList) Then
'            If Not (Me.ActiveControl.SelectedItem Is Nothing) Then
'                Call vDeleteFile(Me.ActiveControl.SelectedItem, FTP) ' Delete Current Node
'            End If
'        End If
    Case TBPROPERTIES                           '
    Case TBVIEWLARGEICONS                       ' Change File List View - Large Icons
        FileList.View = lvwIcon
    Case TBVIEWSMALLICONS                       ' Change File List View - Small Icons
        FileList.View = lvwSmallIcon
    Case TBVIEWLIST                             ' Change File List View - List, Small Icons
        FileList.View = lvwList
    Case TBVIEWDETAILS                          ' Change File List View - Details, List, Small Icons
        FileList.View = lvwReport
    End Select
'------------------------------------------------------------
End Sub
'------------------------------------------------------------

