Attribute VB_Name = "FTP_Constants"
Option Explicit
'-------------------------------------------------------------------
Public Function FtpErrorHandler(FTPERROR As Long, FTPMsg As String) As Boolean
'-------------------------------------------------------------------
    FtpErrorHandler = False                                 ' Set Default Return Code...

'===================================================================
    Select Case FTPERROR
'===================================================================
    Case 110
        FTPMsg = "Restart marker reply."
             'In this case, the text is exact and not left to the
             'particular implementation; it must read:
             '     MARK yyyy = mmmm
             'Where yyyy is User-process data stream marker, and mmmm
             'server 's equivalent marker (note the spaces between markers
             'and "=").
    Case 120    ' Success
        FTPMsg = "Service ready in nnn minutes."
    Case 125    ' Success
        FTPMsg = "Data connection already open; transfer starting."
    Case 150    ' Success
        FTPMsg = "File status okay; about to open data connection."
'===================================================================
    Case 200    ' Success
        FTPMsg = "Command okay."
    Case 202
        FTPMsg = "Command not implemented, superfluous at this site."
    Case 211    ' Success
        FTPMsg = "System status, or system help reply."
    Case 212    ' Success
        FTPMsg = "Directory status."
    Case 213    ' Success
        FTPMsg = "File status."
    Case 214    ' Success
        FTPMsg = "Help message."
        'On how to use the server or the meaning of a particular
        'non-standard command.  This reply is useful only to the
        'human user.
    Case 215
        FTPMsg = "NAME system type."
        'Where NAME is an official system name from the list in the
        'Assigned Numbers document.
    Case 220    ' Success
        FTPMsg = "Service ready for new user."
    Case 221
        FTPMsg = "Service closing control connection."
        'Logged out if appropriate.
    Case 225
        FTPMsg = "Data connection open; no transfer in progress."
    Case 226
        FTPMsg = "Closing data connection."
        'Requested file action successful (for example, file
        'transfer or file abort).
    Case 227
        FTPMsg = "Entering Passive Mode (h1,h2,h3,h4,p1,p2)."
    Case 230    ' Success
        FTPMsg = "User logged in, proceed."
    Case 250    ' Success
        FTPMsg = "Requested file action okay, completed."
    Case 257    ' Success
        FTPMsg = """PATHNAME"" created."
'===================================================================
    Case 331
        FTPMsg = "User name okay, need password."
    Case 332
        FTPMsg = "Need account for login."
    Case 350
        FTPMsg = "Requested file action pending further information."
'===================================================================
    Case 421
        FTPMsg = "Service not available, closing control connection."
        'This may be a reply to any command if the service knows it
        'must shut down.
    Case 425
        FTPMsg = "Can't open data connection."
    Case 426
        FTPMsg = "Connection closed; transfer aborted."
    Case 450
        FTPMsg = "Requested file action not taken."
        'File unavailable (e.g., file busy).
    Case 451
        FTPMsg = "Requested action aborted: local error in processing."
    Case 452
        FTPMsg = "Requested action not taken."
        'Insufficient storage space in system.
'===================================================================
'===================================================================
    Case 500
        FTPMsg = " Syntax error, command unrecognized."
             ' This may include errors such as command line too long.
    Case 501
        FTPMsg = "Syntax error in parameters or arguments."
    Case 502
        FTPMsg = "Command not implemented."
    Case 503
        FTPMsg = "Bad sequence of commands."
    Case 504
        FTPMsg = "Command not implemented for that parameter."
    Case 530
        FTPMsg = "Not logged in."
    Case 532
        FTPMsg = "Need account for storing files."
    Case 550
        FTPMsg = "Requested action not taken."
        'File unavailable (e.g., file not found, no access).
    Case 551
        FTPMsg = "Requested action aborted: page type unknown."
    Case 552
        FTPMsg = "Requested file action aborted."
        'Exceeded storage allocation (for current directory or
        'dataset).
    Case 553
        FTPMsg = "Requested action not taken."
        'File name not allowed.
    Case Else
        FTPMsg = "Unknown FTP Error..."
'===================================================================
    End Select
'===================================================================
    
    Select Case FTPERROR
    Case 120, 125, 150, 200, 211, 2122, 213, 214, 220, 230, 250, 257
        FtpErrorHandler = True                              ' Return Success...
    End Select
'-------------------------------------------------------------------
End Function
'-------------------------------------------------------------------

