VERSION 4.00
Begin VB.Form frmHTTPExplorer 
   Caption         =   "Internet HTTP Explorer"
   ClientHeight    =   6825
   ClientLeft      =   1080
   ClientTop       =   1485
   ClientWidth     =   9030
   Height          =   7230
   Icon            =   "frmHTTP.frx":0000
   Left            =   1020
   LinkTopic       =   "Form1"
   LockControls    =   -1  'True
   ScaleHeight     =   6825
   ScaleWidth      =   9030
   Top             =   1140
   Width           =   9150
   Begin VB.Timer tmrIcons 
      Left            =   9120
      Top             =   3360
   End
   Begin VB.PictureBox SizeBar 
      BorderStyle     =   0  'None
      Height          =   6075
      Left            =   4320
      MousePointer    =   9  'Size W E
      ScaleHeight     =   6075
      ScaleWidth      =   30
      TabIndex        =   3
      Top             =   390
      Width           =   30
   End
   Begin VB.Image picFlag 
      BorderStyle     =   1  'Fixed Single
      Height          =   375
      Left            =   8610
      Picture         =   "frmHTTP.frx":0442
      Stretch         =   -1  'True
      Top             =   0
      Width           =   420
   End
   Begin PicClip.PictureClip Flags 
      Left            =   9120
      Top             =   3930
      _Version        =   65536
      _ExtentX        =   11456
      _ExtentY        =   661
      _StockProps     =   0
      Cols            =   18
      Picture         =   "frmHTTP.frx":0B40
   End
   Begin RichtextLib.RichTextBox txtHTTP 
      Height          =   5745
      Left            =   4350
      TabIndex        =   5
      Top             =   690
      Width           =   4635
      _Version        =   65536
      _ExtentX        =   8176
      _ExtentY        =   10134
      _StockProps     =   69
      BackColor       =   -2147483643
      ScrollBars      =   3
      TextRTF         =   $"frmHTTP.frx":3A26
   End
   Begin HTTPCTLib.HTTPCT HTTP 
      Left            =   9060
      Top             =   2670
      _ExtentX        =   847
      _ExtentY        =   847
      RemoteHost      =   "127.0.0.1"
      RemotePort      =   80
      ConnectTimeout  =   0
      RecvTimeout     =   0
      NotificationMode=   1
      Document        =   ""
      Method          =   1
   End
   Begin VB.Label lblStatus 
      BorderStyle     =   1  'Fixed Single
      Height          =   255
      Left            =   4350
      TabIndex        =   4
      Top             =   390
      Width           =   4665
   End
   Begin ComctlLib.ImageList imgIcons 
      Left            =   9030
      Top             =   2070
      _Version        =   65536
      _ExtentX        =   1005
      _ExtentY        =   1005
      _StockProps     =   1
      BackColor       =   -2147483643
      ImageWidth      =   16
      ImageHeight     =   16
      MaskColor       =   12632256
      NumImages       =   4
      i1              =   "frmHTTP.frx":3B09
      i2              =   "frmHTTP.frx":4000
      i3              =   "frmHTTP.frx":44F7
      i4              =   "frmHTTP.frx":49EE
   End
   Begin ComctlLib.ImageList imgTools 
      Left            =   9030
      Top             =   1380
      _Version        =   65536
      _ExtentX        =   1005
      _ExtentY        =   1005
      _StockProps     =   1
      BackColor       =   -2147483643
      ImageWidth      =   16
      ImageHeight     =   16
      MaskColor       =   12632256
      NumImages       =   1
      i1              =   "frmHTTP.frx":4EE5
   End
   Begin ComctlLib.TreeView Tree 
      Height          =   6075
      Left            =   0
      TabIndex        =   2
      Top             =   390
      Width           =   4305
      _Version        =   65536
      _ExtentX        =   7594
      _ExtentY        =   10716
      _StockProps     =   196
      Appearance      =   1
      HideSelection   =   0   'False
      ImageList       =   "imgIcons"
      Indentation     =   441
      LabelEdit       =   1
      PathSeparator   =   "\"
      Style           =   7
   End
   Begin ComctlLib.StatusBar Status 
      Align           =   2  'Align Bottom
      Height          =   345
      Left            =   0
      TabIndex        =   0
      Top             =   6480
      Width           =   9030
      _Version        =   65536
      _ExtentX        =   15928
      _ExtentY        =   609
      _StockProps     =   68
      AlignSet        =   -1  'True
      SimpleText      =   ""
      _timers         =   2
      NumPanels       =   4
      i1              =   "frmHTTP.frx":52A4
      i2              =   "frmHTTP.frx":5393
      i3              =   "frmHTTP.frx":549F
      i4              =   "frmHTTP.frx":55F3
   End
   Begin ComctlLib.Toolbar Tools 
      Height          =   390
      Left            =   0
      TabIndex        =   1
      Top             =   0
      Width           =   8565
      _Version        =   65536
      _ExtentX        =   15108
      _ExtentY        =   688
      _StockProps     =   96
      ImageList       =   "imgTools"
      NumButtons      =   2
      i1              =   "frmHTTP.frx":5743
      i2              =   "frmHTTP.frx":58E2
      AlignSet        =   -1  'True
   End
End
Attribute VB_Name = "frmHTTPExplorer"
Attribute VB_Creatable = False
Attribute VB_Exposed = False
Option Explicit
Public CurrentNode As Node
Public CurrentURL As String
Public httpDoc As String
Public httpDocName As String

Private Sub Form_Load()
    Dim i As Long
    
    Set CurrentNode = Tree.Nodes.Add(, , HTTPROOT, HTTPROOT, icoWORLDWIDEWEB)
End Sub

'------------------------------------------------------------
Private Sub Form_Resize()
'------------------------------------------------------------
    Dim W As Long
    Dim H As Long
'------------------------------------------------------------
    picFlag.Left = Me.ScaleWidth - picFlag.Width
    Tools.Width = picFlag.Left
    H = Abs(Me.ScaleHeight - Status.Height - Tools.Height)
    Tree.Height = H
    SizeBar.Height = H
    W = Abs(Me.ScaleWidth - SizeBar.Left - SizeBar.Width)
    lblStatus.Width = W
    With txtHTTP
        .Move .Left, .Top, W, Abs(H - .Top + lblStatus.Top)
    End With
'------------------------------------------------------------
End Sub
'------------------------------------------------------------

'------------------------------------------------------------
Private Sub HTTP_DocOutput(ByVal DocOutput As DocOutput)
'------------------------------------------------------------
    Dim URL As String
    Dim EXT As String
    Dim cNode As Node
    Dim vData As Variant
'------------------------------------------------------------
    Select Case DocOutput.State
    Case icDocBegin
        Screen.MousePointer = vbHourglass
        httpDoc = ""
        tmrIcons.Interval = 200
    Case icDocHeaders
    Case icDocData
        Debug.Print "Bytes: " & Str$(DocOutput.BytesTransferred) & "/" & _
                                Str$(DocOutput.BytesTotal)
        
        If (httpDocName = "") Then
            DocOutput.GetData vData
            httpDoc = httpDoc & vData
        End If
    Case icDocEnd
        If (httpDocName = "") Then
            txtHTTP.Text = httpDoc
            On Error Resume Next
            Set cNode = Tree.Nodes.Add(Tree.Nodes(1).Key, tvwChild, CurrentURL, CurrentURL, icoWEBDOC)
            If (cNode Is Nothing) Then Set cNode = Tree.Nodes(CurrentURL)
            cNode.Expanded = True
            
            If (cNode.Children = 0) Then
                Call AddURLDocToTree(Tree, cNode, httpDoc)
            End If
        End If
        httpDoc = ""
        tmrIcons.Interval = 0
        Screen.MousePointer = vbDefault
    Case Else
        HTTP.URL = ""
        httpDoc = ""
        httpDocName = ""
        tmrIcons.Interval = 0
        Screen.MousePointer = vbDefault
    End Select
'------------------------------------------------------------
End Sub
'------------------------------------------------------------

Private Sub HTTP_ProtocolStateChanged(ByVal ProtocolState As Integer)
    Status.Panels(2).Text = HTTP.ProtocolStateString
End Sub
Private Sub HTTP_StateChanged(ByVal State As Integer)
    Status.Panels(1).Text = HTTP.StateString
End Sub

'------------------------------------------------------------
Private Sub SizeBar_MouseMove(Button As Integer, Shift As Integer, X As Single, Y As Single)
'------------------------------------------------------------
    If (Button = vbLeftButton) Then                 ' If Left Button Down
        SizeBar.Left = SizeBar.Left + X             ' Move Size Bar
        Me.Refresh                                  ' Refresh improves appearence
    End If
'------------------------------------------------------------
End Sub
'------------------------------------------------------------

'------------------------------------------------------------
Private Sub SizeBar_MouseUp(Button As Integer, Shift As Integer, X As Single, Y As Single)
'------------------------------------------------------------
    Dim L As Long, W As Long, SW As Long
    Dim L2 As Long, W2 As Long
'------------------------------------------------------------
    With SizeBar
        L = .Left
        W = .Width
        SW = Me.ScaleWidth
        
        If (L < W) Then                             ' Outside Left Of Window
            L = W                                   ' Fix Position
            .Left = L                               ' Adjust sizebar position
        ElseIf (L > SW) Then                        ' Outside Right Of Window
            L = SW - W                              ' Fix Position
            .Left = L                               ' Adjust sizebar position
        End If
        
        Tree.Width = Abs(L - Tree.Left)             ' Resize TreeView Width
        L2 = L + W
        W2 = Abs(SW - L - W)
        
        lblStatus.Move L2, lblStatus.Top, W2
        txtHTTP.Move L2, txtHTTP.Top, W2
    End With
'------------------------------------------------------------
End Sub
'------------------------------------------------------------

Private Sub tmrIcons_Timer()
    Static pic As Long
    picFlag.Picture = Flags.GraphicCell(pic)
    picFlag.Refresh
    pic = (pic + 1) Mod Flags.Cols
End Sub

'------------------------------------------------------------
Private Sub Tools_ButtonClick(ByVal Button As Button)
'------------------------------------------------------------
    Dim URL As String
    Dim defURL As String
    Dim msg As String
    Dim Title As String
'------------------------------------------------------------
    Select Case Button.Index
    Case btnGLOBESEARCH
        msg = "Please enter a valid URL address..."
        Title = "Explore a new internet address..."
        defURL = "http://www.microsoft.com/"
        URL = InputBox(msg, Title, defURL)
        
        If (URL <> "") Then
            URL = LCase$(URL)
            If (Left$(URL, 7) <> "http://") Then URL = "http://" & URL
            If (Right$(URL, 1) <> "/") Then URL = URL & "/"
            
            CurrentURL = URL
            HTTP.GetDoc CurrentURL
        End If
    End Select
'------------------------------------------------------------
End Sub
'------------------------------------------------------------

'------------------------------------------------------------
Private Sub Tree_NodeClick(ByVal Node As Node)
'------------------------------------------------------------
    Dim EXT As String
'------------------------------------------------------------
    If ((Node <> CurrentNode) And (Node.Key <> HTTPROOT)) Then
        Set CurrentNode = Node
        CurrentURL = LCase(Node.Key)
        lblStatus.Caption = CurrentURL
        
        If (Left$(Right$(CurrentURL, 4), 1) = ".") Then EXT = Right$(CurrentURL, 3)
        
        Select Case EXT
        Case "zip", "exe", "txt", "doc", _
             "gif", "jpg", "avi", "wav"         ' Download extentions...
            Call GetTempFileFromURL(CurrentURL, httpDocName)
            
            HTTP.GetDoc CurrentURL, , httpDocName
            Do While ((HTTP.DocOutput.State = icDocBegin) Or _
                      (HTTP.DocOutput.State = icDocData) Or _
                      (HTTP.DocOutput.State = icDocHeaders))
                DoEvents
            Loop
            
            Load frmConfirm
            frmConfirm.lblFileName.Caption = "" & "(" & UCase(EXT) & ")"
            frmConfirm.Show vbModal
            
            Select Case frmConfirm.Tag
            Case CStr(vbOK)
                Call ShellURLDoc(Me.hWnd, httpDocName)
            Case CStr(vbCancel)
            Case Else
                If (Dir$(frmConfirm.Tag) <> "") Then Kill frmConfirm.Tag
                Name httpDocName As frmConfirm.Tag
            End Select
            httpDocName = ""
            Unload frmConfirm
        Case Else
            HTTP.GetDoc CurrentURL
        End Select
    End If
'------------------------------------------------------------
End Sub
'------------------------------------------------------------

