Attribute VB_Name = "tmpFunctions"
Option Explicit
'------------------------------------------------------------
Public Function GetTempFileFromURL(URL As String, tmpName As String) As Boolean
'------------------------------------------------------------
    Dim tmpPath As String
    Dim lenPath As Long
    Dim pos As Long
    Dim rc As Long
'------------------------------------------------------------
    tmpPath = Space$(255)
    lenPath = Len(tmpPath)
    rc = GetTempPath(lenPath, tmpPath)
    
    If (rc < 2) Then Exit Function
    tmpPath = Left$(tmpPath, rc)
    
    If (Asc(Right$(tmpPath, 1)) = 0) Then tmpPath = Left$(tmpPath, rc - 1)
    If (Right$(tmpPath, 1) <> "\") Then tmpPath = tmpPath & "\"
    
    For pos = Len(URL) To 1 Step -1
        If (Mid$(URL, pos, 1) = "/") Then
            tmpName = tmpPath & Mid$(URL, pos + 1)
            Exit For
        End If
    Next
    
    If ((tmpName <> tmpPath) And (Dir$(tmpName) <> "")) Then Exit Function
    
    GetTempFileFromURL = True                               ' Return success
'------------------------------------------------------------
End Function
'------------------------------------------------------------

'------------------------------------------------------------
Public Sub ShellURLDoc(hWnd As Long, httpDocName As String)
'------------------------------------------------------------
    Dim rc As Long
    Dim docPath As String
    Dim docName As String
    Dim pos As Long
'------------------------------------------------------------
    docName = Dir$(httpDocName)
    If (docName <> "") Then
        pos = InStr(1, httpDocName, docName) - 1
        If (pos > 0) Then
            docPath = Mid(httpDocName, 1, pos)
            rc = ShellExecute(hWnd, "open", httpDocName, 0, docPath, SW_SHOWDEFAULT)
Debug.Print "ShellExecute:rc:", rc
        End If
    End If
'------------------------------------------------------------
End Sub
'------------------------------------------------------------

'------------------------------------------------------------
Public Sub AddURLDocToTree(Tree As TreeView, pNode As Node, Doc As String)
'------------------------------------------------------------
    Dim sURL As String
    Dim pURL As String
    Dim URL As String
    Dim uBegin As Long
    Dim uEnd As Long
    Dim pos As Long
'------------------------------------------------------------
    pURL = LCase$(pNode.Key)                            ' Get Parent URL...
    If ((Left$(Right$(pURL, 4), 1) = ".") Or _
        (Left$(Right$(pURL, 5), 1) = ".")) Then         ' If check if URL string has extention at the end
        For pos = Len(pURL) To 1 Step -1                ' Step through each char. starting from right
            If (Mid$(pURL, pos, 1) = "/") Then Exit For ' if sepparator found then finish
        Next
        pURL = Mid$(pURL, 1, pos)                       ' Extract parent URL...
    End If
    
    pos = InStr(8, pURL, "/") - 1                       ' bug
    If (pos > 0) Then
        sURL = Mid(pURL, 1, pos)
    Else
        sURL = pURL
    End If                                              ' end bug
    
    Doc = LCase(Doc)                                    ' Copy http page to all lower case
    uBegin = 1                                          ' initialize search variables...
    uEnd = 0                                            '
    With Tree.Nodes
    Do                                                  ' do while more not at end of document
        If GetNextTagValue("href", Doc, uBegin, uEnd, URL) Then
            On Error Resume Next
            
            pos = InStr(1, URL, ":")
            If (pos > 0) Then
                Select Case Mid$(URL, 1, (pos - 1))
                Case "http", "file"
                    Call .Add(pNode, tvwChild, URL, URL, icoWEBPAGE)
                Case "ftp"
                Case "mailto"
                End Select
            Else
                If (Left$(URL, 1) = "/") Then
                    Call .Add(pNode, tvwChild, sURL & URL, URL, icoWEBDOC)
                Else
                    Call .Add(pNode, tvwChild, pURL & URL, URL, icoWEBDOC)
                End If
            End If
        End If
        
        If Not ((uBegin > 1) And (uEnd > 0)) Then Exit Do
    Loop Until URL = ""                                     ' Continue searching document for URL ref.s
    End With
'------------------------------------------------------------
End Sub
'------------------------------------------------------------

'------------------------------------------------------------
Public Function GetNextTagValue(Tag As String, Doc As String, uBegin As Long, uEnd As Long, URL As String) As Boolean
'------------------------------------------------------------
    uBegin = InStr(uBegin, Doc, Tag)                        ' Search for tag value
    If (uBegin > 0) Then                                    ' tag found...
        uBegin = InStr(uBegin, Doc, """") + 1               ' search for begin quote
        If (uBegin > 1) Then                                ' begin quote found...
            uEnd = InStr(uBegin, Doc, """") - 1             ' search for end quote
            If (uEnd > 0) Then                              ' end quote found
                URL = Mid$(Doc, uBegin, (uEnd - uBegin + 1)) ' Extract URL string from doc
                GetNextTagValue = True
                
                If (Right$(URL, 1) <> "/") Then
                    If ((Mid$(Right$(URL, 4), 1, 1) <> ".") And _
                        (Mid$(Right$(URL, 5), 1, 1) <> ".")) Then
                        URL = URL & "/"
                    End If
                End If
            End If
        End If
    End If
'------------------------------------------------------------
End Function
'------------------------------------------------------------
