VERSION 4.00
Begin VB.Form frmPortSearch 
   BorderStyle     =   3  'Fixed Dialog
   Caption         =   "TCP Port Search Engine"
   ClientHeight    =   3525
   ClientLeft      =   1140
   ClientTop       =   1530
   ClientWidth     =   6345
   Height          =   3930
   Icon            =   "TCPPORTS.frx":0000
   Left            =   1080
   LinkTopic       =   "Form1"
   LockControls    =   -1  'True
   MaxButton       =   0   'False
   ScaleHeight     =   3525
   ScaleWidth      =   6345
   ShowInTaskbar   =   0   'False
   Top             =   1185
   Width           =   6465
   Begin VB.TextBox txtOutput 
      Height          =   3075
      Left            =   30
      MultiLine       =   -1  'True
      ScrollBars      =   3  'Both
      TabIndex        =   4
      Top             =   420
      Width           =   6285
   End
   Begin VB.CommandButton cmdCancel 
      Caption         =   "Stop"
      Height          =   345
      Left            =   1080
      TabIndex        =   3
      Top             =   30
      Width           =   945
   End
   Begin VB.TextBox txtRemotePort 
      Height          =   285
      Left            =   3810
      TabIndex        =   2
      Text            =   "1"
      Top             =   90
      Width           =   945
   End
   Begin VB.TextBox txtName 
      Height          =   285
      Left            =   2100
      TabIndex        =   1
      Text            =   "www.microsoft.com"
      Top             =   90
      Width           =   1665
   End
   Begin VB.CommandButton cmdConnect 
      Caption         =   "Start"
      Height          =   345
      Left            =   60
      TabIndex        =   0
      Top             =   30
      Width           =   945
   End
   Begin WINSOCKLib.TCP TCP 
      Index           =   0
      Left            =   6420
      Top             =   0
      _ExtentX        =   847
      _ExtentY        =   847
      RemoteHost      =   ""
      RemotePort      =   0
      LocalPort       =   0
   End
End
Attribute VB_Name = "frmPortSearch"
Attribute VB_Creatable = False
Attribute VB_Exposed = False
Option Explicit
Dim StillSearching As Boolean                           ' Halt search notification variable
Const MAXPORT = 80                                      ' Maximum # of tcp controls instantances that can be created at run time

Private Sub cmdCancel_Click()
    StillSearching = False                              ' Cancel search
End Sub

'------------------------------------------------------------
Private Sub cmdConnect_Click()
'------------------------------------------------------------
    Dim Socket As Variant                               ' Socket instance variable
    Dim port As Long                                    ' Remote port variable
'------------------------------------------------------------
    On Error Resume Next                                ' Handle errors...
    
    port = Val(txtRemotePort.Text)                      ' Get starting remote port
    StillSearching = True                               ' Initialize status variable
    
    Do While StillSearching                             ' Loop until set to false
        For Each Socket In TCP                          ' Evaluate each socket instance
            If (Socket.State = sckClosed Or Socket.State = sckError) Then ' If not in use...
                txtRemotePort.Text = CStr(port)         ' Use next remote port
                Socket.Close                            ' Clear any errors...
                DoEvents                                ' Allow for user interaction
                Socket.Connect txtName.Text, port       ' Attempt new connection
                port = port + 1                         ' Increment Remote Port number
                If (port = 19) Then port = port + 1     ' <Warning This NOT a port you want to connect to, you will get a constant redundant data flow of ascii charicters>
            End If
            DoEvents                                    ' Allow for user interaction
        Next                                            ' Get next socket instance...
    Loop

    For Each Socket In TCP                              ' Loop through each socket instance...
        Socket.Close                                    ' Close all connections and clear any errors...
    Next                                                ' Get next socket instance...
'------------------------------------------------------------
End Sub
'------------------------------------------------------------

'------------------------------------------------------------
Private Sub Form_Load()
'------------------------------------------------------------
    Dim i As Integer                                    ' Loop counter
'------------------------------------------------------------
    For i = 1 To MAXPORT                                ' For each possible NEW socket instance number
        Load TCP(i)                                     ' Create a NEW Socket instance
    Next                                                ' Get next instance number
'------------------------------------------------------------
End Sub
'------------------------------------------------------------

Private Sub Form_QueryUnload(Cancel As Integer, UnloadMode As Integer)
    cmdCancel_Click                                     ' Call cancel to stop searching socket ports...
End Sub
'------------------------------------------------------------
Private Sub Form_Unload(Cancel As Integer)
'------------------------------------------------------------
    Dim Socket As Variant                               ' Socket instance variable
'------------------------------------------------------------
    For Each Socket In TCP                              ' For each created TCP instance in control array
        Socket.Close                                    ' Close connection
        If (Socket.Index <> 0) Then Unload Socket       ' Unload instanced control, except the design time control-TCP(0)
    Next                                                ' Get next instance...
    
    End                                                 ' End program forcefully
'------------------------------------------------------------
End Sub
'------------------------------------------------------------

'------------------------------------------------------------
Private Sub TCP_Connect(Index As Integer)
'------------------------------------------------------------
    txtOutput.Text = txtOutput.Text & "[Connect]" & _
                    "[" & TCP(Index).RemoteHost & "] " & _
                    "[" & TCP(Index).RemoteHostIP & "] " & _
                    "[" & CStr(TCP(Index).RemotePort) & "]" & vbCrLf ' Display connection info
'------------------------------------------------------------
End Sub
'------------------------------------------------------------

'------------------------------------------------------------
Private Sub TCP_DataArrival(Index As Integer, ByVal bytesTotal As Long)
'------------------------------------------------------------
    Dim Data As String
'------------------------------------------------------------
    If (bytesTotal > 0) Then                            ' If there is any data...
        TCP(Index).GetData Data                         ' Get data from TCP Control
        txtOutput.Text = txtOutput.Text & _
                         "[" & TCP(Index).RemoteHost & "] [" & _
                         TCP(Index).RemotePort & "]" & vbCrLf & _
                         Data & "  " & vbCrLf           ' Display data...
    End If
'------------------------------------------------------------
End Sub
'------------------------------------------------------------

