VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
END
Attribute VB_Name = "cBasicSpinner"
Attribute VB_Creatable = False
Attribute VB_Exposed = False
'Class wrapper for the UpDown common control
'Steve Nicholls
'July 1996
Option Explicit

Private Declare Function GetDlgCtrlID Lib "user32" (ByVal hwnd As Long) As Long

Private Declare Function CreateUpDownControl Lib "COMCTL32.DLL" (ByVal dwStyle As Long, ByVal x&, _
    ByVal y&, ByVal cx&, ByVal cy&, ByVal hParent&, ByVal nID&, ByVal hInst&, ByVal hBuddy&, _
    ByVal nUpper&, ByVal nLower&, ByVal nPos&) As Long

'Up-down control styles
Private Const WS_BORDER = &H800000
Private Const WS_CHILD = &H40000000
Private Const WS_VISIBLE = &H10000000
Private Const UDS_WRAP = &H1
Private Const UDS_SETBUDDYINT = &H2
Private Const UDS_ALIGNRIGHT = &H4
Private Const UDS_ALIGNLEFT = &H8
Private Const UDS_ARROWKEYS = &H20
Private Const UDS_HORZ = &H40
Private Const UDS_NOTHOUSANDS = &H80

'Maximum / Mimimum range for spinner control
Private Const UD_MAXVAL = &H7FFF
Private Const UD_MINVAL = (-UD_MAXVAL)

'Up down control messages
Private Const WM_USER = &H400
Private Const UDM_SETRANGE = (WM_USER + 101)
Private Const UDM_GETRANGE = (WM_USER + 102)
Private Const UDM_SETPOS = (WM_USER + 103)
Private Const UDM_GETPOS = (WM_USER + 104)
Private Const UDM_SETBUDDY = (WM_USER + 105)
Private Const UDM_GETBUDDY = (WM_USER + 106)
Private Const UDM_SETACCEL = (WM_USER + 107)
Private Const UDM_GETACCEL = (WM_USER + 108)
Private Const UDM_SETBASE = (WM_USER + 109)
Private Const UDM_GETBASE = (WM_USER + 110)

Private Declare Function SendMessageByNum Lib "user32" Alias "SendMessageA" (ByVal hwnd As Long, ByVal wMsg As Long, ByVal wParam As Long, ByVal lParam As Long) As Long

Private Const WM_CLOSE = &H10
Private Const WM_DESTROY = &H2

Private Declare Function GetWindowLong Lib "user32" Alias "GetWindowLongA" (ByVal hwnd As Long, ByVal nIndex As Long) As Long
Private Declare Function SetWindowLong Lib "user32" Alias "SetWindowLongA" (ByVal hwnd As Long, ByVal nIndex As Long, ByVal dwNewLong As Long) As Long

Private Const GWL_STYLE = (-16)
Private Const GWL_EXSTYLE = (-20)

Private Declare Function SetWindowPos Lib "user32" (ByVal hwnd As Long, ByVal hWndInsertAfter As Long, ByVal x As Long, ByVal y As Long, ByVal cx As Long, ByVal cy As Long, ByVal wFlags As Long) As Long

Private Const SWP_FRAMECHANGED = &H20
Private Const SWP_DRAWFRAME = SWP_FRAMECHANGED
Private Const SWP_HIDEWINDOW = &H80
Private Const SWP_NOACTIVATE = &H10
Private Const SWP_NOCOPYBITS = &H100
Private Const SWP_NOMOVE = &H2
Private Const SWP_NOOWNERZORDER = &H200
Private Const SWP_NOREDRAW = &H8
Private Const SWP_NOREPOSITION = SWP_NOOWNERZORDER
Private Const SWP_NOSIZE = &H1
Private Const SWP_NOZORDER = &H4
Private Const SWP_SHOWWINDOW = &H40


'The following Constant is used to generate unique
'control identifier VB controls are numbered sequentially
'from zero and the maximum theoretical number of controls
'is 8,323,072 (254 control arrays of 32768 items). Therefore
'if we add 10,000,000 to the buddy control's Control identifier
'we know we have a unique number
Private Const CONST_BIGNUMBER = 10000000

'Private member variables
Private mtxtBuddy As TextBox
Private mlHwndUpDown As Long
Public Property Get ArrowKeys() As Boolean
    
    'Returns True if up/down keys are enabled for the spin control
    Dim lStyle As Long
    
    lStyle = GetWindowLong(mlHwndUpDown, GWL_STYLE)
            
    ArrowKeys = CBool(lStyle And UDS_ARROWKEYS)

End Property

Public Property Get Base() As Integer
    
    'Returns the base of the spin control either 10 (decimal)
    'or 16 (hexadecimal)
    Dim lTempValue As Long
    
    lTempValue = SendMessageByNum(hwnd:=mlHwndUpDown, _
        wMsg:=UDM_GETBASE, wParam:=0, lParam:=0)

    Base = CInt(lTempValue)

End Property
Public Property Let Base(iNewValue As Integer)

    'Sets the base for the control - valid values are 10, 16
    Dim lPreviousBase As Long

    'Base must either be decimal or hexadecimal
    If iNewValue <> 10 And iNewValue <> 16 Then
        Err.Raise vbObjectError + 1005, "cBasicSpinner", "Allowable values for Base property are 10 and 16 only"
    Else
        'If the up-down control has been created send
        'a message specifying the new base
        lPreviousBase = SendMessageByNum(hwnd:=mlHwndUpDown, _
            wMsg:=UDM_SETBASE, wParam:=iNewValue, lParam:=0)
    End If

End Property

Public Property Get Border() As Boolean

'Returns True if spin control has a border
Dim lStyle As Long

lStyle = GetWindowLong(mlHwndUpDown, GWL_STYLE)
        
Border = CBool(lStyle And WS_BORDER)
        
End Property
Public Sub Create(txtBuddy As TextBox, Optional viValue, _
    Optional viMinValue, Optional viMaxValue, Optional vbWrap, _
    Optional vbArrowKeys, Optional vbBorder, Optional vbThousands)
    
    'Create the spin control
    Dim lControlID As Long
    Dim lStyle As Long
    Dim iMinValue As Integer
    Dim iMaxValue As Integer
    Dim iValue As Integer
    
    Set mtxtBuddy = txtBuddy
    
    'Get a unique control identifier for the updown control
    lControlID = GetDlgCtrlID(mtxtBuddy.hwnd) + CONST_BIGNUMBER
    
    'Set default style for the up/down control
    'All spin controls are aligned right, however, it would be easy
    'to set them to be aligned left using the UDS_ALIGNLEFT flag
    lStyle = WS_CHILD Or WS_VISIBLE Or UDS_SETBUDDYINT Or UDS_ALIGNRIGHT
    
    'Default is to wrap around at max/min values
    If IsMissing(vbWrap) Or CBool(vbWrap) Then
        lStyle = lStyle Or UDS_WRAP
    End If
    
    'Default is up/down arrow keys enabled
    If IsMissing(vbArrowKeys) Or CBool(vbArrowKeys) Then
        lStyle = lStyle Or UDS_ARROWKEYS
    End If
    
    'Default is border on
    If IsMissing(vbBorder) Or CBool(vbBorder) Then
        lStyle = lStyle Or WS_BORDER
    End If
    
    'Default is no thousands separator
    If IsMissing(vbThousands) Or (Not CBool(vbThousands)) Then
        lStyle = lStyle Or UDS_NOTHOUSANDS
    End If
    
    'Default minimum value is 0
    If IsMissing(viMinValue) Then
        iMinValue = 0
    Else
        iMinValue = CInt(viMinValue)
    End If
    
    'Default maximum value is UD_MAXVAL
    If IsMissing(viMaxValue) Then
        iMaxValue = UD_MAXVAL
    Else
        iMaxValue = CInt(viMaxValue)
    End If
    
    'Default value is zero
    If IsMissing(viValue) Then
        iValue = 0
    Else
        iValue = CInt(viValue)
    End If
    
    'Create the up/down control
    'NB setting the position and size of the up down
    'control has no effect when the UDS_ALIGNLEFT and
    'UDS_ALIGNRIGHT styles are used
    mlHwndUpDown = CreateUpDownControl(lStyle, 0, 0, 0, 0, _
        mtxtBuddy.Parent.hwnd, lControlID, App.hInstance, _
        mtxtBuddy.hwnd, iMaxValue, iMinValue, iValue)
    
End Sub
Public Sub SetRange(iMinValue As Integer, iMaxValue As Integer)

    Dim lNewRange As Long
    Dim lRetVal As Long
    
    'Perform validation for range
    If Abs(CLng(iMaxValue) - iMinValue) > UD_MAXVAL Then
        Err.Raise vbObjectError + 1004, "cBasicSpinner", "Maximum range for the spin control must not exceed " & UD_MAXVAL
    Else
        'We are dealing with a valid range
        lNewRange = lMakeLong(iMinValue, iMaxValue)
    
        lRetVal = SendMessageByNum(hwnd:=mlHwndUpDown, _
            wMsg:=UDM_SETRANGE, wParam:=0&, lParam:=(lNewRange))
    End If

End Sub
Public Property Let Value(iNewValue As Integer)

    Dim lDummy As Long
    Dim lTemp As Long
    
    lTemp = lMakeLong(0, iNewValue)
       
    'Ideally this property should be extended to include a check
    'to ensure the value property falls within the range for the spin control
    lDummy = SendMessageByNum(hwnd:=mlHwndUpDown, wMsg:=UDM_SETPOS, wParam:=0&, lParam:=lTemp)

End Property
Private Function iWordHi(ByVal lLong As Long) As Integer
    iWordHi = (lLong And &HFFFF0000) \ &H10000
End Function

Private Function iWordLo(ByVal lLong As Long) As Integer
    If (lLong And &HFFFF&) > &H7FFF Then
        iWordLo = (lLong And &HFFFF&) - &H10000
    Else
        iWordLo = lLong And &HFFFF&
    End If
End Function
Private Function lMakeLong(vWordHi As Variant, iWordLo As Integer) As Long
   lMakeLong = (vWordHi * &H10000) + (iWordLo And &HFFFF&)
End Function
Public Property Get Value() As Integer

    Dim lTempValue As Long
    Dim bError As Boolean

    'The value of the spin control is retrieved using
    'the UDM_GETPOS message.  Although we could just read
    'the entry in the text control using this method saves
    'us having to worry about a thousands operator being
    'present, and also saves having to worry about whether
    'the value falls in a valid range.
    
    'An error is indicated by a non zero value in the high-order word
    lTempValue = SendMessageByNum(hwnd:=mlHwndUpDown, _
    wMsg:=UDM_GETPOS, wParam:=0, lParam:=0)
                
    bError = CBool(iWordHi(lTempValue))
            
    If bError Then
        'In the event that an error occurs on the following line
        'you should set your error trapping option (on the Advanced
        'Tab of the VB options screen to "Break on Unhandled Errors"
        Err.Raise vbObjectError + 1006, "cBasicSpinner", "The spin control contains an invalid value"
    Else
        Value = iWordLo(lTempValue)
    End If
    
End Property
Public Property Get Thousands() As Boolean

'Returns true if a thousands seperator is shown
Dim lStyle As Long

lStyle = GetWindowLong(mlHwndUpDown, GWL_STYLE)
        
Thousands = Not CBool(lStyle And UDS_NOTHOUSANDS)

End Property
Public Property Get Buddy() As TextBox

    'Returns the buddy control associated with the spinner
    Set Buddy = mtxtBuddy

End Property
Public Property Get Wrap() As Boolean

Dim lStyle As Long

lStyle = GetWindowLong(mlHwndUpDown, GWL_STYLE)
        
Wrap = CBool(lStyle And UDS_WRAP)

End Property
Public Property Get MaxValue() As Integer
    
    Dim lRange As Long

    lRange = SendMessageByNum(hwnd:=mlHwndUpDown, _
        wMsg:=UDM_GETRANGE, wParam:=0&, lParam:=0&)
        
    MaxValue = iWordLo(lRange)

End Property
Public Property Get MinValue() As Integer
    
    Dim lRange As Long

    lRange = SendMessageByNum(hwnd:=mlHwndUpDown, _
        wMsg:=UDM_GETRANGE, wParam:=0&, lParam:=0&)
        
    MinValue = iWordHi(lRange)

End Property
Public Property Let Border(bNewValue As Boolean)

    'Turns spin control border on /off
    Dim lStyle As Long
    Dim lRetVal As Long
    
    lStyle = GetWindowLong(mlHwndUpDown, GWL_STYLE)
    
    If bNewValue Then
        lStyle = lStyle Or WS_BORDER
    Else
        lStyle = lStyle And (&HFFFFFFFF Xor WS_BORDER)
    End If
    
    lStyle = SetWindowLong(mlHwndUpDown, GWL_STYLE, lStyle)
    
    lRetVal = SetWindowPos(hwnd:=mlHwndUpDown, hWndInsertAfter:=mtxtBuddy.Parent.hwnd, _
        x:=0, y:=0, cx:=0, cy:=0, wFlags:=SWP_NOZORDER Or SWP_NOSIZE Or SWP_NOMOVE Or SWP_DRAWFRAME)
    
End Property
Private Sub Class_Terminate()

Dim lTemp As Long

'Although windows should destroy the up-down control when the form
'is unloaded, it is good practice to tidy up after ourselves
'There should be no problem if the controls have already been unloaded
lTemp = SendMessageByNum(hwnd:=mlHwndUpDown, wMsg:=WM_CLOSE, wParam:=0&, lParam:=0&)
lTemp = SendMessageByNum(hwnd:=mlHwndUpDown, wMsg:=WM_DESTROY, wParam:=0&, lParam:=0&)

End Sub


