VERSION 4.00
Begin VB.Form AlarmForm 
   BorderStyle     =   1  'Fixed Single
   Caption         =   "Alarm Clock"
   ClientHeight    =   1065
   ClientLeft      =   3750
   ClientTop       =   4020
   ClientWidth     =   2685
   BeginProperty Font 
      name            =   "MS Sans Serif"
      charset         =   0
      weight          =   700
      size            =   8.25
      underline       =   0   'False
      italic          =   0   'False
      strikethrough   =   0   'False
   EndProperty
   Height          =   1470
   Icon            =   "Alarm.frx":0000
   Left            =   3690
   LinkTopic       =   "Form2"
   LockControls    =   -1  'True
   MaxButton       =   0   'False
   ScaleHeight     =   71
   ScaleMode       =   3  'Pixel
   ScaleWidth      =   179
   Top             =   3675
   Width           =   2805
   Begin VB.CommandButton Command1 
      Caption         =   "Set Alarm"
      BeginProperty Font 
         name            =   "MS Sans Serif"
         charset         =   0
         weight          =   400
         size            =   8.25
         underline       =   0   'False
         italic          =   0   'False
         strikethrough   =   0   'False
      EndProperty
      Height          =   315
      Left            =   120
      TabIndex        =   1
      Top             =   660
      Width           =   2415
   End
   Begin VB.Timer Timer1 
      Interval        =   500
      Left            =   660
      Top             =   60
   End
   Begin VB.PictureBox picTime 
      Height          =   435
      Left            =   120
      ScaleHeight     =   375
      ScaleWidth      =   2355
      TabIndex        =   0
      Top             =   120
      Width           =   2415
   End
End
Attribute VB_Name = "AlarmForm"
Attribute VB_Creatable = False
Attribute VB_Exposed = False
' Sample program that comes with VB.
' Adapted for VBMaxLCD.dll by Mike Stanley

Option Explicit
Dim Readout As New clsLCD
Dim AlarmTime

Const conMinimized = 1


Private Sub Form_Load()
     
    With Readout
        .Alignment = gnCENTER
        .ShowUnlitSegments = False
        .ForeColor = &H8080&
        Set .Container = picTime
    End With

    AlarmTime = ""
    
End Sub

Private Sub Form_Resize()
    If WindowState = conMinimized Then      ' If form is minimized, display the time in a caption.
        SetCaptionTime
    Else
        Caption = "Alarm Clock"
    End If
End Sub

Private Sub SetCaptionTime()
    Caption = Format(Time, "Medium Time")   ' Display time using medium time format.
End Sub

Private Sub Form_Unload(Cancel As Integer)
    Set Readout = Nothing
    Set AlarmForm = Nothing
End Sub

Private Sub Timer1_Timer()
Static AlarmSounded As Integer
    If Readout.Caption <> CStr(Time) Then
        ' It's now a different second than the one displayed.
        If Time >= AlarmTime And Not AlarmSounded Then
            Beep
            MsgBox "Alarm at " & Time
            AlarmSounded = True
        ElseIf Time < AlarmTime Then
            AlarmSounded = False
        End If
        If WindowState = conMinimized Then
            ' If minimized, then update the form's Caption every minute.
            If Minute(CDate(Caption)) <> Minute(Time) Then SetCaptionTime
        Else
            ' Otherwise, update the label Caption in the form every second.
            Readout.Caption = Time
        End If
    End If
End Sub

Private Sub Command1_Click()
    AlarmTime = InputBox("Enter alarm time", "VB Alarm", AlarmTime)
    If AlarmTime = "" Then Exit Sub
    If Not IsDate(AlarmTime) Then
        MsgBox "The time you entered was not valid."
    Else                                    ' String returned from InputBox is a valid time,
        AlarmTime = CDate(AlarmTime)        ' so store it as a date/time value in AlarmTime.
    End If
End Sub

