VERSION 4.00
Begin VB.Form Form1 
   BorderStyle     =   1  'Fixed Single
   Caption         =   "News Summary"
   ClientHeight    =   6270
   ClientLeft      =   255
   ClientTop       =   480
   ClientWidth     =   8475
   Height          =   6675
   Icon            =   "NEWS.frx":0000
   Left            =   195
   LinkTopic       =   "Form1"
   MaxButton       =   0   'False
   ScaleHeight     =   6270
   ScaleWidth      =   8475
   Top             =   135
   Width           =   8595
   Begin VB.TextBox txtNews 
      BeginProperty Font 
         name            =   "Arial"
         charset         =   0
         weight          =   400
         size            =   9.75
         underline       =   0   'False
         italic          =   -1  'True
         strikethrough   =   0   'False
      EndProperty
      Height          =   5145
      Left            =   225
      MultiLine       =   -1  'True
      ScrollBars      =   2  'Vertical
      TabIndex        =   0
      Top             =   810
      Width           =   6720
   End
   Begin dsSocketLib.dsSocket dsSocket1 
      Height          =   420
      Left            =   7320
      TabIndex        =   2
      Top             =   360
      Width           =   420
      _version        =   65542
      _extentx        =   741
      _extenty        =   741
      _stockprops     =   64
      localport       =   0
      remotehost      =   ""
      remoteport      =   0
      servicename     =   ""
      remotedotaddr   =   ""
      datasize        =   2048
      linger          =   0   'False
      timeout         =   10
      linemode        =   0   'False
      eolchar         =   0
      bindconnect     =   0   'False
      sockettype      =   0
   End
   Begin VB.Label Label1 
      AutoSize        =   -1  'True
      Caption         =   "Reuters New Media internetMCI Daily News Summary"
      BeginProperty Font 
         name            =   "Arial"
         charset         =   0
         weight          =   400
         size            =   14.25
         underline       =   0   'False
         italic          =   -1  'True
         strikethrough   =   0   'False
      EndProperty
      Height          =   330
      Left            =   180
      TabIndex        =   1
      Top             =   135
      Width           =   7395
   End
End
Attribute VB_Name = "Form1"
Attribute VB_Creatable = False
Attribute VB_Exposed = False

Option Explicit

'-- Used to tell us when we've connected
Private nConnected As Integer

'-- Stores received data
Private szNews As String

Private Function szStripHTML(szString As String) As String

    Dim szTemp As String
    Dim szResult As String
    Dim nPos As Integer
    Dim nMarker As Integer
    
    '-- Copy the argument into a local
    '   string so the original does not
    '   get whacked.
    szTemp = szString
    
    '-- Remove HTML codes
    Do
        nPos = InStr(szTemp, "<")
        If nPos = False Then
            Exit Do
        Else
            '-- szResult contains the final
            '   product of this routine.
            szResult = szResult & _
                Left$(szTemp, nPos - 1)
            '-- szTemp is the working string,
            '   which is continuously
            '   shortened as new codes
            '   are found
            szTemp = Mid$(szTemp, nPos + 1)
            nPos = InStr(szTemp, ">")
            If nPos = False Then
                '-- No complimentary arrow
                '   was found.
                Exit Do
            Else
                '-- Shorten the working
                '   string
                szTemp = Mid$(szTemp, _
                    nPos + 1)
            End If
        End If
    Loop
    
    '-- Find a marker byte by looking for
    '   a char that does not already exist
    '   in the string.
    For nMarker = 255 To 1 Step -1
        If InStr(szResult, Chr$(nMarker)) _
            = 0 Then
            Exit For
        End If
    Next
    
    '-- Remove carriage returns
    Do
        nPos = InStr(szResult, Chr$(13))
        If nPos Then
            szResult = Left$(szResult, _
                nPos - 1) & Mid$(szResult, _
                nPos + 1)
        Else
            Exit Do
        End If
    Loop

    '-- Replace linefeeds with Marker bytes
    Do
        nPos = InStr(szResult, Chr$(10))
        If nPos Then
            szResult = Left$(szResult, _
                nPos - 1) & Chr$(nMarker) _
                & Mid$(szResult, nPos + 1)
        Else
            Exit Do
        End If
    Loop

    '-- Replace marker bytes with CR/LF pairs
    Do
        nPos = InStr(szResult, Chr$(nMarker))
        If nPos Then
            szResult = Left$(szResult, _
                nPos - 1) & Chr$(13) & Chr$(10) _
                & Trim$(Mid$(szResult, nPos + 1))
        Else
            Exit Do
        End If
    Loop

    '-- Thats all for this routine!
    szStripHTML = szResult

End Function

Private Sub DSSocket1_Close(ErrorCode As Integer, ErrorDesc As String)

    '-- Display the news string after converting
    '   it to straight text
    txtNews = szStripHTML(szNews)
    
    '-- Re-enable the form and reset the mouse
    '   pointer
    Screen.MousePointer = vbDefault
    Enabled = True

End Sub

Private Sub DSSocket1_Connect()

    '-- Set this flag indicating we've connected
    nConnected = True

End Sub


Private Sub DSSocket1_Receive(ReceiveData As String)

    '-- Data was received. Add to the module-level
    '   string variable
    szNews = szNews & ReceiveData

End Sub


Private Sub Form_Load()
    
    '-- Temporarily disable the form and set the hourglass cursor
    Enabled = False
    Screen.MousePointer = vbHourglass
    
    '-- Show the form
    Show
    
    '-- Connect to the internetMCI server
    DSSocket1.RemotePort = 80
    DSSocket1.RemoteHost = "www.fyionline.com"
    On Error Resume Next
    DSSocket1.Action = 2    'SOCK_ACTION_CONNECT
    
    If Err Then
        '-- There was an error. Re-enable the form
        '   and reset the mouse pointer
        Screen.MousePointer = vbDefault
        Enabled = True
        
        '-- Display the error
        MsgBox "Error connecting: " & Error
        Exit Sub
    Else
        '-- Wait until we've connected
        nConnected = False
        Do
            DoEvents
        Loop Until nConnected
    
        '-- Initialize the szNews module-level variable,
        '   which holds the received data.
        szNews = ""
        
        '-- Send the command to retrieve the daily news summary
        DSSocket1.Send = "GET /infoMCI/update/NEWS-MCI.html" & _
            Chr$(13) & Chr$(10) & Chr$(13) & Chr$(10)
    End If
    
End Sub


