Attribute VB_Name = "Module2"
Option Explicit
'==========================================================================
'Copyright (c) 1992-1995, SunOpTech, Inc., All Rights Reserved
'
'       Program Name: SUNOP.BAS
'Program Description: General SunOpTech routines
'
'             Author: Chris Barlow
'       Date Created: May 2, 1994
'
'      Revision History
'   Who     Date    Comment
'   CRB  5-May-1994
'   CRB  5-Dec-1994 modify Match to change to variant and add compare if null
'   CRB  5-Jan-1995 added gProcessing global
'   SJS 13-Jun-1995 Include system constants
'
'
'Discussion:
'******  DO NOT MODIFY!  ******
'
'
'===========================================================================
'
'Global application variables
Global DBPath As String     'for path to database
Global DBType As String     'for type of db, "dbase iv"
Global C9 As String
Global CRLF As String
Global gProcessing As Integer
Global gDebugMsg

'---------------------------------------------------------------------------------------
'Windows API Declarations
'
'Timer
Declare Function GetTickCount Lib "User" () As Long

'These work with Clear...Box
Declare Function SendMessage% Lib "User" (ByVal hWnd%, ByVal wMsg%, ByVal wparam%, ByVal lParam As Any)
Declare Function SendMess& Lib "User" Alias "SendMessage" (ByVal hWnd%, ByVal wMsg%, ByVal wparam%, lParam As Any)
Declare Function GetFocus% Lib "User" ()
Declare Function GetParent% Lib "User" (ByVal hWnd%)
Declare Function SetParent Lib "User" (ByVal hWndChild%, ByVal hWndParent%) As Integer
Declare Function PutFocus% Lib "User" Alias "SetFocus" (ByVal hWnd%)
Declare Function GetFreeSpace Lib "Kernel" (ByVal wFlags As Integer) As Long
Declare Function GetWinFlags Lib "Kernel" () As Long
Declare Function GetFreeSystemResources Lib "User" (ByVal fuSysResource As Integer) As Integer

Global Const WM_USER = &H400
Global Const LB_ADDSTRING = WM_USER + 1
Global Const LB_RESETCONTENT = WM_USER + 5
Global Const LB_FINDSTRING = WM_USER + 16
Global Const CB_RESETCONTENT = WM_USER + 11
Global Const CB_ADDSTRING = WM_USER + 3
Global Const CB_FINDSTRING = WM_USER + 12
Global Const CB_SELECTSTRING = WM_USER + 13
Global Const CB_SHOWDROPDOWN = WM_USER + 15
Global Const EM_SETSEL = WM_USER + 1
Global Const EM_GETLINECOUNT = WM_USER + 10
Global Const EM_GETLINE = WM_USER + 20
Global Const EM_SETREADONLY = WM_USER + 31
Global Const EM_SETTABSTOPS = WM_USER + 27
Global Const LB_SETTABSTOPS = WM_USER + 19

Global Const WF_STANDARD = &H10
Global Const WF_ENHANCED = &H20
Global Const WF_80x87 = &H400


'These work with the INI file:
Declare Function GetPrivateProfileInt Lib "Kernel" (ByVal lpApplicationName As String, ByVal lpKeyName As String, ByVal nDefault As Integer, ByVal lpFileName As String) As Integer
Declare Function GetPrivateProfileString Lib "Kernel" (ByVal lpApplicationName As String, ByVal lpKeyName As String, ByVal lpDefault As String, ByVal lpReturnedString As String, ByVal nSize As Integer, ByVal lpFileName As String) As Integer
Declare Function GetINISections Lib "Kernel" Alias "GetPrivateProfileString" (ByVal lpAppName$, ByVal lpKeynum&, ByVal lpDef&, ByVal lpBuffer$, ByVal nSize%, ByVal lpFileName$) As Integer
Declare Function WritePrivateProfileString Lib "Kernel" (ByVal lpApplicationName As String, ByVal lpKeyName As Any, ByVal lpString As Any, ByVal lplFileName As String) As Integer
Declare Function GetProfileString Lib "Kernel" (ByVal lpApplicationName As String, ByVal lpKeyName As String, ByVal lpDefault As String, ByVal lpReturnedString As String, ByVal nSize As Integer) As Integer

'These work with windows
Declare Function GetWindowLong Lib "User" (ByVal hWnd%, ByVal nIndex%) As Long
Declare Function SetWindowLong Lib "User" (ByVal hWnd%, ByVal nIndex%, ByVal dwNewLong&) As Long
Declare Function SetMessage Lib "User" (ByVal hWnd%, ByVal nMsg%, ByVal wparam%, ByVal lParam&) As Long
Declare Function GetSystemMenu Lib "User" (ByVal hWnd%, ByVal bRevert)
Declare Function ModifyMenu Lib "User" (ByVal hMenu, ByVal nPosition, ByVal wFlags, ByVal wIDnewItem, ByVal lpNewItems$)
Declare Function DeleteMenu Lib "User" (ByVal hMenu, ByVal nPosition, ByVal wFlags)


'API function used by SelectItem

'these work with files
Type OFSTRUCT
    cBytes As String * 1
    fFixedDisk As String * 1
    nErrCode As Integer
    Reserved As String * 4
    szPathName As String * 128
End Type
Global OFFILE As OFSTRUCT
Global Const OF_DELETE = &H200

Declare Function OpenFile Lib "Kernel" (ByVal lpFileName As String, lpReOpenBuff As OFSTRUCT, ByVal wStyle As Integer) As Integer
Declare Function lopen Lib "Kernel" Alias "_lopen" (ByVal lpPathName As String, ByVal iReadWrite As Integer) As Integer
Declare Function lclose Lib "Kernel" Alias "_lclose" (ByVal hFile As Integer) As Integer
Declare Function lcreat Lib "Kernel" Alias "_lcreat" (ByVal lpPathName As String, ByVal iAttribute As Integer) As Integer
Declare Function llseek Lib "Kernel" Alias "_llseek" (ByVal hFile As Integer, ByVal lOffset As Long, ByVal iOrigin As Integer) As Long
Declare Function lread Lib "Kernel" Alias "_lread" (ByVal hFile As Integer, ByVal lpBuffer As String, ByVal wBytes As Integer) As Integer
Declare Function lwrite Lib "Kernel" Alias "_lwrite" (ByVal hFile As Integer, ByVal lpBuffer As String, ByVal wBytes As Integer) As Integer
Declare Function Crc32 Lib "CRC32.DLL" (ByVal f$) As Long

'these work with clipboard
Declare Function OpenClipboard Lib "User" (ByVal hWnd As Integer) As Integer
Declare Function EmptyClipboard Lib "User" () As Integer
Declare Function SetClipboardData Lib "User" (ByVal wFormat As Integer, ByVal hMem As Integer) As Integer
Declare Function GetClipboardData Lib "User" (ByVal wFormat As Integer) As Integer
Declare Function CloseClipboard Lib "User" () As Integer
Declare Function IsClipboardFormatAvailable Lib "User" (ByVal wFormat As Integer) As Integer
Declare Function RegisterClipboardFormat Lib "User" (ByVal lpString As String) As Integer
Declare Function GlobalAlloc Lib "Kernel" (ByVal wFlags As Integer, ByVal dwBytes As Long) As Integer
Declare Function GlobalFree Lib "Kernel" (ByVal hMem As Integer) As Integer
Declare Function GlobalLock Lib "Kernel" (ByVal hMem As Integer) As Long
Declare Function GlobalUnlock Lib "Kernel" (ByVal hMem As Integer) As Integer
Declare Function GlobalHandleToSel Lib "toolhelp.dll" (ByVal hMem%) As Integer
Declare Function MemoryWrite Lib "toolhelp.dll" (ByVal wSel%, ByVal dwOffset&, lpvBuf As Any, ByVal dwcb&) As Long
Declare Function MemoryRead Lib "toolhelp.dll" (ByVal wSel%, ByVal dwOffset&, lpvBuf As Any, ByVal dwcb&) As Long

Global Const GMEM_MOVEABLE = &H2
Global Const GMEM_ZEROINIT = &H40
Global Const GHND = (GMEM_MOVEABLE Or GMEM_ZEROINIT)
Global Const CF_LINK = &HBF00
Global Const CF_TEXT = 1
Global Const CF_BITMAP = 2
Global Const CF_METAFILE = 3
Global Const CF_DIB = 8

Declare Function WNetGetUser% Lib "User" (ByVal User$, BufSize%)

'------------------------------------------------------------------------------
'From VB\CONSTANT.TXT

' DragOver
Global Const ENTER = 0
Global Const LEAVE = 1
Global Const OVER = 2

' Drag (controls)
Global Const CANCEL = 0
Global Const BEGIN_DRAG = 1
Global Const END_DRAG = 2

' Show parameters
Global Const MODAL = 1
Global Const MODELESS = 0

' Key Codes
Global Const KEY_LBUTTON = &H1
Global Const KEY_RBUTTON = &H2
Global Const KEY_CANCEL = &H3
Global Const KEY_MBUTTON = &H4    ' NOT contiguous with L & RBUTTON
Global Const KEY_BACK = &H8
Global Const KEY_TAB = &H9
Global Const KEY_CLEAR = &HC
Global Const KEY_RETURN = &HD
Global Const KEY_SHIFT = &H10
Global Const KEY_CONTROL = &H11
Global Const KEY_MENU = &H12
Global Const KEY_PAUSE = &H13
Global Const KEY_CAPITAL = &H14
Global Const KEY_ESCAPE = &H1B
Global Const KEY_SPACE = &H20
Global Const KEY_PRIOR = &H21
Global Const KEY_NEXT = &H22
Global Const KEY_END = &H23
Global Const KEY_HOME = &H24
Global Const KEY_LEFT = &H25
Global Const KEY_UP = &H26
Global Const KEY_RIGHT = &H27
Global Const KEY_DOWN = &H28
Global Const KEY_SELECT = &H29
Global Const KEY_PRINT = &H2A
Global Const KEY_EXECUTE = &H2B
Global Const KEY_SNAPSHOT = &H2C
Global Const KEY_INSERT = &H2D
Global Const KEY_DELETE = &H2E
Global Const KEY_HELP = &H2F

' KEY_A thru KEY_Z are the same as their ASCII equivalents: 'A' thru 'Z'
' KEY_0 thru KEY_9 are the same as their ASCII equivalents: '0' thru '9'

Global Const KEY_NUMPAD0 = &H60
Global Const KEY_NUMPAD1 = &H61
Global Const KEY_NUMPAD2 = &H62
Global Const KEY_NUMPAD3 = &H63
Global Const KEY_NUMPAD4 = &H64
Global Const KEY_NUMPAD5 = &H65
Global Const KEY_NUMPAD6 = &H66
Global Const KEY_NUMPAD7 = &H67
Global Const KEY_NUMPAD8 = &H68
Global Const KEY_NUMPAD9 = &H69
Global Const KEY_MULTIPLY = &H6A
Global Const KEY_ADD = &H6B
Global Const KEY_SEPARATOR = &H6C
Global Const KEY_SUBTRACT = &H6D
Global Const KEY_DECIMAL = &H6E
Global Const KEY_DIVIDE = &H6F
Global Const KEY_F1 = &H70
Global Const KEY_F2 = &H71
Global Const KEY_F3 = &H72
Global Const KEY_F4 = &H73
Global Const KEY_F5 = &H74
Global Const KEY_F6 = &H75
Global Const KEY_F7 = &H76
Global Const KEY_F8 = &H77
Global Const KEY_F9 = &H78
Global Const KEY_F10 = &H79
Global Const KEY_F11 = &H7A
Global Const KEY_F12 = &H7B
Global Const KEY_F13 = &H7C
Global Const KEY_F14 = &H7D
Global Const KEY_F15 = &H7E
Global Const KEY_F16 = &H7F

Global Const KEY_NUMLOCK = &H90

' Variant VarType tags

Global Const V_EMPTY = 0
Global Const V_NULL = 1
Global Const V_INTEGER = 2
Global Const V_LONG = 3
Global Const V_SINGLE = 4
Global Const V_DOUBLE = 5
Global Const V_CURRENCY = 6
Global Const V_DATE = 7
Global Const V_STRING = 8


' Properties

' Colors
Global Const BLACK = &H0&
Global Const RED = &HFF&
Global Const GREEN = &HFF00&
Global Const YELLOW = &HFFFF&
Global Const BLUE = &HFF0000
Global Const MAGENTA = &HFF00FF
Global Const CYAN = &HFFFF00
Global Const WHITE = &HFFFFFF

' System Colors
Global Const SCROLL_BARS = &H80000000           ' Scroll-bars gray area.
Global Const DESKTOP = &H80000001               ' Desktop.
Global Const ACTIVE_TITLE_BAR = &H80000002      ' Active window caption.
Global Const INACTIVE_TITLE_BAR = &H80000003    ' Inactive window caption.
Global Const MENU_BAR = &H80000004              ' Menu background.
Global Const WINDOW_BACKGROUND = &H80000005     ' Window background.
Global Const WINDOW_FRAME = &H80000006          ' Window frame.
Global Const MENU_TEXT = &H80000007             ' Text in menus.
Global Const WINDOW_TEXT = &H80000008           ' Text in windows.
Global Const TITLE_BAR_TEXT = &H80000009        ' Text in caption, size box, scroll-bar arrow box..
Global Const ACTIVE_BORDER = &H8000000A         ' Active window border.
Global Const INACTIVE_BORDER = &H8000000B       ' Inactive window border.
Global Const APPLICATION_WORKSPACE = &H8000000C ' Background color of multiple document interface (MDI) applications.
Global Const HIGHLIGHT = &H8000000D             ' Items selected item in a control.
Global Const HIGHLIGHT_TEXT = &H8000000E        ' Text of item selected in a control.
Global Const BUTTON_FACE = &H8000000F           ' Face shading on command buttons.
Global Const BUTTON_SHADOW = &H80000010         ' Edge shading on command buttons.
Global Const GRAY_TEXT = &H80000011             ' Grayed (disabled) text.  This color is set to 0 if the current display driver does not support a solid gray color.
Global Const BUTTON_TEXT = &H80000012           ' Text on push buttons.

' MousePointer
Global Const DEFAULT = 0        ' 0 - Default
Global Const ARROW = 1          ' 1 - Arrow
Global Const CROSSHAIR = 2      ' 2 - Cross
Global Const IBEAM = 3          ' 3 - I-Beam
Global Const ICON_POINTER = 4   ' 4 - Icon
Global Const SIZE_POINTER = 5   ' 5 - Size
Global Const SIZE_NE_SW = 6     ' 6 - Size NE SW
Global Const SIZE_N_S = 7       ' 7 - Size N S
Global Const SIZE_NW_SE = 8     ' 8 - Size NW SE
Global Const SIZE_W_E = 9       ' 9 - Size W E
Global Const UP_ARROW = 10      ' 10 - Up Arrow
Global Const HOURGLASS = 11     ' 11 - Hourglass
Global Const NO_DROP = 12       ' 12 - No drop

' WindowState
Global Const NORMAL = 0    ' 0 - Normal
Global Const MINIMIZED = 1 ' 1 - Minimized
Global Const MAXIMIZED = 2 ' 2 - Maximized

' Check Value
Global Const UNCHECKED = 0 ' 0 - Unchecked
Global Const CHECKED = 1   ' 1 - Checked
Global Const GRAYED = 2    ' 2 - Grayed

' Function Parameters
' MsgBox parameters
Global Const MB_OK = 0                 ' OK button only
Global Const MB_OKCANCEL = 1           ' OK and Cancel buttons
Global Const MB_ABORTRETRYIGNORE = 2   ' Abort, Retry, and Ignore buttons
Global Const MB_YESNOCANCEL = 3        ' Yes, No, and Cancel buttons
Global Const MB_YESNO = 4              ' Yes and No buttons
Global Const MB_RETRYCANCEL = 5        ' Retry and Cancel buttons

Global Const MB_ICONSTOP = 16          ' Critical message
Global Const MB_ICONQUESTION = 32      ' Warning query
Global Const MB_ICONEXCLAMATION = 48   ' Warning message
Global Const MB_ICONINFORMATION = 64   ' Information message

Global Const MB_APPLMODAL = 0          ' Application Modal Message Box
Global Const MB_DEFBUTTON1 = 0         ' First button is default
Global Const MB_DEFBUTTON2 = 256       ' Second button is default
Global Const MB_DEFBUTTON3 = 512       ' Third button is default
Global Const MB_SYSTEMMODAL = 4096      'System Modal

' MsgBox return values
Global Const IDOK = 1                  ' OK button pressed
Global Const IDCANCEL = 2              ' Cancel button pressed
Global Const IDABORT = 3               ' Abort button pressed
Global Const IDRETRY = 4               ' Retry button pressed
Global Const IDIGNORE = 5              ' Ignore button pressed
Global Const IDYES = 6                 ' Yes button pressed
Global Const IDNO = 7                  ' No button pressed

'---------------------------------------------------------
'      Table of Contents for Visual Basic Professional
'
'       1.  3-D Controls
'           (Frame/Panel/Option/Check/Command/Group Push)
'       2.  Animated Button
'       3.  Gauge Control
'       4.  Graph Control Section
'       5.  Key Status Control
'       6.  Spin Button
'       7.  MCI Control (Multimedia)
'       8.  Masked Edit Control
'       9.  Comm Control
'       10. Outline Control
'---------------------------------------------------------

'---------------------------------------
'Key Status Control
'---------------------------------------
'Style
Global Const KEYSTAT_CAPSLOCK = 0
Global Const KEYSTAT_NUMLOCK = 1
Global Const KEYSTAT_INSERT = 2
Global Const KEYSTAT_SCROLLLOCK = 3

'---------------------------------------
'Spin Button
'---------------------------------------
'SpinOrientation
Global Const SPIN_VERTICAL = 0
Global Const SPIN_HORIZONTAL = 1

'---------------------------------------
'Masked Edit Control
'---------------------------------------
'ClipMode
Global Const ME_INCLIT = 0
Global Const ME_EXCLIT = 1
'-----------------------------------
'Common Dialog Control
'-----------------------------------
'Action Property
Global Const DLG_FILE_OPEN = 1
Global Const DLG_FILE_SAVE = 2
Global Const DLG_COLOR = 3
Global Const DLG_FONT = 4
Global Const DLG_PRINT = 5
Global Const DLG_HELP = 6

'File Open/Save Dialog Flags
Global Const OFN_READONLY = &H1&
Global Const OFN_OVERWRITEPROMPT = &H2&
Global Const OFN_HIDEREADONLY = &H4&
Global Const OFN_NOCHANGEDIR = &H8&
Global Const OFN_SHOWHELP = &H10&
Global Const OFN_NOVALIDATE = &H100&
Global Const OFN_ALLOWMULTISELECT = &H200&
Global Const OFN_EXTENTIONDIFFERENT = &H400&
Global Const OFN_PATHMUSTEXIST = &H800&
Global Const OFN_FILEMUSTEXIST = &H1000&
Global Const OFN_CREATEPROMPT = &H2000&
Global Const OFN_SHAREAWARE = &H4000&
Global Const OFN_NOREADONLYRETURN = &H8000&

'Printer Dialog Flags
Global Const PD_ALLPAGES = &H0&
Global Const PD_SELECTION = &H1&
Global Const PD_PAGENUMS = &H2&
Global Const PD_NOSELECTION = &H4&
Global Const PD_NOPAGENUMS = &H8&
Global Const PD_COLLATE = &H10&
Global Const PD_PRINTTOFILE = &H20&
Global Const PD_PRINTSETUP = &H40&
Global Const PD_NOWARNING = &H80&
Global Const PD_RETURNDC = &H100&
Global Const PD_RETURNIC = &H200&
Global Const PD_RETURNDEFAULT = &H400&
Global Const PD_SHOWHELP = &H800&
Global Const PD_USEDEVMODECOPIES = &H40000
Global Const PD_DISABLEPRINTTOFILE = &H80000
Global Const PD_HIDEPRINTTOFILE = &H100000

' WinHelp API declaration
Declare Function WinHelp Lib "User" (ByVal hWnd As Integer, ByVal lpHelpFile As String, ByVal wCommand As Integer, dwData As Any) As Integer
'Help Constants
Global Const HELP_CONTEXT = &H1           'Display topic in ulTopic
Global Const HELP_QUIT = &H2              'Terminate help
Global Const HELP_INDEX = &H3             'Display index
Global Const HELP_CONTENTS = &H3
Global Const HELP_HELPONHELP = &H4        'Display help on using help
Global Const HELP_SETINDEX = &H5          'Set the current Index for multi index help
Global Const HELP_SETCONTENTS = &H5
Global Const HELP_CONTEXTPOPUP = &H8
Global Const HELP_FORCEFILE = &H9
Global Const HELP_KEY = &H101             'Display topic for keyword in offabData
Global Const HELP_COMMAND = &H102
Global Const HELP_PARTIALKEY = &H105      'call the search engine in winhelp
'---------------------------------------
'OLE 2 Client Control
'Actions
Global Const OLE_CREATE_EMBED = 0
Global Const OLE_CREATE_NEW = 0           'from ole1 control
Global Const OLE_CREATE_LINK = 1
Global Const OLE_CREATE_FROM_FILE = 1     'from ole1 control
Global Const OLE_COPY = 4
Global Const OLE_PASTE = 5
Global Const OLE_UPDATE = 6
Global Const OLE_ACTIVATE = 7
Global Const OLE_CLOSE = 9
Global Const OLE_DELETE = 10
Global Const OLE_SAVE_TO_FILE = 11
Global Const OLE_READ_FROM_FILE = 12
Global Const OLE_INSERT_OBJ_DLG = 14
Global Const OLE_PASTE_SPECIAL_DLG = 15
Global Const OLE_FETCH_VERBS = 17
Global Const OLE_SAVE_TO_OLE1FILE = 18

'OLEType
Global Const OLE_LINKED = 0
Global Const OLE_EMBEDDED = 1
Global Const OLE_NONE = 3

'OLETypeAllowed
Global Const OLE_EITHER = 2

'UpdateOptions
Global Const OLE_AUTOMATIC = 0
Global Const OLE_FROZEN = 1
Global Const OLE_MANUAL = 2

'AutoActivate modes
'Note that OLE_ACTIVATE_GETFOCUS only applies to objects that
'support "inside-out" activation.  See related Verb notes below.
Global Const OLE_ACTIVATE_MANUAL = 0
Global Const OLE_ACTIVATE_GETFOCUS = 1
Global Const OLE_ACTIVATE_DOUBLECLICK = 2

'SizeModes
Global Const OLE_SIZE_CLIP = 0
Global Const OLE_SIZE_STRETCH = 1
Global Const OLE_SIZE_AUTOSIZE = 2

'DisplayTypes
Global Const OLE_DISPLAY_CONTENT = 0
Global Const OLE_DISPLAY_ICON = 1

'Update Event Constants
Global Const OLE_CHANGED = 0
Global Const OLE_SAVED = 1
Global Const OLE_CLOSED = 2
Global Const OLE_RENAMED = 3

'Special Verb Values
Global Const VERB_PRIMARY = 0
Global Const VERB_SHOW = -1
Global Const VERB_OPEN = -2
Global Const VERB_HIDE = -3
Global Const VERB_INPLACEUIACTIVATE = -4
Global Const VERB_INPLACEACTIVATE = -5
'The last two verbs are for objects that support "inside-out" activation,
'meaning they can be edited in-place, and that they support being left
'in-place-active even when the input focus moves to another control or form.
'These objects actually have 2 levels of being active.  "InPlace Active"
'means that the object is ready for the user to click inside it and start
'working with it.  "In-Place UI-Active" means that, in addition, if the object
'has any other UI associated with it, such as floating palette windows,
'that those windows are visible and ready for use.  Any number of objects
'can be "In-Place Active" at a time, although only one can be
'"InPlace UI-Active".

'You can cause an object to move to either one of states programmatically by
'setting the Verb property to the appropriate verb and setting
'Action=OLE_ACTIVATE.

'Also, if you set AutoActivate = OLE_ACTIVATE_GETFOCUS, the server will
'automatically be put into "InPlace UI-Active" state when the user clicks
'on or tabs into the control.

'VerbFlag Bit Masks
Global Const VERBFLAG_GRAYED = &H1
Global Const VERBFLAG_DISABLED = &H2
Global Const VERBFLAG_CHECKED = &H8
Global Const VERBFLAG_SEPARATOR = &H800

'MiscFlag Bits - Or these together as desired for special behaviors

'MEMSTORAGE causes the control to use memory to store the object while
'           it is loaded.  This is faster than the default (disk-tempfile),
'           but can consume a lot of memory for objects whose data takes
'           up a lot of space, such as the bitmap for a paint program.
Global Const OLE_MISCFLAG_MEMSTORAGE = &H1

'DISABLEINPLACE overrides the control's default behavior of allowing
'           in-place activation for objects that support it.  If you
'           are having problems activating an object inplace, you can
'           force it to always activate in a separate window by setting this
'           bit
Global Const OLE_MISCFLAG_DISABLEINPLACE = &H2
'*************************
Global Const EM_SETPASSWORDCHAR = WM_USER + 28
Global Const ES_PASSWORD = &H20
Global Const GWL_STYLE = -16
Global Const MF_BYCOMMAND = 0
Global Const MF_BYPOSITION = &H400
Global Const SC_TASKLIST = &HF130

'DragDrop API
Type POINTAPI           'used to identify location of drop action
        X As Integer
        Y As Integer
End Type
Type Msg                'used by peekmessage function
        hWnd As Integer
        message As Integer
        wparam As Integer
        lParam As Long
        time As Long
        pt As POINTAPI
End Type

'dragacceptfiles tells windows that hwnd can accept drag/drop messages
Declare Sub DragAcceptFiles Lib "Shell" (ByVal hWnd As Integer, ByVal Accept As Integer)
'Main() uses peekmessage to determine if hwnd has received a d/d message
Declare Function PeekMessage Lib "User" (lpMsg As Msg, ByVal hWnd As Integer, ByVal wMsgFilterMin As Integer, ByVal wMsgFilterMax As Integer, ByVal wRemoveMsg As Integer) As Integer
'dragqueryfile is used to get number of files dropped (when indexFilenum=-1) and then name of each file in succession (when indexFilenum > -1)
Declare Function DragQueryFile Lib "Shell" (ByVal hdrop As Integer, ByVal indexFilenum As Integer, ByVal lpFileName As String, ByVal buffsize As Integer) As Integer
'dragfinish must be called after all filenames have been retrieved to cancel memory buffer for d/d operation
Declare Sub DragFinish Lib "Shell" (ByVal hWnd As Integer)

'----------------------------------------------------------------------------------------
' Data Access constants - from VB\DATACONS.TXT
'
' Option argument values (CreateDynaset, etc)
Global Const DB_DENYWRITE = &H1
Global Const DB_DENYREAD = &H2
Global Const DB_READONLY = &H4
Global Const DB_APPENDONLY = &H8
Global Const DB_INCONSISTENT = &H10
Global Const DB_CONSISTENT = &H20
Global Const DB_SQLPASSTHROUGH = &H40

' SetDataAccessOption
Global Const DB_OPTIONINIPATH = 1

' Field Attributes
Global Const DB_FIXEDFIELD = &H1
Global Const DB_VARIABLEFIELD = &H2
Global Const DB_AUTOINCRFIELD = &H10
Global Const DB_UPDATABLEFIELD = &H20

' Field Data Types
Global Const DB_BOOLEAN = 1
Global Const DB_BYTE = 2
Global Const DB_INTEGER = 3
Global Const DB_LONG = 4
Global Const DB_CURRENCY = 5
Global Const DB_SINGLE = 6
Global Const DB_DOUBLE = 7
Global Const DB_DATE = 8
Global Const DB_TEXT = 10
Global Const DB_LONGBINARY = 11
Global Const DB_MEMO = 12

' TableDef Attributes
Global Const DB_ATTACHEXCLUSIVE = &H10000
Global Const DB_ATTACHSAVEPWD = &H20000
Global Const DB_SYSTEMOBJECT = &H80000002
Global Const DB_ATTACHEDTABLE = &H40000000
Global Const DB_ATTACHEDODBC = &H20000000

' ListTables TableType
Global Const DB_TABLE = 1
Global Const DB_QUERYDEF = 5

' ListTables Attributes (for QueryDefs)
Global Const DB_QACTION = &HF0
Global Const DB_QCROSSTAB = &H10
Global Const DB_QDELETE = &H20
Global Const DB_QUPDATE = &H30
Global Const DB_QAPPEND = &H40
Global Const DB_QMAKETABLE = &H50

' ListIndexes IndexAttributes values
Global Const DB_UNIQUE = 1
Global Const DB_PRIMARY = 2
Global Const DB_PROHIBITNULL = 4
Global Const DB_IGNORENULL = 8
' ListIndexes FieldAttributes value
Global Const DB_DESCENDING = 1  'For each field in Index

' CreateDatabase and CompactDatabase Language constants
Global Const DB_LANG_GENERAL = ";LANGID=0x0809;CP=1252;COUNTRY=0"
Global Const DB_LANG_SPANISH = ";LANGID=0x040A;CP=1252;COUNTRY=0"
Global Const DB_LANG_DUTCH = ";LANGID=0x0413;CP=1252;COUNTRY=0"
Global Const DB_LANG_SWEDFIN = ";LANGID=0x040C;CP=1252;COUNTRY=0"   'VB3 and Access 1.1 Databases
Global Const DB_LANG_NORWDAN = ";LANGID=0x0414;CP=1252;COUNTRY=0"   'VB3 and Access 1.1 Databases
Global Const DB_LANG_ICELANDIC = ";LANGID=0x040F;CP=1252;COUNTRY=0" 'VB3 and Access 1.1 Databases
Global Const DB_LANG_NORDIC = ";LANGID=0x041D;CP=1252;COUNTRY=0"    'Access 1.0 Databases only

' CreateDatabase and CompactDatabase options
Global Const DB_VERSION10 = 1        ' Microsoft Access Version 1.0
Global Const DB_ENCRYPT = 2          ' Make database encrypted.
Global Const DB_DECRYPT = 4          ' Decrypt database while compacting.

'Collating order values
Global Const DB_SORTGENERAL = 256    ' Sort by EFGPI rules (English, French, German,Portuguese, Italian)
Global Const DB_SORTSPANISH = 258    ' Sort by Spanish rules
Global Const DB_SORTDUTCH = 259      ' Sort by Dutch rules
Global Const DB_SORTSWEDFIN = 260    ' Sort by Swedish, Finnish rules
Global Const DB_SORTNORWDAN = 261    ' Sort by Norwegian, Danish rules
Global Const DB_SORTICELANDIC = 262  ' Sort by Icelandic rules
Global Const DB_SORTPDXINTL = 4096   ' Sort by Paradox international rules
Global Const DB_SORTPDXSWE = 4097    ' Sort by Paradox Swedish, Finnish rules
Global Const DB_SORTPDXNOR = 4098    ' Sort by Paradox Norwegian, Danish rules
Global Const DB_SORTUNDEFINED = -1   ' Sort rules are undefined or unknown

Function AddBoxString(srch$, Ctrl As Control) As Integer
'adds string to list/combobox and returns listindex or -1 = notfound

    Dim hWndcb%
    Dim s$
    
    hWndcb% = Ctrl.hWnd
    s$ = srch$ & Chr$(0)
    
    If TypeOf Ctrl Is ListBox Then
        AddBoxString = SendMessage(hWndcb%, LB_ADDSTRING, 0, s$)
    Else
        AddBoxString = SendMessage(hWndcb%, CB_ADDSTRING, 0, s$)
    End If

End Function

Sub AddUnique(s$, Ctrl As Control)
'adds to combobox if not already there
    
    Dim X%

    If FindBoxString(s$, Ctrl) = -1 Then  'if not found then
        X% = AddBoxString(s$, Ctrl)
    End If

End Sub

Function ANSIString(VBString As String) As String
'removes trailing blanks then adds a null to the end of a string
    
    ANSIString = RTrim(VBString) + Chr$(0)
End Function

Sub CenterForm(frmParent As Form, frmChild As Form)
' This procedure centers a child form over a parent form.
' Calling this routine loads the dialog. Use the Show method
' to display the dialog after calling this routine (i.e. MyFrm.Show MODAL)
    
Dim L As Integer, t As Integer

    ' get left offset
    L = frmParent.Left + ((frmParent.Width - frmChild.Width) / 2)
    If (L + frmChild.Width > Screen.Width) Then
    L = Screen.Width - frmChild.Width
    End If

    ' get top offset
    t = frmParent.TOP + ((frmParent.Height - frmChild.Height) / 2)
    If (t + frmChild.Height > Screen.Height) Then
    t = Screen.Height - frmChild.Height
    End If

    ' Make sure l,t are still on the screen
    If (L < 0) Then L = 0
    If (t < 0) Then t = 0
    ' center the child formfv
    frmChild.Move L, t

End Sub

Function CompressStr(s$) As String
'compresses spaces out of a string

    Dim L&
    
    L& = 0&
    Do While L& + 1 <= Len(s$)
        L& = InStr(s$, " ")
        If L& Then
            s$ = Left$(s$, L& - 1) + Mid$(s$, L& + 1) 'change them to blanks
        Else
            Exit Do
        End If
    Loop
    CompressStr = s$

End Function

Sub CopyFileBytes(SourceFilenum, DestFilenum, numBytes As Long)
'use binary read/write to copy a file to an already open binary file
'call with files already open

Dim whole%, part%, buffer$, start&, i%

    whole% = numBytes \ 32000        'number of whole 32768 byte chunks
    part% = numBytes Mod 32000     'remaining bytes at end of file
    buffer$ = String$(32000, 0)
    
    start& = 1
    For i% = 1 To whole                   'this for-next loop will copy 32,000
           Get SourceFilenum, , buffer$       'byte chunks at a time. If there is
           Put DestFilenum, , buffer$      'less than 32,000 bytes in the file,
    Next
    
    buffer$ = String$(part%, 0)           'this part of the routine will copy
    Get SourceFilenum, , buffer$              'the remaining bytes at the end of the
    Put DestFilenum, , buffer$              'file.

End Sub

Sub Delay(secs As Integer)
'Wait a few seconds to get a unique order number
'CRB 5/2/95 add doevents

    Dim DelayTime!
    
    DelayTime! = Timer: Do: DoEvents: Loop Until Timer > DelayTime! + secs

End Sub

Sub DisplayHourglass()
'Routine to display the hourglass

    Screen.MousePointer = HOURGLASS
End Sub

Sub DisplayMousepointer()
'Routine to display the default mousepointer

    Screen.MousePointer = DEFAULT
End Sub

Sub FileDelete(File$)
'Delete file (use open in case file is hidden!)

    Dim X%
    
    X% = OpenFile(File$, OFFILE, OF_DELETE)

End Sub

Function FileExist(fname) As Integer
'checks if file exists, returns True or error

    Dim FileRet As Integer
    
    On Error Resume Next
    
    'first check for directory
    FileRet = Len(Dir(fname))
    If Err Then
        FileExist = Err
    ElseIf FileRet Then
        FileExist = True
    Else
        FileExist = 53
    End If
    
    On Error GoTo 0

End Function

Function FindBoxString(srch$, Ctrl As Control) As Integer
'finds search string in combobox and returns listindex or -1 = notfound

    Dim MsgNum As Integer, hWndcb As Integer, X As Integer, xl As Integer
    Dim s$
    
    FindBoxString = True
    If TypeOf Ctrl Is ComboBox Then
        MsgNum = CB_FINDSTRING
    Else
        MsgNum = LB_FINDSTRING
    End If
    
    If Ctrl.ListCount Then
        hWndcb = Ctrl.hWnd
        s$ = srch$ & Chr$(0)
        X = -1  'start at beginning
        Do
        xl = X  'save prior index
        X = SendMessage(hWndcb, MsgNum, xl, s$)
        If X <> -1 And UCase$(trim_nul(s$)) = UCase$(Ctrl.List(X)) Then    'if really equal
            FindBoxString = X
            Exit Function
        End If
        Loop Until X <= xl  'loop if last found > prior found
    End If

End Function

Function FindComboString(srch$, Ctrl As Control) As Integer
'finds search string in combobox and returns listindex or -1 = notfound

    Dim MsgNum As Long, hWndcb%, X As Integer, xl As Integer
    Dim s$
    
    FindComboString = True
    If TypeOf Ctrl Is ListBox Then
        MsgNum = LB_FINDSTRING
    Else
        MsgNum = CB_FINDSTRING
    End If
    
    If Ctrl.ListCount Then
        hWndcb% = Ctrl.hWnd
        s$ = srch$ & Chr$(0)
        X = -1  'start at beginning
        Do
        xl = X  'save prior index
        X = SendMessage(hWndcb%, MsgNum, xl, s$)
        If X <> -1 And trim_nul(s$) = Ctrl.List(X) Then    'if really equal
        FindComboString = X
        Exit Function
        End If
        Loop Until X <= xl  'loop if last found > prior found
    End If

End Function

Function FindPrefixString(srch As String, start&, Ctrl As Control) As Long
'finds first prefix string in combobox and returns listindex or -1 = notfound

    Dim Msg As Long, hWndcb As Integer
    Dim s$
    
    FindPrefixString = True
    
    If TypeOf Ctrl Is ListBox Then
        Msg = LB_FINDSTRING
    Else
        Msg = CB_FINDSTRING
    End If
    
    If Ctrl.ListCount Then
        hWndcb = Ctrl.hWnd
        s = srch + Chr$(0)
        FindPrefixString = SendMessage(hWndcb, Msg&, start&, s)
    End If

End Function

Function GetFileName(fname As String) As String
'Parses the filename out of a directory string
     
     Dim i As Integer
     
     On Error Resume Next
     
     For i = Len(fname) To 1 Step -1
       If Mid(fname, i, 1) = "\" Then
         Exit For
       End If
     Next
     
     GetFileName = Mid(fname, i + 1)

End Function

Function GetNetUser() As String
   Dim ReturnCode As Integer, Size As Integer, UserName As String
   GetNetUser = "Not logged on to network"
   UserName = String$(255, 0)
   Size = Len(UserName)
   ReturnCode = WNetGetUser%(UserName, Size)
   If ReturnCode = 0 Then GetNetUser = Left$(UserName, Size - 1)
End Function

Function GetSoundexCode(sInput As String) As String
'CRB 6/30/95

Dim sSoundex As String
Dim sCurrentCharacter As String
Dim sLastCharacter As String
Dim i As Integer

sInput = UCase$(sInput)
sSoundex = Left(sInput, 1)

i = 2

Do While Not Len(sSoundex) = 4  'Soundexlenght is always 4 characters
  'Twice the same character
  Do While Mid$(sInput, i, 1) = sLastCharacter And i <= Len(sInput)
    i = i + 1
  Loop
  'End of String reached, but soundexlenght < 4 characters
  If i > Len(sInput) Then
    sSoundex = sSoundex & "0"
  Else
    'Determine soundexcharacter
    sCurrentCharacter = Mid$(sInput, i, 1)
    If InStr("BFPV", sCurrentCharacter) Then
      sSoundex = sSoundex & "1"
    ElseIf InStr("CGJKQSXZ", sCurrentCharacter) Then
      sSoundex = sSoundex & "2"
    ElseIf InStr("DT", sCurrentCharacter) Then
      sSoundex = sSoundex & "3"
    ElseIf InStr("L", sCurrentCharacter) Then
      sSoundex = sSoundex & "4"
    ElseIf InStr("MN", sCurrentCharacter) Then
      sSoundex = sSoundex & "5"
    ElseIf InStr("R", sCurrentCharacter) Then
      sSoundex = sSoundex & "6"
    Else
    'Invalid character, vocal, H, W or Y
    End If
  End If
  sLastCharacter = sCurrentCharacter
  i = i + 1
Loop
GetSoundexCode = sSoundex
End Function

Function Match(s As Variant, f As Variant) As Integer
'tests for match of Search with Found and returns TRUE/FALSE
'   uses wildcard * for postion and anymore
'Logic: if F shorter than S = FALSE
'       check match up to last wildcard in S
'return True if Match, False if no match, 1 if null/empty

    Dim i%
    
    Select Case VarType(s)
    
    Case 0, 1   'empty/null
        Match = 1
    
    Case 8      'string
        s = trim_nul(CStr(s)): f = trim_nul(CStr(f))
        If Len(s) = 0 Then
            Match = 1
        ElseIf Len(f) >= Len(s) Then
            
            If f = s Then
                Match% = True
                Exit Function
            End If
            
            For i% = 1 To Len(s)
                If Mid$(s, i%, 1) = Mid$(f, i%, 1) Or Mid$(s, i%, 1) = "*" Then
                    Match% = True
                Else
                    Match% = False
                    Exit For
                End If
            Next
        End If
    
    Case Else   'numeric
        If f = s Then Match = True
    End Select

End Function

Function Pad(s$, L%) As String
'pad a string to a given length

    If Len(Trim(s$)) > L% Then
        Pad = Left$(s$, L%)
    Else
        Pad = Trim(s$) & Space$(L% - Len(Trim(s$)))
    End If

End Function

Function ParseName(s$, n%) As String
'parses a name and if n%=1 returns first name, else returns last name
'checks for comma delimiter and reverses name

    Dim ret$
    
    If InStr(s$, ",") Then  'has comma so assume Last,First
        If n% = 1 Then 'first name
            ret$ = ParseString(s$, ",", 2)
        Else
            ret$ = ParseString(s$, ",", 1)
        End If
    
    Else    'assume First Last with space delimited
        If n% = 1 Then 'first name
            ret$ = ParseString(s$, " ", 1)
        Else
            ret$ = ParseString(s$, " ", 2)
        End If
    End If
    
    If ret$ = "" Then ret$ = s$ 'if blank set to original
    ParseName = ret$

End Function

Function ParseString(s$, del$, n) As String
'parse a string by delimiter and return nth value
    
    Dim pos As Long, i As Integer, pos2 As Long

    ParseString = s$
    pos = InStr(s$, del$)
    If pos Then    'if has del$
        If n = 1 Then
            ParseString = Left$(s$, pos - 1)
        Else
            For i = 1 To n - 1     'count items
                pos2 = InStr(pos + 1, s$, del$)
                If pos2 = 0 Then  'end of string
                    If i = n - 1 Then
                        ParseString = Mid$(s$, pos + 1)
                    Else
                        ParseString = ""  'nth item not found
                    End If
                    Exit Function
                End If
                ParseString = Mid$(s$, pos + 1, pos2 - pos - 1)
                pos = pos2
            Next
        End If
    
    ElseIf n > 1 Then
        ParseString = ""  'nth item not found
    End If

End Function

Sub PrintAtPos(txt$, X As Integer, Y As Integer, FSize As Integer, FromX As Integer)
'if Fromx=True then start printing so text ends at X, else start printing at X

    Printer.FontSize = FSize
    Printer.CurrentY = Y
    Printer.CurrentX = IIf(FromX, X - Printer.TextWidth(txt$), X)
    Printer.Print txt$
    
End Sub

Function SelectBoxString(s$, Ctrl As Control) As Integer
'selects search string in combobox and returns listindex or -1 = notfound

    Dim X As Integer
    
    SelectBoxString = True
    X = FindBoxString(s$, Ctrl)         'try to find it
    If X <> -1 Then                     'if found then select
        SelectBoxString = X
        Ctrl.ListIndex = X
    End If

End Function

Function SelectComboString(s$, Ctrl As Control) As Long
'selects search string in combobox and returns listindex or -1 = notfound

    Dim X As Long
    
    SelectComboString = True
    X = FindComboString(s$, Ctrl)
    If Not X Then                     'if found then select
        SelectComboString = X
        Ctrl.ListIndex = X
    End If

End Function

Sub SetEditText(Ctrl As Control, s$)
'set edit control text

    Dim res As Integer
    
    res = SendMessage(Ctrl.hWnd, EM_SETSEL, 0, s$)

End Sub

Sub SetReadOnly(Ctrl As Control, ReadOnly As Integer)
'set edit control to readonly

    Dim res As Integer
    
    If TypeOf Ctrl Is TextBox Then
        res = SendMessage(Ctrl.hWnd, EM_SETREADONLY, ReadOnly, "")
    ElseIf TypeOf Ctrl Is ComboBox Then
        Ctrl.Enabled = Not ReadOnly
    End If

End Sub

Function ShowDropDown(Opt, Ctrl As Control) As Integer
'Dropdownbox shown if Opt=TRUE, else hidden

    Dim hWndcb As Integer, s$
    
    hWndcb = Ctrl.hWnd
    s$ = Chr$(0)
    ShowDropDown = SendMessage(hWndcb, CB_SHOWDROPDOWN, Opt, s$)

End Function

Function StartUp(Program$, File$, Key$, Title$)
'start the appropriate program
    
    Dim X%
    On Error GoTo NotRunning
    AppActivate Title$
    If Len(Key$) Then SendKeys Key$
    GoTo Finish

NotRunning:
    X% = Shell(Program$ + " " + File$, 1)
    Resume Finish

Finish:
    On Error GoTo 0

End Function

Function strip_NUL(istr As String) As String
'removes the null and trailing blanks from a string

    Dim NUL$, L&
    
    NUL$ = Chr$(0)
    L& = 0&
    
    'step thru the string looking for nulls
    Do While L& + 1 <= Len(istr)
        L& = InStr(istr, NUL$)
        If L& Then
        Mid$(istr, L&, 1&) = " "    'change them to blanks
        Else
        Exit Do
        End If
    Loop
    strip_NUL = istr           'now strip blanks

End Function

Function StripFileName(fname As String) As String
'returns path
  
  On Error Resume Next
  Dim i As Integer

  For i = Len(fname) To 1 Step -1
    If Mid(fname, i, 1) = "\" Then
      Exit For
    End If
  Next

  StripFileName = Mid(fname, 1, i - 1)

End Function

Function StripPathName(fname As String) As String
'returns filename
  
  On Error Resume Next
  Dim i As Integer

  For i = Len(fname) To 1 Step -1
    If Mid(fname, i, 1) = "\" Then
      Exit For
    End If
  Next

  StripPathName = Trim(Mid(fname, i + 1))

End Function

Function StripSP(istr As String) As String
'removes the blanks from a string

    Dim SP$, L&, ostr As String
    
    SP$ = Chr$(32)
    L& = 0&
    ostr = Trim(istr)
    
    'step thru the string looking for nulls
    Do While L& + 1 <= Len(ostr)
        L& = InStr(ostr, SP$)
        If L& Then
            ostr = Left$(ostr, L& - 1) & Mid$(ostr, L& + 1) 'remove blanks
        Else
            Exit Do
        End If
    Loop
    StripSP = ostr

End Function

Function ToHex(strIn As String) As String
'Converts a string value to hex

    Dim Out As String
    Dim Temp As String
    Dim i As Integer

    If (Len(strIn) Mod 2) <> 0 Then strIn = "0" + strIn ' add leading 0 if needed

    Out = ""
    For i = 1 To Len(strIn) Step 2
        Temp = Hex$(Asc(Mid$(strIn, i + 1, 1))) ' Because of Intel's "Reversed-Byte" architecture
        If Len(Temp) = 1 Then Out = Out + "0" ' handle second byte first
        Out = Out + Temp

        Temp = Hex$(Asc(Mid$(strIn, i, 1)))  ' now handle first byte strIn word
        If Len(Temp) = 1 Then Out = Out + "0" ' add leading zero if necessary
        Out = Out + Temp
    Next
    ToHex = Out

End Function

Function trim_nul(s$) As String
' trim string at first null

    Dim n As String, P As Long
    
    n = Chr$(0)
    trim_nul = Trim(s$)
    If Len(s$) Then
        P = InStr(s$, n)
        If P Then
            trim_nul = Trim(Left$(s$, P - 1))
        End If
    End If

End Function

