Attribute VB_Name = "trakpak"
Option Explicit


Declare Function GetTickCount Lib "kernel32" () As Long

Global Const SOCK_ACTION_CLOSE = 1
Global Const SOCK_ACTION_CONNECT = 2
Global Const SOCK_ACTION_LISTEN = 3
Global Const SOCK_STATE_CLOSED = 1
Global Const SOCK_STATE_CONNECTED = 2

Type PackList
    OrderNUm As String * 6
    OrderDate As Variant
    ShipTo As String * 40
    ShipToAdx As String * 40
    ShipToCity As String * 20
    ShipToState As String * 2
    ShipToZip As String * 9
    ShipVia As String * 10
    TrackNum As String * 20
    ShipStatus As String * 10
End Type

Global plist As PackList
Global db As Database
Global tablevar As Table

Global state As String
Global ready As Integer
Global recvdata As String

Sub CloseDb()

    tablevar.Close
    db.Close

End Sub

Sub FileToStruct()

    plist.OrderNUm = tablevar.Fields("OrderNum")
    plist.OrderDate = tablevar.Fields("OrderDate") & ""
    plist.ShipTo = tablevar.Fields("ShipTo") & ""
    plist.ShipToAdx = tablevar.Fields("ShipToAdx") & ""
    plist.ShipToCity = tablevar.Fields("ShipToCity") & ""
    plist.ShipToState = tablevar.Fields("ShipToState") & ""
    plist.ShipToZip = tablevar.Fields("ShipToZip") & ""
    plist.ShipVia = tablevar.Fields("ShipVia") & ""
    plist.TrackNum = tablevar.Fields("TrackNum") & ""
    plist.ShipStatus = tablevar.Fields("ShipStatus") & ""

End Sub

Sub GetStatus()

        
End Sub

Sub OpenInit()
    
    Set db = OpenDatabase("TRAKPAK.MDB")
    Set tablevar = db.OpenTable("Packing List")

End Sub

Function ParseHTML(DataIn As String) As String

    Dim rc As Integer

    If trim_nul(plist.ShipVia) = "UPS" Then
        rc = InStr(DataIn, "</b> Delivered")
    ElseIf trim_nul(plist.ShipVia) = "Fedex" Then
        rc = InStr(DataIn, "Delivered")
    End If
    If rc <> 0 Then
        ParseHTML = "Delivered"
        Exit Function
    End If
    If trim_nul(plist.ShipVia) = "UPS" Then
        rc = InStr(DataIn, "</b> In-transit")
    ElseIf trim_nul(plist.ShipVia) = "Fedex" Then
        rc = InStr(DataIn, "Package has not been Delivered!")
    End If
    If rc <> 0 Then
        ParseHTML = "In-transit"
        Exit Function
    End If
    rc = InStr(DataIn, "/html")
    If rc <> 0 Then
        ParseHTML = "End"
        Exit Function
    End If
    rc = InStr(DataIn, "/HTML")
    If rc <> 0 Then
        ParseHTML = "End"
        Exit Function
    End If

    ParseHTML = ""
    Exit Function

End Function

Sub StructToFile()

    tablevar.Fields("OrderNum").Value = plist.OrderNUm
    tablevar.Fields("OrderDate").Value = plist.OrderDate
    tablevar.Fields("ShipTo").Value = plist.ShipTo
    tablevar.Fields("ShipToAdx").Value = plist.ShipToAdx
    tablevar.Fields("ShipToCity").Value = plist.ShipToCity
    tablevar.Fields("ShipToState").Value = plist.ShipToState
    tablevar.Fields("ShipToZip").Value = plist.ShipToZip
    tablevar.Fields("ShipVia").Value = plist.ShipVia
    tablevar.Fields("TrackNum").Value = plist.TrackNum
    tablevar.Fields("ShipStatus").Value = plist.ShipStatus
    
End Sub

Function trim_nul(S$) As String

Dim n As String, P As Long

' trim string at first null
n = Chr$(0)
trim_nul = Trim$(S$)
If Len(S$) Then
    P = InStr(S$, n)
    If P Then
        trim_nul = Trim$(Left$(S$, P - 1))
    End If
End If
End Function


