Attribute VB_Name = "ZipLd"
Option Explicit


Declare Function GetTickCount Lib "kernel32" () As Long

Global Const SOCK_ACTION_CLOSE = 1
Global Const SOCK_ACTION_CONNECT = 2
Global Const SOCK_ACTION_LISTEN = 3
Global Const SOCK_STATE_CLOSED = 1
Global Const SOCK_STATE_CONNECTED = 2

Type Location
    Name As String * 40
    Addr1 As String * 40
    Addr2 As String * 40
    City As String * 30
    State As String * 10
    ZipCode As String * 20
    CHECKED As Integer      '0 = no, 1 = yes, 2 = problem (needs manual intervention)
End Type

Global loc As Location
Global db As Database
Global tablevar As Table

Global State As String
Global ready As Integer
Global recvdata As String
Global addrStr As String

Sub CloseDb()

    tablevar.Close
    db.Close

End Sub

Sub FileToStruct()

    loc.Name = tablevar.Fields("Name") & ""
    loc.Addr1 = tablevar.Fields("Addr1") & ""
    loc.Addr2 = tablevar.Fields("Addr2") & ""
    loc.City = tablevar.Fields("City") & ""
    loc.State = tablevar.Fields("State") & ""
    loc.ZipCode = tablevar.Fields("ZipCode") & ""
    If IsNull(tablevar.Fields("Checked")) Then
        loc.CHECKED = 0
    Else
        loc.CHECKED = tablevar.Fields("Checked")
    End If
    'loc.Checked = tablevar.Fields("Checked") + 0
    
End Sub

Sub GetStatus()

        
End Sub

Sub OpenInit()
    
    Set db = OpenDatabase("ZIPLOAD.MDB")
    Set tablevar = db.OpenTable("Locations")

End Sub

Function ParseHTML(DataIn As String) As String

    Dim rc As Integer
    Dim ptr1 As Integer
    Dim ptr2 As Integer
    Dim str1 As String
    Dim str2 As String
    Dim str3 As String
    Dim len1 As Integer
    Dim len2 As Integer
    Dim len3 As Integer
    
    If InStr(DataIn, "multiple responses") Then
        loc.CHECKED = 2
        ParseHTML = "Found"
        Exit Function
    End If
    'rc = InStr(DataIn, "<BR><BR><i>")
    'If (rc <> 0) Then
    '    str1 = Mid$(DataIn, rc - 10, 10)
    '    loc.ZipCode = str1
    '    loc.Checked = 1
    '    ParseHTML = "Found"
    '    Exit Function
    'End If
    'rc = InStr(DataIn, "<BR><p><i>")
    'If (rc = 0) Then
    '    loc.Checked = 0
    '    ParseHTML = "Not Found"
    '    Exit Function
    'End If
    'str1 = Mid$(DataIn, rc - 10, 10)
    'loc.ZipCode = str1
    'loc.Checked = 1
    str1 = Left$(loc.ZipCode, 3)
    rc = InStr(DataIn, str1)
    If (rc = 0) Then
        loc.CHECKED = 0
        ParseHTML = "Not Found"
        Exit Function
    End If
    loc.ZipCode = Mid$(DataIn, rc, 10)
    loc.CHECKED = 1
    ParseHTML = "Found"
    Exit Function
End Function

Sub StructToFile()

    tablevar.Fields("Name").Value = loc.Name
    tablevar.Fields("Addr1").Value = loc.Addr1
    tablevar.Fields("Addr2").Value = loc.Addr2
    tablevar.Fields("City").Value = loc.City
    tablevar.Fields("State").Value = loc.State
    tablevar.Fields("ZipCode").Value = loc.ZipCode
    tablevar.Fields("Checked").Value = loc.CHECKED
    
End Sub

Sub StructToURL()
    Dim tmpStr As String
    Dim tmpStr1 As String
    Dim lenStr As Integer
    Dim i As Integer

    addrStr = "company="
    tmpStr = Trim_nul(loc.Name)
    tmpStr1 = ReplBlank(tmpStr)
    addrStr = addrStr & tmpStr1
    addrStr = addrStr & "&urbanization=&street="
    tmpStr = Trim_nul(loc.Addr1)
    tmpStr1 = ReplBlank(tmpStr)
    addrStr = addrStr & tmpStr1
    tmpStr = Trim_nul(loc.Addr2)
    tmpStr1 = ReplBlank(tmpStr)
    addrStr = addrStr & tmpStr1
    addrStr = addrStr & "&lastline="
    tmpStr = Trim_nul(loc.City)
    tmpStr1 = ReplBlank(tmpStr)
    addrStr = addrStr & tmpStr1
    addrStr = addrStr & "+" & Trim_nul(loc.State)
    addrStr = addrStr & "+" & Trim_nul(loc.ZipCode)
    
End Sub

Function ReplBlank(tmpStr As String) As String
'rudimentary URL encoding - detects blanks(ascii 32) and periods (ascii 46) only when
'performing replacements

    Dim i As Integer
    Dim lenStr As Integer
    Dim endStr As String

    lenStr = Len(tmpStr)
    For i = 1 To lenStr
        If i = lenStr Then
            If Mid$(tmpStr, i, 1) = Chr$(46) Then
                endStr = endStr & Left(tmpStr, i - 1) & "%2E"
            Else
                endStr = endStr & tmpStr
            End If
            ReplBlank = endStr
            Exit Function
        End If
        If Mid$(tmpStr, i, 1) = Chr$(32) Or Mid$(tmpStr, i, 1) = Chr$(46) Then
            If Mid$(tmpStr, i, 1) = Chr$(32) Then
                endStr = endStr & Left(tmpStr, i - 1) & "+"
            ElseIf Mid$(tmpStr, i, 1) = Chr$(46) Then
                endStr = endStr & Left(tmpStr, i - 1) & "%2E"
            End If
            tmpStr = Mid$(tmpStr, i + 1, lenStr - i)
            lenStr = Len(tmpStr)
            i = 0
        End If
    Next i
    If endStr = "" Then endStr = tmpStr
    ReplBlank = endStr
    
End Function
Function Trim_nul(S$) As String
' trim string at first null

    Dim n As String, P As Long
    
    n = Chr$(0)
    Trim_nul = Trim(S$)
    If Len(S$) Then
        P = InStr(S$, n)
        If P Then
            Trim_nul = Trim(Left$(S$, P - 1))
        End If
    End If

End Function

