unit Unit1;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, VBXCtrl, Air25, ExtCtrls, StdCtrls, Menus;

type
  TForm1 = class(TForm)
    Heading: TAir;
    Airspeed: TAir;
    Altimeter: TAir;
    Climbrate: TAir;
    HSI: TAir;
    ADF: TAir;
    RMI: TAir;
    OBI: TAir;
    Horizon: TAir;
    Turn: TAir;
    Label1: TLabel;
    Timer1: TTimer;
    MainMenu1: TMainMenu;
    Exit1: TMenuItem;
    Exit2: TMenuItem;
    procedure Timer1Timer(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure Exit2Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

procedure TForm1.Timer1Timer(Sender: TObject);
begin

{this is not a real simulation}
    Horizon.Bank := Horizon.Bank + 2*Random(100)/100-1;
    If Horizon.Bank > 30 Then Horizon.Bank := 30;
    If Horizon.Bank < -30 Then Horizon.Bank := -30;

    Horizon.Pitch := Horizon.Pitch + 2*Random(100)/100-1;
    If Horizon.Pitch > 30 Then Horizon.Pitch := 30;
    If Horizon.Pitch < -30 Then Horizon.Pitch := -30;

    Climbrate.Value := 50 * Airspeed.Value * Sin(Horizon.Pitch * Cos(Horizon.Bank * 3.14159 / 180) * 3.14159 / 180);
    Altimeter.Value := Altimeter.Value + Climbrate.Value / 100;

    Airspeed.Value := Airspeed.Value - Climbrate.Value / 2000;
    If Airspeed.Value > 120 Then Airspeed.Value := 120;
    If Airspeed.Value < 60 Then Airspeed.Value := 60;

    Heading.Value := Heading.Value - Airspeed.Value * Sin(Horizon.Bank * 3.14159 / 180) / 20;
    OBI.OBICourse := Heading.Value;
    ADF.ADFBearing := Heading.Value + 30;
    RMI.RMIBearing := Heading.Value + 45;

    HSI.Value := Heading.Value;

    Turn.Turn := Airspeed.Value * Sin(Horizon.Bank * 3.14159 / 180) * Sin(Horizon.Pitch * 3.14159 / 180);

    {In this cockpit demo, all instruments have the AutoRedraw property
    set to false for improved refresh rates.  This requires that
    you force the instruments to redraw after all the instruments'
    properties have been updated.  Setting the Redraw property to
    True forces the instruments to be refreshed immediately. }

    Heading.Redraw := True;
    Airspeed.Redraw := True;
    Climbrate.Redraw := True;
    Altimeter.Redraw := True;
    HSI.Redraw := True;
    Horizon.Redraw := True;
    OBI.Redraw := True;
    RMI.Redraw := True;
    ADF.Redraw := True;

end;
procedure TForm1.FormCreate(Sender: TObject);
begin

     Randomize;
     Altimeter.Value := 11250;
     Airspeed.Value := 95;

end;

procedure TForm1.Exit2Click(Sender: TObject);
begin

     Halt(0);

end;

end.
