Option Explicit

Global Const CTLRAISED = 1
Global Const CTLSUNKEN = 2


Sub HighLight (C As Control, Style As Integer)
    Dim TLShade     As Long
    Dim BRShade     As Long
    Dim i           As Integer
    Dim T, L, W, H  As Integer
    Dim oldScale    As Integer
    '
    ' Save control parent's ScaleMode and change it to Pixel
    '
    oldScale = C.Parent.ScaleMode
    C.Parent.ScaleMode = 3
    '
    ' Initialize shade colors based on Style
    '
    If Style = CTLRAISED Then
       TLShade = RGB(255, 255, 255)
       BRShade = RGB(128, 128, 128)
    Else
       TLShade = RGB(128, 128, 128)
       BRShade = RGB(255, 255, 255)
    End If
    '
    ' Draw two pixel wide shadowed border
    '
    For i = 1 To 1
       T = C.Top - i
       L = C.Left - i
       H = C.Height + 2 * i
       W = C.Width + 2 * i
       '
       ' Draw left, top, right, bottom
       '
       C.Parent.Line (L, T)-Step(0, H), TLShade
       C.Parent.Line (L, T)-Step(W, 0), TLShade
       C.Parent.Line (L + W, T)-Step(0, H), BRShade
       C.Parent.Line (L, T + H)-Step(W, 0), BRShade
    Next i
    C.Parent.ScaleMode = oldScale
End Sub

