VERSION 2.00
Begin Form CoolDrum 
   AutoRedraw      =   -1  'True
   BackColor       =   &H00C0C0C0&
   BorderStyle     =   3  'Fixed Double
   Caption         =   "Cool Drum"
   ClientHeight    =   3600
   ClientLeft      =   855
   ClientTop       =   1890
   ClientWidth     =   7200
   Height          =   4290
   Icon            =   COOLDRUM.FRX:0000
   Left            =   795
   LinkTopic       =   "Form1"
   MaxButton       =   0   'False
   ScaleHeight     =   3600
   ScaleWidth      =   7200
   Top             =   1260
   Width           =   7320
   Begin Timer Timer1 
      Enabled         =   0   'False
      Interval        =   150
      Left            =   3600
      Top             =   1920
   End
   Begin Frame Frame5 
      BackColor       =   &H00C0C0C0&
      Caption         =   "Transpose Bass"
      FontBold        =   0   'False
      FontItalic      =   0   'False
      FontName        =   "MS Sans Serif"
      FontSize        =   8.25
      FontStrikethru  =   0   'False
      FontUnderline   =   0   'False
      Height          =   1455
      Left            =   2040
      TabIndex        =   22
      Top             =   2040
      Width           =   1575
      Begin VSlider VSlider1 
         BackColor       =   &H00C0C0C0&
         BevelInner      =   0  'None
         BevelOuter      =   1  'Raised
         BevelWidth      =   1
         BorderWidth     =   1
         Gap             =   3
         Height          =   975
         LargeChange     =   1
         Left            =   240
         LinkControl     =   ""
         LinkProperty    =   ""
         Max             =   12
         Min             =   -12
         ThumbHeight     =   220
         ThumbStyle      =   3  'Lined
         ThumbWidth      =   360
         TickColor       =   &H00000000&
         TickCount       =   3
         TickLength      =   4
         TickMarks       =   3  'Both
         TickWidth       =   1
         Top             =   360
         TrackBevel      =   1  'Raised
         TrackWidth      =   0
         Value           =   0
         Width           =   1080
      End
   End
   Begin Frame Frame4 
      BackColor       =   &H00C0C0C0&
      Caption         =   "Bass "
      FontBold        =   0   'False
      FontItalic      =   0   'False
      FontName        =   "MS Sans Serif"
      FontSize        =   8.25
      FontStrikethru  =   0   'False
      FontUnderline   =   0   'False
      Height          =   1455
      Left            =   120
      TabIndex        =   18
      Top             =   2040
      Width           =   1575
      Begin OptionButton OptionBass 
         BackColor       =   &H00C0C0C0&
         Caption         =   "None"
         FontBold        =   0   'False
         FontItalic      =   0   'False
         FontName        =   "MS Sans Serif"
         FontSize        =   8.25
         FontStrikethru  =   0   'False
         FontUnderline   =   0   'False
         Height          =   255
         Index           =   2
         Left            =   120
         TabIndex        =   21
         Top             =   1080
         Value           =   -1  'True
         Width           =   975
      End
      Begin OptionButton OptionBass 
         BackColor       =   &H00C0C0C0&
         Caption         =   "Bass 2"
         FontBold        =   0   'False
         FontItalic      =   0   'False
         FontName        =   "MS Sans Serif"
         FontSize        =   8.25
         FontStrikethru  =   0   'False
         FontUnderline   =   0   'False
         Height          =   255
         Index           =   1
         Left            =   120
         TabIndex        =   20
         Top             =   720
         Width           =   975
      End
      Begin OptionButton OptionBass 
         BackColor       =   &H00C0C0C0&
         Caption         =   "Bass 1"
         FontBold        =   0   'False
         FontItalic      =   0   'False
         FontName        =   "MS Sans Serif"
         FontSize        =   8.25
         FontStrikethru  =   0   'False
         FontUnderline   =   0   'False
         Height          =   255
         Index           =   0
         Left            =   120
         TabIndex        =   19
         Top             =   360
         Width           =   975
      End
   End
   Begin Frame Frame3 
      BackColor       =   &H00C0C0C0&
      Caption         =   "High Hat Beats"
      FontBold        =   0   'False
      FontItalic      =   0   'False
      FontName        =   "MS Sans Serif"
      FontSize        =   8.25
      FontStrikethru  =   0   'False
      FontUnderline   =   0   'False
      Height          =   1455
      Left            =   2040
      TabIndex        =   14
      Top             =   480
      Width           =   1575
      Begin OptionButton OptionCymbal 
         BackColor       =   &H00C0C0C0&
         Caption         =   "None"
         FontBold        =   0   'False
         FontItalic      =   0   'False
         FontName        =   "MS Sans Serif"
         FontSize        =   8.25
         FontStrikethru  =   0   'False
         FontUnderline   =   0   'False
         Height          =   255
         Index           =   2
         Left            =   120
         TabIndex        =   17
         Top             =   1080
         Width           =   1215
      End
      Begin OptionButton OptionCymbal 
         BackColor       =   &H00C0C0C0&
         Caption         =   "High Hat 2"
         FontBold        =   0   'False
         FontItalic      =   0   'False
         FontName        =   "MS Sans Serif"
         FontSize        =   8.25
         FontStrikethru  =   0   'False
         FontUnderline   =   0   'False
         Height          =   255
         Index           =   1
         Left            =   120
         TabIndex        =   16
         Top             =   720
         Width           =   1215
      End
      Begin OptionButton OptionCymbal 
         BackColor       =   &H00C0C0C0&
         Caption         =   "High Hat 1"
         FontBold        =   0   'False
         FontItalic      =   0   'False
         FontName        =   "MS Sans Serif"
         FontSize        =   8.25
         FontStrikethru  =   0   'False
         FontUnderline   =   0   'False
         Height          =   255
         Index           =   0
         Left            =   120
         TabIndex        =   15
         Top             =   360
         Value           =   -1  'True
         Width           =   1215
      End
   End
   Begin Frame Frame2 
      BackColor       =   &H00C0C0C0&
      Caption         =   "Drum Beats"
      FontBold        =   0   'False
      FontItalic      =   0   'False
      FontName        =   "MS Sans Serif"
      FontSize        =   8.25
      FontStrikethru  =   0   'False
      FontUnderline   =   0   'False
      Height          =   1455
      Left            =   120
      TabIndex        =   12
      Top             =   480
      Width           =   1575
      Begin OptionButton OptionDrums 
         BackColor       =   &H00C0C0C0&
         Caption         =   "Fill 1"
         FontBold        =   0   'False
         FontItalic      =   0   'False
         FontName        =   "MS Sans Serif"
         FontSize        =   8.25
         FontStrikethru  =   0   'False
         FontUnderline   =   0   'False
         Height          =   255
         Index           =   2
         Left            =   120
         TabIndex        =   1
         Top             =   1080
         Width           =   1215
      End
      Begin OptionButton OptionDrums 
         BackColor       =   &H00C0C0C0&
         Caption         =   "Beat 2"
         FontBold        =   0   'False
         FontItalic      =   0   'False
         FontName        =   "MS Sans Serif"
         FontSize        =   8.25
         FontStrikethru  =   0   'False
         FontUnderline   =   0   'False
         Height          =   255
         Index           =   1
         Left            =   120
         TabIndex        =   2
         Top             =   720
         Width           =   1215
      End
      Begin OptionButton OptionDrums 
         BackColor       =   &H00C0C0C0&
         Caption         =   "Beat 1"
         FontBold        =   0   'False
         FontItalic      =   0   'False
         FontName        =   "MS Sans Serif"
         FontSize        =   8.25
         FontStrikethru  =   0   'False
         FontUnderline   =   0   'False
         Height          =   255
         Index           =   0
         Left            =   120
         TabIndex        =   13
         Top             =   360
         Value           =   -1  'True
         Width           =   1215
      End
   End
   Begin CommandButton CmdStop 
      Caption         =   "Stop"
      Height          =   495
      Left            =   5640
      TabIndex        =   11
      Top             =   3000
      Width           =   1455
   End
   Begin CommandButton CmdStart 
      Caption         =   "Start"
      Height          =   495
      Left            =   3960
      TabIndex        =   10
      Top             =   3000
      Width           =   1455
   End
   Begin PictureBox Picture1 
      BackColor       =   &H00C0C0C0&
      BorderStyle     =   0  'None
      Height          =   435
      Left            =   0
      ScaleHeight     =   435
      ScaleWidth      =   3915
      TabIndex        =   4
      Top             =   0
      Width           =   3915
      Begin ComboBox OutputDevCombo 
         Height          =   300
         Left            =   120
         Style           =   2  'Dropdown List
         TabIndex        =   5
         Top             =   60
         Width           =   3495
      End
   End
   Begin Frame Frame1 
      BackColor       =   &H00C0C0C0&
      Caption         =   "MIDI Note Value"
      FontBold        =   0   'False
      FontItalic      =   0   'False
      FontName        =   "MS Sans Serif"
      FontSize        =   8.25
      FontStrikethru  =   0   'False
      FontUnderline   =   0   'False
      Height          =   1935
      Left            =   3960
      TabIndex        =   3
      Top             =   960
      Width           =   3135
      Begin VIndicator VuSnare 
         BackColor       =   &H00000000&
         BevelInner      =   0  'None
         BevelOuter      =   1  'Raised
         BevelWidth      =   1
         Border          =   1  'Single Width
         BorderWidth     =   1
         Height          =   1245
         ItemBackColor   =   &H00000000&
         ItemCount1      =   5
         ItemCount2      =   3
         ItemCount3      =   2
         ItemForeColor1  =   &H0000FF00&
         ItemForeColor2  =   &H0000FFFF&
         ItemForeColor3  =   &H000000FF&
         Left            =   1680
         LinkControl     =   ""
         LinkProperty    =   ""
         Max             =   100
         Min             =   0
         ThreeD          =   -1  'True
         Top             =   600
         Value           =   0
         Width           =   300
      End
      Begin VIndicator VuKick 
         BackColor       =   &H00000000&
         BevelInner      =   0  'None
         BevelOuter      =   1  'Raised
         BevelWidth      =   1
         Border          =   1  'Single Width
         BorderWidth     =   1
         Height          =   1245
         ItemBackColor   =   &H00000000&
         ItemCount1      =   5
         ItemCount2      =   3
         ItemCount3      =   2
         ItemForeColor1  =   &H0000FF00&
         ItemForeColor2  =   &H0000FFFF&
         ItemForeColor3  =   &H000000FF&
         Left            =   120
         LinkControl     =   ""
         LinkProperty    =   ""
         Max             =   100
         Min             =   0
         ThreeD          =   -1  'True
         Top             =   600
         Value           =   0
         Width           =   300
      End
      Begin HSlider HSliderNote1 
         BackColor       =   &H00C0C0C0&
         BevelInner      =   0  'None
         BevelOuter      =   1  'Raised
         BevelWidth      =   1
         BorderWidth     =   1
         Gap             =   3
         Height          =   495
         LargeChange     =   1
         Left            =   480
         LinkControl     =   ""
         LinkProperty    =   ""
         Max             =   127
         Min             =   0
         ThumbHeight     =   350
         ThumbStyle      =   3  'Lined
         ThumbWidth      =   220
         TickColor       =   &H00000000&
         TickCount       =   5
         TickLength      =   4
         TickMarks       =   3  'Both
         TickWidth       =   1
         Top             =   1320
         TrackBevel      =   1  'Raised
         TrackWidth      =   0
         Value           =   36
         Width           =   975
      End
      Begin HSlider HSliderNote2 
         BackColor       =   &H00C0C0C0&
         BevelInner      =   0  'None
         BevelOuter      =   1  'Raised
         BevelWidth      =   1
         BorderWidth     =   1
         Gap             =   3
         Height          =   495
         LargeChange     =   1
         Left            =   2040
         LinkControl     =   ""
         LinkProperty    =   ""
         Max             =   127
         Min             =   0
         ThumbHeight     =   350
         ThumbStyle      =   3  'Lined
         ThumbWidth      =   220
         TickColor       =   &H00000000&
         TickCount       =   5
         TickLength      =   4
         TickMarks       =   3  'Both
         TickWidth       =   1
         Top             =   1320
         TrackBevel      =   1  'Raised
         TrackWidth      =   0
         Value           =   38
         Width           =   975
      End
      Begin Label Label1 
         Alignment       =   2  'Center
         BackColor       =   &H00C0C0C0&
         Caption         =   "Snare MIDI Value"
         FontBold        =   0   'False
         FontItalic      =   0   'False
         FontName        =   "MS Sans Serif"
         FontSize        =   8.25
         FontStrikethru  =   0   'False
         FontUnderline   =   0   'False
         Height          =   255
         Index           =   1
         Left            =   1680
         TabIndex        =   9
         Top             =   360
         Width           =   1335
      End
      Begin Label Label1 
         Alignment       =   2  'Center
         BackColor       =   &H00C0C0C0&
         Caption         =   "Kick MIDI Value"
         FontBold        =   0   'False
         FontItalic      =   0   'False
         FontName        =   "MS Sans Serif"
         FontSize        =   8.25
         FontStrikethru  =   0   'False
         FontUnderline   =   0   'False
         Height          =   255
         Index           =   0
         Left            =   120
         TabIndex        =   8
         Top             =   360
         Width           =   1335
      End
      Begin Label LabelNote1 
         Alignment       =   2  'Center
         BackColor       =   &H00000000&
         BorderStyle     =   1  'Fixed Single
         Caption         =   "36"
         FontBold        =   0   'False
         FontItalic      =   0   'False
         FontName        =   "MS Sans Serif"
         FontSize        =   12
         FontStrikethru  =   0   'False
         FontUnderline   =   0   'False
         ForeColor       =   &H0000FF00&
         Height          =   330
         Left            =   480
         TabIndex        =   7
         Top             =   960
         Width           =   975
      End
      Begin Label LabelNote2 
         Alignment       =   2  'Center
         BackColor       =   &H00000000&
         BorderStyle     =   1  'Fixed Single
         Caption         =   "38"
         FontBold        =   0   'False
         FontItalic      =   0   'False
         FontName        =   "MS Sans Serif"
         FontSize        =   12
         FontStrikethru  =   0   'False
         FontUnderline   =   0   'False
         ForeColor       =   &H0000FF00&
         Height          =   330
         Left            =   2040
         TabIndex        =   6
         Top             =   960
         Width           =   975
      End
   End
   Begin Frame FrameTempo 
      BackColor       =   &H00C0C0C0&
      Caption         =   "Tempo"
      FontBold        =   0   'False
      FontItalic      =   0   'False
      FontName        =   "MS Sans Serif"
      FontSize        =   8.25
      FontStrikethru  =   0   'False
      FontUnderline   =   0   'False
      Height          =   855
      Left            =   3960
      TabIndex        =   0
      Top             =   0
      Width           =   3135
      Begin HSlider HSliderTempo 
         BackColor       =   &H00C0C0C0&
         BevelInner      =   1  'Raised
         BevelOuter      =   0  'None
         BevelWidth      =   1
         BorderWidth     =   1
         Gap             =   3
         Height          =   435
         LargeChange     =   10
         Left            =   120
         LinkControl     =   "[None]"
         LinkProperty    =   ""
         Max             =   1
         Min             =   150
         ThumbHeight     =   335
         ThumbStyle      =   2  'Pointed Down
         ThumbWidth      =   200
         TickColor       =   &H00000000&
         TickCount       =   20
         TickLength      =   4
         TickMarks       =   2  'Bottom
         TickWidth       =   1
         Top             =   300
         TrackBevel      =   2  'Inset
         TrackWidth      =   2
         Value           =   65
         Width           =   2895
      End
   End
   Begin MIDIOutput MIDIOutput1 
      DeviceID        =   0
      Left            =   3600
      Top             =   1320
      VolumeLeft      =   0
      VolumeRight     =   0
   End
   Begin Menu FileMenu 
      Caption         =   "&File"
      Begin Menu FileExit 
         Caption         =   "E&xit"
      End
   End
   Begin Menu mnuFile 
      Caption         =   "&Help"
      Begin Menu mnuAbout 
         Caption         =   "&About CoolDrum..."
      End
   End
End
Option Explicit

' CoolDrum
' =======
' The CoolDrum example is to demonstrate how the queue timing works and
' to show a very simple example of creating MIDI music in real-time.  This
' example can be expanded to do all kinds of really neat things.

' MIDIOutput Queue
' ==============
' Whenever the MIDIOutput queue becomes empty, it automatically resets the
' time (ms) to 0. Once you place another event into the queue, it will
' restart automatically at 0 ms.  As long as events are in the queue, the
' queue will not reset to 0.  It will continue  to count up in ms and
' sending events when scheduled.

' The MIDI Output has a QueueEmpty Event that is fired as soon as the queue
' sends its last event.  At that moment, the timer in the queue is reset
' back to 0.  You can use this event to notify your program that more events
' are needed in the MIDI Output.  As soon as the first event is received in
' the MIDI Output, playback will start right back up automatically.

' Another thing that you should understand about the MIDI Output is that it
' can be running (sending events as scheduled) and also receiving more
' events to schedule for sending. It will automatically sort these new
' events by time -- place them into the correct order to be sent.  The only
' limitation is if the schedule time has already passed, the event is
' discarded.

Sub CloseOutputDevice ()
    '
    ' Restore volume before closing
    '
    If MIDIOutput1.State >= MIDISTATE_OPEN Then
	'
	' Close
	'
	MIDIOutput1.Action = MIDIOUT_CLOSE
    End If
End Sub

Sub CmdStart_Click ()
    StartPlay
    
    ' Enable the VU timer.  This timer is used to allow the VU
    ' meters to slowly decay in value.
    Timer1.Enabled = True
End Sub

Sub CmdStop_Click ()
    
    StopPlay

    ' Disable the VU meter timer and zero out the VU values
    Timer1.Enabled = False
    VuKick = 0
    VuSnare = 0
End Sub

' Queue a few MIDI events for a bass part
Sub DBass1 ()
    Dim Transpose As Integer
    Transpose = VSlider1.Value

    ' Send MIDI message data now
    MIDIOutput1.MessageTag = 4000 + 100
    SendMIDIOut (NOTE_ON + 1), (36 + Transpose), 0, 0, MIDIOUT_SEND

    ' Queue MIDI message data
    SendMIDIOut (NOTE_ON + 1), (36 + Transpose), 100, (750 * HSliderTempo.Value / 100), MIDIOUT_QUEUE
    SendMIDIOut (NOTE_ON + 1), (36 + Transpose), 0, (850 * HSliderTempo.Value / 100), MIDIOUT_QUEUE
    SendMIDIOut (NOTE_ON + 1), (36 + Transpose), 100, (1000 * HSliderTempo.Value / 100), MIDIOUT_QUEUE
    SendMIDIOut (NOTE_ON + 1), (36 + Transpose), 0, (1500 * HSliderTempo.Value / 100), MIDIOUT_QUEUE
    SendMIDIOut (NOTE_ON + 1), (36 + Transpose), 100, (2000 * HSliderTempo.Value / 100), MIDIOUT_QUEUE

End Sub

' Queue a few MIDI events for a bass part
Sub DBass2 ()
    Dim Transpose As Integer
    Transpose = VSlider1.Value
    
    ' Queue MIDI message data
    SendMIDIOut (NOTE_ON + 1), (41 + Transpose), 100, (1000 * HSliderTempo.Value / 100), MIDIOUT_QUEUE
    SendMIDIOut (NOTE_ON + 1), (41 + Transpose), 0, (1250 * HSliderTempo.Value / 100), MIDIOUT_QUEUE
    SendMIDIOut (NOTE_ON + 1), (41 + Transpose), 100, (1500 * HSliderTempo.Value / 100), MIDIOUT_QUEUE
    SendMIDIOut (NOTE_ON + 1), (41 + Transpose), 0, (2000 * HSliderTempo.Value / 100), MIDIOUT_QUEUE

End Sub

'  Queue a few MIDI events for a drum part
Sub DrumBeat1 ()

    ' Queue MIDI message data
    MIDIOutput1.MessageTag = 1000 + 100
    SendMIDIOut (NOTE_ON + 9), (HSliderNote1), 100, (1000 * HSliderTempo.Value / 100), MIDIOUT_QUEUE
    
    MIDIOutput1.MessageTag = 2000 + 100
    SendMIDIOut (NOTE_ON + 9), (HSliderNote2), 100, (2000 * HSliderTempo.Value / 100), MIDIOUT_QUEUE
End Sub

' Queue a few MIDI events for a drum part
Sub DrumBeat2 ()

    ' Queue MIDI message data
    MIDIOutput1.MessageTag = 1000 + 100
    SendMIDIOut (NOTE_ON + 9), (HSliderNote1), 100, (1000 * HSliderTempo.Value / 100), MIDIOUT_QUEUE

    MIDIOutput1.MessageTag = 1000 + 100
    SendMIDIOut (NOTE_ON + 9), (HSliderNote1), 100, (1500 * HSliderTempo.Value / 100), MIDIOUT_QUEUE

    MIDIOutput1.MessageTag = 2000 + 120
    SendMIDIOut (NOTE_ON + 9), (HSliderNote2), 120, (2000 * HSliderTempo.Value / 100), MIDIOUT_QUEUE
End Sub

' Queue a few MIDI events for starting 4 count click
Sub DrumBeatStartingClicks ()
    MIDIOutput1.MessageTag = 5000 + 100

    SendMIDIOut (NOTE_ON + 9), (HSliderNote2 - 1), 127, (1000 * HSliderTempo.Value / 100), MIDIOUT_QUEUE
    SendMIDIOut (NOTE_ON + 9), (HSliderNote2 - 1), 127, (2000 * HSliderTempo.Value / 100), MIDIOUT_QUEUE
    SendMIDIOut (NOTE_ON + 9), (HSliderNote2 - 1), 127, (3000 * HSliderTempo.Value / 100), MIDIOUT_QUEUE
    SendMIDIOut (NOTE_ON + 9), (HSliderNote2 - 1), 127, (4000 * HSliderTempo.Value / 100), MIDIOUT_QUEUE
End Sub

' Queue a few MIDI events for a drum part
Sub DrumFill1 ()

    MIDIOutput1.MessageTag = 2000 + 100
    SendMIDIOut (NOTE_ON + 9), (HSliderNote2), 100, (500 * HSliderTempo.Value / 100), MIDIOUT_QUEUE
    
    MIDIOutput1.MessageTag = 2000 + 127
    SendMIDIOut (NOTE_ON + 9), (HSliderNote2), 127, (750 * HSliderTempo.Value / 100), MIDIOUT_QUEUE
    
    MIDIOutput1.MessageTag = 1000 + 100
    SendMIDIOut (NOTE_ON + 9), (HSliderNote1), 100, (1000 * HSliderTempo.Value / 100), MIDIOUT_QUEUE
    'Cymbal crash
    SendMIDIOut (NOTE_ON + 9), (HSliderNote1 + 13), 100, (1000 * HSliderTempo.Value / 100), MIDIOUT_QUEUE

    
    MIDIOutput1.MessageTag = 1000 + 127
    SendMIDIOut (NOTE_ON + 9), (HSliderNote1), 127, (1500 * HSliderTempo.Value / 100), MIDIOUT_QUEUE

    MIDIOutput1.MessageTag = 2000 + 127
    SendMIDIOut (NOTE_ON + 9), (HSliderNote2), 127, (2000 * HSliderTempo.Value / 100), MIDIOUT_QUEUE

End Sub

'Queue a few MIDI events for a high hat part
Sub DrumHH1 ()
    Dim HHSticked As Integer
    Dim HHOpen As Integer
    HHSticked = 42
    HHOpen = 46

    MIDIOutput1.MessageTag = 3000 + 100
    SendMIDIOut (NOTE_ON + 9), (HHOpen), 127, (500 * HSliderTempo.Value / 100), MIDIOUT_QUEUE
    SendMIDIOut (NOTE_ON + 9), (HHSticked), 100, (1000 * HSliderTempo.Value / 100), MIDIOUT_QUEUE
    SendMIDIOut (NOTE_ON + 9), (HHSticked), 100, (1500 * HSliderTempo.Value / 100), MIDIOUT_QUEUE
    SendMIDIOut (NOTE_ON + 9), (HHSticked), 100, (2000 * HSliderTempo.Value / 100), MIDIOUT_QUEUE

End Sub

' Queue a few MIDI events for a high hat part
Sub DrumHH2 ()
    Dim HHSticked As Integer
    Dim HHOpen As Integer
    HHSticked = 42
    HHOpen = 46

    MIDIOutput1.MessageTag = 3000 + 100
    SendMIDIOut (NOTE_ON + 9), (HHSticked), 127, (250 * HSliderTempo.Value / 100), MIDIOUT_QUEUE
    SendMIDIOut (NOTE_ON + 9), (HHOpen), 100, (500 * HSliderTempo.Value / 100), MIDIOUT_QUEUE
    SendMIDIOut (NOTE_ON + 9), (HHSticked), 100, (750 * HSliderTempo.Value / 100), MIDIOUT_QUEUE
    SendMIDIOut (NOTE_ON + 9), (HHSticked), 100, (1000 * HSliderTempo.Value / 100), MIDIOUT_QUEUE
    SendMIDIOut (NOTE_ON + 9), (HHSticked), 100, (1250 * HSliderTempo.Value / 100), MIDIOUT_QUEUE
    SendMIDIOut (NOTE_ON + 9), (HHSticked), 127, (1500 * HSliderTempo.Value / 100), MIDIOUT_QUEUE
    SendMIDIOut (NOTE_ON + 9), (HHSticked), 100, (1750 * HSliderTempo.Value / 100), MIDIOUT_QUEUE
    SendMIDIOut (NOTE_ON + 9), (HHSticked), 100, (2000 * HSliderTempo.Value / 100), MIDIOUT_QUEUE

End Sub

Sub FileExit_Click ()
    
	End
End Sub

Sub Form_Load ()
    Dim i As Integer

    '
    ' Fill output device combo box
    '
    For i = -1 To MIDIOutput1.DeviceCount - 1
	MIDIOutput1.DeviceID = i
	OutputDevCombo.AddItem MIDIOutput1.ProductName
    Next
    '
    ' Select first in list
    '
    MIDIOutput1.DeviceID = -1
    OutputDevCombo.ListIndex = 0
    
End Sub

Sub Form_Unload (Cancel As Integer)
    CloseOutputDevice
End Sub

Sub HSliderNote1_Change ()
     LabelNote1.Caption = Str(HSliderNote1)
End Sub

Sub HSliderNote1_Scroll ()
     LabelNote1.Caption = Str(HSliderNote1)
End Sub

Sub HSliderNote2_Change ()
    LabelNote2.Caption = Str(HSliderNote2)
End Sub

Sub HSliderNote2_Scroll ()
    LabelNote2.Caption = Str(HSliderNote2)
End Sub

Sub MIDIOutput1_Error (ErrorCode As Integer, ErrorMessage As String)
    MsgBox ErrorMessage
End Sub

Sub MIDIOutput1_MessageSent (MessageTag As Long)

    ' MessageTag has been passed to the program right as the MIDI message was
    ' sent to the output.  We coded the MessageTag with velocity data as we queued
    ' the events.  Now will set the VU meters with that velocity data.
    Select Case Left(MessageTag, 1)
	Case Is = 1
	    VuKick.Value = MessageTag - 1000
	Case Is = 2
	    VuSnare.Value = MessageTag - 2000
    End Select
    
End Sub

Sub MIDIOutput1_QueueEmpty ()
    'The MIDIOutput1 queue is empty.  Let's put some more MIDI data into the queue
    If OptionCymbal(0) = True Then DrumHH1
    If OptionCymbal(1) = True Then DrumHH2
    If OptionDrums(0) = True Then DrumBeat1
    If OptionDrums(1) = True Then DrumBeat2
    If OptionDrums(2) = True Then DrumFill1
    If OptionBass(0) = True Then DBass1
    If OptionBass(1) = True Then DBass2
End Sub

Sub MidiReset ()
    Dim x As Integer
    'Turn off all MIDI Notes on all channels.
    For x = 176 To 191
      MIDIOutput1.Message = x
      MIDIOutput1.Data1 = 123
      MIDIOutput1.Data2 = 0
      MIDIOutput1.Action = MIDIOUT_SEND
    Next
    MIDIOutput1.Action = MIDIOUT_STOP
End Sub

Sub mnuAbout_Click ()
    AboutBox1.Show
End Sub

Sub OpenOutputDevice ()
    '
    ' Open selected device
    '
    MIDIOutput1.DeviceID = OutputDevCombo.ListIndex - 1
    MIDIOutput1.Action = MIDIOUT_OPEN
    
End Sub

Sub OutputDevCombo_Click ()
    '
    ' Stop and Close currently opened device (if any)
    '
    StopPlay
End Sub

Sub SendMIDIOut (Message As Integer, Data1 As Integer, Data2 As Integer, TimeVal As Long, Action As Integer)

    ' Put MIDI data in MIDIoutput queue
    MIDIOutput1.Message = Message
    MIDIOutput1.Data1 = Data1
    MIDIOutput1.Data2 = Data2
    MIDIOutput1.Time = TimeVal
    MIDIOutput1.Action = Action

End Sub

Sub StartPlay ()
    OpenOutputDevice
    MIDIOutput1.Action = MIDIOUT_START
    
    'Queue the 4 count click off events
    DrumBeatStartingClicks
    CmdStart.Enabled = False
    CmdStop.Enabled = True
End Sub

Sub StopPlay ()
    MIDIOutput1.Action = MIDIOUT_STOP

    ' Turn off any bass notes still playing on MIDI channel 2
    MidiReset
    CloseOutputDevice
    CmdStart.Enabled = True
    CmdStop.Enabled = False
End Sub

Sub Timer1_Timer ()
    VuKick.Value = Int(VuKick.Value / 2 - .5)
    VuSnare.Value = Int(VuSnare.Value / 2 - .5)
End Sub

