Global Const Modal = 1

Global lVolume As Integer
Global rVolume As Integer

' MousePointer
Global Const DEFAULT = 0        ' 0 - Default
Global Const ARROW = 1          ' 1 - Arrow
Global Const CROSSHAIR = 2      ' 2 - Cross
Global Const IBEAM = 3          ' 3 - I-Beam
Global Const ICON_POINTER = 4   ' 4 - Icon
Global Const SIZE_POINTER = 5   ' 5 - Size
Global Const SIZE_NE_SW = 6     ' 6 - Size NE SW
Global Const SIZE_N_S = 7       ' 7 - Size N S
Global Const SIZE_NW_SE = 8     ' 8 - Size NW SE
Global Const SIZE_W_E = 9       ' 9 - Size W E
Global Const UP_ARROW = 10      ' 10 - Up Arrow
Global Const HOURGLASS = 11     ' 11 - Hourglass
Global Const NO_DROP = 12       ' 12 - No drop





Sub MIDIInOpen ()
    If FormMidiMixr.MIDIInput1.State >= MIDISTATE_OPEN Then
        ' Close midiin port
        FormMidiMixr.MIDIInput1.Action = MIDIIN_CLOSE
    End If

    
    ' Get selected device id
    FormMidiMixr.MIDIInput1.DeviceID = MIDISetupForm.ComboMidiIn.ListIndex
    
    ' Open and display handle
    FormMidiMixr.MIDIInput1.Action = MIDIIN_OPEN

    ' Start midi input
    FormMidiMixr.MIDIInput1.Action = MIDIIN_START
    
End Sub

Sub MIDIOutOpen ()

    If FormMidiMixr.MIDIOutput1.State >= MIDISTATE_OPEN Or FormMidiMixr.MIDIOutput1.DeviceID = -1 Then
        ' Restore volume before closing
        If (FormMidiMixr.MIDIOutput1.HasLRVolume) Then
            FormMidiMixr.MIDIOutput1.VolumeLeft = lVolume
            FormMidiMixr.MIDIOutput1.VolumeRight = rVolume
        ElseIf (FormMidiMixr.MIDIOutput1.HasVolume) Then
            FormMidiMixr.MIDIOutput1.VolumeLeft = lVolume
        End If
    
        ' Close
        FormMidiMixr.MIDIOutput1.Action = MIDIOUT_CLOSE
    
        ' Restore defaults
        FormMidiMixr.Knob1.Enabled = False
        FormMidiMixr.Knob1.Value = 0
    End If
    

    ' Open selected device
    FormMidiMixr.MIDIOutput1.DeviceID = MIDISetupForm.ComboMidiOut.ListIndex - 1
    FormMidiMixr.MIDIOutput1.Action = MIDIOUT_OPEN
    ' Display device handle

    If (FormMidiMixr.MIDIOutput1.HMidiDevice <> 0) Then
        
        ' If device supports volume, save starting volume
        If (FormMidiMixr.MIDIOutput1.HasLRVolume) Then
            FormMidiMixr.Knob1.Enabled = True
            FormMidiMixr.Knob1.Value = FormMidiMixr.MIDIOutput1.VolumeLeft
            FormMidiMixr.MIDIOutput1.VolumeRight = FormMidiMixr.Knob1.Value
            lVolume = FormMidiMixr.Knob1.Value
            rVolume = FormMidiMixr.Knob1.Value
        ElseIf (FormMidiMixr.MIDIOutput1.HasVolume) Then
            FormMidiMixr.Knob1.Enabled = True
            FormMidiMixr.Knob1.Value = FormMidiMixr.MIDIOutput1.VolumeLeft
            lVolume = FormMidiMixr.Knob1.Value
        End If
    End If

End Sub

Sub MidiOutputSend (Message As Integer, Data1 As Integer, Data2 As Integer, TimeVal As Long)
    FormMidiMixr.MIDIOutput1.Message = Message
    FormMidiMixr.MIDIOutput1.Data1 = Data1
    FormMidiMixr.MIDIOutput1.Data2 = Data2
    FormMidiMixr.MIDIOutput1.Time = TimeVal
        
    'Tell MIDIOutput1 to send the MIDI data
    FormMidiMixr.MIDIOutput1.Action = MIDIOUT_SEND

End Sub

