VERSION 2.00
Begin Form Form1 
   BackColor       =   &H00C0C0C0&
   BorderStyle     =   1  'Fixed Single
   Caption         =   "MIDI CoolTools - MIDI Thru Example"
   Height          =   3000
   Icon            =   MIDITHRU.FRX:0000
   Left            =   285
   LinkTopic       =   "Form1"
   MaxButton       =   0   'False
   ScaleHeight     =   2595
   ScaleWidth      =   8730
   Top             =   1260
   Width           =   8850
   Begin Frame Frame6 
      BackColor       =   &H00C0C0C0&
      Caption         =   "Transpose"
      Height          =   1635
      Left            =   7560
      TabIndex        =   28
      Top             =   60
      Width           =   1095
      Begin VSlider VSliderTranspose 
         BackColor       =   &H00C0C0C0&
         BevelInner      =   0  'None
         BevelOuter      =   0  'None
         BevelWidth      =   2
         BorderWidth     =   2
         Gap             =   3
         Height          =   975
         LargeChange     =   12
         Left            =   240
         LinkControl     =   ""
         LinkProperty    =   ""
         Max             =   36
         Min             =   -36
         ThumbHeight     =   200
         ThumbStyle      =   2  'Pointed Right
         ThumbWidth      =   335
         TickColor       =   &H00000000&
         TickCount       =   7
         TickLength      =   4
         TickMarks       =   2  'Right
         TickWidth       =   1
         Top             =   600
         TrackBevel      =   3  'Lowered
         TrackWidth      =   5
         Value           =   0
         Width           =   615
      End
      Begin Label LabelTranspose 
         Alignment       =   2  'Center
         BackColor       =   &H00000000&
         BorderStyle     =   1  'Fixed Single
         Caption         =   "0"
         FontBold        =   0   'False
         FontItalic      =   0   'False
         FontName        =   "MS Sans Serif"
         FontSize        =   9.75
         FontStrikethru  =   0   'False
         FontUnderline   =   0   'False
         ForeColor       =   &H0000FF00&
         Height          =   255
         Left            =   120
         TabIndex        =   29
         Top             =   280
         Width           =   855
      End
   End
   Begin Frame Frame5 
      BackColor       =   &H00C0C0C0&
      Caption         =   "MIDI Filtering"
      Height          =   1605
      Left            =   5550
      TabIndex        =   0
      Top             =   60
      Width           =   1785
      Begin CheckBox CheckMIDIFilter 
         BackColor       =   &H00C0C0C0&
         Caption         =   "Pitch Bend"
         FontBold        =   0   'False
         FontItalic      =   0   'False
         FontName        =   "MS Sans Serif"
         FontSize        =   8.25
         FontStrikethru  =   0   'False
         FontUnderline   =   0   'False
         Height          =   225
         Index           =   3
         Left            =   120
         TabIndex        =   1
         Top             =   1080
         Width           =   1605
      End
      Begin CheckBox CheckMIDIFilter 
         BackColor       =   &H00C0C0C0&
         Caption         =   "Active Sensing"
         FontBold        =   0   'False
         FontItalic      =   0   'False
         FontName        =   "MS Sans Serif"
         FontSize        =   8.25
         FontStrikethru  =   0   'False
         FontUnderline   =   0   'False
         Height          =   225
         Index           =   2
         Left            =   120
         TabIndex        =   2
         Top             =   600
         Width           =   1605
      End
      Begin CheckBox CheckMIDIFilter 
         BackColor       =   &H00C0C0C0&
         Caption         =   "Undefined F9"
         FontBold        =   0   'False
         FontItalic      =   0   'False
         FontName        =   "MS Sans Serif"
         FontSize        =   8.25
         FontStrikethru  =   0   'False
         FontUnderline   =   0   'False
         Height          =   225
         Index           =   1
         Left            =   120
         TabIndex        =   3
         Top             =   840
         Width           =   1365
      End
      Begin CheckBox CheckMIDIFilter 
         BackColor       =   &H00C0C0C0&
         Caption         =   "MIDI Time Clock"
         FontBold        =   0   'False
         FontItalic      =   0   'False
         FontName        =   "MS Sans Serif"
         FontSize        =   8.25
         FontStrikethru  =   0   'False
         FontUnderline   =   0   'False
         Height          =   225
         Index           =   0
         Left            =   120
         TabIndex        =   4
         Top             =   360
         Width           =   1515
      End
   End
   Begin Frame Frame4 
      BackColor       =   &H00C0C0C0&
      Caption         =   "L/R Volume"
      Height          =   1605
      Left            =   4290
      TabIndex        =   5
      Top             =   60
      Width           =   1215
      Begin VSlider VSlider1 
         BackColor       =   &H00C0C0C0&
         BevelInner      =   0  'None
         BevelOuter      =   2  'Inset
         BevelWidth      =   1
         BorderWidth     =   1
         Enabled         =   0   'False
         Gap             =   3
         Height          =   1215
         LargeChange     =   1000
         Left            =   120
         LinkControl     =   ""
         LinkProperty    =   ""
         Max             =   32767
         Min             =   0
         ThumbHeight     =   300
         ThumbStyle      =   3  'Lined
         ThumbWidth      =   280
         TickColor       =   &H00008000&
         TickCount       =   4
         TickLength      =   4
         TickMarks       =   3  'Both
         TickWidth       =   1
         Top             =   270
         TrackBevel      =   0  'None
         TrackWidth      =   1
         Value           =   0
         Width           =   465
      End
      Begin VSlider VSlider2 
         BackColor       =   &H00C0C0C0&
         BevelInner      =   0  'None
         BevelOuter      =   2  'Inset
         BevelWidth      =   1
         BorderWidth     =   1
         Enabled         =   0   'False
         Gap             =   3
         Height          =   1215
         LargeChange     =   1000
         Left            =   630
         LinkControl     =   ""
         LinkProperty    =   ""
         Max             =   32767
         Min             =   0
         ThumbHeight     =   300
         ThumbStyle      =   3  'Lined
         ThumbWidth      =   280
         TickColor       =   &H00008000&
         TickCount       =   4
         TickLength      =   4
         TickMarks       =   3  'Both
         TickWidth       =   1
         Top             =   270
         TrackBevel      =   0  'None
         TrackWidth      =   1
         Value           =   0
         Width           =   465
      End
   End
   Begin Frame Frame3 
      BackColor       =   &H00C0C0C0&
      Caption         =   "MIDI Out"
      Height          =   855
      Left            =   4320
      TabIndex        =   6
      Top             =   1710
      Width           =   4335
      Begin ComboBox Combo1 
         Height          =   300
         Left            =   90
         Style           =   2  'Dropdown List
         TabIndex        =   7
         Top             =   330
         Width           =   3495
      End
      Begin MIDIOutput MIDIOutput1 
         DeviceID        =   0
         Left            =   3690
         Top             =   270
         VolumeLeft      =   0
         VolumeRight     =   0
      End
   End
   Begin Frame Frame2 
      BackColor       =   &H00C0C0C0&
      Caption         =   "MIDI In"
      Height          =   855
      Left            =   30
      TabIndex        =   8
      Top             =   1710
      Width           =   4185
      Begin ComboBox Combo2 
         Height          =   300
         Left            =   60
         Style           =   2  'Dropdown List
         TabIndex        =   9
         Top             =   330
         Width           =   3525
      End
      Begin MIDIInput MIDIInput1 
         DeviceID        =   0
         Left            =   3660
         MaxSysexSize    =   0
         MessageEventEnable=   0   'False
         Top             =   300
      End
   End
   Begin Frame Frame1 
      BackColor       =   &H00C0C0C0&
      Caption         =   "Input Level"
      ClipControls    =   0   'False
      Height          =   1605
      Left            =   30
      TabIndex        =   18
      Top             =   60
      Width           =   4215
      Begin CheckBox CheckMeter 
         BackColor       =   &H00C0C0C0&
         Caption         =   "Meters On"
         FontBold        =   0   'False
         FontItalic      =   0   'False
         FontName        =   "MS Sans Serif"
         FontSize        =   8.25
         FontStrikethru  =   0   'False
         FontUnderline   =   0   'False
         Height          =   255
         Left            =   150
         TabIndex        =   10
         Top             =   1260
         Value           =   1  'Checked
         Width           =   1095
      End
      Begin VIndicator VIndicator1 
         BackColor       =   &H00404040&
         BevelInner      =   0  'None
         BevelOuter      =   0  'None
         BevelWidth      =   1
         Border          =   1  'Single Width
         BorderWidth     =   0
         Height          =   765
         Index           =   0
         ItemBackColor   =   &H00000000&
         ItemCount1      =   4
         ItemCount2      =   1
         ItemCount3      =   2
         ItemForeColor1  =   &H0000FF00&
         ItemForeColor2  =   &H0000FFFF&
         ItemForeColor3  =   &H000000FF&
         Left            =   150
         LinkControl     =   ""
         LinkProperty    =   ""
         Max             =   127
         Min             =   0
         ThreeD          =   0   'False
         Top             =   260
         Value           =   0
         Width           =   195
      End
      Begin VIndicator VIndicator1 
         BackColor       =   &H00404040&
         BevelInner      =   0  'None
         BevelOuter      =   0  'None
         BevelWidth      =   1
         Border          =   1  'Single Width
         BorderWidth     =   0
         Height          =   765
         Index           =   1
         ItemBackColor   =   &H00000000&
         ItemCount1      =   4
         ItemCount2      =   1
         ItemCount3      =   2
         ItemForeColor1  =   &H0000FF00&
         ItemForeColor2  =   &H0000FFFF&
         ItemForeColor3  =   &H000000FF&
         Left            =   390
         LinkControl     =   ""
         LinkProperty    =   ""
         Max             =   127
         Min             =   0
         ThreeD          =   0   'False
         Top             =   260
         Value           =   0
         Width           =   195
      End
      Begin VIndicator VIndicator1 
         BackColor       =   &H00404040&
         BevelInner      =   0  'None
         BevelOuter      =   0  'None
         BevelWidth      =   1
         Border          =   1  'Single Width
         BorderWidth     =   0
         Height          =   765
         Index           =   2
         ItemBackColor   =   &H00000000&
         ItemCount1      =   4
         ItemCount2      =   1
         ItemCount3      =   2
         ItemForeColor1  =   &H0000FF00&
         ItemForeColor2  =   &H0000FFFF&
         ItemForeColor3  =   &H000000FF&
         Left            =   630
         LinkControl     =   ""
         LinkProperty    =   ""
         Max             =   127
         Min             =   0
         ThreeD          =   0   'False
         Top             =   260
         Value           =   0
         Width           =   195
      End
      Begin VIndicator VIndicator1 
         BackColor       =   &H00404040&
         BevelInner      =   0  'None
         BevelOuter      =   0  'None
         BevelWidth      =   1
         Border          =   1  'Single Width
         BorderWidth     =   0
         Height          =   765
         Index           =   3
         ItemBackColor   =   &H00000000&
         ItemCount1      =   4
         ItemCount2      =   1
         ItemCount3      =   2
         ItemForeColor1  =   &H0000FF00&
         ItemForeColor2  =   &H0000FFFF&
         ItemForeColor3  =   &H000000FF&
         Left            =   870
         LinkControl     =   ""
         LinkProperty    =   ""
         Max             =   127
         Min             =   0
         ThreeD          =   0   'False
         Top             =   260
         Value           =   0
         Width           =   195
      End
      Begin VIndicator VIndicator1 
         BackColor       =   &H00404040&
         BevelInner      =   0  'None
         BevelOuter      =   0  'None
         BevelWidth      =   1
         Border          =   1  'Single Width
         BorderWidth     =   0
         Height          =   765
         Index           =   4
         ItemBackColor   =   &H00000000&
         ItemCount1      =   4
         ItemCount2      =   1
         ItemCount3      =   2
         ItemForeColor1  =   &H0000FF00&
         ItemForeColor2  =   &H0000FFFF&
         ItemForeColor3  =   &H000000FF&
         Left            =   1110
         LinkControl     =   ""
         LinkProperty    =   ""
         Max             =   127
         Min             =   0
         ThreeD          =   0   'False
         Top             =   260
         Value           =   0
         Width           =   195
      End
      Begin VIndicator VIndicator1 
         BackColor       =   &H00404040&
         BevelInner      =   0  'None
         BevelOuter      =   0  'None
         BevelWidth      =   1
         Border          =   1  'Single Width
         BorderWidth     =   0
         Height          =   765
         Index           =   5
         ItemBackColor   =   &H00000000&
         ItemCount1      =   4
         ItemCount2      =   1
         ItemCount3      =   2
         ItemForeColor1  =   &H0000FF00&
         ItemForeColor2  =   &H0000FFFF&
         ItemForeColor3  =   &H000000FF&
         Left            =   1350
         LinkControl     =   ""
         LinkProperty    =   ""
         Max             =   127
         Min             =   0
         ThreeD          =   0   'False
         Top             =   260
         Value           =   0
         Width           =   195
      End
      Begin VIndicator VIndicator1 
         BackColor       =   &H00404040&
         BevelInner      =   0  'None
         BevelOuter      =   0  'None
         BevelWidth      =   1
         Border          =   1  'Single Width
         BorderWidth     =   0
         Height          =   765
         Index           =   6
         ItemBackColor   =   &H00000000&
         ItemCount1      =   4
         ItemCount2      =   1
         ItemCount3      =   2
         ItemForeColor1  =   &H0000FF00&
         ItemForeColor2  =   &H0000FFFF&
         ItemForeColor3  =   &H000000FF&
         Left            =   1590
         LinkControl     =   ""
         LinkProperty    =   ""
         Max             =   127
         Min             =   0
         ThreeD          =   0   'False
         Top             =   260
         Value           =   0
         Width           =   195
      End
      Begin VIndicator VIndicator1 
         BackColor       =   &H00404040&
         BevelInner      =   0  'None
         BevelOuter      =   0  'None
         BevelWidth      =   1
         Border          =   1  'Single Width
         BorderWidth     =   0
         Height          =   765
         Index           =   7
         ItemBackColor   =   &H00000000&
         ItemCount1      =   4
         ItemCount2      =   1
         ItemCount3      =   2
         ItemForeColor1  =   &H0000FF00&
         ItemForeColor2  =   &H0000FFFF&
         ItemForeColor3  =   &H000000FF&
         Left            =   1830
         LinkControl     =   ""
         LinkProperty    =   ""
         Max             =   127
         Min             =   0
         ThreeD          =   0   'False
         Top             =   260
         Value           =   0
         Width           =   195
      End
      Begin VIndicator VIndicator1 
         BackColor       =   &H00404040&
         BevelInner      =   0  'None
         BevelOuter      =   0  'None
         BevelWidth      =   1
         Border          =   1  'Single Width
         BorderWidth     =   0
         Height          =   765
         Index           =   8
         ItemBackColor   =   &H00000000&
         ItemCount1      =   4
         ItemCount2      =   1
         ItemCount3      =   2
         ItemForeColor1  =   &H0000FF00&
         ItemForeColor2  =   &H0000FFFF&
         ItemForeColor3  =   &H000000FF&
         Left            =   2070
         LinkControl     =   ""
         LinkProperty    =   ""
         Max             =   127
         Min             =   0
         ThreeD          =   0   'False
         Top             =   260
         Value           =   0
         Width           =   195
      End
      Begin VIndicator VIndicator1 
         BackColor       =   &H00404040&
         BevelInner      =   0  'None
         BevelOuter      =   0  'None
         BevelWidth      =   1
         Border          =   1  'Single Width
         BorderWidth     =   0
         Height          =   765
         Index           =   9
         ItemBackColor   =   &H00000000&
         ItemCount1      =   4
         ItemCount2      =   1
         ItemCount3      =   2
         ItemForeColor1  =   &H0000FF00&
         ItemForeColor2  =   &H0000FFFF&
         ItemForeColor3  =   &H000000FF&
         Left            =   2310
         LinkControl     =   ""
         LinkProperty    =   ""
         Max             =   127
         Min             =   0
         ThreeD          =   0   'False
         Top             =   260
         Value           =   0
         Width           =   195
      End
      Begin VIndicator VIndicator1 
         BackColor       =   &H00404040&
         BevelInner      =   0  'None
         BevelOuter      =   0  'None
         BevelWidth      =   1
         Border          =   1  'Single Width
         BorderWidth     =   0
         Height          =   765
         Index           =   10
         ItemBackColor   =   &H00000000&
         ItemCount1      =   4
         ItemCount2      =   1
         ItemCount3      =   2
         ItemForeColor1  =   &H0000FF00&
         ItemForeColor2  =   &H0000FFFF&
         ItemForeColor3  =   &H000000FF&
         Left            =   2550
         LinkControl     =   ""
         LinkProperty    =   ""
         Max             =   127
         Min             =   0
         ThreeD          =   0   'False
         Top             =   260
         Value           =   0
         Width           =   195
      End
      Begin VIndicator VIndicator1 
         BackColor       =   &H00404040&
         BevelInner      =   0  'None
         BevelOuter      =   0  'None
         BevelWidth      =   1
         Border          =   1  'Single Width
         BorderWidth     =   0
         Height          =   765
         Index           =   11
         ItemBackColor   =   &H00000000&
         ItemCount1      =   4
         ItemCount2      =   1
         ItemCount3      =   2
         ItemForeColor1  =   &H0000FF00&
         ItemForeColor2  =   &H0000FFFF&
         ItemForeColor3  =   &H000000FF&
         Left            =   2790
         LinkControl     =   ""
         LinkProperty    =   ""
         Max             =   127
         Min             =   0
         ThreeD          =   0   'False
         Top             =   260
         Value           =   0
         Width           =   195
      End
      Begin VIndicator VIndicator1 
         BackColor       =   &H00404040&
         BevelInner      =   0  'None
         BevelOuter      =   0  'None
         BevelWidth      =   1
         Border          =   1  'Single Width
         BorderWidth     =   0
         Height          =   765
         Index           =   12
         ItemBackColor   =   &H00000000&
         ItemCount1      =   4
         ItemCount2      =   1
         ItemCount3      =   2
         ItemForeColor1  =   &H0000FF00&
         ItemForeColor2  =   &H0000FFFF&
         ItemForeColor3  =   &H000000FF&
         Left            =   3030
         LinkControl     =   ""
         LinkProperty    =   ""
         Max             =   127
         Min             =   0
         ThreeD          =   0   'False
         Top             =   260
         Value           =   0
         Width           =   195
      End
      Begin VIndicator VIndicator1 
         BackColor       =   &H00404040&
         BevelInner      =   0  'None
         BevelOuter      =   0  'None
         BevelWidth      =   1
         Border          =   1  'Single Width
         BorderWidth     =   0
         Height          =   765
         Index           =   13
         ItemBackColor   =   &H00000000&
         ItemCount1      =   4
         ItemCount2      =   1
         ItemCount3      =   2
         ItemForeColor1  =   &H0000FF00&
         ItemForeColor2  =   &H0000FFFF&
         ItemForeColor3  =   &H000000FF&
         Left            =   3270
         LinkControl     =   ""
         LinkProperty    =   ""
         Max             =   127
         Min             =   0
         ThreeD          =   0   'False
         Top             =   260
         Value           =   0
         Width           =   195
      End
      Begin VIndicator VIndicator1 
         BackColor       =   &H00404040&
         BevelInner      =   0  'None
         BevelOuter      =   0  'None
         BevelWidth      =   1
         Border          =   1  'Single Width
         BorderWidth     =   0
         Height          =   765
         Index           =   14
         ItemBackColor   =   &H00000000&
         ItemCount1      =   4
         ItemCount2      =   1
         ItemCount3      =   2
         ItemForeColor1  =   &H0000FF00&
         ItemForeColor2  =   &H0000FFFF&
         ItemForeColor3  =   &H000000FF&
         Left            =   3510
         LinkControl     =   ""
         LinkProperty    =   ""
         Max             =   127
         Min             =   0
         ThreeD          =   0   'False
         Top             =   260
         Value           =   0
         Width           =   195
      End
      Begin VIndicator VIndicator1 
         BackColor       =   &H00404040&
         BevelInner      =   0  'None
         BevelOuter      =   0  'None
         BevelWidth      =   1
         Border          =   1  'Single Width
         BorderWidth     =   0
         Height          =   765
         Index           =   15
         ItemBackColor   =   &H00000000&
         ItemCount1      =   4
         ItemCount2      =   1
         ItemCount3      =   2
         ItemForeColor1  =   &H0000FF00&
         ItemForeColor2  =   &H0000FFFF&
         ItemForeColor3  =   &H000000FF&
         Left            =   3750
         LinkControl     =   ""
         LinkProperty    =   ""
         Max             =   127
         Min             =   0
         ThreeD          =   0   'False
         Top             =   260
         Value           =   0
         Width           =   195
      End
      Begin Label Label1 
         Alignment       =   2  'Center
         BackColor       =   &H00C0C0C0&
         Caption         =   "1"
         FontBold        =   0   'False
         FontItalic      =   0   'False
         FontName        =   "Small Fonts"
         FontSize        =   6.75
         FontStrikethru  =   0   'False
         FontUnderline   =   0   'False
         Height          =   270
         Index           =   0
         Left            =   150
         TabIndex        =   11
         Top             =   1110
         Width           =   195
      End
      Begin Label Label1 
         Alignment       =   2  'Center
         BackColor       =   &H00C0C0C0&
         Caption         =   "2"
         FontBold        =   0   'False
         FontItalic      =   0   'False
         FontName        =   "Small Fonts"
         FontSize        =   6.75
         FontStrikethru  =   0   'False
         FontUnderline   =   0   'False
         Height          =   270
         Index           =   1
         Left            =   390
         TabIndex        =   12
         Top             =   1110
         Width           =   195
      End
      Begin Label Label1 
         Alignment       =   2  'Center
         BackColor       =   &H00C0C0C0&
         Caption         =   "3"
         FontBold        =   0   'False
         FontItalic      =   0   'False
         FontName        =   "Small Fonts"
         FontSize        =   6.75
         FontStrikethru  =   0   'False
         FontUnderline   =   0   'False
         Height          =   270
         Index           =   2
         Left            =   630
         TabIndex        =   13
         Top             =   1110
         Width           =   195
      End
      Begin Label Label1 
         Alignment       =   2  'Center
         BackColor       =   &H00C0C0C0&
         Caption         =   "4"
         FontBold        =   0   'False
         FontItalic      =   0   'False
         FontName        =   "Small Fonts"
         FontSize        =   6.75
         FontStrikethru  =   0   'False
         FontUnderline   =   0   'False
         Height          =   270
         Index           =   3
         Left            =   870
         TabIndex        =   14
         Top             =   1110
         Width           =   195
      End
      Begin Label Label1 
         Alignment       =   2  'Center
         BackColor       =   &H00C0C0C0&
         Caption         =   "5"
         FontBold        =   0   'False
         FontItalic      =   0   'False
         FontName        =   "Small Fonts"
         FontSize        =   6.75
         FontStrikethru  =   0   'False
         FontUnderline   =   0   'False
         Height          =   270
         Index           =   4
         Left            =   1110
         TabIndex        =   15
         Top             =   1110
         Width           =   195
      End
      Begin Label Label1 
         Alignment       =   2  'Center
         BackColor       =   &H00C0C0C0&
         Caption         =   "6"
         FontBold        =   0   'False
         FontItalic      =   0   'False
         FontName        =   "Small Fonts"
         FontSize        =   6.75
         FontStrikethru  =   0   'False
         FontUnderline   =   0   'False
         Height          =   270
         Index           =   5
         Left            =   1350
         TabIndex        =   16
         Top             =   1110
         Width           =   195
      End
      Begin Label Label1 
         Alignment       =   2  'Center
         BackColor       =   &H00C0C0C0&
         Caption         =   "7"
         FontBold        =   0   'False
         FontItalic      =   0   'False
         FontName        =   "Small Fonts"
         FontSize        =   6.75
         FontStrikethru  =   0   'False
         FontUnderline   =   0   'False
         Height          =   270
         Index           =   6
         Left            =   1590
         TabIndex        =   17
         Top             =   1110
         Width           =   195
      End
      Begin Label Label1 
         Alignment       =   2  'Center
         BackColor       =   &H00C0C0C0&
         Caption         =   "8"
         FontBold        =   0   'False
         FontItalic      =   0   'False
         FontName        =   "Small Fonts"
         FontSize        =   6.75
         FontStrikethru  =   0   'False
         FontUnderline   =   0   'False
         Height          =   270
         Index           =   7
         Left            =   1830
         TabIndex        =   27
         Top             =   1110
         Width           =   195
      End
      Begin Label Label1 
         Alignment       =   2  'Center
         BackColor       =   &H00C0C0C0&
         Caption         =   "9"
         FontBold        =   0   'False
         FontItalic      =   0   'False
         FontName        =   "Small Fonts"
         FontSize        =   6.75
         FontStrikethru  =   0   'False
         FontUnderline   =   0   'False
         Height          =   270
         Index           =   8
         Left            =   2070
         TabIndex        =   26
         Top             =   1110
         Width           =   195
      End
      Begin Label Label1 
         Alignment       =   2  'Center
         BackColor       =   &H00C0C0C0&
         Caption         =   "10"
         FontBold        =   0   'False
         FontItalic      =   0   'False
         FontName        =   "Small Fonts"
         FontSize        =   6.75
         FontStrikethru  =   0   'False
         FontUnderline   =   0   'False
         Height          =   270
         Index           =   9
         Left            =   2310
         TabIndex        =   25
         Top             =   1110
         Width           =   195
      End
      Begin Label Label1 
         Alignment       =   2  'Center
         BackColor       =   &H00C0C0C0&
         Caption         =   "11"
         FontBold        =   0   'False
         FontItalic      =   0   'False
         FontName        =   "Small Fonts"
         FontSize        =   6.75
         FontStrikethru  =   0   'False
         FontUnderline   =   0   'False
         Height          =   270
         Index           =   10
         Left            =   2550
         TabIndex        =   24
         Top             =   1110
         Width           =   195
      End
      Begin Label Label1 
         Alignment       =   2  'Center
         BackColor       =   &H00C0C0C0&
         Caption         =   "12"
         FontBold        =   0   'False
         FontItalic      =   0   'False
         FontName        =   "Small Fonts"
         FontSize        =   6.75
         FontStrikethru  =   0   'False
         FontUnderline   =   0   'False
         Height          =   270
         Index           =   11
         Left            =   2790
         TabIndex        =   23
         Top             =   1110
         Width           =   195
      End
      Begin Label Label1 
         Alignment       =   2  'Center
         BackColor       =   &H00C0C0C0&
         Caption         =   "13"
         FontBold        =   0   'False
         FontItalic      =   0   'False
         FontName        =   "Small Fonts"
         FontSize        =   6.75
         FontStrikethru  =   0   'False
         FontUnderline   =   0   'False
         Height          =   270
         Index           =   12
         Left            =   3030
         TabIndex        =   22
         Top             =   1110
         Width           =   195
      End
      Begin Label Label1 
         Alignment       =   2  'Center
         BackColor       =   &H00C0C0C0&
         Caption         =   "14"
         FontBold        =   0   'False
         FontItalic      =   0   'False
         FontName        =   "Small Fonts"
         FontSize        =   6.75
         FontStrikethru  =   0   'False
         FontUnderline   =   0   'False
         Height          =   270
         Index           =   13
         Left            =   3270
         TabIndex        =   21
         Top             =   1110
         Width           =   195
      End
      Begin Label Label1 
         Alignment       =   2  'Center
         BackColor       =   &H00C0C0C0&
         Caption         =   "15"
         FontBold        =   0   'False
         FontItalic      =   0   'False
         FontName        =   "Small Fonts"
         FontSize        =   6.75
         FontStrikethru  =   0   'False
         FontUnderline   =   0   'False
         Height          =   270
         Index           =   14
         Left            =   3510
         TabIndex        =   20
         Top             =   1110
         Width           =   195
      End
      Begin Label Label1 
         Alignment       =   2  'Center
         BackColor       =   &H00C0C0C0&
         Caption         =   "16"
         FontBold        =   0   'False
         FontItalic      =   0   'False
         FontName        =   "Small Fonts"
         FontSize        =   6.75
         FontStrikethru  =   0   'False
         FontUnderline   =   0   'False
         Height          =   270
         Index           =   15
         Left            =   3750
         TabIndex        =   19
         Top             =   1110
         Width           =   195
      End
   End
End

Option Explicit

Dim lVolume As Integer
Dim rVolume As Integer

Sub CheckMIDIFilter_Click (index As Integer)
    Select Case index
	Case Is = 0
	    If CheckMIDIFilter(index).Value = 0 Then
		MIDIInput1.Filter(FILTER_F9) = False
	    Else
		MIDIInput1.Filter(FILTER_F9) = True
	    End If
	Case Is = 1
	    If CheckMIDIFilter(index) = 0 Then
		MIDIInput1.Filter(FILTER_ACTIVE_SENSE) = False
	    Else
		MIDIInput1.Filter(FILTER_ACTIVE_SENSE) = True
	    End If
	Case Is = 2
	    If CheckMIDIFilter(index) = 0 Then
		MIDIInput1.Filter(FILTER_CLOCK) = False
	    Else
		MIDIInput1.Filter(FILTER_CLOCK) = True
	    End If
	Case Is = 3
	    If CheckMIDIFilter(index) = 0 Then
		MIDIInput1.Filter(PITCH_BEND) = False
	    Else
		MIDIInput1.Filter(PITCH_BEND) = True
	    End If
	
    End Select
End Sub

Sub Combo1_Click ()
    Dim wRtn As Integer

    If MIDIOutput1.State >= MIDISTATE_OPEN Or MIDIOutput1.DeviceID = -1 Then
	' Restore volume before closing
	If (MIDIOutput1.HasLRVolume) Then
	    MIDIOutput1.VolumeLeft = lVolume
	    MIDIOutput1.VolumeRight = rVolume
	ElseIf (MIDIOutput1.HasVolume) Then
	    MIDIOutput1.VolumeLeft = lVolume
	End If
    
	' Close
	MIDIOutput1.Action = MIDIOUT_CLOSE
    
	' Restore defaults
	VSlider1.Enabled = False
	VSlider2.Enabled = False
	VSlider1.Value = 0
	VSlider2.Value = 0
    End If
    

    ' Open selected device
    MIDIOutput1.DeviceID = Combo1.ListIndex - 1
    MIDIOutput1.Action = MIDIOUT_OPEN
    
    ' Display device handle
    If (MIDIOutput1.HMidiDevice <> 0) Then
	
	' If device supports volume, save starting volume
	If (MIDIOutput1.HasLRVolume) Then
	    VSlider1.Enabled = True
	    VSlider2.Enabled = True
	    VSlider1.Value = MIDIOutput1.VolumeLeft
	    VSlider2.Value = MIDIOutput1.VolumeRight
	    lVolume = VSlider1.Value
	    rVolume = VSlider2.Value
	ElseIf (MIDIOutput1.HasVolume) Then
	    VSlider1.Enabled = True
	    VSlider1.Value = MIDIOutput1.VolumeLeft
	    lVolume = VSlider1.Value
	End If
    End If
End Sub

Sub Combo2_Click ()
    Dim wRtn As Integer
    
    If MIDIInput1.State >= MIDISTATE_OPEN Then
	' Close midiin port
	MIDIInput1.Action = MIDIIN_CLOSE
    End If

    
    ' Get selected device id
    MIDIInput1.DeviceID = Combo2.ListIndex
    
    ' Open and display handle
    MIDIInput1.Action = MIDIIN_OPEN

    ' Start midi input
    MIDIInput1.Action = MIDIIN_START
End Sub

Sub Form_Load ()
    Dim i As Integer

    ' Center the form on the screen
    'Move (Screen.Width - Width) \ 2, (Screen.Height - Height) \ 2

    Form1.Show
    '
    ' Fill output device combo box
    '
    For i = -1 To MIDIOutput1.DeviceCount - 1
	MIDIOutput1.DeviceID = i
	Combo1.AddItem MIDIOutput1.ProductName
    Next
    '
    ' Select first in list
    '
    Combo1.ListIndex = 0
    MIDIOutput1.DeviceID = -1
    Combo1_Click

    '
    ' Fill input device combo box
    '
    For i = 0 To MIDIInput1.DeviceCount - 1
	MIDIInput1.DeviceID = i
	Combo2.AddItem MIDIInput1.ProductName
    Next
    '
    ' Select first in list
    '
    Combo2.ListIndex = 0
    MIDIInput1.DeviceID = 0
    Combo2_Click
End Sub

Sub Form_Unload (Cancel As Integer)
    MIDIInput1.Action = MIDIIN_STOP
    
    ' Close midiin port
    MIDIInput1.Action = MIDIIN_CLOSE

    ' Restore volume before closing
    If (MIDIOutput1.HasLRVolume) Then
	MIDIOutput1.VolumeLeft = lVolume
	MIDIOutput1.VolumeRight = rVolume
    ElseIf (MIDIOutput1.HasVolume) Then
	MIDIOutput1.VolumeLeft = lVolume
    End If
    
    ' Close
    MIDIOutput1.Action = MIDIOUT_CLOSE
End Sub

Sub MIDIInput1_Error (ErrorCode As Integer, ErrorMessage As String)
    MsgBox ErrorMessage
End Sub

Sub MIDIInput1_Message ()
    Dim InMessage As Integer
    Dim InData1 As Integer
    Dim InData2 As Integer


    '
    'This do while loop allows you to take all the messages that are
    'waiting in the message queue.
    '
    Do While MIDIInput1.MessageCount > 0
	'
	'This is the incoming MIDI data
	'

	InMessage = MIDIInput1.Message
	InData1 = MIDIInput1.Data1
	InData2 = MIDIInput1.Data2

	' Labels in VB 3.0 are very slow in updating/repainting,
	' at least in terms of real-time.  If you use a label REFRESH
	' method you will experience some time delay.
	'
	' Generally, painting of a label control is handled automatically
	' by VB while no events are occurring.  So if you try to force
	' VB to repaint a label control immediately you will be taking
	' away from the real-time processing of MIDI data.  The following
	' is an example of a label refresh.
	' LblInQueueCount.Caption = MIDIInput1.MessageCount
	' LblInQueueCount.Refresh
	'

	' If this is a note on or note off event, transpose it according to the
	' value of VSliderTranspose control.
	If InMessage >= 128 And InMessage <= 159 Then
	    InData1 = InData1 + VSliderTranspose
	End If
	
	'
	' Now we are going to send the MIDI data that just came in the
	' MIDI IN, right back out the MIDI OUT
	'
	MIDIOutput1.Message = InMessage
	MIDIOutput1.Data1 = InData1
	MIDIOutput1.Data2 = InData2
    
	'
	'Tell MIDIOutput1 to send the MIDI data
	'
	MIDIOutput1.Action = MIDIOUT_SEND

	'
	'Remove the MIDI data from the MIDI IN queue
	'
	MIDIInput1.Action = MIDIIN_REMOVE
    Loop

    '
    ' Make MIDI Note On volume from one of 16 MIDI channels light correct
    ' VU meter.  If MIDI Note Off then 0 VU Meter.  CheckMeter must be on.
    '
    ' The VIndicator routine is placed outside the MessageCount loop
    ' because we don't want screen updating to slow us down if a lot
    ' a MIDI messages are coming in.
    '
    If InMessage >= 144 And InMessage <= 159 And CheckMeter.Value = 1 Then
	VIndicator1(InMessage Mod 16).Value = InData2
    ElseIf InMessage >= 128 And InMessage <= 143 And CheckMeter.Value = 1 Then
	VIndicator1(InMessage Mod 16).Value = 0
    End If
End Sub

Sub MIDIOutput1_Error (ErrorCode As Integer, ErrorMessage As String)
    MsgBox ErrorMessage
End Sub

Sub VSlider1_Change ()
    If (MIDIOutput1.HMidiDevice <> 0) Then
	MIDIOutput1.VolumeLeft = VSlider1.Value
    End If
End Sub

Sub VSlider1_Scroll ()
    If (MIDIOutput1.HMidiDevice <> 0) Then
	MIDIOutput1.VolumeLeft = VSlider1.Value
    End If
End Sub

Sub VSlider2_Change ()
    If (MIDIOutput1.HMidiDevice <> 0) Then
	MIDIOutput1.VolumeRight = VSlider2.Value
    End If
End Sub

Sub VSlider2_Scroll ()
    If (MIDIOutput1.HMidiDevice <> 0) Then
	MIDIOutput1.VolumeRight = VSlider2.Value
    End If
End Sub

Sub VSliderTranspose_Change ()
    LabelTranspose.Caption = Str(VSliderTranspose.Value)
End Sub

Sub VSliderTranspose_Scroll ()
    LabelTranspose.Caption = Str(VSliderTranspose.Value)
End Sub

