VERSION 2.00
Begin Form Piano 
   BackColor       =   &H00C0C0C0&
   BorderStyle     =   0  'None
   Caption         =   "MIDI CoolTools - Piano"
   Height          =   2355
   Icon            =   PIANO2.FRX:0000
   Left            =   45
   LinkTopic       =   "Form1"
   MaxButton       =   0   'False
   ScaleHeight     =   1665
   ScaleWidth      =   9330
   Top             =   1530
   Width           =   9450
   Begin Frame Frame1 
      BackColor       =   &H00C0C0C0&
      Height          =   915
      Left            =   -30
      TabIndex        =   8
      Top             =   0
      Width           =   9375
      Begin ComboBox ComboPatch 
         BackColor       =   &H00000000&
         FontBold        =   0   'False
         FontItalic      =   0   'False
         FontName        =   "MS Sans Serif"
         FontSize        =   8.25
         FontStrikethru  =   0   'False
         FontUnderline   =   0   'False
         ForeColor       =   &H0000FF00&
         Height          =   300
         Left            =   5460
         Style           =   2  'Dropdown List
         TabIndex        =   5
         Top             =   510
         Width           =   2295
      End
      Begin Knob KnobPan 
         BackColor       =   &H00C0C0C0&
         BevelWidth      =   2
         BorderWidth     =   0
         FontBold        =   0   'False
         FontItalic      =   0   'False
         FontName        =   "Small Fonts"
         FontSize        =   5.25
         FontStrikethru  =   0   'False
         FontUnderline   =   0   'False
         Height          =   600
         Indicator       =   1  'Line
         IndicatorColor  =   &H000000FF&
         IndicatorWidth  =   0
         KnobColor       =   &H00C0C0C0&
         KnobStyle       =   3  'Textured
         Left            =   8160
         LinkControl     =   ""
         LinkProperty    =   ""
         Max             =   127
         Min             =   0
         Radius          =   240
         TickCaptionColor=   &H00000000&
         TickCaptions    =   PIANO2.FRX:0302
         TickColor       =   &H00000000&
         TickCount       =   0
         TickGap         =   1
         TickLength      =   4
         TickWidth       =   1
         Top             =   300
         Value           =   1
         Width           =   855
      End
      Begin HSlider HSliderMIDIChannel 
         BackColor       =   &H00C0C0C0&
         BevelInner      =   0  'None
         BevelOuter      =   0  'None
         BevelWidth      =   1
         BorderWidth     =   1
         Gap             =   3
         Height          =   315
         LargeChange     =   2
         Left            =   90
         LinkControl     =   ""
         LinkProperty    =   ""
         Max             =   15
         Min             =   0
         ThumbHeight     =   245
         ThumbStyle      =   1  'Pointed Up
         ThumbWidth      =   200
         TickColor       =   &H00000000&
         TickCount       =   16
         TickLength      =   4
         TickMarks       =   1  'Top
         TickWidth       =   1
         Top             =   570
         TrackBevel      =   1  'Raised
         TrackWidth      =   3
         Value           =   1
         Width           =   1665
      End
      Begin HSlider HSliderVolume 
         BackColor       =   &H00C0C0C0&
         BevelInner      =   0  'None
         BevelOuter      =   0  'None
         BevelWidth      =   1
         BorderWidth     =   1
         Gap             =   3
         Height          =   315
         LargeChange     =   2
         Left            =   2160
         LinkControl     =   ""
         LinkProperty    =   ""
         Max             =   127
         Min             =   0
         ThumbHeight     =   245
         ThumbStyle      =   3  'Lined
         ThumbWidth      =   320
         TickColor       =   &H00000000&
         TickCount       =   5
         TickLength      =   4
         TickMarks       =   0  'No Tick Marks
         TickWidth       =   1
         Top             =   570
         TrackBevel      =   1  'Raised
         TrackWidth      =   3
         Value           =   1
         Width           =   1275
      End
      Begin HSlider HSliderOctave 
         BackColor       =   &H00C0C0C0&
         BevelInner      =   0  'None
         BevelOuter      =   0  'None
         BevelWidth      =   1
         BorderWidth     =   1
         Gap             =   3
         Height          =   315
         LargeChange     =   2
         Left            =   3900
         LinkControl     =   ""
         LinkProperty    =   ""
         Max             =   3
         Min             =   0
         ThumbHeight     =   245
         ThumbStyle      =   1  'Pointed Up
         ThumbWidth      =   200
         TickColor       =   &H00000000&
         TickCount       =   4
         TickLength      =   4
         TickMarks       =   1  'Top
         TickWidth       =   1
         Top             =   570
         TrackBevel      =   1  'Raised
         TrackWidth      =   3
         Value           =   1
         Width           =   1185
      End
      Begin Label Label5 
         BackColor       =   &H00C0C0C0&
         Caption         =   "L - Pan - R"
         Height          =   255
         Left            =   8130
         TabIndex        =   9
         Top             =   120
         Width           =   1005
      End
      Begin Label MidiChannelOutLabel 
         Alignment       =   2  'Center
         BackColor       =   &H00000000&
         Caption         =   "1"
         FontBold        =   0   'False
         FontItalic      =   0   'False
         FontName        =   "MS Sans Serif"
         FontSize        =   9.75
         FontStrikethru  =   0   'False
         FontUnderline   =   0   'False
         ForeColor       =   &H0000FF00&
         Height          =   255
         Left            =   1350
         TabIndex        =   0
         Top             =   270
         Width           =   405
      End
      Begin Label Label1 
         BackColor       =   &H00C0C0C0&
         Caption         =   "MIDI Channel"
         Height          =   255
         Left            =   120
         TabIndex        =   1
         Top             =   270
         Width           =   1215
      End
      Begin Label Label2 
         BackColor       =   &H00C0C0C0&
         Caption         =   "Volume"
         Height          =   255
         Left            =   2160
         TabIndex        =   2
         Top             =   270
         Width           =   675
      End
      Begin Label Label3 
         BackColor       =   &H00C0C0C0&
         Caption         =   "Octave"
         Height          =   255
         Left            =   3930
         TabIndex        =   3
         Top             =   270
         Width           =   645
      End
      Begin Label LabelVolume 
         Alignment       =   2  'Center
         BackColor       =   &H00000000&
         Caption         =   "100"
         FontBold        =   0   'False
         FontItalic      =   0   'False
         FontName        =   "MS Sans Serif"
         FontSize        =   9.75
         FontStrikethru  =   0   'False
         FontUnderline   =   0   'False
         ForeColor       =   &H0000FF00&
         Height          =   255
         Left            =   2820
         TabIndex        =   4
         Top             =   270
         Width           =   585
      End
      Begin Label Label4 
         BackColor       =   &H00C0C0C0&
         Caption         =   "Patch"
         Height          =   255
         Left            =   5460
         TabIndex        =   6
         Top             =   270
         Width           =   645
      End
      Begin Label LabelOctave 
         Alignment       =   2  'Center
         BackColor       =   &H00000000&
         Caption         =   "0"
         FontBold        =   0   'False
         FontItalic      =   0   'False
         FontName        =   "MS Sans Serif"
         FontSize        =   9.75
         FontStrikethru  =   0   'False
         FontUnderline   =   0   'False
         ForeColor       =   &H0000FF00&
         Height          =   255
         Left            =   4560
         TabIndex        =   7
         Top             =   270
         Width           =   405
      End
   End
   Begin MIDIOutput MIDIOutput1 
      DeviceID        =   0
      Left            =   420
      Top             =   2490
      VolumeLeft      =   0
      VolumeRight     =   0
   End
   Begin MIDIInput MIDIInput1 
      DeviceID        =   0
      Left            =   -60
      MaxSysexSize    =   0
      MessageEventEnable=   -1  'True
      Top             =   2340
   End
   Begin Frame Frame3 
      BackColor       =   &H00C0C0C0&
      DragMode        =   1  'Automatic
      Height          =   885
      Left            =   60
      MousePointer    =   1  'Arrow
      TabIndex        =   10
      Top             =   810
      Width           =   9165
      Begin Frame PianoKey 
         BackColor       =   &H00000000&
         DragMode        =   1  'Automatic
         ForeColor       =   &H00000000&
         Height          =   555
         Index           =   63
         Left            =   8800
         MousePointer    =   10  'Up Arrow
         TabIndex        =   74
         Top             =   30
         Width           =   165
      End
      Begin Frame PianoKey 
         BackColor       =   &H00000000&
         DragMode        =   1  'Automatic
         ForeColor       =   &H00000000&
         Height          =   555
         Index           =   61
         Left            =   8560
         MousePointer    =   10  'Up Arrow
         TabIndex        =   73
         Top             =   30
         Width           =   165
      End
      Begin Frame PianoKey 
         BackColor       =   &H00000000&
         DragMode        =   1  'Automatic
         ForeColor       =   &H00000000&
         Height          =   555
         Index           =   58
         Left            =   8080
         MousePointer    =   10  'Up Arrow
         TabIndex        =   72
         Top             =   30
         Width           =   165
      End
      Begin Frame PianoKey 
         BackColor       =   &H00000000&
         DragMode        =   1  'Automatic
         ForeColor       =   &H00000000&
         Height          =   555
         Index           =   56
         Left            =   7840
         MousePointer    =   10  'Up Arrow
         TabIndex        =   71
         Top             =   30
         Width           =   165
      End
      Begin Frame PianoKey 
         BackColor       =   &H00000000&
         DragMode        =   1  'Automatic
         ForeColor       =   &H00000000&
         Height          =   555
         Index           =   54
         Left            =   7600
         MousePointer    =   10  'Up Arrow
         TabIndex        =   70
         Top             =   30
         Width           =   165
      End
      Begin Frame PianoKey 
         BackColor       =   &H00000000&
         DragMode        =   1  'Automatic
         ForeColor       =   &H00000000&
         Height          =   555
         Index           =   51
         Left            =   7120
         MousePointer    =   10  'Up Arrow
         TabIndex        =   69
         Top             =   30
         Width           =   165
      End
      Begin Frame PianoKey 
         BackColor       =   &H00000000&
         DragMode        =   1  'Automatic
         ForeColor       =   &H00000000&
         Height          =   555
         Index           =   49
         Left            =   6880
         MousePointer    =   10  'Up Arrow
         TabIndex        =   68
         Top             =   30
         Width           =   165
      End
      Begin Frame PianoKey 
         BackColor       =   &H00000000&
         DragMode        =   1  'Automatic
         ForeColor       =   &H00000000&
         Height          =   555
         Index           =   46
         Left            =   6400
         MousePointer    =   10  'Up Arrow
         TabIndex        =   67
         Top             =   30
         Width           =   165
      End
      Begin Frame PianoKey 
         BackColor       =   &H00000000&
         DragMode        =   1  'Automatic
         ForeColor       =   &H00000000&
         Height          =   555
         Index           =   44
         Left            =   6160
         MousePointer    =   10  'Up Arrow
         TabIndex        =   66
         Top             =   30
         Width           =   165
      End
      Begin Frame PianoKey 
         BackColor       =   &H00000000&
         DragMode        =   1  'Automatic
         ForeColor       =   &H00000000&
         Height          =   555
         Index           =   42
         Left            =   5920
         MousePointer    =   10  'Up Arrow
         TabIndex        =   65
         Top             =   30
         Width           =   165
      End
      Begin Frame PianoKey 
         BackColor       =   &H00000000&
         DragMode        =   1  'Automatic
         ForeColor       =   &H00000000&
         Height          =   555
         Index           =   39
         Left            =   5440
         MousePointer    =   10  'Up Arrow
         TabIndex        =   64
         Top             =   30
         Width           =   165
      End
      Begin Frame PianoKey 
         BackColor       =   &H00000000&
         DragMode        =   1  'Automatic
         ForeColor       =   &H00000000&
         Height          =   555
         Index           =   37
         Left            =   5200
         MousePointer    =   10  'Up Arrow
         TabIndex        =   63
         Top             =   30
         Width           =   165
      End
      Begin Frame PianoKey 
         BackColor       =   &H00000000&
         DragMode        =   1  'Automatic
         ForeColor       =   &H00000000&
         Height          =   555
         Index           =   34
         Left            =   4720
         MousePointer    =   10  'Up Arrow
         TabIndex        =   62
         Top             =   30
         Width           =   165
      End
      Begin Frame PianoKey 
         BackColor       =   &H00000000&
         DragMode        =   1  'Automatic
         ForeColor       =   &H00000000&
         Height          =   555
         Index           =   32
         Left            =   4480
         MousePointer    =   10  'Up Arrow
         TabIndex        =   61
         Top             =   30
         Width           =   165
      End
      Begin Frame PianoKey 
         BackColor       =   &H00000000&
         DragMode        =   1  'Automatic
         ForeColor       =   &H00000000&
         Height          =   555
         Index           =   30
         Left            =   4240
         MousePointer    =   10  'Up Arrow
         TabIndex        =   60
         Top             =   30
         Width           =   165
      End
      Begin Frame PianoKey 
         BackColor       =   &H00000000&
         DragMode        =   1  'Automatic
         ForeColor       =   &H00000000&
         Height          =   555
         Index           =   27
         Left            =   3760
         MousePointer    =   10  'Up Arrow
         TabIndex        =   59
         Top             =   30
         Width           =   165
      End
      Begin Frame PianoKey 
         BackColor       =   &H00000000&
         DragMode        =   1  'Automatic
         ForeColor       =   &H00000000&
         Height          =   555
         Index           =   25
         Left            =   3520
         MousePointer    =   10  'Up Arrow
         TabIndex        =   58
         Top             =   30
         Width           =   165
      End
      Begin Frame PianoKey 
         BackColor       =   &H00000000&
         DragMode        =   1  'Automatic
         ForeColor       =   &H00000000&
         Height          =   555
         Index           =   22
         Left            =   3040
         MousePointer    =   10  'Up Arrow
         TabIndex        =   57
         Top             =   30
         Width           =   165
      End
      Begin Frame PianoKey 
         BackColor       =   &H00000000&
         DragMode        =   1  'Automatic
         ForeColor       =   &H00000000&
         Height          =   555
         Index           =   20
         Left            =   2800
         MousePointer    =   10  'Up Arrow
         TabIndex        =   56
         Top             =   30
         Width           =   165
      End
      Begin Frame PianoKey 
         BackColor       =   &H00000000&
         DragMode        =   1  'Automatic
         ForeColor       =   &H00000000&
         Height          =   555
         Index           =   18
         Left            =   2560
         MousePointer    =   10  'Up Arrow
         TabIndex        =   55
         Top             =   30
         Width           =   165
      End
      Begin Frame PianoKey 
         BackColor       =   &H00000000&
         DragMode        =   1  'Automatic
         ForeColor       =   &H00000000&
         Height          =   555
         Index           =   15
         Left            =   2080
         MousePointer    =   10  'Up Arrow
         TabIndex        =   54
         Top             =   30
         Width           =   165
      End
      Begin Frame PianoKey 
         BackColor       =   &H00000000&
         DragMode        =   1  'Automatic
         ForeColor       =   &H00000000&
         Height          =   555
         Index           =   13
         Left            =   1840
         MousePointer    =   10  'Up Arrow
         TabIndex        =   53
         Top             =   30
         Width           =   165
      End
      Begin Frame PianoKey 
         BackColor       =   &H00000000&
         DragMode        =   1  'Automatic
         ForeColor       =   &H00000000&
         Height          =   555
         Index           =   10
         Left            =   1360
         MousePointer    =   10  'Up Arrow
         TabIndex        =   52
         Top             =   30
         Width           =   165
      End
      Begin Frame PianoKey 
         BackColor       =   &H00000000&
         DragMode        =   1  'Automatic
         ForeColor       =   &H00000000&
         Height          =   555
         Index           =   8
         Left            =   1120
         MousePointer    =   10  'Up Arrow
         TabIndex        =   51
         Top             =   30
         Width           =   165
      End
      Begin Frame PianoKey 
         BackColor       =   &H00000000&
         DragMode        =   1  'Automatic
         ForeColor       =   &H00000000&
         Height          =   555
         Index           =   6
         Left            =   880
         MousePointer    =   10  'Up Arrow
         TabIndex        =   50
         Top             =   30
         Width           =   165
      End
      Begin Frame PianoKey 
         BackColor       =   &H00000000&
         DragMode        =   1  'Automatic
         ForeColor       =   &H00000000&
         Height          =   555
         Index           =   3
         Left            =   400
         MousePointer    =   10  'Up Arrow
         TabIndex        =   49
         Top             =   30
         Width           =   165
      End
      Begin Frame PianoKey 
         BackColor       =   &H00000000&
         ForeColor       =   &H00000000&
         Height          =   555
         Index           =   1
         Left            =   160
         MousePointer    =   10  'Up Arrow
         TabIndex        =   48
         Top             =   30
         Width           =   165
      End
      Begin Frame PianoKey 
         DragMode        =   1  'Automatic
         Height          =   855
         Index           =   64
         Left            =   8880
         MousePointer    =   10  'Up Arrow
         TabIndex        =   47
         Top             =   0
         Width           =   255
      End
      Begin Frame PianoKey 
         DragMode        =   1  'Automatic
         Height          =   855
         Index           =   62
         Left            =   8640
         MousePointer    =   10  'Up Arrow
         TabIndex        =   46
         Top             =   0
         Width           =   255
      End
      Begin Frame PianoKey 
         DragMode        =   1  'Automatic
         Height          =   855
         Index           =   60
         Left            =   8400
         MousePointer    =   10  'Up Arrow
         TabIndex        =   45
         Top             =   0
         Width           =   255
      End
      Begin Frame PianoKey 
         DragMode        =   1  'Automatic
         Height          =   855
         Index           =   59
         Left            =   8160
         MousePointer    =   10  'Up Arrow
         TabIndex        =   44
         Top             =   0
         Width           =   255
      End
      Begin Frame PianoKey 
         DragMode        =   1  'Automatic
         Height          =   855
         Index           =   57
         Left            =   7920
         MousePointer    =   10  'Up Arrow
         TabIndex        =   43
         Top             =   0
         Width           =   255
      End
      Begin Frame PianoKey 
         DragMode        =   1  'Automatic
         Height          =   855
         Index           =   55
         Left            =   7680
         MousePointer    =   10  'Up Arrow
         TabIndex        =   42
         Top             =   0
         Width           =   255
      End
      Begin Frame PianoKey 
         DragMode        =   1  'Automatic
         Height          =   855
         Index           =   53
         Left            =   7440
         MousePointer    =   10  'Up Arrow
         TabIndex        =   41
         Top             =   0
         Width           =   255
      End
      Begin Frame PianoKey 
         DragMode        =   1  'Automatic
         Height          =   855
         Index           =   52
         Left            =   7200
         MousePointer    =   10  'Up Arrow
         TabIndex        =   40
         Top             =   0
         Width           =   255
      End
      Begin Frame PianoKey 
         DragMode        =   1  'Automatic
         Height          =   855
         Index           =   50
         Left            =   6960
         MousePointer    =   10  'Up Arrow
         TabIndex        =   39
         Top             =   0
         Width           =   255
      End
      Begin Frame PianoKey 
         DragMode        =   1  'Automatic
         Height          =   855
         Index           =   48
         Left            =   6720
         MousePointer    =   10  'Up Arrow
         TabIndex        =   38
         Top             =   0
         Width           =   255
      End
      Begin Frame PianoKey 
         DragMode        =   1  'Automatic
         Height          =   855
         Index           =   47
         Left            =   6480
         MousePointer    =   10  'Up Arrow
         TabIndex        =   37
         Top             =   0
         Width           =   255
      End
      Begin Frame PianoKey 
         DragMode        =   1  'Automatic
         Height          =   855
         Index           =   45
         Left            =   6240
         MousePointer    =   10  'Up Arrow
         TabIndex        =   36
         Top             =   0
         Width           =   255
      End
      Begin Frame PianoKey 
         DragMode        =   1  'Automatic
         Height          =   855
         Index           =   43
         Left            =   6000
         MousePointer    =   10  'Up Arrow
         TabIndex        =   35
         Top             =   0
         Width           =   255
      End
      Begin Frame PianoKey 
         DragMode        =   1  'Automatic
         Height          =   855
         Index           =   41
         Left            =   5760
         MousePointer    =   10  'Up Arrow
         TabIndex        =   34
         Top             =   0
         Width           =   255
      End
      Begin Frame PianoKey 
         DragMode        =   1  'Automatic
         Height          =   855
         Index           =   40
         Left            =   5520
         MousePointer    =   10  'Up Arrow
         TabIndex        =   33
         Top             =   0
         Width           =   255
      End
      Begin Frame PianoKey 
         DragMode        =   1  'Automatic
         Height          =   855
         Index           =   38
         Left            =   5280
         MousePointer    =   10  'Up Arrow
         TabIndex        =   32
         Top             =   0
         Width           =   255
      End
      Begin Frame PianoKey 
         DragMode        =   1  'Automatic
         Height          =   855
         Index           =   36
         Left            =   5040
         MousePointer    =   10  'Up Arrow
         TabIndex        =   31
         Top             =   0
         Width           =   255
      End
      Begin Frame PianoKey 
         DragMode        =   1  'Automatic
         Height          =   855
         Index           =   35
         Left            =   4800
         MousePointer    =   10  'Up Arrow
         TabIndex        =   30
         Top             =   0
         Width           =   255
      End
      Begin Frame PianoKey 
         DragMode        =   1  'Automatic
         Height          =   855
         Index           =   33
         Left            =   4560
         MousePointer    =   10  'Up Arrow
         TabIndex        =   29
         Top             =   0
         Width           =   255
      End
      Begin Frame PianoKey 
         DragMode        =   1  'Automatic
         Height          =   855
         Index           =   31
         Left            =   4320
         MousePointer    =   10  'Up Arrow
         TabIndex        =   28
         Top             =   0
         Width           =   255
      End
      Begin Frame PianoKey 
         DragMode        =   1  'Automatic
         Height          =   855
         Index           =   29
         Left            =   4080
         MousePointer    =   10  'Up Arrow
         TabIndex        =   27
         Top             =   0
         Width           =   255
      End
      Begin Frame PianoKey 
         DragMode        =   1  'Automatic
         Height          =   855
         Index           =   28
         Left            =   3840
         MousePointer    =   10  'Up Arrow
         TabIndex        =   26
         Top             =   0
         Width           =   255
      End
      Begin Frame PianoKey 
         DragMode        =   1  'Automatic
         Height          =   855
         Index           =   26
         Left            =   3600
         MousePointer    =   10  'Up Arrow
         TabIndex        =   25
         Top             =   0
         Width           =   255
      End
      Begin Frame PianoKey 
         DragMode        =   1  'Automatic
         Height          =   855
         Index           =   24
         Left            =   3360
         MousePointer    =   10  'Up Arrow
         TabIndex        =   24
         Top             =   0
         Width           =   255
      End
      Begin Frame PianoKey 
         DragMode        =   1  'Automatic
         Height          =   855
         Index           =   23
         Left            =   3120
         MousePointer    =   10  'Up Arrow
         TabIndex        =   23
         Top             =   0
         Width           =   255
      End
      Begin Frame PianoKey 
         DragMode        =   1  'Automatic
         Height          =   855
         Index           =   21
         Left            =   2880
         MousePointer    =   10  'Up Arrow
         TabIndex        =   22
         Top             =   0
         Width           =   255
      End
      Begin Frame PianoKey 
         DragMode        =   1  'Automatic
         Height          =   855
         Index           =   19
         Left            =   2640
         MousePointer    =   10  'Up Arrow
         TabIndex        =   21
         Top             =   0
         Width           =   255
      End
      Begin Frame PianoKey 
         DragMode        =   1  'Automatic
         Height          =   855
         Index           =   17
         Left            =   2400
         MousePointer    =   10  'Up Arrow
         TabIndex        =   20
         Top             =   0
         Width           =   255
      End
      Begin Frame PianoKey 
         DragMode        =   1  'Automatic
         Height          =   855
         Index           =   16
         Left            =   2160
         MousePointer    =   10  'Up Arrow
         TabIndex        =   19
         Top             =   0
         Width           =   255
      End
      Begin Frame PianoKey 
         DragMode        =   1  'Automatic
         Height          =   855
         Index           =   14
         Left            =   1920
         MousePointer    =   10  'Up Arrow
         TabIndex        =   18
         Top             =   0
         Width           =   255
      End
      Begin Frame PianoKey 
         DragMode        =   1  'Automatic
         Height          =   855
         Index           =   12
         Left            =   1680
         MousePointer    =   10  'Up Arrow
         TabIndex        =   17
         Top             =   0
         Width           =   255
      End
      Begin Frame PianoKey 
         DragMode        =   1  'Automatic
         Height          =   855
         Index           =   11
         Left            =   1440
         MousePointer    =   10  'Up Arrow
         TabIndex        =   16
         Top             =   0
         Width           =   255
      End
      Begin Frame PianoKey 
         DragMode        =   1  'Automatic
         Height          =   855
         Index           =   9
         Left            =   1200
         MousePointer    =   10  'Up Arrow
         TabIndex        =   15
         Top             =   0
         Width           =   255
      End
      Begin Frame PianoKey 
         DragMode        =   1  'Automatic
         Height          =   855
         Index           =   7
         Left            =   960
         MousePointer    =   10  'Up Arrow
         TabIndex        =   14
         Top             =   0
         Width           =   255
      End
      Begin Frame PianoKey 
         DragMode        =   1  'Automatic
         Height          =   855
         Index           =   5
         Left            =   720
         MousePointer    =   10  'Up Arrow
         TabIndex        =   13
         Top             =   0
         Width           =   255
      End
      Begin Frame PianoKey 
         DragMode        =   1  'Automatic
         Height          =   855
         Index           =   4
         Left            =   480
         MousePointer    =   10  'Up Arrow
         TabIndex        =   12
         Top             =   0
         Width           =   255
      End
      Begin Frame PianoKey 
         BackColor       =   &H00FFFFFF&
         DragIcon        =   PIANO2.FRX:0504
         DragMode        =   1  'Automatic
         Height          =   855
         Index           =   0
         Left            =   0
         MousePointer    =   10  'Up Arrow
         TabIndex        =   11
         Top             =   0
         Width           =   255
      End
      Begin Frame PianoKey 
         BackColor       =   &H00FFFFFF&
         DragMode        =   1  'Automatic
         Height          =   855
         Index           =   2
         Left            =   210
         MousePointer    =   10  'Up Arrow
         TabIndex        =   75
         Top             =   0
         Width           =   285
      End
   End
   Begin Menu File 
      Caption         =   "&File"
      Begin Menu Exit 
         Caption         =   "E&xit"
      End
   End
   Begin Menu MIDI 
      Caption         =   "&MIDI"
      Begin Menu MIDISetup 
         Caption         =   "MIDI &Setup..."
      End
   End
End
Option Explicit

Dim NoteCatchCount As Integer
Dim NoteOnCatcher(1024) As Integer

'
' While recording this variable contains the recording
' start time
'
Dim startTime As Long

'
' Index into notes array
'
Dim note As Integer
'

Sub ComboPatch_Click ()
    ' Sets the Patch for the current Midi Channel Out
    MidiPatch(MidiChannelOut) = ComboPatch.ListIndex

    'Patch Midi Out routine
    MIDIOutput1.Message = PROGRAM_CHANGE + MidiChannelOut
    MIDIOutput1.Data1 = MidiPatch(MidiChannelOut)
    MIDIOutput1.Data2 = 0
    MIDIOutput1.Time = 0
    MIDIOutput1.Action = MIDIOUT_SEND
End Sub

Sub Exit_Click ()
    ' Stop the MIDI In
    MIDIInput1.Action = MIDIIN_STOP
    
    ' Close MIDI In
    MIDIInput1.Action = MIDIIN_CLOSE

    
    ' Close MIDI Out
    MIDIOutput1.Action = MIDIOUT_CLOSE

    End
End Sub

Sub Form_Load ()
    Dim n As Integer

    Screen.MousePointer = 11
    Piano.Left = 0
    Piano.Top = 0
    
    ' General MIDI patches
    ComboPatch.AddItem "Acoustic Grand Piano"
    ComboPatch.AddItem "Bright Acoustic Piano"
    ComboPatch.AddItem "Electric Grand Piano"
    ComboPatch.AddItem "Honkytonk Piano"
    ComboPatch.AddItem "Rhodes Piano"
    ComboPatch.AddItem "Chorus Piano"
    ComboPatch.AddItem "Harpsichord"
    ComboPatch.AddItem "Clavinet"
    ComboPatch.AddItem "Celesta"
    ComboPatch.AddItem "Glockenspiel"
    ComboPatch.AddItem "Music Box"
    ComboPatch.AddItem "Vibraphone"
    ComboPatch.AddItem "Marimba"
    ComboPatch.AddItem "Xylophone"
    ComboPatch.AddItem "Tubular Bells"
    ComboPatch.AddItem "Dulcimer"
    ComboPatch.AddItem "Hammond Organ"
    ComboPatch.AddItem "Percuss. Organ"
    ComboPatch.AddItem "Rock Organ"
    ComboPatch.AddItem "Church Organ"
    ComboPatch.AddItem "Reed Organ"
    ComboPatch.AddItem "Accordion"
    ComboPatch.AddItem "Harmonica"
    ComboPatch.AddItem "Tango Accordion"
    ComboPatch.AddItem "Acoustic Guitar (nylon)"
    ComboPatch.AddItem "Acoustic Guitar (steel)"
    ComboPatch.AddItem "Electric Guitar (jazz)"
    ComboPatch.AddItem "Electric Guitar (clean)"
    ComboPatch.AddItem "Electric Guitar (muted)"
    ComboPatch.AddItem "Overdriven Guitar"
    ComboPatch.AddItem "Distortion Guitar"
    ComboPatch.AddItem "Guitar Harmonics"
    ComboPatch.AddItem "Acoustic Bass"
    ComboPatch.AddItem "Electric Bass (finger)"
    ComboPatch.AddItem "Electric Bass (pick)"
    ComboPatch.AddItem "Fretless Bass"
    ComboPatch.AddItem "Slap Bass 1"
    ComboPatch.AddItem "Slap Bass 2"
    ComboPatch.AddItem "Synth Bass 1"
    ComboPatch.AddItem "Synth Bass 2"
    ComboPatch.AddItem "Violin"
    ComboPatch.AddItem "Viola"
    ComboPatch.AddItem "Cello"
    ComboPatch.AddItem "Contra Bass"
    ComboPatch.AddItem "Tremolo Strings"
    ComboPatch.AddItem "Pizzicato Strings"
    ComboPatch.AddItem "Orchestral Harp"
    ComboPatch.AddItem "Timpani"
    ComboPatch.AddItem "String Ensemble 1"
    ComboPatch.AddItem "String Ensemble 2"
    ComboPatch.AddItem "Synth Strings 1"
    ComboPatch.AddItem "Synth Strings 2"
    ComboPatch.AddItem "Choir Aahs"
    ComboPatch.AddItem "Voice Oohs"
    ComboPatch.AddItem "Synth Voice"
    ComboPatch.AddItem "Orchestra Hit"
    ComboPatch.AddItem "Trumpet"
    ComboPatch.AddItem "Trombone"
    ComboPatch.AddItem "Tuba"
    ComboPatch.AddItem "Muted Trumpet"
    ComboPatch.AddItem "French Horn"
    ComboPatch.AddItem "Brass Section"
    ComboPatch.AddItem "Synth Brass 1"
    ComboPatch.AddItem "Synth Brass 2"
    ComboPatch.AddItem "Soprano Sax"
    ComboPatch.AddItem "Alto Sax"
    ComboPatch.AddItem "Tenor Sax"
    ComboPatch.AddItem "Baritone Sax"
    ComboPatch.AddItem "Oboe"
    ComboPatch.AddItem "English Horn"
    ComboPatch.AddItem "Bassoon"
    ComboPatch.AddItem "Clarinet"
    ComboPatch.AddItem "Piccolo"
    ComboPatch.AddItem "Flute"
    ComboPatch.AddItem "Recorder"
    ComboPatch.AddItem "Pan Flute"
    ComboPatch.AddItem "Bottle Blow"
    ComboPatch.AddItem "Shaku"
    ComboPatch.AddItem "Whistle"
    ComboPatch.AddItem "Ocarina"
    ComboPatch.AddItem "Lead 1 (square)"
    ComboPatch.AddItem "Lead 2 (saw tooth)"
    ComboPatch.AddItem "Lead 3 (calliope lead)"
    ComboPatch.AddItem "Lead 4 (chiff lead)"
    ComboPatch.AddItem "Lead 5 (charang)"
    ComboPatch.AddItem "Lead 6 (voice)"
    ComboPatch.AddItem "Lead 7 (fifths)"
    ComboPatch.AddItem "Lead 8 (bass + lead)"
    ComboPatch.AddItem "Pad 1 (new age)"
    ComboPatch.AddItem "Pad 2 (warm)"
    ComboPatch.AddItem "Pad 3 (poly synth)"
    ComboPatch.AddItem "Pad 4 (choir)"
    ComboPatch.AddItem "Pad 5 (bowed)"
    ComboPatch.AddItem "Pad 6 (metallic)"
    ComboPatch.AddItem "Pad 7 (halo)"
    ComboPatch.AddItem "Pad 8 (sweep)"
    ComboPatch.AddItem "FX 1 (rain)"
    ComboPatch.AddItem "FX 2 (sound track)"
    ComboPatch.AddItem "FX 3 (crystal)"
    ComboPatch.AddItem "FX 4 (atmo - sphere)"
    ComboPatch.AddItem "FX 5 (bright)"
    ComboPatch.AddItem "FX 6 (goblins)"
    ComboPatch.AddItem "FX 7 (echoes)"
    ComboPatch.AddItem "FX 8 (sci-fi)"
    ComboPatch.AddItem "Sitar"
    ComboPatch.AddItem "Banjo"
    ComboPatch.AddItem "Shamisen"
    ComboPatch.AddItem "Koto"
    ComboPatch.AddItem "Kalimba"
    ComboPatch.AddItem "Bagpipe"
    ComboPatch.AddItem "Fiddle"
    ComboPatch.AddItem "Shanai"
    ComboPatch.AddItem "Tinkle Bell"
    ComboPatch.AddItem "Agogo"
    ComboPatch.AddItem "Steel Drums"
    ComboPatch.AddItem "Wood block"
    ComboPatch.AddItem "Taiko Drum"
    ComboPatch.AddItem "Melodic Tom"
    ComboPatch.AddItem "Synth Drum"
    ComboPatch.AddItem "Reverse Cymbal"
    ComboPatch.AddItem "Guitar Fret Noise"
    ComboPatch.AddItem "Breath Noise"
    ComboPatch.AddItem "Seashore"
    ComboPatch.AddItem "Bird Tweet"
    ComboPatch.AddItem "Telephone Ring"
    ComboPatch.AddItem "Helicopter"
    ComboPatch.AddItem "Applause"
    ComboPatch.AddItem "Gunshot"
    ComboPatch.ListIndex = 0

    MidiChannelOut = 0
    HSliderMIDIChannel.Value = 0
    HSliderOctave.Value = 3
    HSliderVolume.Value = 100
    KnobPan.Value = 64
    Screen.MousePointer = 0

    For n = 1 To 64
	PianoKey(n).DragIcon = PianoKey(0).DragIcon
    Next

    Piano.Show
    MidiSetupForm.Show MODAL

End Sub

Sub Form_Unload (Cancel As Integer)
    ' Stop the MIDI In
    MIDIInput1.Action = MIDIIN_STOP
    
    ' Close MIDI In
    MIDIInput1.Action = MIDIIN_CLOSE

    
    ' Close MIDI Out
    MIDIOutput1.Action = MIDIOUT_CLOSE

    End
End Sub

Sub HSliderMIDIChannel_Change ()
    ' Change Midi Channel to Vscroll1 value
    MidiChannelOut = HSliderMIDIChannel.Value

    ' Display new channel
    MidiChannelOutLabel.Caption = Str$(MidiChannelOut + 1)

    ' Sets the Patch & Volume for the current Midi Channel Out
    ComboPatch.ListIndex = MidiPatch(MidiChannelOut)
    HSliderVolume.Value = MidiVolume(MidiChannelOut)
    KnobPan.Value = MidiPan(MidiChannelOut)
    HSliderOctave.Value = Octave(MidiChannelOut) / 12
End Sub

Sub HSliderMIDIChannel_Scroll ()
    ' Change Midi Channel to Vscroll1 value
    MidiChannelOut = HSliderMIDIChannel.Value

    ' Display new channel
    MidiChannelOutLabel.Caption = Str$(MidiChannelOut + 1)

    ' Sets the Patch & Volume for the current Midi Channel Out
    ComboPatch.ListIndex = MidiPatch(MidiChannelOut)
    HSliderVolume.Value = MidiVolume(MidiChannelOut)
    KnobPan.Value = MidiPan(MidiChannelOut)
    HSliderOctave.Value = Octave(MidiChannelOut) / 12

End Sub

Sub HSliderOctave_Change ()
    LabelOctave.Caption = Str$(HSliderOctave.Value)
    Octave(MidiChannelOut) = (HSliderOctave.Value * 12)
End Sub

Sub HSliderOctave_Scroll ()
    LabelOctave.Caption = Str$(HSliderOctave.Value)
    Octave(MidiChannelOut) = (HSliderOctave.Value * 12)
End Sub

Sub HSliderVolume_Change ()
    MidiVelocity = HSliderVolume.Value
    MidiVolume(MidiChannelOut) = HSliderVolume.Value
    LabelVolume.Caption = Str$(MidiVelocity)
End Sub

Sub HSliderVolume_Scroll ()
    MidiVelocity = HSliderVolume.Value
    MidiVolume(MidiChannelOut) = HSliderVolume.Value
    LabelVolume.Caption = Str$(MidiVelocity)
End Sub

Sub KnobPan_Change ()
    MidiPan(MidiChannelOut) = KnobPan.Value

    'Pan Midi Out routine
    MIDIOutput1.Message = CONTROLLER_CHANGE + MidiChannelOut
    MIDIOutput1.Data1 = PAN
    MIDIOutput1.Data2 = MidiPan(MidiChannelOut)
    MIDIOutput1.Time = 0
    MIDIOutput1.Action = MIDIOUT_SEND
End Sub

Sub KnobPan_Scroll ()
    MidiPan(MidiChannelOut) = KnobPan.Value

    'Pan Midi Out routine
    MIDIOutput1.Message = CONTROLLER_CHANGE + MidiChannelOut
    MIDIOutput1.Data1 = PAN
    MIDIOutput1.Data2 = MidiPan(MidiChannelOut)
    MIDIOutput1.Time = 0
    MIDIOutput1.Action = MIDIOUT_SEND
End Sub

Sub MIDIInput1_Error (ErrorCode As Integer, ErrorMessage As String)
    MsgBox ErrorMessage
End Sub

Sub MIDIInput1_Message ()
    Dim InMessage As Integer
    Dim InData1 As Integer
    Dim InData2 As Integer

    '
    ' The MIDI1.VBX will receive and time stamp in-coming MIDI data very
    ' fast, but it takes VB a lot of time to fire this Message event. If
    ' you need to process MIDI data in real-time, each time this Message
    ' event fires, you should take all the pending messages.  One way to
    ' do this is by using a Do While MIDIInput2.MessageCount > 0
    ' This do while loop allows you to take all the messages that are
    ' waiting in the message queue.

    Do While MIDIInput1.MessageCount > 0
	'
	'This is in-coming MIDI data
	'
	InMessage = MIDIInput1.Message
	InData1 = MIDIInput1.Data1
	InData2 = MIDIInput1.Data2

	'
	'Now we are going to prepare the MIDI data that just came in to
	'be ready to go right back out the MIDI OUT
	'
	MIDIOutput1.Message = InMessage
	MIDIOutput1.Data1 = InData1
	MIDIOutput1.Data2 = InData2
	
	Select Case InMessage
	'
	' NOTE_ON, NOTE_OFF, PROGRAM_CHANGE, TOTAL_MIDI_CHANNELS
	' are all constants from the MIDCONST.BAS file.  Using constants in
	' the MIDCONST.BAS file will allow you to not have to work with
	' confusing codes.
	'
	' Check to see if the in-coming MIDI Message was a NOTE_ON from the
	' currently selected MIDI channel.
	'
	' We can only display 64 notes on our graphic piano.  Check to see if
	' InData1 (which is the actual MIDI note be played) can be shown on
	' the graphic piano display.
	'
	' Using HSliderOctave, the Octave(MidiChannelOut) is set.  This
	' allows you to slide the octave display up and down for disaply
	' notes that would otherwise not be able to appear on the graphic
	' piano display.
	'
	   Case NOTE_ON + MidiChannelOut
		If InData1 <= 64 + Octave(MidiChannelOut) Then
		    '
		    ' Some MIDI manufactures turn MIDI notes off by sending a MIDI NOTE ON
		    ' with a velocity = 0.  InData2 is the note velocity.  If it is greater
		    ' than 0 then it truly is a note on.  If it is, then push down the
		    ' graphic key on the piano.
		    '
		    ' If InData2 is equal to zero, then release the graphic key on the piano
		    ' because it is actually a note off.
		    '
		    If InData2 > 0 Then
			'
			' Push down the graphic key on the piano
			'
			'Piano.PianoKey(InData1 - Octave(MidiChannelOut)).BevelOuter = 0
		    Else
			' Release the graphic key on the piano
			'
			'Piano.PianoKey(InData1 - Octave(MidiChannelOut)).BevelOuter = 2
		    End If
		End If
		'
		'Tell MIDIOutput1 to send the MIDI data
		'
		MIDIOutput1.Action = MIDIOUT_SEND

	    '
	    ' MIDI NOTE OFF Event received
	    '
	    Case NOTE_OFF + MidiChannelOut
		If InData1 <= 64 + Octave(MidiChannelOut) Then
		    '
		    ' Release the graphic key on the piano
		    '
		    'Piano.PianoKey(InData1 - Octave(MidiChannelOut)).BevelOuter = 2
		End If
		'
		'Tell MIDIOutput1 to send the MIDI data
		'
		MIDIOutput1.Action = MIDIOUT_SEND

	    '
	    ' Patch Program Change received
	    '
	    Case PROGRAM_CHANGE + MidiChannelOut
		'
		' Patches (organ, piano, horn, etc.) are changed by sending
		' a PROGRAM_CHANGE.  If we received a PROGRAM_CHANGE on the
		' current MIDI channel from an external MIDI device, we
		' will update the patch name on the screen and send the patch
		' change out the MIDI Out.
		'
		 ComboPatch.ListIndex = MIDIOutput1.Data1

	    '
	    'Controller Change received
	    '
	    Case CONTROLLER_CHANGE + MidiChannelOut
		Select Case InData1
		    Case MAIN_VOLUME
			HSliderVolume.Value = InData2
		    Case PAN
			KnobPan.Value = InData2
		End Select
	    
	    Case Else
		'
		'Tell MIDIOutput1 to send the MIDI data
		'
		MIDIOutput1.Action = MIDIOUT_SEND
		
	End Select

	'
	'Remove the MIDI data from the MIDI IN queue
	'
	MIDIInput1.Action = MIDIIN_REMOVE
    Loop
End Sub

Sub MIDISetup_Click ()
    MidiSetupForm.Show MODAL
End Sub

Sub PanelWhite_DragDrop (Index As Integer, Source As Control, X As Single, Y As Single)
    Dim nn As Integer
    For nn = 0 To NoteCatchCount - 1
	MIDIOutput1.Message = NOTE_ON + MidiChannelOut
	MIDIOutput1.Data2 = 0
	MIDIOutput1.Data1 = NoteOnCatcher(nn)
	MIDIOutput1.Time = 0
	MIDIOutput1.Action = MIDIOUT_SEND

	'Piano.PianoKey(NoteOnCatcher(nn) - Octave(MidiChannelOut)).BevelOuter = 2
    Next nn

    NoteCatchCount = 0
End Sub

Sub PanelWhite_DragOver (Index As Integer, Source As Control, X As Single, Y As Single, State As Integer)
    Dim MIDIMessage As Integer
    Dim MIDINoteOut As Integer

    MIDINoteOut = Index + Octave(MidiChannelOut)

    'If still on same note, discard
    If NoteCatchCount > 0 Then
       If NoteOnCatcher(NoteCatchCount - 1) = MIDINoteOut Then
	    Exit Sub
       End If
    End If

    'Piano.PianoKey(Index).BevelOuter = 0
	
    MIDIOutput1.Message = NOTE_ON + MidiChannelOut
    MIDIOutput1.Data2 = MidiVelocity
    MIDIOutput1.Data1 = MIDINoteOut
    MIDIOutput1.Time = 0
    MIDIOutput1.Action = MIDIOUT_SEND

    'Since drag/drop is being used, we must keep track of the note being
    'played.
    NoteOnCatcher(NoteCatchCount) = MIDINoteOut
    If NoteCatchCount < 750 Then
	NoteCatchCount = NoteCatchCount + 1
    End If

End Sub

Sub PianoKey_DragDrop (Index As Integer, Source As Control, X As Single, Y As Single)
    Dim nn As Integer
    For nn = 0 To NoteCatchCount - 1
	MIDIOutput1.Message = NOTE_ON + MidiChannelOut
	MIDIOutput1.Data2 = 0
	MIDIOutput1.Data1 = NoteOnCatcher(nn)
	MIDIOutput1.Time = 0
	MIDIOutput1.Action = MIDIOUT_SEND

	Select Case (NoteOnCatcher(nn) - Octave(MidiChannelOut)) Mod 12
	    Case Is = 0, 2, 4, 5, 7, 9, 11
	    Piano.PianoKey(NoteOnCatcher(nn) - Octave(MidiChannelOut)).BackColor = WHITE
	    Case Is = 1, 3, 6, 8, 10
	    Piano.PianoKey(NoteOnCatcher(nn) - Octave(MidiChannelOut)).BackColor = BLACK
	End Select
    Next nn

    NoteCatchCount = 0

End Sub

Sub PianoKey_DragOver (Index As Integer, Source As Control, X As Single, Y As Single, State As Integer)
    Dim MIDIMessage As Integer
    Dim MIDINoteOut As Integer

    MIDINoteOut = Index + Octave(MidiChannelOut)

    'If still on same note, discard
    If NoteCatchCount > 0 Then
       If NoteOnCatcher(NoteCatchCount - 1) = MIDINoteOut Then
	    Exit Sub
       End If
    End If

    Select Case (Index Mod 12)
	Case Is = 0, 2, 4, 5, 7, 9, 11
	    Piano.PianoKey(Index).BackColor = YELLOW
	Case Is = 1, 3, 6, 8, 10
	    Piano.PianoKey(Index).BackColor = CYAN
    End Select
	
    MIDIOutput1.Message = NOTE_ON + MidiChannelOut
    MIDIOutput1.Data2 = MidiVelocity
    MIDIOutput1.Data1 = MIDINoteOut
    MIDIOutput1.Time = 0
    MIDIOutput1.Action = MIDIOUT_SEND

    'Since drag/drop is being used, we must keep track of the note being
    'played.
    NoteOnCatcher(NoteCatchCount) = MIDINoteOut
    If NoteCatchCount < 750 Then
	NoteCatchCount = NoteCatchCount + 1
    End If


End Sub

